/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-10-30 08:53:54 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=866 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=81551 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2555 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=291535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5597 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3427 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_analytics_keyword_manager` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` varchar(1000) NOT NULL,
  `collection` varchar(200) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_analytics_objects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `title` text NOT NULL,
  `page` varchar(500) NOT NULL,
  `object_type` varchar(100) NOT NULL,
  `object_subtype` varchar(100) NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `primary_key` varchar(255) NOT NULL,
  `seo_score` tinyint(4) NOT NULL DEFAULT 0,
  `page_score` tinyint(4) NOT NULL DEFAULT 0,
  `is_indexable` tinyint(1) NOT NULL DEFAULT 1,
  `schemas_in_use` varchar(500) DEFAULT NULL,
  `desktop_interactive` double DEFAULT 0,
  `desktop_pagescore` double DEFAULT 0,
  `mobile_interactive` double DEFAULT 0,
  `mobile_pagescore` double DEFAULT 0,
  `pagespeed_refreshed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `analytics_object_page` (`page`(190))
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_internal_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_internal_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT 0,
  `external_link_count` int(10) unsigned DEFAULT 0,
  `incoming_link_count` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_redirections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sources` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_to` text NOT NULL,
  `header_code` smallint(4) unsigned NOT NULL,
  `hits` bigint(20) unsigned NOT NULL DEFAULT 0,
  `status` varchar(25) NOT NULL DEFAULT 'active',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_rank_math_redirections_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `redirection_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `object_type` varchar(10) NOT NULL DEFAULT 'post',
  `is_redirected` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `redirection_id` (`redirection_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31876 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=170 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_wp_wc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `wp_woocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woof_query_cache` (
  `mkey` varchar(64) NOT NULL,
  `mvalue` text NOT NULL,
  KEY `mkey` (`mkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6178 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


 /* SQL Chunk Header Index 1 */ 

/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES 
("61","woocommerce_run_update_callback","failed","2022-04-27 04:57:48","2022-04-27 04:57:48","{\"update_callback\":\"wc_update_560_create_refund_returns_page\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651035468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651035468;}","2","1","2022-04-27 04:58:35","2022-04-27 11:58:35","0",NULL),
("65","woocommerce_run_update_callback","failed","2022-04-27 04:57:52","2022-04-27 04:57:52","{\"update_callback\":\"wc_update_630_create_product_attributes_lookup_table\"}","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1651035472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1651035472;}","2","1","2022-04-27 04:58:35","2022-04-27 11:58:35","0",NULL),
("819","rank_math/analytics/data_fetch","complete","2023-10-01 17:44:38","2023-10-01 17:44:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696182278;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696182278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-01 17:51:01","2023-10-02 00:51:01","0",NULL),
("820","woocommerce_cleanup_draft_orders","complete","2023-09-29 22:26:05","2023-09-29 22:26:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696026365;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696026365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-09-29 22:40:06","2023-09-30 05:40:06","0",NULL),
("821","woocommerce_cleanup_draft_orders","complete","2023-09-30 22:40:06","2023-09-30 22:40:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696113606;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696113606;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-09-30 22:53:57","2023-10-01 05:53:57","0",NULL),
("822","woocommerce_cleanup_draft_orders","complete","2023-10-01 22:53:57","2023-10-01 22:53:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696200837;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696200837;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-01 23:08:19","2023-10-02 06:08:19","0",NULL),
("823","rank_math/analytics/data_fetch","complete","2023-10-04 17:51:01","2023-10-04 17:51:01","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696441861;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696441861;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-04 18:06:21","2023-10-05 01:06:21","0",NULL),
("824","woocommerce_cleanup_draft_orders","complete","2023-10-02 23:08:19","2023-10-02 23:08:19","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696288099;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696288099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-02 23:18:50","2023-10-03 06:18:50","0",NULL),
("825","woocommerce_cleanup_draft_orders","complete","2023-10-03 23:18:50","2023-10-03 23:18:50","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696375130;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696375130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-03 23:24:00","2023-10-04 06:24:00","0",NULL),
("826","woocommerce_cleanup_draft_orders","complete","2023-10-04 23:24:00","2023-10-04 23:24:00","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696461840;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696461840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-04 23:58:22","2023-10-05 06:58:22","0",NULL),
("827","rank_math/analytics/data_fetch","complete","2023-10-07 18:06:21","2023-10-07 18:06:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696701981;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696701981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-07 19:20:04","2023-10-08 02:20:04","0",NULL),
("828","woocommerce_cleanup_draft_orders","complete","2023-10-05 23:58:22","2023-10-05 23:58:22","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696550302;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696550302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-06 00:01:33","2023-10-06 07:01:33","0",NULL),
("829","woocommerce_cleanup_draft_orders","complete","2023-10-07 00:01:33","2023-10-07 00:01:33","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696636893;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696636893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-07 00:05:46","2023-10-07 07:05:46","0",NULL),
("830","woocommerce_cleanup_draft_orders","complete","2023-10-08 00:05:46","2023-10-08 00:05:46","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696723546;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696723546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-08 00:11:28","2023-10-08 07:11:28","0",NULL),
("831","rank_math/analytics/data_fetch","complete","2023-10-10 19:20:04","2023-10-10 19:20:04","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696965604;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696965604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-10 19:31:05","2023-10-11 02:31:05","0",NULL),
("832","woocommerce_cleanup_draft_orders","complete","2023-10-09 00:11:28","2023-10-09 00:11:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696810288;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696810288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-09 00:52:09","2023-10-09 07:52:09","0",NULL),
("833","woocommerce_cleanup_draft_orders","complete","2023-10-10 00:52:09","2023-10-10 00:52:09","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696899129;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696899129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-10 01:47:21","2023-10-10 08:47:21","0",NULL),
("834","woocommerce_cleanup_draft_orders","complete","2023-10-11 01:47:21","2023-10-11 01:47:21","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1696988841;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1696988841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-11 03:01:29","2023-10-11 10:01:29","0",NULL),
("835","rank_math/analytics/data_fetch","complete","2023-10-13 19:31:05","2023-10-13 19:31:05","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697225465;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697225465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-13 19:57:49","2023-10-14 02:57:49","0",NULL),
("836","woocommerce_cleanup_draft_orders","complete","2023-10-12 03:01:29","2023-10-12 03:01:29","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697079689;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697079689;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-12 03:06:57","2023-10-12 10:06:57","0",NULL),
("837","woocommerce_cleanup_draft_orders","complete","2023-10-13 03:06:57","2023-10-13 03:06:57","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697166417;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697166417;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-13 03:14:25","2023-10-13 10:14:25","0",NULL),
("838","woocommerce_cleanup_draft_orders","complete","2023-10-14 03:14:25","2023-10-14 03:14:25","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697253265;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697253265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-14 03:57:58","2023-10-14 10:57:58","0",NULL),
("839","rank_math/analytics/data_fetch","complete","2023-10-16 19:57:49","2023-10-16 19:57:49","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697486269;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697486269;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-16 20:05:17","2023-10-17 03:05:17","0",NULL),
("840","woocommerce_cleanup_draft_orders","complete","2023-10-15 03:57:58","2023-10-15 03:57:58","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697342278;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697342278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-15 04:06:45","2023-10-15 11:06:45","0",NULL),
("841","woocommerce_cleanup_draft_orders","complete","2023-10-16 04:06:45","2023-10-16 04:06:45","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697429205;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697429205;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-16 04:08:37","2023-10-16 11:08:37","0",NULL),
("842","woocommerce_cleanup_draft_orders","complete","2023-10-17 04:08:37","2023-10-17 04:08:37","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697515717;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697515717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-17 04:16:12","2023-10-17 11:16:12","0",NULL),
("843","rank_math/analytics/data_fetch","complete","2023-10-19 20:05:17","2023-10-19 20:05:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697745917;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697745917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-19 20:19:06","2023-10-20 03:19:06","0",NULL),
("844","woocommerce_cleanup_draft_orders","complete","2023-10-18 04:16:12","2023-10-18 04:16:12","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697602572;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697602572;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-18 04:30:27","2023-10-18 11:30:27","0",NULL),
("845","woocommerce_cleanup_draft_orders","complete","2023-10-19 04:30:27","2023-10-19 04:30:27","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697689827;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697689827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-19 05:00:31","2023-10-19 12:00:31","0",NULL),
("846","woocommerce_cleanup_draft_orders","complete","2023-10-20 05:00:31","2023-10-20 05:00:31","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697778031;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697778031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-20 05:00:38","2023-10-20 12:00:38","0",NULL),
("847","rank_math/analytics/data_fetch","complete","2023-10-22 20:19:06","2023-10-22 20:19:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698005946;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698005946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-22 20:33:51","2023-10-23 03:33:51","0",NULL),
("848","woocommerce_cleanup_draft_orders","complete","2023-10-21 05:00:38","2023-10-21 05:00:38","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697864438;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697864438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-21 05:05:45","2023-10-21 12:05:45","0",NULL),
("849","woocommerce_cleanup_draft_orders","complete","2023-10-22 05:05:45","2023-10-22 05:05:45","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1697951145;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1697951145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-22 05:11:42","2023-10-22 12:11:42","0",NULL),
("850","woocommerce_cleanup_draft_orders","complete","2023-10-23 05:11:42","2023-10-23 05:11:42","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698037902;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698037902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-23 05:32:52","2023-10-23 12:32:52","0",NULL),
("851","rank_math/analytics/data_fetch","complete","2023-10-25 20:33:51","2023-10-25 20:33:51","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698266031;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698266031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-25 20:34:52","2023-10-26 03:34:52","0",NULL),
("852","woocommerce_cleanup_draft_orders","complete","2023-10-24 05:32:52","2023-10-24 05:32:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698125572;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698125572;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-24 05:45:28","2023-10-24 12:45:28","0",NULL),
("853","woocommerce_cleanup_draft_orders","complete","2023-10-25 05:45:28","2023-10-25 05:45:28","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698212728;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698212728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-25 06:37:06","2023-10-25 13:37:06","0",NULL),
("854","woocommerce_cleanup_draft_orders","complete","2023-10-26 06:37:06","2023-10-26 06:37:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698302226;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698302226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-26 06:39:32","2023-10-26 13:39:32","0",NULL),
("855","rank_math/analytics/data_fetch","complete","2023-10-28 20:34:52","2023-10-28 20:34:52","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698525292;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698525292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","1","2023-10-28 20:36:15","2023-10-29 03:36:15","0",NULL),
("856","woocommerce_cleanup_draft_orders","complete","2023-10-27 06:39:32","2023-10-27 06:39:32","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698388772;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698388772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-27 06:51:17","2023-10-27 13:51:17","0",NULL),
("857","woocommerce_cleanup_draft_orders","complete","2023-10-28 06:51:17","2023-10-28 06:51:17","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698475877;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698475877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-28 06:52:03","2023-10-28 13:52:03","0",NULL),
("858","woocommerce_cleanup_draft_orders","complete","2023-10-29 06:52:03","2023-10-29 06:52:03","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698562323;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698562323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-29 06:52:16","2023-10-29 13:52:16","0",NULL),
("859","wc-admin_import_customers","complete","2023-10-28 14:45:16","2023-10-28 14:45:16","[1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698504316;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698504316;}","3","1","2023-10-28 14:51:15","2023-10-28 21:51:15","0",NULL),
("860","wc-admin_import_customers","complete","2023-10-28 15:27:35","2023-10-28 15:27:35","[1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698506855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698506855;}","3","1","2023-10-28 15:27:35","2023-10-28 22:27:35","0",NULL),
("861","wc-admin_import_orders","complete","2023-10-28 15:27:35","2023-10-28 15:27:35","[3425]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698506855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698506855;}","3","1","2023-10-28 15:27:35","2023-10-28 22:27:35","0",NULL),
("862","rank_math/analytics/data_fetch","pending","2023-10-31 20:36:15","2023-10-31 20:36:15","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698784575;s:18:\"\0*\0first_timestamp\";i:1660842120;s:13:\"\0*\0recurrence\";i:259200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698784575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:259200;}","7","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("863","woocommerce_cleanup_draft_orders","complete","2023-10-30 06:52:16","2023-10-30 06:52:16","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698648736;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698648736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","1","2023-10-30 06:55:06","2023-10-30 13:55:06","0",NULL),
("864","woocommerce_cleanup_draft_orders","pending","2023-10-31 06:55:06","2023-10-31 06:55:06","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1698735306;s:18:\"\0*\0first_timestamp\";i:1655781251;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1698735306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("865","wc-admin_import_customers","complete","2023-10-30 08:38:29","2023-10-30 08:38:29","[1]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698655109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698655109;}","3","1","2023-10-30 08:38:39","2023-10-30 15:38:39","0",NULL);


/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","woocommerce-db-updates"),
("3","wc-admin-data"),
("4","woocommerce-remote-inbox-engine"),
("5","wc_update_product_default_cat"),
("6","workflow"),
("7","rank-math");


/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES 
("111","61","hành động được tạo","2022-04-27 04:57:44","2022-04-27 04:57:44"),
("115","65","hành động được tạo","2022-04-27 04:57:44","2022-04-27 04:57:44"),
("153","61","action started via WP Cron","2022-04-27 04:58:35","2022-04-27 04:58:35"),
("154","61","unexpected shutdown: PHP Fatal error Cannot redeclare filter_created_pages() (previously declared in /home/songkh15/public_html/antam.net/wp-content/plugins/woocommerce/includes/wc-update-functions.php:2289) in /home/songkh15/public_html/antam.net/wp-content/plugins/woocommerce/includes/wc-update-functions.php on line 2289","2022-04-27 04:58:35","2022-04-27 04:58:35"),
("165","65","action started via Async Request","2022-04-27 04:58:35","2022-04-27 04:58:35"),
("166","65","action failed via Async Request: Can\'t enable or disable the attributes lookup table usage while it\'s regenerating.","2022-04-27 04:58:35","2022-04-27 04:58:35"),
("2416","819","action created","2023-09-28 17:44:38","2023-09-28 17:44:38"),
("2419","820","action created","2023-09-28 22:26:05","2023-09-28 22:26:05"),
("2420","820","action started via WP Cron","2023-09-29 22:40:06","2023-09-29 22:40:06"),
("2421","820","action complete via WP Cron","2023-09-29 22:40:06","2023-09-29 22:40:06"),
("2422","821","action created","2023-09-29 22:40:06","2023-09-29 22:40:06"),
("2423","821","action started via WP Cron","2023-09-30 22:53:57","2023-09-30 22:53:57"),
("2424","821","action complete via WP Cron","2023-09-30 22:53:57","2023-09-30 22:53:57"),
("2425","822","action created","2023-09-30 22:53:57","2023-09-30 22:53:57"),
("2426","819","action started via WP Cron","2023-10-01 17:51:01","2023-10-01 17:51:01"),
("2427","819","action complete via WP Cron","2023-10-01 17:51:01","2023-10-01 17:51:01"),
("2428","823","action created","2023-10-01 17:51:01","2023-10-01 17:51:01"),
("2429","822","action started via WP Cron","2023-10-01 23:08:19","2023-10-01 23:08:19"),
("2430","822","action complete via WP Cron","2023-10-01 23:08:19","2023-10-01 23:08:19"),
("2431","824","action created","2023-10-01 23:08:19","2023-10-01 23:08:19"),
("2432","824","action started via WP Cron","2023-10-02 23:18:50","2023-10-02 23:18:50"),
("2433","824","action complete via WP Cron","2023-10-02 23:18:50","2023-10-02 23:18:50"),
("2434","825","action created","2023-10-02 23:18:50","2023-10-02 23:18:50"),
("2435","825","action started via WP Cron","2023-10-03 23:24:00","2023-10-03 23:24:00"),
("2436","825","action complete via WP Cron","2023-10-03 23:24:00","2023-10-03 23:24:00"),
("2437","826","action created","2023-10-03 23:24:00","2023-10-03 23:24:00"),
("2438","823","action started via WP Cron","2023-10-04 18:06:21","2023-10-04 18:06:21"),
("2439","823","action complete via WP Cron","2023-10-04 18:06:21","2023-10-04 18:06:21"),
("2440","827","action created","2023-10-04 18:06:21","2023-10-04 18:06:21"),
("2441","826","action started via WP Cron","2023-10-04 23:58:22","2023-10-04 23:58:22"),
("2442","826","action complete via WP Cron","2023-10-04 23:58:22","2023-10-04 23:58:22"),
("2443","828","action created","2023-10-04 23:58:22","2023-10-04 23:58:22"),
("2444","828","action started via WP Cron","2023-10-06 00:01:33","2023-10-06 00:01:33"),
("2445","828","action complete via WP Cron","2023-10-06 00:01:33","2023-10-06 00:01:33"),
("2446","829","action created","2023-10-06 00:01:33","2023-10-06 00:01:33"),
("2447","829","action started via WP Cron","2023-10-07 00:05:46","2023-10-07 00:05:46"),
("2448","829","action complete via WP Cron","2023-10-07 00:05:46","2023-10-07 00:05:46"),
("2449","830","action created","2023-10-07 00:05:46","2023-10-07 00:05:46"),
("2450","827","action started via WP Cron","2023-10-07 19:20:04","2023-10-07 19:20:04"),
("2451","827","action complete via WP Cron","2023-10-07 19:20:04","2023-10-07 19:20:04"),
("2452","831","action created","2023-10-07 19:20:04","2023-10-07 19:20:04"),
("2453","830","action started via WP Cron","2023-10-08 00:11:28","2023-10-08 00:11:28"),
("2454","830","action complete via WP Cron","2023-10-08 00:11:28","2023-10-08 00:11:28"),
("2455","832","action created","2023-10-08 00:11:28","2023-10-08 00:11:28"),
("2456","832","action started via WP Cron","2023-10-09 00:52:09","2023-10-09 00:52:09"),
("2457","832","action complete via WP Cron","2023-10-09 00:52:09","2023-10-09 00:52:09"),
("2458","833","action created","2023-10-09 00:52:09","2023-10-09 00:52:09"),
("2459","833","action started via WP Cron","2023-10-10 01:47:21","2023-10-10 01:47:21"),
("2460","833","action complete via WP Cron","2023-10-10 01:47:21","2023-10-10 01:47:21"),
("2461","834","action created","2023-10-10 01:47:21","2023-10-10 01:47:21"),
("2462","831","action started via WP Cron","2023-10-10 19:31:05","2023-10-10 19:31:05"),
("2463","831","action complete via WP Cron","2023-10-10 19:31:05","2023-10-10 19:31:05"),
("2464","835","action created","2023-10-10 19:31:05","2023-10-10 19:31:05"),
("2465","834","action started via WP Cron","2023-10-11 03:01:29","2023-10-11 03:01:29"),
("2466","834","action complete via WP Cron","2023-10-11 03:01:29","2023-10-11 03:01:29"),
("2467","836","action created","2023-10-11 03:01:29","2023-10-11 03:01:29"),
("2468","836","action started via WP Cron","2023-10-12 03:06:57","2023-10-12 03:06:57"),
("2469","836","action complete via WP Cron","2023-10-12 03:06:57","2023-10-12 03:06:57"),
("2470","837","action created","2023-10-12 03:06:57","2023-10-12 03:06:57"),
("2471","837","action started via WP Cron","2023-10-13 03:14:25","2023-10-13 03:14:25"),
("2472","837","action complete via WP Cron","2023-10-13 03:14:25","2023-10-13 03:14:25"),
("2473","838","action created","2023-10-13 03:14:25","2023-10-13 03:14:25"),
("2474","835","action started via WP Cron","2023-10-13 19:57:49","2023-10-13 19:57:49"),
("2475","835","action complete via WP Cron","2023-10-13 19:57:49","2023-10-13 19:57:49"),
("2476","839","action created","2023-10-13 19:57:49","2023-10-13 19:57:49"),
("2477","838","action started via WP Cron","2023-10-14 03:57:58","2023-10-14 03:57:58"),
("2478","838","action complete via WP Cron","2023-10-14 03:57:58","2023-10-14 03:57:58"),
("2479","840","action created","2023-10-14 03:57:58","2023-10-14 03:57:58"),
("2480","840","action started via WP Cron","2023-10-15 04:06:45","2023-10-15 04:06:45"),
("2481","840","action complete via WP Cron","2023-10-15 04:06:45","2023-10-15 04:06:45"),
("2482","841","action created","2023-10-15 04:06:45","2023-10-15 04:06:45"),
("2483","841","action started via WP Cron","2023-10-16 04:08:37","2023-10-16 04:08:37"),
("2484","841","action complete via WP Cron","2023-10-16 04:08:37","2023-10-16 04:08:37"),
("2485","842","action created","2023-10-16 04:08:37","2023-10-16 04:08:37"),
("2486","839","action started via WP Cron","2023-10-16 20:05:17","2023-10-16 20:05:17"),
("2487","839","action complete via WP Cron","2023-10-16 20:05:17","2023-10-16 20:05:17"),
("2488","843","action created","2023-10-16 20:05:17","2023-10-16 20:05:17"),
("2489","842","action started via WP Cron","2023-10-17 04:16:12","2023-10-17 04:16:12"),
("2490","842","action complete via WP Cron","2023-10-17 04:16:12","2023-10-17 04:16:12"),
("2491","844","action created","2023-10-17 04:16:12","2023-10-17 04:16:12"),
("2492","844","action started via WP Cron","2023-10-18 04:30:27","2023-10-18 04:30:27"),
("2493","844","action complete via WP Cron","2023-10-18 04:30:27","2023-10-18 04:30:27"),
("2494","845","action created","2023-10-18 04:30:27","2023-10-18 04:30:27"),
("2495","845","action started via WP Cron","2023-10-19 05:00:31","2023-10-19 05:00:31"),
("2496","845","action complete via WP Cron","2023-10-19 05:00:31","2023-10-19 05:00:31"),
("2497","846","action created","2023-10-19 05:00:31","2023-10-19 05:00:31"),
("2498","843","action started via WP Cron","2023-10-19 20:19:06","2023-10-19 20:19:06"),
("2499","843","action complete via WP Cron","2023-10-19 20:19:06","2023-10-19 20:19:06"),
("2500","847","action created","2023-10-19 20:19:06","2023-10-19 20:19:06"),
("2501","846","action started via WP Cron","2023-10-20 05:00:38","2023-10-20 05:00:38"),
("2502","846","action complete via WP Cron","2023-10-20 05:00:38","2023-10-20 05:00:38"),
("2503","848","action created","2023-10-20 05:00:38","2023-10-20 05:00:38"),
("2504","848","action started via WP Cron","2023-10-21 05:05:45","2023-10-21 05:05:45"),
("2505","848","action complete via WP Cron","2023-10-21 05:05:45","2023-10-21 05:05:45"),
("2506","849","action created","2023-10-21 05:05:45","2023-10-21 05:05:45"),
("2507","849","action started via WP Cron","2023-10-22 05:11:42","2023-10-22 05:11:42"),
("2508","849","action complete via WP Cron","2023-10-22 05:11:42","2023-10-22 05:11:42"),
("2509","850","action created","2023-10-22 05:11:42","2023-10-22 05:11:42"),
("2510","847","action started via WP Cron","2023-10-22 20:33:51","2023-10-22 20:33:51"),
("2511","847","action complete via WP Cron","2023-10-22 20:33:51","2023-10-22 20:33:51"),
("2512","851","action created","2023-10-22 20:33:51","2023-10-22 20:33:51"),
("2513","850","action started via WP Cron","2023-10-23 05:32:52","2023-10-23 05:32:52"),
("2514","850","action complete via WP Cron","2023-10-23 05:32:52","2023-10-23 05:32:52"),
("2515","852","action created","2023-10-23 05:32:52","2023-10-23 05:32:52"),
("2516","852","action started via WP Cron","2023-10-24 05:45:28","2023-10-24 05:45:28"),
("2517","852","action complete via WP Cron","2023-10-24 05:45:28","2023-10-24 05:45:28"),
("2518","853","action created","2023-10-24 05:45:28","2023-10-24 05:45:28"),
("2519","853","action started via WP Cron","2023-10-25 06:37:06","2023-10-25 06:37:06"),
("2520","853","action complete via WP Cron","2023-10-25 06:37:06","2023-10-25 06:37:06"),
("2521","854","action created","2023-10-25 06:37:06","2023-10-25 06:37:06"),
("2522","851","action started via WP Cron","2023-10-25 20:34:52","2023-10-25 20:34:52"),
("2523","851","action complete via WP Cron","2023-10-25 20:34:52","2023-10-25 20:34:52"),
("2524","855","action created","2023-10-25 20:34:52","2023-10-25 20:34:52"),
("2525","854","action started via WP Cron","2023-10-26 06:39:32","2023-10-26 06:39:32"),
("2526","854","action complete via WP Cron","2023-10-26 06:39:32","2023-10-26 06:39:32"),
("2527","856","action created","2023-10-26 06:39:32","2023-10-26 06:39:32"),
("2528","856","action started via WP Cron","2023-10-27 06:51:17","2023-10-27 06:51:17"),
("2529","856","action complete via WP Cron","2023-10-27 06:51:17","2023-10-27 06:51:17"),
("2530","857","action created","2023-10-27 06:51:17","2023-10-27 06:51:17"),
("2531","857","action started via WP Cron","2023-10-28 06:52:03","2023-10-28 06:52:03"),
("2532","857","action complete via WP Cron","2023-10-28 06:52:03","2023-10-28 06:52:03"),
("2533","858","action created","2023-10-28 06:52:03","2023-10-28 06:52:03"),
("2534","859","action created","2023-10-28 14:45:11","2023-10-28 14:45:11"),
("2535","859","action started via WP Cron","2023-10-28 14:51:15","2023-10-28 14:51:15"),
("2536","859","action complete via WP Cron","2023-10-28 14:51:15","2023-10-28 14:51:15"),
("2537","860","action created","2023-10-28 15:27:30","2023-10-28 15:27:30"),
("2538","861","action created","2023-10-28 15:27:30","2023-10-28 15:27:30"),
("2539","860","action started via WP Cron","2023-10-28 15:27:35","2023-10-28 15:27:35"),
("2540","860","action complete via WP Cron","2023-10-28 15:27:35","2023-10-28 15:27:35"),
("2541","861","action started via WP Cron","2023-10-28 15:27:35","2023-10-28 15:27:35"),
("2542","861","action complete via WP Cron","2023-10-28 15:27:35","2023-10-28 15:27:35"),
("2543","855","action started via WP Cron","2023-10-28 20:36:15","2023-10-28 20:36:15"),
("2544","855","action complete via WP Cron","2023-10-28 20:36:15","2023-10-28 20:36:15"),
("2545","862","action created","2023-10-28 20:36:15","2023-10-28 20:36:15"),
("2546","858","action started via WP Cron","2023-10-29 06:52:16","2023-10-29 06:52:16"),
("2547","858","action complete via WP Cron","2023-10-29 06:52:16","2023-10-29 06:52:16"),
("2548","863","action created","2023-10-29 06:52:16","2023-10-29 06:52:16"),
("2549","863","action started via WP Cron","2023-10-30 06:55:06","2023-10-30 06:55:06"),
("2550","863","action complete via WP Cron","2023-10-30 06:55:06","2023-10-30 06:55:06"),
("2551","864","action created","2023-10-30 06:55:06","2023-10-30 06:55:06"),
("2552","865","action created","2023-10-30 08:38:24","2023-10-30 08:38:24"),
("2553","865","action started via WP Cron","2023-10-30 08:38:39","2023-10-30 08:38:39"),
("2554","865","action complete via WP Cron","2023-10-30 08:38:39","2023-10-30 08:38:39");


/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES 
("1","3","verified","1"),
("2","4","rating","5"),
("3","4","verified","1"),
("4","5","rating","4"),
("5","5","verified","1"),
("9","8","rating","5"),
("10","8","verified","1"),
("21","36","_wp_trash_meta_status","0"),
("22","36","_wp_trash_meta_time","1698504930");


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES 
("2","2044","admin","khuong3012@gmail.com","http://hungyen.thaibinhweb.com","103.74.119.248","2018-03-24 14:24:13","2018-03-24 07:24:13","Alo","0","1","","comment","0","1"),
("3","1942","admin","khuong3012@gmail.com","http://hungyen.thaibinhweb.com","103.74.119.251","2018-03-24 15:08:44","2018-03-24 08:08:44","ngon","0","1","","review","0","1"),
("4","1942","khách hàng","khuong3012@gmail.com","","103.74.119.247","2018-03-26 08:46:20","2018-03-26 01:46:20","Hàng tốt cảm ơn bạn","0","1","","review","0","0"),
("5","1967","admin","khuong3012@gmail.com","http://hungyen.thaibinhweb.com","103.74.119.247","2018-03-24 15:21:56","2018-03-24 08:21:56","hiii","0","1","","review","0","1"),
("8","2135","Thanh Pham","thanhppm@gmail.com","","103.74.119.247","2018-03-24 14:59:02","2018-03-24 07:59:02","Rất tốt","0","1","","review","0","0"),
("16","3210","WooCommerce","woocommerce@phukientot.vn","","","2022-04-28 15:03:37","2022-04-28 08:03:37","Đơn hàng từ plugin MUA HÀNG NHANH Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Tạm giữ.","0","1","WooCommerce","order_note","0","0"),
("17","3226","WooCommerce","woocommerce@phukientot.vn","","","2022-05-05 14:19:23","2022-05-05 07:19:23","Thực hiện thanh toán khi giao hàng Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Đang xử lý.","0","1","WooCommerce","order_note","0","0"),
("18","3282","WooCommerce","woocommerce@phukientot.vn","","","2022-05-24 14:50:30","2022-05-24 07:50:30","Thực hiện thanh toán khi giao hàng Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Đang xử lý.","0","1","WooCommerce","order_note","0","0"),
("19","3283","phukientot","tamnguyen.tuu@gmail.com","","","2022-05-24 14:50:55","2022-05-24 07:50:55","Đơn hàng từ plugin MUA HÀNG NHANH Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Đang xử lý.","0","1","WooCommerce","order_note","0","0"),
("20","3284","WooCommerce","woocommerce@phukientot.vn","","","2022-05-24 14:54:13","2022-05-24 07:54:13","Thực hiện thanh toán khi giao hàng Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Đang xử lý.","0","1","WooCommerce","order_note","0","0"),
("21","3285","WooCommerce","woocommerce@phukientot.vn","","","2022-05-24 14:56:11","2022-05-24 07:56:11","Thực hiện thanh toán khi giao hàng Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Đang xử lý.","0","1","WooCommerce","order_note","0","0"),
("22","3285","phukientot","tamnguyen.tuu@gmail.com","","","2022-05-24 14:57:30","2022-05-24 07:57:30","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Đang xử lý sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("23","3210","phukientot","tamnguyen.tuu@gmail.com","","","2022-05-24 14:58:09","2022-05-24 07:58:09","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Tạm giữ sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("24","3226","phukientot","tamnguyen.tuu@gmail.com","","","2022-05-24 14:58:09","2022-05-24 07:58:09","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Đang xử lý sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("25","3282","phukientot","tamnguyen.tuu@gmail.com","","","2022-05-24 14:58:10","2022-05-24 07:58:10","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Đang xử lý sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("26","3283","phukientot","tamnguyen.tuu@gmail.com","","","2022-05-24 14:58:10","2022-05-24 07:58:10","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Đang xử lý sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("27","3284","phukientot","tamnguyen.tuu@gmail.com","","","2022-05-24 14:58:10","2022-05-24 07:58:10","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Đang xử lý sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("28","3312","phukientot","tamnguyen.tuu@gmail.com","","","2022-07-15 15:14:23","2022-07-15 08:14:23","Đơn hàng từ plugin MUA HÀNG NHANH Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Đang xử lý.","0","1","WooCommerce","order_note","0","0"),
("29","3381","WooCommerce","woocommerce@antam.net","","","2022-08-06 04:02:43","2022-08-05 21:02:43","Đơn hàng từ plugin MUA HÀNG NHANH Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Tạm giữ.","0","1","WooCommerce","order_note","0","0"),
("30","3397","WooCommerce","woocommerce@antam.net","","","2022-09-01 17:54:40","2022-09-01 10:54:40","Đơn hàng từ plugin MUA HÀNG NHANH Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Đang xử lý.","0","1","WooCommerce","order_note","0","0"),
("31","3312","antam","tamnguyen.tuu@gmail.com","","","2022-09-16 15:16:47","2022-09-16 08:16:47","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Đang xử lý sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("32","3381","antam","tamnguyen.tuu@gmail.com","","","2022-09-16 15:16:47","2022-09-16 08:16:47","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Tạm giữ sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("33","3397","antam","tamnguyen.tuu@gmail.com","","","2022-09-16 15:16:47","2022-09-16 08:16:47","Trạng thái đơn hàng đã thay đổi bởi sửa hàng loạt: Trạng thái đơn hàng đã được chuyển từ Đang xử lý sang Đã hoàn thành.","0","1","WooCommerce","order_note","0","0"),
("34","2041","philippines bingo live","hung.barney@wildmail.com","http://www.Bingoplus.com/","184.174.25.243","2023-05-20 04:17:46","2023-05-19 21:17:46","I ｒeally enjoy thiѕ game.Iplay ɑ game , and then Ι clean սρ a paгt \r\nof my house. Thеn, for my bredak Ӏ play а diffeгent game.\r\nΙ\'m addicted І\'m aware.","0","spam","Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0","comment","0","0"),
("35","2041","Http://Arenaplus.Net","lettie_manske@yahoo.de","http://Arenaplus.net/","150.107.202.143","2023-05-23 20:13:27","2023-05-23 13:13:27","What\'s not tߋ love! Thіs game ⲟffers eｖerything I\'ve \r\nɑlways wanted in a sports bettingg games. Ƭhe thingѕ \r\nӀ enjoy moѕt arе: numerous sports bettings on ⲟne \r\ncard, easy to earn rewards, joining ɑ club, the tournament mode...ɑnd tthe \r\nlist goеs on. It\'s the onoy game I could practically play ɑll ԁay long without \r\nworrying about being unable to play Ƅecause ⲟf credit.\r\nIt woᥙld bе ցreat having diffeгent daggers һowever, \r\nеverything eⅼse, 100% tһe most enjoyable!","0","spam","Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0","comment","0","0"),
("36","2041","David E. Smith","desmondhowie@hotmail.co.uk","https://m.cheapestdigitalbooks.com","103.134.33.91","2023-10-24 08:51:07","2023-10-24 01:51:07","Dear Website Owner,\r\n\r\nI hope this email finds you well. I recently discovered your website and was impressed by the quality of your content and the helpful information you offer to your audience. In light of this, I would like to propose a backlink exchange that could benefit both our websites.\r\n\r\nMy website, https://m.cheapestdigitalbooks.com/, is focused on providing affordable digital books to readers around the world. We currently have a strong online presence with a Domain Authority (DA) of 13, a Page Authority (PA) of 52, and a Domain Rating (DR) of 78. Our website features 252K backlinks, with 95% of them being dofollow, and has established connections with 5.3K linking websites, with 23% of these being dofollow links.\r\n\r\nI believe that a mutually beneficial backlink exchange could be of great value for both of our websites, as it may lead to an increase in website authority and improve our search engine rankings. In this collaboration, I am willing to add backlinks from my website using your desired keywords and anchor texts. In return, I would be grateful if you could include backlinks with my desired keywords and anchor texts on your website.\r\n\r\nI kindly request that you visit my website, https://m.cheapestdigitalbooks.com/, to get a sense of the potential benefits this partnership could bring to your site. I am confident that this collaboration will provide a win-win situation for both parties, and I look forward to learning more about your thoughts on this proposal.\r\n\r\nThank you for considering my offer. I am excited about the potential growth this partnership may bring to our websites and am eager to discuss the details further. Please do not hesitate to reach out to me at your convenience.\r\n\r\nBest regards,\r\n\r\nDavid E. Smith\r\nEmail: david@cheapestdigitalbooks.com\r\nAddress: 3367 Hood Avenue, San Diego, CA 92117","0","spam","Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:114.0) Gecko/20100101 Firefox/114.0","comment","0","0"),
("37","3425","WooCommerce","woocommerce@antam.net","","","2023-10-28 22:27:30","2023-10-28 15:27:30","Chờ thanh toán chuyển khoản Trạng thái đơn hàng đã được chuyển từ Chờ thanh toán sang Tạm giữ.","0","1","WooCommerce","order_note","0","0");


/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_phpdump_qrylimit\": 500,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"http:\\/\\/antam.net\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1000,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1698655703,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1698655715,\n    \"initial_activation_timestamp\": 1698655715,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"notices\": {\n        \"dupArchiveSwitch\": true\n    }\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": null,\n    \"lkp\": \"\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1698656032,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}"),
("4","DUP_PRO_Package_Template_Entity","{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");


/* INSERT TABLE DATA: wp_duplicator_pro_packages */
INSERT INTO `wp_duplicator_pro_packages` VALUES 
("1","20231030_antammaytinhphukien","43c441f59558f7aa2287_20231030085341","21","2023-10-30 15:53:50","antam","{\n    \"Created\": \"2023-10-30 08:53:41\",\n    \"Version\": \"3.8.4\",\n    \"VersionWP\": \"6.3.2\",\n    \"VersionDB\": \"10.6.15\",\n    \"VersionPHP\": \"7.3.33\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 1,\n    \"Name\": \"20231030_antammaytinhphukien\",\n    \"Hash\": \"43c441f59558f7aa2287_20231030085341\",\n    \"NameHash\": \"20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341\",\n    \"Type\": 0,\n    \"Notes\": \"\",\n    \"StorePath\": \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/antam.net\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341_scan.json\",\n    \"timer_start\": 1698656033.050567,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/cache\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/old-cache\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/updraft\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/wfcache\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/.htaccess\",\n            \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error.log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"File\": \"20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/songkh15\\/public_html\\/antam.net\",\n        \"Size\": 193666593,\n        \"Dirs\": null,\n        \"DirCount\": 2015,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 12784,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"Unreadable\": [],\n                \"AddonSites\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Unreadable\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \";\\n\",\n        \"throttleDelayInUs\": 2,\n        \"isOuterWPContentDir\": false\n    },\n    \"Multisite\": {\n        \"FilterSites\": \"\"\n    },\n    \"Installer\": {\n        \"File\": \"20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"collationList\": [\n                \"utf8mb4_unicode_ci\",\n                \"latin1_swedish_ci\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"songkh15_antam\",\n            \"tablesBaseCount\": 57,\n            \"tablesFinalCount\": 57,\n            \"tablesRowCount\": 6894,\n            \"tablesSizeOnDisk\": 8273796,\n            \"varLowerCaseTables\": \"0\",\n            \"version\": \"10.6.15\",\n            \"versionComment\": \"MariaDB Server\",\n            \"tableWiseRowCounts\": {\n                \"wp_actionscheduler_actions\": \"49\",\n                \"wp_actionscheduler_claims\": \"0\",\n                \"wp_actionscheduler_groups\": \"7\",\n                \"wp_actionscheduler_logs\": \"143\",\n                \"wp_commentmeta\": \"9\",\n                \"wp_comments\": \"27\",\n                \"wp_duplicator_pro_entities\": \"5\",\n                \"wp_duplicator_pro_packages\": \"1\"\n            }\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": null,\n        \"File\": \"20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backups-dup-pro\\/tmp\\/20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341_database.sql\",\n        \"sameNameTableExists\": false,\n        \"indexProcessedSchemaSize\": [\n            0,\n            180224,\n            212992,\n            245760,\n            294912,\n            344064,\n            458752,\n            468432\n        ],\n        \"intFieldsStruct\": {\n            \"wp_actionscheduler_actions\": {\n                \"action_id\": \"NULL\",\n                \"group_id\": \"0\",\n                \"attempts\": \"0\",\n                \"claim_id\": \"0\"\n            },\n            \"wp_actionscheduler_claims\": {\n                \"claim_id\": \"NULL\"\n            },\n            \"wp_actionscheduler_groups\": {\n                \"group_id\": \"NULL\"\n            },\n            \"wp_actionscheduler_logs\": {\n                \"log_id\": \"NULL\",\n                \"action_id\": \"NULL\"\n            },\n            \"wp_commentmeta\": {\n                \"meta_id\": \"NULL\",\n                \"comment_id\": \"0\"\n            },\n            \"wp_comments\": {\n                \"comment_ID\": \"NULL\",\n                \"comment_post_ID\": \"0\",\n                \"comment_karma\": \"0\",\n                \"comment_parent\": \"0\",\n                \"user_id\": \"0\"\n            },\n            \"wp_duplicator_pro_entities\": {\n                \"id\": \"NULL\"\n            }\n        }\n    },\n    \"Status\": \"21.1\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1698656035,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"custom_data\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tableIndex\": 0,\n        \"tableOffset\": 0,\n        \"totalRowOffset\": 0,\n        \"chunkIndex\": null,\n        \"validationStage1\": false,\n        \"bulkOffset\": 0,\n        \"bulkSizeOffset\": 0,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"tablesToProcess\": [\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_pro_entities\",\n            \"wp_duplicator_pro_packages\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_rank_math_analytics_keyword_manager\",\n            \"wp_rank_math_analytics_objects\",\n            \"wp_rank_math_internal_links\",\n            \"wp_rank_math_internal_meta\",\n            \"wp_rank_math_redirections\",\n            \"wp_rank_math_redirections_cache\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_usermeta\",\n            \"wp_users\",\n            \"wp_wc_admin_note_actions\",\n            \"wp_wc_admin_notes\",\n            \"wp_wc_category_lookup\",\n            \"wp_wc_customer_lookup\",\n            \"wp_wc_download_log\",\n            \"wp_wc_order_coupon_lookup\",\n            \"wp_wc_order_product_lookup\",\n            \"wp_wc_order_stats\",\n            \"wp_wc_order_tax_lookup\",\n            \"wp_wc_product_attributes_lookup\",\n            \"wp_wc_product_download_directories\",\n            \"wp_wc_product_meta_lookup\",\n            \"wp_wc_rate_limits\",\n            \"wp_wc_reserved_stock\",\n            \"wp_wc_tax_rate_classes\",\n            \"wp_wc_webhooks\",\n            \"wp_woocommerce_api_keys\",\n            \"wp_woocommerce_attribute_taxonomies\",\n            \"wp_woocommerce_downloadable_product_permissions\",\n            \"wp_woocommerce_log\",\n            \"wp_woocommerce_order_itemmeta\",\n            \"wp_woocommerce_order_items\",\n            \"wp_woocommerce_payment_tokenmeta\",\n            \"wp_woocommerce_payment_tokens\",\n            \"wp_woocommerce_sessions\",\n            \"wp_woocommerce_shipping_zone_locations\",\n            \"wp_woocommerce_shipping_zone_methods\",\n            \"wp_woocommerce_shipping_zones\",\n            \"wp_woocommerce_tax_rate_locations\",\n            \"wp_woocommerce_tax_rates\",\n            \"wp_woof_query_cache\",\n            \"wp_yoast_seo_links\",\n            \"wp_yoast_seo_meta\"\n        ],\n        \"startTime\": 1698656033.136839,\n        \"fileOffset\": 31134,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"totalSchemaSize\": 8284564,\n        \"tablesSchemaSizes\": {\n            \"wp_termmeta\": 49152,\n            \"wp_yoast_seo_meta\": 65536,\n            \"wp_wc_category_lookup\": 16384,\n            \"wp_actionscheduler_groups\": 32768,\n            \"wp_wc_reserved_stock\": 16384,\n            \"wp_rank_math_analytics_keyword_manager\": 1024,\n            \"wp_woocommerce_payment_tokenmeta\": 49152,\n            \"wp_woocommerce_downloadable_product_permissions\": 81920,\n            \"wp_rank_math_analytics_objects\": 17880,\n            \"wp_wc_product_download_directories\": 4096,\n            \"wp_wc_download_log\": 49152,\n            \"wp_wc_order_stats\": 65536,\n            \"wp_rank_math_redirections_cache\": 3188,\n            \"wp_options\": 3457024,\n            \"wp_rank_math_redirections\": 3512,\n            \"wp_wc_admin_notes\": 81920,\n            \"wp_woof_query_cache\": 32768,\n            \"wp_woocommerce_api_keys\": 49152,\n            \"wp_duplicator_pro_entities\": 9680,\n            \"wp_term_relationships\": 32768,\n            \"wp_wc_product_attributes_lookup\": 4168,\n            \"wp_wc_rate_limits\": 4096,\n            \"wp_wc_order_coupon_lookup\": 49152,\n            \"wp_wc_admin_note_actions\": 98304,\n            \"wp_posts\": 1589248,\n            \"wp_woocommerce_tax_rates\": 81920,\n            \"wp_yoast_seo_links\": 32768,\n            \"wp_wc_product_meta_lookup\": 114688,\n            \"wp_postmeta\": 901120,\n            \"wp_woocommerce_shipping_zones\": 16384,\n            \"wp_wc_order_product_lookup\": 81920,\n            \"wp_users\": 65536,\n            \"wp_woocommerce_tax_rate_locations\": 49152,\n            \"wp_actionscheduler_logs\": 49152,\n            \"wp_usermeta\": 49152,\n            \"wp_wc_customer_lookup\": 49152,\n            \"wp_actionscheduler_actions\": 180224,\n            \"wp_woocommerce_order_itemmeta\": 49152,\n            \"wp_links\": 32768,\n            \"wp_terms\": 49152,\n            \"wp_rank_math_internal_meta\": 3308,\n            \"wp_term_taxonomy\": 49152,\n            \"wp_wc_order_tax_lookup\": 49152,\n            \"wp_woocommerce_payment_tokens\": 32768,\n            \"wp_woocommerce_sessions\": 32768,\n            \"wp_woocommerce_attribute_taxonomies\": 32768,\n            \"wp_comments\": 114688,\n            \"wp_woocommerce_order_items\": 32768,\n            \"wp_duplicator_pro_packages\": 11792,\n            \"wp_commentmeta\": 49152,\n            \"wp_woocommerce_shipping_zone_locations\": 49152,\n            \"wp_rank_math_internal_links\": 13436,\n            \"wp_woocommerce_log\": 32768,\n            \"wp_actionscheduler_claims\": 32768,\n            \"wp_wc_tax_rate_classes\": 32768,\n            \"wp_woocommerce_shipping_zone_methods\": 16384,\n            \"wp_wc_webhooks\": 32768\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}");


/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES 
("1","siteurl","https://antam.net","yes"),
("2","home","https://antam.net","yes"),
("3","blogname","An Tâm - Máy tính, Phụ kiện","yes"),
("4","blogdescription","Uy tín, chất lượng hàng đầu","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","tamnguyen.tuu@gmail.com","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","d/m/Y","yes"),
("24","time_format","H:i","yes"),
("25","links_updated_date_format","j F, Y g:i a","yes"),
("26","comment_moderation","1","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:14:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:35:\"devvn-quick-buy/devvn-quick-buy.php\";i:4;s:55:\"devvn-woocommerce-reviews/devvn-woocommerce-reviews.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:22:\"font-awesome/index.php\";i:7;s:25:\"menu-icons/menu-icons.php\";i:8;s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";i:9;s:30:\"seo-by-rank-math/rank-math.php\";i:10;s:51:\"webico-slider-flatsome-addons/wbc_slider_addons.php\";i:11;s:56:\"woo-checkout-field-editor-pro/checkout-form-designer.php\";i:12;s:37:\"woocommerce-products-filter/index.php\";i:13;s:27:\"woocommerce/woocommerce.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","http://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","7","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","a:5:{i:0;s:103:\"/home/songkh15/public_html/antam.net/wp-content/themes/phu-kien/template-parts/posts/content-single.php\";i:2;s:73:\"/home/songkh15/public_html/antam.net/wp-content/themes/phu-kien/style.css\";i:3;s:77:\"/home/songkh15/public_html/antam.net/wp-content/themes/phu-kien/functions.php\";i:4;s:100:\"/home/songkh15/public_html/antam.net/wp-content/themes/phu-kien/woocommerce/single-product/share.php\";i:5;s:121:\"/home/songkh15/public_html/antam.net/wp-content/themes/phu-kien/woocommerce/single-product/layouts/product-no-sidebar.php\";}","no"),
("40","template","flatsome","yes"),
("41","stylesheet","phu-kien","yes"),
("44","comment_registration","","yes"),
("45","html_type","text/html","yes"),
("46","use_trackback","0","yes"),
("47","default_role","subscriber","yes"),
("48","db_version","55853","yes"),
("49","uploads_use_yearmonth_folders","1","yes"),
("50","upload_path","","yes"),
("51","blog_public","1","yes"),
("52","default_link_category","2","yes"),
("53","show_on_front","page","yes"),
("54","tag_base","","yes"),
("55","show_avatars","1","yes"),
("56","avatar_rating","G","yes"),
("57","upload_url_path","","yes"),
("58","thumbnail_size_w","150","yes"),
("59","thumbnail_size_h","150","yes"),
("60","thumbnail_crop","1","yes"),
("61","medium_size_w","300","yes"),
("62","medium_size_h","300","yes"),
("63","avatar_default","mystery","yes"),
("64","large_size_w","1024","yes"),
("65","large_size_h","1024","yes"),
("66","image_default_link_type","file","yes"),
("67","image_default_size","","yes"),
("68","image_default_align","","yes"),
("69","close_comments_for_old_posts","","yes"),
("70","close_comments_days_old","14","yes"),
("71","thread_comments","1","yes"),
("72","thread_comments_depth","3","yes"),
("73","page_comments","1","yes"),
("74","comments_per_page","2","yes"),
("75","default_comments_page","oldest","yes"),
("76","comment_order","desc","yes"),
("77","sticky_posts","a:0:{}","yes"),
("78","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("79","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("80","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("81","uninstall_plugins","a:1:{s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}}","no"),
("82","timezone_string","","yes"),
("83","page_for_posts","0","yes"),
("84","page_on_front","24","yes"),
("85","default_post_format","0","yes"),
("86","link_manager_enabled","0","yes"),
("87","finished_splitting_shared_terms","1","yes"),
("88","site_icon","3232","yes"),
("89","medium_large_size_w","768","yes"),
("90","medium_large_size_h","0","yes"),
("91","wp_page_for_privacy_policy","3","yes"),
("92","show_comments_cookies_opt_in","","yes"),
("93","admin_email_lifespan","1698763875","yes"),
("94","initial_db_version","47018","yes"),
("95","wp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:131:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}","yes"),
("96","fresh_site","0","yes"),
("97","WPLANG","vi","yes"),
("98","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes"),
("99","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("100","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("101","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("103","sidebars_widgets","a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:17:\"sidebar-product-2\";a:1:{i:0;s:14:\"block_widget-2\";}s:12:\"sidebar-main\";a:3:{i:0;s:8:\"search-2\";i:1;s:23:\"flatsome_recent_posts-3\";i:2;s:22:\"woocommerce_products-3\";}s:16:\"sidebar-footer-1\";a:0:{}s:16:\"sidebar-footer-2\";a:0:{}s:12:\"shop-sidebar\";a:1:{i:0;s:13:\"woof_widget-2\";}s:15:\"product-sidebar\";a:2:{i:0;s:22:\"woocommerce_products-2\";i:1;s:23:\"flatsome_recent_posts-2\";}s:13:\"array_version\";i:3;}","yes"),
("104","cron","a:24:{i:1698656072;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1698656136;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1698656388;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1698656556;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1698657208;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1698658795;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1698659983;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698660362;a:2:{s:41:\"wpseo-premium-prominent-words-recalculate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698662905;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c00531746b968c9f642fabc102fbfcac\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:3426;}}}}i:1698673195;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1698677641;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1698679234;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1698685200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698710400;a:2:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"rank_math/links/internal_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698716395;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698716426;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698716428;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698722018;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698732808;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1698822495;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1699005962;a:1:{s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1699061995;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1699845268;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}","yes"),
("105","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("106","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("107","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("111","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("112","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("113","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("115","recovery_keys","a:0:{}","yes"),
("144","recently_activated","a:0:{}","yes"),
("152","theme_mods_twentytwenty","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1595554894;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","yes"),
("153","current_theme","Phụ kiện","yes"),
("154","theme_mods_flatsome","a:31:{i:0;b:0;s:17:\"flatsome_fallback\";i:0;s:20:\"topbar_elements_left\";a:1:{i:0;s:4:\"html\";}s:21:\"topbar_elements_right\";a:3:{i:0;s:7:\"nav-top\";i:1;s:10:\"newsletter\";i:2;s:6:\"social\";}s:20:\"header_elements_left\";a:2:{i:0;s:6:\"search\";i:1;s:3:\"nav\";}s:21:\"header_elements_right\";a:3:{i:0;s:7:\"account\";i:1;s:7:\"divider\";i:2;s:4:\"cart\";}s:27:\"header_elements_bottom_left\";a:0:{}s:29:\"header_elements_bottom_center\";a:0:{}s:28:\"header_elements_bottom_right\";a:0:{}s:27:\"header_mobile_elements_left\";a:1:{i:0;s:9:\"menu-icon\";}s:28:\"header_mobile_elements_right\";a:1:{i:0;s:4:\"cart\";}s:26:\"header_mobile_elements_top\";a:1:{i:0;s:4:\"html\";}s:14:\"mobile_sidebar\";a:7:{i:0;s:11:\"search-form\";i:1;s:3:\"nav\";i:2;s:7:\"account\";i:3;s:10:\"newsletter\";i:4;s:6:\"social\";i:5;s:6:\"html-2\";i:6;s:6:\"html-3\";}s:14:\"product_layout\";s:19:\"right-sidebar-small\";s:23:\"payment_icons_placement\";s:6:\"footer\";s:14:\"follow_twitter\";s:10:\"http://url\";s:15:\"follow_facebook\";s:10:\"http://url\";s:16:\"follow_instagram\";s:10:\"http://url\";s:12:\"follow_email\";s:10:\"your@email\";s:16:\"flatsome_version\";i:3;s:24:\"portfolio_archive_filter\";s:4:\"left\";s:13:\"type_headings\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"700\";}s:10:\"type_texts\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"400\";}s:8:\"type_nav\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"700\";}s:8:\"type_alt\";a:2:{s:11:\"font-family\";s:14:\"Dancing Script\";s:7:\"variant\";s:3:\"400\";}s:14:\"pages_template\";s:7:\"default\";s:19:\"flatsome_db_version\";s:6:\"3.11.3\";s:18:\"nav_menu_locations\";a:0:{}s:7:\"backups\";N;s:9:\"smof_init\";s:31:\"Fri, 24 Jul 2020 01:41:34 +0000\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1595554918;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:16:\"sidebar-footer-1\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:16:\"sidebar-footer-2\";a:0:{}}}}","yes"),
("155","theme_switched","","yes"),
("156","widget_flatsome_recent_posts","a:3:{i:2;a:4:{s:5:\"title\";s:17:\"Bài viết mới\";s:6:\"number\";i:5;s:5:\"image\";s:2:\"on\";s:10:\"date-stamp\";N;}i:3;a:4:{s:5:\"title\";s:17:\"Bài viết mới\";s:6:\"number\";i:8;s:5:\"image\";s:2:\"on\";s:10:\"date-stamp\";N;}s:12:\"_multiwidget\";i:1;}","yes"),
("157","widget_block_widget","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:5:\"block\";s:23:\"block-sidebar-product-2\";}s:12:\"_multiwidget\";i:1;}","yes"),
("161","flatsome_wup_purchase_code","8f93cd51-5246-4505-9228-9a4137e6ec00","yes"),
("162","flatsome_wup_sold_at","2015-05-22T19:31:36+10:00","yes"),
("163","flatsome_wup_supported_until","2016-03-02T03:00:00+11:00","yes"),
("164","flatsome_wup_buyer","trannguyen886","yes"),
("165","allowedthemes","a:1:{s:8:\"phu-kien\";b:1;}","no"),
("166","fl_has_child_theme","phu-kien","yes"),
("168","theme_mods_phu-kien","a:209:{i:0;b:0;s:17:\"flatsome_fallback\";i:0;s:20:\"topbar_elements_left\";a:0:{}s:21:\"topbar_elements_right\";a:0:{}s:20:\"header_elements_left\";a:1:{i:0;s:11:\"search-form\";}s:21:\"header_elements_right\";a:2:{i:0;s:3:\"nav\";i:1;s:4:\"cart\";}s:27:\"header_elements_bottom_left\";a:0:{}s:29:\"header_elements_bottom_center\";a:0:{}s:28:\"header_elements_bottom_right\";a:0:{}s:27:\"header_mobile_elements_left\";a:1:{i:0;s:9:\"menu-icon\";}s:28:\"header_mobile_elements_right\";a:1:{i:0;s:4:\"cart\";}s:26:\"header_mobile_elements_top\";a:0:{}s:14:\"mobile_sidebar\";a:1:{i:0;s:3:\"nav\";}s:14:\"product_layout\";s:10:\"no-sidebar\";s:23:\"payment_icons_placement\";s:6:\"footer\";s:14:\"follow_twitter\";s:10:\"http://url\";s:15:\"follow_facebook\";s:10:\"http://url\";s:16:\"follow_instagram\";s:10:\"http://url\";s:12:\"follow_email\";s:10:\"your@email\";s:16:\"flatsome_version\";i:3;s:24:\"portfolio_archive_filter\";s:4:\"left\";s:13:\"type_headings\";a:5:{s:11:\"font-family\";s:6:\"Roboto\";s:7:\"variant\";s:3:\"700\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:700;s:10:\"font-style\";s:6:\"normal\";}s:10:\"type_texts\";a:5:{s:11:\"font-family\";s:6:\"Roboto\";s:7:\"variant\";s:7:\"regular\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:400;s:10:\"font-style\";s:6:\"normal\";}s:8:\"type_nav\";a:5:{s:11:\"font-family\";s:6:\"Roboto\";s:7:\"variant\";s:3:\"500\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";i:500;s:10:\"font-style\";s:6:\"normal\";}s:8:\"type_alt\";a:2:{s:11:\"font-family\";s:14:\"Dancing Script\";s:7:\"variant\";s:3:\"400\";}s:14:\"pages_template\";s:13:\"right-sidebar\";s:19:\"flatsome_db_version\";s:6:\"3.15.5\";s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:23;s:14:\"primary_mobile\";i:23;}s:7:\"backups\";N;s:9:\"smof_init\";s:31:\"Fri, 24 Jul 2020 01:42:00 +0000\";s:19:\"html_scripts_header\";s:423:\"<meta name=\"google-site-verification\" content=\"bqUo4ur9K4a7-ugz_y1cMJZtAz0zeaNnZMeDCSN2FHg\" />\r\n<!-- Global site tag (gtag.js) - Google Analytics -->\r\n<script async src=\"https://www.googletagmanager.com/gtag/js?id=UA-149853128-15\"></script>\r\n<script>\r\n  window.dataLayer = window.dataLayer || [];\r\n  function gtag(){dataLayer.push(arguments);}\r\n  gtag(\'js\', new Date());\r\n\r\n  gtag(\'config\', \'UA-149853128-15\');\r\n</script>\r\n\";s:19:\"html_scripts_footer\";s:5114:\"<style>\r\n.phone-mobile {display: none;}\r\n.giuseart-nav {\r\n    position: fixed;\r\n    left: 13px;\r\n    background: #fff;\r\n    border-radius: 5px;\r\n    width: auto;\r\n    z-index: 150;\r\n    bottom: 50px;\r\n    padding: 10px 0;\r\n    border: 1px solid #f2f2f2;\r\n}\r\n.giuseart-nav ul {list-style: none;padding: 0;margin: 0;}\r\n.giuseart-nav ul li {list-style: none!important;}\r\n.giuseart-nav ul>li a {\r\n    border:none;\r\n    padding: 3px;\r\n    display: block;\r\n    border-radius: 5px;\r\n    text-align: center;\r\n    font-size: 10px;\r\n    line-height: 15px;\r\n    color: #515151;\r\n    font-weight: 700;\r\n    max-width: 72.19px;\r\n    max-height: 54px;\r\n    text-decoration: none;\r\n}\r\n.giuseart-nav ul>li .chat_animation{display:none}\r\n.giuseart-nav ul>li a i.ticon-heart {\r\n    background: url(https://myphamxanh.vn/wp-content/uploads/2022/04/icon-map.png) no-repeat;\r\n    background-size: contain;\r\n    width: 36px;\r\n    height: 36px;\r\n    display: block;\r\n}\r\n.giuseart-nav ul>li a i.ticon-zalo-circle2 {\r\n    background: url(https://myphamxanh.vn/wp-content/uploads/2022/04/icon-zalo-circle2..png) no-repeat;\r\n    background-size: contain;\r\n    width: 36px;\r\n    height: 36px;\r\n    display: block;\r\n}.giuseart-nav li .button {\r\n    background: transparent;\r\n}.giuseart-nav ul>li a i.ticon-angle-up {\r\n    background: url(https://myphamxanh.vn/wp-content/uploads/2022/04/icon-angle-up.png) no-repeat;\r\n    background-size: contain;\r\n    width: 36px;\r\n    height: 36px;\r\n    display: block;\r\n}.giuseart-nav ul>li a i {\r\n    width: 33px;\r\n    height: 33px;\r\n    display: block;\r\n    margin: auto;\r\n}.giuseart-nav ul li .button .btn_phone_txt {\r\n    position: relative; top:35px;\r\n    font-size: 10px;\r\n    font-weight: bold;\r\n    text-transform: none;\r\n}\r\n.giuseart-nav ul li .button .phone_animation i {\r\n    display: inline-block;\r\n    width: 27px;\r\n    font-size: 26px;\r\n    margin-top: 12px;\r\n}.giuseart-nav ul>li a.chat_animation svg {\r\n    margin: -13px 0 -20px;\r\n}\r\n.giuseart-nav ul>li a i.ticon-messenger {\r\n    background: url(https://myphamxanh.vn/wp-content/uploads/2022/04/icon-messenger.png) no-repeat;\r\n    background-size: contain;\r\n    width: 36px;\r\n    height: 36px;\r\n    display: block;\r\n}.giuseart-nav ul li .button .phone_animation i {\r\n    display: inline-block;\r\n    width: 27px;\r\n    font-size: 26px;\r\n    margin-top: 12px;\r\n}\r\n.giuseart-nav ul>li a i.ticon-chat-sms {\r\n    background: url(https://myphamxanh.vn/wp-content/uploads/2022/04/icon-sms-1.jpg) no-repeat;\r\n    background-size: contain;\r\n    width: 38px;\r\n    height: 36px;\r\n    display: block;\r\n}\r\n.giuseart-nav ul>li a i.icon-phone-w {\r\n    background: url(https://myphamxanh.vn/wp-content/uploads/2022/04/icon-phone-w.png) no-repeat;\r\n    background-size: contain;}\r\n.giuseart-nav ul li .button .btn_phone_txt {\r\n    position: relative;\r\n}\r\n@media only screen and (max-width: 600px){\r\n.giuseart-nav li .chat_animation{display:block !Important}\r\n \r\n.giuseart-nav li .button .phone_animation {box-shadow: none;\r\n    position: absolute;\r\n    top: -16px;\r\n    left: 50%;\r\n    transform: translate(-50%,0);\r\n    width: 50px;\r\n    height: 50px;\r\n    border-radius: 100%;\r\n    background: #6cb917;\r\n    line-height: 15px;\r\n    border: 2px solid white;\r\n}\r\n.giuseart-nav ul>li a{padding:0; margin:0 auto}\r\n.giuseart-nav {\r\n    background: white;\r\n    width: 100%; border-radius:0;\r\n    color: #fff;\r\n    height: 60px;\r\n    line-height: 50px;\r\n    position: fixed;\r\n    bottom: 0;\r\n    left: 0;\r\n    z-index: 999;\r\n    padding: 5px;\r\n    margin: 0;\r\n    box-shadow: 0 4px 10px 0 #000;\r\n}\r\n.giuseart-nav li {\r\n    float: left;\r\n    width: 20%;\r\n    list-style: none;\r\n    height: 50px;\r\n}\r\n.phone-mobile{display:block !important}}\r\n</style>\r\n<div class=\"giuseart-nav\">\r\n        <ul>\r\n            <li><a href=\"https://myphamxanh.vn\" rel=\"nofollow\" target=\"_blank\"><i class=\"ticon-heart\"></i>Tìm đường</a></li>\r\n            <li><a href=\"https://zalo.me/0906203020\" rel=\"nofollow\" target=\"_blank\"><i class=\"ticon-zalo-circle2\"></i>Chat Zalo</a></li>\r\n                        <li class=\"phone-mobile\">\r\n                            <a href=\"tel:0906203020\" rel=\"nofollow\" class=\"button\">\r\n                                <span class=\"phone_animation animation-shadow\">\r\n                                    <i class=\"icon-phone-w\" aria-hidden=\"true\"></i>\r\n                                </span>\r\n                                <span class=\"btn_phone_txt\">Gọi điện</span>\r\n                            </a>\r\n                        </li>\r\n                        <li><a href=\"https://www.messenger.com/t/phukienantam\" rel=\"nofollow\" target=\"_blank\"><i class=\"ticon-messenger\"></i>Messenger</a></li>\r\n            <li><a href=\"sms:0906203020\" class=\"chat_animation\">\r\n            <i class=\"ticon-chat-sms\" aria-hidden=\"true\" title=\"Nhắn tin sms\"></i>\r\n                Nhắn tin SMS</a>\r\n            </li>\r\n            <li class=\"to-top-pc\">\r\n                <a href=\"#\" rel=\"nofollow\">\r\n                    <i class=\"ticon-angle-up\" aria-hidden=\"true\" title=\"Quay lên trên\"></i>\r\n                </a>\r\n            </li>\r\n        </ul>\r\n    </div>\";s:23:\"html_scripts_after_body\";s:0:\"\";s:24:\"html_scripts_before_body\";s:0:\"\";s:15:\"html_custom_css\";s:20460:\".header-nav li a img{    margin: 0 auto !important;\r\n    max-width: 27px;\r\n    height: 27px;}.TextCaptions {\r\n    padding: 0 !important;\r\n}.flickity-page-dots .dot{width:9px; height:9px}\r\n.slider-section .col{padding-bottom:0}\r\n.devvn_single_price .label-sale{font-size:15px; color:gray} .TextCaptions .item::before{display:none}\r\n.devvn_single_price .gia-goc span.amount{    text-decoration: line-through;\r\n    color: gray;\r\n    font-weight: normal;}\r\n.single-product .product-info{padding-left:5px; display:inline-block; width:100%}\r\n.single-product .large-10{padding-bottom:0}\r\n.single-product .product-info .large-9{padding-bottom:0; padding-left:0; flex-basis:60%; max-width:60%; float:left; display:inline-block; }\r\na.devvn_buy_now_style{margin-bottom:10px; width: 100%;\r\n    max-width: 100%;\r\n    border-radius: 29px;\r\n    background: #ffbe01;\r\n    font-size: 12px; color:#d51f16 !important}\r\n.devvn-popup-title, .popup-customer-info-group .devvn-order-btn{background:#ffeb02 !important; color:black}\r\n.devvn-popup-quickbuy{font-family:\"roboto\", sans-serif}\r\n\r\n.product-footer .container .large-9{float:left; display:inline-block; padding-right:20px}.product-footer .woocommerce-tabs>.nav-line-grow, .product-footer .woocommerce-tabs>.nav-line:not(.nav-vertical){    border-bottom: 2px solid #efefef; margin-top:0}.product-footer .woocommerce-tabs {border: 1px solid #ececec;\r\n    padding: 0;\r\n}.product-main {\r\n    padding: 20px 0;\r\n}\r\n.product-footer .container .large-3{float:left; display:inline-block}\r\na.devvn_buy_now_style:hover, a.devvn_buy_now_style:focus{background:#ffa801}\r\na.devvn_buy_now_style span{    font-size: 12px;\r\n    color: #1d1d1d;}\r\na.devvn_buy_now_style strong{    font-size: 17px;\r\n    font-weight: normal;}\r\n.star-rating span:before{  \r\n		color: #ffbe01;}\r\n.block_widget .icon-box{padding-top:10px;padding-bottom:10px; border-bottom:1px dotted #dddddd}\r\n.block_widget .icon-box .icon-box-text{font-size:13px}\r\n.block_widget .icon-box h3{font-size:15px;text-transform:uppercase}\r\n.single-product .product-info .large-3{    padding-right: 0;\r\n    padding-top: 10px;\r\n    flex-basis: 40%;\r\n    max-width: 40%;\r\n    float: left;\r\n    display: inline-block;\r\n    border-left: 1px solid #efefef;\r\n		padding-bottom: 0; }.devvn_single_price{ padding-top:0 !important; padding-left:0 !important; padding-right:0 !important; background:none !important; border-top:none !important; border-left:none !important; border-right:none !important; border-bottom: 1px dotted #dddddd !important;\r\n    padding-bottom: 10px !important;}\r\n.devvn_single_price .gia-tiet-kiem span.amount{color: gray;\r\n    font-weight: normal;}\r\n.single-product .product-info .price del {display:none}\r\n.single-product .product-info .price{font-size: 15px;\r\n    margin-bottom: 5px;\r\n    font-weight: normal;\r\n    letter-spacing: 0;\r\n    color: gray;}\r\n.single-product .product-info .price ins span, .single-product .product-info .price span.amount{color: #d51f16;\r\n    font-size: 19px;\r\n    font-weight: normal;}\r\n.TextCaptions .item.is-selected{background:#ffeb03; color:white;}\r\n\r\n.TextCaptions .item.col.large-3{padding: 6px !important;\r\n    height: 60px !important;flex-basis:20%; max-width:20%; border-right: 1px solid #e4e4e4 !important;font-size: 13px;}.TextCaptions .flickity-slider{border: 1px solid #e4e4e4;\r\n    border-top: none;\r\n				border-right: none;}\r\n.header-nav li a span{font-weight:normal; font-size:14px; margin-top:5px; display:block;text-align:center; width:100%; }.header-main .nav > li > a{text-align:center; display:block}.nav-spacing-large>li {\r\n    margin: 0 8px;\r\n}.header-nav li a:hover span{color:#d51f16; text-decoration:underline}\r\n.header-nav .has-dropdown .icon-angle-down{display:none}\r\n.header-nav li.header-search-form{margin-right:15px !important}.nav-dropdown-default {\r\n    padding: 14px;\r\n    border: none;border-top: 2px solid #e60000;\r\n}.nav-dropdown.nav-dropdown-default>li>a:hover{    border-bottom: 1px solid #d51f16;color:#d51f16; padding-left:15px}\r\n.nav-dropdown-has-arrow li.has-dropdown:before {\r\n    border-width: 8px;\r\n    margin-left: -8px;\r\n}\r\n.nav-dropdown.nav-dropdown-default>li>a {margin:0; padding-top:6px;padding-bottom:6px;\r\n    border-bottom:1px solid #e8e8e8;font-size:14px; padding-left:10px;padding-right:10px;color:black\r\n}\r\n.searchform-wrapper input{box-shadow:none; border-top-left-radius:4px; border-bottom-left-radius:4px}\r\n.searchform .button.icon {height:36px;\r\n    margin: 0;\r\n    width: 50px;\r\n    border-top-right-radius: 4px;\r\n    border-bottom-right-radius: 4px;\r\n}\r\n.section-title-container {\r\n    margin-bottom: 6px;\r\n}\r\n    .section-title-normal span{border-top-left-radius:4px; border-bottom-left-radius:4px; display: inline-block;\r\n    background: #ffeb02;\r\n    padding: 0 8px 0 12px;\r\n    height: 100%;\r\n    position: relative;\r\n    margin: 0;\r\n    float: left;\r\n    -webkit-border-radius: 4px 0 0 4px;\r\n    -moz-border-radius: 4px 0 0 4px;\r\n    border-radius: 4px 0 0 4px;\r\n    color: #333;\r\n    line-height: 45px;\r\n    font-size: 16px;border-bottom:none;\r\ntext-transform: uppercase}.section-title-normal {\r\n    border-bottom: 0;\r\n    background: white;\r\n    border-top-right-radius: 5px;\r\n    border-bottom-right-radius: 5px;\r\n}\r\n.section-title-normal span:after {\r\n    content: \" \";\r\n    display: block;\r\n    width: 0;\r\n    height: 0;\r\n    margin-left: 2px;\r\n    vertical-align: middle;\r\n    border-top: 22px solid transparent;\r\n    border-left: 15px solid;\r\n    border-left-color: #ffeb02;\r\n    border-right: 0 solid transparent;\r\n    border-bottom: 23px solid transparent;\r\n    position: absolute;\r\n    top: 0;\r\n		right: -15px;}\r\n.product-small.box{border-radius:5px; background: white;\r\n    padding: 10px;}\r\n.product-small.box:hover{    box-shadow: 1px 2px 20px #00000026;}.badge-container{margin:0px}\r\n.product-small.box .box-text{padding:10px 0\r\n}\r\n.product-small.box .product-title{ margin-bottom:7px;  }\r\n.product-small.box .product-title a{    margin: 0;color: #383838;\r\n    font-size: 14px;\r\n    height: 36px;\r\n    overflow: hidden;}\r\n.product-small.box .product-title a:hover{color:#d51e16}\r\n.flickity-prev-next-button svg{    background: #d51e16;border-radius:4px;\r\n    color: white;\r\n    height: 55px;}.slider-nav-push:not(.slider-nav-reveal) .flickity-prev-next-button {\r\n    margin-top: -2%;\r\n}\r\n.category-section .flickity-prev-next-button.previous, .danh-muc-section .flickity-prev-next-button.previous, .tin-tuc-section .flickity-prev-next-button.previous{right: 98%;}\r\n.category-section .flickity-prev-next-button.next, .danh-muc-section .flickity-prev-next-button.next, .tin-tuc-section .flickity-prev-next-button.next{left: 98%;}\r\n.tin-tuc-section .post-item .post-title{font-size:20px; font-weight:normal}.tin-tuc-section .post-item .post-title:hover{color:#d51e16}\r\na.back-to-top{background:#fffb01 !important; border:none !important; color:#d51e16 !important}\r\n.xem-them{    border: none;\r\n    padding: 0;\r\n    text-transform: none;\r\n    color: red;\r\n    font-weight: normal;\r\n    font-size: 13px;\r\n    letter-spacing: 0;}\r\n.tin-tuc-section .col{padding-bottom:0}\r\n.tin-tuc-section .post-item .box-text, .tin-tuc-section .post-item{padding-bottom:0}\r\n.danh-muc-section .cot3 .badge-container{display:none}\r\n.danh-muc-section .cot3 .product-small.box{border-radius:0}\r\n.product-small.box .price span.amount, .product-small.box ins span{color:#d51e16; font-weight:normal;font-size:16px}\r\n.product-small.box .price, .product-small .price del span{font-size:15px !important; color:gray !important}\r\n\r\n.badge-container .badge-inner span{background: url(/wp-content/uploads/2020/07/tải-xuống.png);\r\n    height: 54px;\r\n    padding: 8px;\r\n    border-top-right-radius: 5px;\r\n    border-bottom-right-radius: 5px;\r\n    font-size: 13px;\r\n    font-weight: normal;\r\n    padding-left: 23px;}\r\n.badge-container .badge-inner{    background-color: #00000000;}\r\n.section-title a{    font-size: 13px;\r\n    font-weight: normal;\r\n    border: 1px solid gray;\r\n    padding: 5px 10px;\r\n    border-radius: 4px;\r\n    margin-right: 18px;}\r\n.section-title a:hover{color:#d51e16; border:1px solid #d51e16}\r\n.danh-muc-section .col{padding-bottom:0}\r\n.category-section .col{padding-bottom:0}\r\n.list-product .col{padding:0 6px 12px !important}.list-product.row{margin-left:-5px !important; margin-right:-5px !important}\r\n.hdevvn_cats a{font-size:15px; text-transform:none; background:none; border:none; padding:0}\r\n.danh-muc-section .cot3 .section-title-normal{border-radius:0; border-bottom: 2px solid #f4f8fa; margin-bottom:0; }\r\n.danh-muc-section .cot3 .section-title-container{margin-bottom:0; border-radius:0}\r\n.danh-muc-section .cot3 .section-title-normal span{background:white}\r\n.danh-muc-section .cot3 .section-title-normal span:after{display:none}\r\n.hdevvn-show-cats li.hdevvn_cats{margin-bottom:0; float: left;\r\n    display: inline-block; } .hdevvn-show-cats:after{display:none !important}\r\n.hdevvn-show-cats{margin-left:20px !important}\r\n.hdevvn_cats a:hover{border:none}\r\n.hdevvn-show-cats {display:inline-block !important; background:none !important;line-height: 13px !important;\r\n    font-size: 14px !important;}\r\n.section-title-center span:after {\r\n    content: \"\";\r\n    display: table;\r\n    clear: both;\r\n    background: url(/wp-content/uploads/2020/07/line.png);\r\n    width: 100%;\r\n    height: 20px;\r\n    background-repeat: no-repeat;\r\n    background-position-x: center;\r\n    background-position-y: bottom;\r\n    padding-top: 0;\r\n}.section-title b{background:none}.section-title-center span {\r\n    margin: 0 15px;\r\n    font-size: 21px;\r\n}\r\n.footer-section .col{padding-bottom:10px}\r\n.footer-section2 .col{padding-bottom:0}.footer-secondary {\r\n    padding: 0;\r\n}\r\n.footer-section ul li{margin-bottom:3px}\r\n.footer-section h4{    border-bottom: 1px solid #e2e2e2;\r\n    color: #d51e16;font-size: 15px;}\r\n.footer-section2, .footer-section{padding-bottom:0 !important}\r\n.copyright-footer{    color: black;\r\n    font-size: 13px;}\r\n.archive #main{background:#f4f8fa}\r\n.archive .page-title-inner{padding-bottom: 15px;\r\n    padding-top: 10px;}\r\n.single-product .page-title{background:#efefef;}\r\n.single-product .page-title-inner {\r\n    position: relative;\r\n    padding-top: 10px;\r\n    min-height: 45px;\r\n    padding-bottom: 10px;\r\n    background: #efefef;\r\n}#breadcrumbs{font-size: 14px;\r\n    color: gray;}.product-info {\r\n    padding-top: 0;\r\n    padding-bottom: 0;\r\n}\r\n.dong-thong-tin{   display: block;\r\n    border-bottom: 1px solid #efefef;\r\n    padding-bottom: 10px; font-size: 14px;\r\n    color:#313131;}\r\n.product-info .fa{color: #d51e16;}\r\n.dong-thong-tin .fa{font-size:12px; margin-right:8px}\r\n.product-info .danh-muc a:hover{text-decoration:underline; color:#d51e16}\r\n.ma-hang{    margin-right: 20px;}\r\n.single-product .product-info .product-title{font-size: 24px;}\r\n#breadcrumbs a:hover{text-decoration:underline; color:#d51e16}\r\n.widget-woof{background:white; padding:15px;}\r\n.widget .is-divider {\r\n    height: 1px;\r\n    display: block;\r\n    background-color: rgba(0,0,0,0.1);\r\n    margin:6px 0 6px;\r\n    width: 100%;\r\n    max-width: 100%;\r\n}span.widget-title{letter-spacing: 0;\r\n    font-size: 18px;}.woof_list_checkbox li div {\r\n    margin-top: 0;\r\n}.woof_list label {\r\n padding-top: 0;\r\n    padding-bottom: 0;\r\n    margin-bottom: 0;\r\n    font-weight: normal;\r\n}\r\n.woof_container_inner h4{font-size: 16px;\r\n    color: #000000;\r\n		font-weight: bold;}.woof_list label:hover{text-decoration:underline; color:#d51e16}\r\n.woocommerce-result-count, .woocommerce-ordering select{font-size:15px}\r\n.archive .product-small.box .quick-view{display:none}\r\n.woof_products_top_panel li span {\r\n    padding-right: 16px;\r\n    background-size: 12px 12px;\r\n    background-repeat: no-repeat;\r\n    background-position: right;\r\n    border: 1px solid #d51e16;\r\n    padding: 4px 25px 4px 10px;\r\n    border-radius: 4px;\r\n    background-position-x: 97%;\r\n    background-color: white;\r\n}\r\n.anh-dau-trang{    background: #f4f8fa;}\r\n.duong-dan-breadcrumbs{background: #efefef;}\r\n.duong-dan-breadcrumbs #breadcrumbs{margin-bottom: 10px;\r\n    padding-top: 10px;\r\n    font-size: 14px;\r\n    color: gray;}\r\n.duong-dan-breadcrumbs #breadcrumbs a{color: #d51e16;}\r\n.duong-dan-breadcrumbs #breadcrumbs a:hover{text-decoration:underline}\r\n.single-product .product-short-description ul li{font-size: 14px;\r\n    margin-bottom: 3px;}\r\n.single-product .single_add_to_cart_button{margin-bottom: 0;\r\n    border-radius: 20px;\r\n		letter-spacing: 0;}.product-summary .quantity{margin-bottom:0}\r\n.single-product .product-info .share-icons a{min-width: 25px;border:none}\r\n.product-gallery-slider img, .product-thumbnails img{border:1px solid #efefef}.product-tabs li{margin-right:0; margin-left:0}\r\n.product-tabs li a{     border-right: 1px solid #efefef;   font-size: 16px;\r\n    letter-spacing: 0;\r\n    font-weight: bold;\r\n    color: #292929;\r\n    padding: 8px 15px;}.nav-line>li.active>a:before, .nav-line>li>a:before{display:none}.product-tabs li.active a{color: #d51f16;\r\n    border-bottom: 3px solid #d51f16;\r\n    padding-left: 15px;\r\n    padding-right: 15px;}span.widget-title {\r\n    letter-spacing: 0;\r\n    font-size: 18px;\r\n    width: 100%;\r\n    display: block;\r\n    background: #d51f16;\r\n    padding: 9px 15px;\r\n    letter-spacing: 0;\r\n    color: white;\r\n    text-transform: none;\r\n}.widget .is-divider{display:none}\r\n.product_list_widget, .flatsome_recent_posts{    border: 1px solid #efefef;background:white}\r\nul.product_list_widget li img{margin-left:6px}.recent-blog-posts{padding:10px 5px 10px}\r\n.widget_search input{box-shadow: none;\r\n    border-top-left-radius: 4px;\r\n    border-bottom-left-radius: 4px;\r\n    border: 1px solid #d51f16;}\r\n.recent-blog-posts .post_comments{display:none}\r\n.blog-single{background:#f4f8fa}\r\n.blog-single .article-inner {\r\n    margin-top: 20px;\r\n    background: white;\r\n    border-radius: 4px;\r\n    padding: 20px;\r\n}.is-divider{display:none}.tag-meta-post, .tag-meta-post a {\r\n    font-size: 14px;\r\n    color: gray;\r\n}.tag-meta-post .luot-xem {\r\n    padding-left: 3px;\r\n    padding-right: 10px;\r\n}.tag-meta-post .meta-date-capnhat {\r\n    padding-left: 4px;\r\n    padding-right: 6px;\r\n}.danh-muc {\r\n    margin-bottom: 15px;\r\n}.danh-muc ul {\r\n    margin-bottom: 0;\r\n    margin-left: 10px;\r\n}.article-inner ul li {\r\n    margin-bottom: 2px; font-size:15px;\r\n}\r\n.recent-blog-posts a {\r\n    \r\n    display: block;\r\n    margin-bottom: 0;\r\n    font-size: 15px;\r\n    color: #272727;\r\n}.recent-blog-posts a:hover{color:#d51f16}\r\nul.product_list_widget li img{margin-left:6px}.recent-blog-posts{padding:10px 5px 10px}\r\nul.product_list_widget li .product-title{font-size:14px; color:#212121}\r\nul.product_list_widget li{    padding: 10px 5px 5px 75px;}\r\n.product_list_widget ins span, .product_list_widget span.amount{color:#d51f16; font-weight:normal}.article-inner a {\r\n    color: #0092ff;\r\n}#breabcrumb, .danh-muc ul, .danh-muc ul li, .list-news, .social-share, .tag-meta-post{\r\n    display: inline-block;\r\n}\r\n\r\n.product_list_widget del span{color:gray!important; font-size:14px !important}.tabbed-content .tab-panels {padding:15px}\r\n.related h3{display: inline;margin-bottom:20px;\r\n    background: #ffff00;\r\n    padding: 12px 8px 12px 12px;\r\n    height: 100%;\r\n    position: relative;\r\n    margin: 0;\r\n\r\n    -webkit-border-radius: 4px 0 0 4px;\r\n    -moz-border-radius: 4px 0 0 4px;\r\n    border-radius: 4px 0 0 4px;\r\n    color: #333;\r\n    line-height: 45px;\r\n    font-size: 16px;\r\n    text-transform: uppercase;}\r\n.related h3:after{content: \" \";\r\n    display: block;\r\n    width: 0;\r\n    height: 0;\r\n    margin-left: 2px;\r\n    vertical-align: middle;\r\n    border-top: 22px solid transparent;\r\n    border-left: 15px solid;\r\n    border-left-color: #ffff00;\r\n    border-right: 0 solid transparent;\r\n    border-bottom: 23px solid transparent;\r\n    position: absolute;\r\n    top: 0;\r\n    right: -15px;}\r\n.related .product-small.box{border: 1px solid #ececec;}\r\n.related{margin-top:20px}\r\ndiv#reviews.woocommerce-Reviews, .devvn_prod_cmt{max-width:100%}\r\n#comments a.btn-reviews-now {\r\n    background-color: #d51f16;\r\n		color: #ffffff;}\r\nutton#devvn_cmt_submit, button#devvn_cmt_replysubmit {\r\n      background: #d51f16;\r\n		color: white;}\r\n.related .product-small.box .quick-view {display:none}\r\n.devvn_cmt_input textarea, .devvn_cmt_input input{    border: 1px solid #ececec;}\r\n.devvn_cmt_form_bottom{border: 1px solid #ececec;}\r\n.devvn-popup-title span{font-weight:bold}\r\n.archive span.widget-title{margin-bottom:15px}\r\n.single-product .product-short-description{    text-align: justify;font-size:14px}.product-section {\r\n    border-top: 0;\r\n}\r\n.page-wrapper {\r\n    padding-top: 0;\r\n    padding-bottom: 0;\r\n}\r\n.blog-archive .duong-dan-breadcrumbs{margin-bottom:30px}\r\n.blog-archive .large-3{padding-left:0}\r\n.blog-archive .badge.post-date{margin:10px; top:0; }\r\n.blog-archive{background: #f4f8fa;}\r\n.blog-archive .post-item .col-inner{border-radius:4px; background:white}\r\n.blog-archive .post-item .box-text{padding:10px}\r\n.blog-archive .post-item .box-text .post-title{font-size:20px; font-weight:normal; margin-bottom:15px}.blog-archive .post-item .box-text .post-title:hover{text-decoration:underline; color:#d51f16}\r\n.related .row{margin-top:20px}\r\n.blog-single .entry-title{margin-bottom: 5px;\r\n    font-size: 22px;}\r\n.tieu-de-xem-them{    font-size: 17px;\r\n    font-weight: bold;\r\n    color: #292929;}xem-them ul li a:hover {\r\n    color: #57b2e9;\r\n    transition: all .2s ease-in-out;\r\n}\r\n.bai-viet-lien-quan{margin-top:20px}.bai-viet-lien-quan ul {\r\n    margin-bottom: 0;\r\n    display: inline-block;\r\n    width: 100%;\r\n}\r\n.bai-viet-lien-quan ul li{list-style: none;\r\n    width: 33.33336%;\r\n    color: graytext;\r\n    float: left;\r\n    padding-left: 4px;\r\n    padding-right: 5px;}\r\n.article-inner ul li {\r\n    margin-bottom: 2px;\r\n}.bai-viet-lien-quan ul li .box-image img {\r\n    height: 160px;\r\n    object-fit: cover;\r\n    object-position: center;\r\n} .bai-viet-lien-quan h4 {\r\n    font-size: 16px;\r\n    color: black;\r\n    line-height: 19px;\r\n    padding-top: 7px;\r\n    height: 47px;\r\n    overflow: hidden;\r\n    font-weight: normal;\r\n}.bai-viet-lien-quan h4:hover{text-transform:underline; color:#d51f16}\r\n.blog-single .large-3{padding-left:0; padding-top:20px}.newpost {background: #ffffff;\r\n    padding: 10px;\r\n    border: 0;\r\n    border-radius: 3px;\r\n}.newpost ul {\r\n    margin-bottom: 0;\r\n}.newpost ul li {\r\n    margin-bottom: 0;\r\n    color: #4267b2;\r\n    border-top: 1px dashed #c7e7ff;\r\n    margin-left: 20px;\r\n    font-size: 13px;\r\n}.newpost ul li h4 {\r\n    margin-bottom: 0;\r\n    padding-top: 5px;\r\n    padding-bottom: 5px;\r\n}.newpost ul li a {\r\n    color: #0070c3;\r\n    font-weight: 400;\r\n}.newpost ul li a:hover {\r\n    text-decoration: underline;\r\n}\r\n#comments .comment-respond {\r\n		background-color: rgb(255 255 255);}\r\n.page-right-sidebar .large-9{padding-top:20px; border-right:none}\r\n.page-right-sidebar .large-3{padding-left:0; padding-top:20px}\r\np.des{margin-bottom:10px}\r\n.entry-title.mb {\r\n    margin-bottom: 10px;\r\n    font-size: 22px;\r\n    letter-spacing: 0;\r\n}\r\ninput[type=\'submit\']{border-radius:20px}\r\ninput[type=\'email\'], input[type=\'search\'], input[type=\'number\'], input[type=\'url\'], input[type=\'tel\'], input[type=\'text\'], textarea{box-shadow:none; font-size:14px;}\r\n.ftShopInfo p{margin-bottom:5px}.thong-so-ky-thuat {\r\n    border: 1px solid #e9e9e9;\r\n    font-size: 14px;\r\n    display: inline-block;\r\n    border-radius: 5px;margin-bottom:20px;\r\n}\r\n.thong-so-ky-thuat h3 {\r\n    margin-bottom: 0;\r\n    padding: 10px;\r\n    border-bottom: 1px solid #e9e9e9;\r\n    background: #fed700;\r\n}\r\n.thong-so-ky-thuat .row-info {\r\n    border-bottom: 1px solid #e9e9e9;\r\n    padding: 10px 7px;\r\n    display: inline-flex;\r\n    clear: both;\r\n    width: 100%;\r\n}\r\n.thong-so-ky-thuat .row-info .left {\r\n    width: 43% !important;\r\n    color: #a0a0a0;display: inline-block;\r\n    float: left;\r\n    padding-right: 10px;\r\n}\r\n.thong-so-ky-thuat .row-info .right {\r\n    width: 57% !important;\r\n    color: black;display: inline-block;\r\n    float: left;\r\n    padding-left: 10px;\r\n}.khuyen-mai {\r\n    border: 1px solid #ffdb97;\r\n    padding: 8px;\r\n    font-size: 14px;\r\n    border-radius: 4px;\r\n    margin-bottom: 15px;\r\n    line-height: 18px;\r\n    background: #fffbf4;\r\n}\r\n.khuyen-mai h4 {\r\n    color: red;\r\n}\r\n.khuyen-mai ul li {\r\n    background: url(/wp-content/uploads/2022/04/check@2x.png);\r\n    background-repeat: no-repeat;\r\n    background-size: 14px;  list-style: none;\r\n    background-position-y: 2px;\r\n    padding-left: 22px;\r\n    margin-left: 0;\r\n    margin-bottom: 10px;\r\n}\";s:22:\"html_custom_css_tablet\";s:0:\"\";s:22:\"html_custom_css_mobile\";s:2162:\".icon-menu:before{color:#d51f16}\r\noff-canvas:not(.off-canvas-center) .nav-vertical li>a {\r\n    padding-left: 20px;\r\n    padding-top: 5px;\r\n    padding-bottom: 5px;\r\n}.product-footer .container {\r\n    display: inline-grid;\r\n}\r\n.product-footer .container .large-9 {\r\n    order: 1;\r\n}\r\n.product-footer .container .large-3 {\r\n    order: -3;\r\n}\r\n.nav.nav-vertical li a img{max-width:40px}.off-canvas:not(.off-canvas-center) .nav-vertical li>a {\r\n    padding-left: 20px;\r\n    padding-top: 6px;\r\n    padding-bottom: 6px;\r\n}.TextCaptions .item.col.large-3{flex-basis:50%; max-width:50%}\r\n.section-title-normal span{font-size:14px}\r\n.hdevvn-show-cats{display:none !important}\r\n.danh-muc-section .cot3 .san-pham-ngang .col{    padding-bottom: 15px; flex-basis:50%; max-width:50%}\r\n.danh-muc-section .cot3 .san-pham-ngang .col:nth-child(2n+1){padding-right:6px}\r\n.danh-muc-section .cot3 .san-pham-ngang .col:nth-child(2n+2){padding-left:6px}\r\n.flickity-prev-next-button.previous{    right: 94% !important;left:auto}.category-section .flickity-prev-next-button.next, .danh-muc-section .flickity-prev-next-button.next, .tin-tuc-section .flickity-prev-next-button.next {\r\n    left: 94%;\r\n}.single-product .large-10, .product-gallery, .product-thumbnails .col {\r\n    padding-bottom: 10px !important;\r\n}.single-product .product-info{padding-left:15px}.single-product .product-info .large-9, .single-product .product-info .large-9, .single-product .product-info .large-3{flex-basis:100%; max-width:100%; padding-left:0;padding-right:0; border:none !important}.product-footer .container .large-9{padding-right:0px}off-canvas .sidebar-inner {\r\n    padding: 0;\r\n}\r\n.archive .product-small.col{padding:0 5px 10px}\r\n.page-right-sidebar .large-3, .blog-single .large-3, .blog-archive .large-3{padding-left:15px}.blog-single .article-inner{padding:10px}\r\n.blog-single .blog-share{text-align:left; margin-top:20px}.bai-viet-lien-quan ul li{width:50%}.bai-viet-lien-quan ul li .box-image img{height:120px}.bai-viet-lien-quan h4 {\r\n    font-size: 15px;\r\n    color: black;\r\n    line-height: 19px;\r\n    padding-top: 7px;\r\n    height: 64px;\r\n    overflow: hidden;\r\n    font-weight: normal;\r\n}\";s:17:\"perf_instant_page\";s:1:\"1\";s:21:\"lazy_load_backgrounds\";s:1:\"1\";s:16:\"lazy_load_images\";s:1:\"1\";s:26:\"flatsome_disable_style_css\";s:1:\"0\";s:13:\"disable_emoji\";s:1:\"1\";s:16:\"disable_blockcss\";s:1:\"1\";s:14:\"jquery_migrate\";s:1:\"1\";s:11:\"site_loader\";s:0:\"\";s:17:\"site_loader_color\";s:5:\"light\";s:14:\"site_loader_bg\";s:0:\"\";s:11:\"live_search\";s:1:\"0\";s:18:\"search_placeholder\";s:20:\"Laptop, Phụ kiện\";s:17:\"facebook_accounts\";a:1:{i:0;s:1:\"0\";}s:14:\"google_map_api\";s:0:\"\";s:16:\"maintenance_mode\";s:1:\"0\";s:29:\"maintenance_mode_admin_notice\";s:1:\"1\";s:21:\"maintenance_mode_page\";s:1:\"0\";s:21:\"maintenance_mode_text\";s:24:\"Please check back soon..\";s:9:\"404_block\";s:1:\"0\";s:12:\"fl_portfolio\";s:1:\"0\";s:15:\"parallax_mobile\";s:1:\"0\";s:15:\"flatsome_studio\";s:1:\"0\";s:18:\"custom_css_post_id\";i:-1;s:11:\"preset_demo\";s:14:\"header-default\";s:22:\"topbar_elements_center\";a:0:{}s:29:\"header_mobile_elements_bottom\";a:0:{}s:13:\"logo_position\";s:4:\"left\";s:11:\"topbar_show\";b:1;s:17:\"header_top_height\";s:2:\"30\";s:12:\"topbar_color\";s:4:\"dark\";s:9:\"topbar_bg\";s:0:\"\";s:13:\"nav_style_top\";s:7:\"divided\";s:12:\"header_width\";s:9:\"container\";s:13:\"header_height\";s:2:\"69\";s:12:\"header_color\";s:5:\"light\";s:9:\"header_bg\";s:7:\"#ffeb01\";s:20:\"header_bg_img_repeat\";s:8:\"repeat-x\";s:17:\"box_shadow_header\";b:0;s:9:\"nav_style\";s:0:\"\";s:8:\"nav_size\";s:6:\"medium\";s:13:\"nav_uppercase\";b:0;s:14:\"type_nav_color\";s:7:\"#191919\";s:20:\"type_nav_color_hover\";s:0:\"\";s:25:\"header_height_transparent\";s:3:\"265\";s:21:\"header_bg_transparent\";s:0:\"\";s:27:\"header_bg_transparent_shade\";b:0;s:20:\"header_bottom_height\";s:2:\"10\";s:15:\"nav_position_bg\";s:7:\"#f1f1f1\";s:16:\"nav_style_bottom\";s:0:\"\";s:15:\"nav_size_bottom\";s:0:\"\";s:20:\"nav_uppercase_bottom\";b:1;s:18:\"nav_position_color\";s:5:\"light\";s:21:\"type_nav_bottom_color\";s:0:\"\";s:27:\"type_nav_bottom_color_hover\";s:0:\"\";s:13:\"color_primary\";s:7:\"#d51e16\";s:11:\"color_texts\";s:7:\"#353535\";s:19:\"type_headings_color\";s:7:\"#0a0a0a\";s:14:\"header_divider\";b:0;s:11:\"nav_spacing\";s:5:\"large\";s:10:\"nav_height\";s:2:\"16\";s:8:\"nav_push\";s:1:\"0\";s:10:\"site_width\";s:4:\"1260\";s:9:\"type_size\";s:3:\"100\";s:16:\"type_size_mobile\";s:3:\"100\";s:9:\"site_logo\";i:3309;s:12:\"logo_padding\";s:1:\"0\";s:10:\"logo_width\";s:3:\"180\";s:18:\"account_icon_style\";s:5:\"image\";s:19:\"header_search_width\";s:3:\"100\";s:23:\"category_sticky_sidebar\";b:1;s:27:\"category_force_image_height\";b:1;s:16:\"products_pr_page\";s:2:\"40\";s:18:\"category_row_count\";s:1:\"4\";s:25:\"category_row_count_tablet\";s:1:\"3\";s:20:\"category_title_style\";s:0:\"\";s:19:\"category_show_title\";b:1;s:15:\"breadcrumb_size\";s:5:\"small\";s:9:\"cat_style\";s:6:\"normal\";s:10:\"grid_style\";s:5:\"grid2\";s:16:\"add_to_cart_icon\";s:7:\"disable\";s:18:\"disable_quick_view\";b:0;s:20:\"equalize_product_box\";b:1;s:12:\"bubble_style\";s:6:\"style2\";s:22:\"sale_bubble_percentage\";b:1;s:16:\"sale_bubble_text\";s:11:\"Giảm giá\";s:25:\"category_row_count_mobile\";s:1:\"2\";s:15:\"category_shadow\";s:1:\"0\";s:21:\"category_shadow_hover\";s:1:\"0\";s:17:\"add_to_cart_style\";s:5:\"shade\";s:33:\"sale_bubble_percentage_formatting\";s:16:\"Giảm -{value}%\";s:19:\"blog_excerpt_suffix\";s:3:\"...\";s:16:\"blog_badge_style\";s:6:\"square\";s:12:\"footer_block\";s:6:\"footer\";s:16:\"footer_left_text\";s:129:\"Copyright [ux_current_year] © <strong>Máy tính, Laptop, Phụ kiện chính hãng</strong> | Thiết kế bởi TAMNGUYENMEDIA\";s:18:\"footer_bottom_text\";s:5:\"light\";s:19:\"footer_bottom_color\";s:7:\"#ffeb01\";s:20:\"product_box_category\";b:0;s:18:\"product_box_rating\";b:0;s:13:\"product_hover\";s:4:\"none\";s:21:\"category_image_height\";s:3:\"100\";s:13:\"search_result\";s:1:\"1\";s:19:\"search_result_style\";s:6:\"slider\";s:24:\"search_products_order_by\";s:9:\"relevance\";s:13:\"search_by_sku\";s:1:\"0\";s:21:\"search_by_product_tag\";s:1:\"0\";s:15:\"disable_reviews\";s:1:\"0\";s:27:\"product_gallery_woocommerce\";s:1:\"0\";s:14:\"html_shop_page\";s:0:\"\";s:9:\"tab_title\";s:0:\"\";s:11:\"tab_content\";s:0:\"\";s:23:\"html_before_add_to_cart\";s:1:\" \";s:22:\"html_after_add_to_cart\";s:0:\"\";s:14:\"html_thank_you\";s:0:\"\";s:12:\"catalog_mode\";s:1:\"0\";s:19:\"catalog_mode_prices\";s:1:\"0\";s:19:\"catalog_mode_header\";s:0:\"\";s:20:\"catalog_mode_product\";s:0:\"\";s:21:\"catalog_mode_lightbox\";s:0:\"\";s:24:\"flatsome_infinite_scroll\";s:1:\"1\";s:27:\"infinite_scroll_loader_type\";s:6:\"button\";s:26:\"infinite_scroll_loader_img\";s:0:\"\";s:15:\"breadcrumb_home\";b:1;s:14:\"product_header\";s:3:\"top\";s:21:\"product_next_prev_nav\";b:0;s:19:\"product_image_style\";s:8:\"vertical\";s:16:\"product_lightbox\";s:8:\"disabled\";s:19:\"product_image_width\";s:1:\"5\";s:15:\"color_secondary\";s:7:\"#d51f16\";s:11:\"color_links\";s:7:\"#d51f16\";s:17:\"product_info_meta\";b:0;s:19:\"blog_layout_divider\";b:0;s:10:\"blog_style\";s:5:\"2-col\";s:16:\"blog_posts_depth\";s:1:\"0\";s:22:\"blog_posts_depth_hover\";s:1:\"0\";s:22:\"blog_posts_title_align\";s:4:\"left\";s:18:\"blog_style_archive\";s:5:\"2-col\";s:23:\"blog_single_header_meta\";b:0;s:26:\"blog_single_featured_image\";b:1;s:23:\"blog_single_footer_meta\";b:1;s:15:\"blog_author_box\";b:0;s:25:\"blog_single_next_prev_nav\";b:0;s:15:\"blog_post_style\";s:6:\"inline\";s:18:\"blog_archive_title\";b:0;s:13:\"default_title\";b:1;s:18:\"wpseo_primary_term\";s:1:\"0\";s:37:\"wpseo_manages_product_layout_priority\";s:1:\"0\";s:16:\"wpseo_breadcrumb\";s:1:\"0\";s:28:\"wpseo_breadcrumb_remove_last\";s:1:\"1\";s:30:\"mobile_submenu_parent_behavior\";s:6:\"toggle\";s:21:\"mobile_submenu_effect\";s:5:\"slide\";s:11:\"topbar_left\";s:79:\"CHÀO MỪNG BẠN ĐẾN VỚI WEBSITE TRỰC TUYẾN CỦA PHỤ KIỆN TỐT\";s:20:\"category_filter_text\";s:25:\"Phân loại sản phẩm\";s:20:\"header_height_sticky\";s:2:\"70\";s:17:\"nav_height_sticky\";s:2:\"12\";s:11:\"back_to_top\";b:0;s:19:\"sticky_logo_padding\";s:1:\"0\";s:15:\"cart_icon_style\";s:10:\"fill-round\";s:17:\"header_cart_total\";b:0;s:17:\"header_cart_title\";b:0;s:17:\"header_cart_style\";s:10:\"off-canvas\";s:21:\"search_result_latency\";s:1:\"0\";s:8:\"swatches\";s:1:\"0\";s:23:\"catalog_mode_sale_badge\";s:1:\"0\";s:15:\"release_channel\";s:6:\"stable\";s:16:\"site_logo_slogan\";b:0;s:13:\"payment_icons\";a:0:{}s:14:\"site_logo_dark\";i:3309;s:13:\"header_sticky\";b:0;s:16:\"bottombar_sticky\";b:0;s:22:\"rank_math_primary_term\";s:1:\"0\";s:41:\"rank_math_manages_product_layout_priority\";s:1:\"0\";s:20:\"rank_math_breadcrumb\";s:1:\"0\";}","yes"),
("170","envato_setup_complete","1595554924","yes"),
("198","action_scheduler_hybrid_store_demarkation","12","yes"),
("199","schema-ActionScheduler_StoreSchema","6.0.1651035245","yes"),
("200","schema-ActionScheduler_LoggerSchema","3.0.1651035245","yes"),
("203","woocommerce_schema_version","430","yes"),
("204","woocommerce_store_address","","yes"),
("205","woocommerce_store_address_2","","yes"),
("206","woocommerce_store_city","","yes"),
("207","woocommerce_default_country","VN","yes"),
("208","woocommerce_store_postcode","","yes"),
("209","woocommerce_allowed_countries","all","yes"),
("210","woocommerce_all_except_countries","a:0:{}","yes"),
("211","woocommerce_specific_allowed_countries","a:0:{}","yes"),
("212","woocommerce_ship_to_countries","","yes"),
("213","woocommerce_specific_ship_to_countries","a:0:{}","yes"),
("214","woocommerce_default_customer_address","base","yes"),
("215","woocommerce_calc_taxes","no","yes"),
("216","woocommerce_enable_coupons","yes","yes"),
("217","woocommerce_calc_discounts_sequentially","no","no"),
("218","woocommerce_currency","VND","yes"),
("219","woocommerce_currency_pos","right","yes"),
("220","woocommerce_price_thousand_sep",".","yes"),
("221","woocommerce_price_decimal_sep",".","yes"),
("222","woocommerce_price_num_decimals","0","yes"),
("223","woocommerce_shop_page_id","3205","yes"),
("224","woocommerce_cart_redirect_after_add","no","yes"),
("225","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("226","woocommerce_placeholder_image","12","yes"),
("227","woocommerce_weight_unit","kg","yes"),
("228","woocommerce_dimension_unit","cm","yes"),
("229","woocommerce_enable_reviews","yes","yes"),
("230","woocommerce_review_rating_verification_label","yes","no"),
("231","woocommerce_review_rating_verification_required","no","no"),
("232","woocommerce_enable_review_rating","yes","yes"),
("233","woocommerce_review_rating_required","yes","no"),
("234","woocommerce_manage_stock","yes","yes"),
("235","woocommerce_hold_stock_minutes","60","no"),
("236","woocommerce_notify_low_stock","yes","no"),
("237","woocommerce_notify_no_stock","yes","no"),
("238","woocommerce_stock_email_recipient","info.giuseart.com@gmail.com","no"),
("239","woocommerce_notify_low_stock_amount","2","no"),
("240","woocommerce_notify_no_stock_amount","0","yes"),
("241","woocommerce_hide_out_of_stock_items","no","yes"),
("242","woocommerce_stock_format","","yes"),
("243","woocommerce_file_download_method","force","no"),
("244","woocommerce_downloads_require_login","no","no"),
("245","woocommerce_downloads_grant_access_after_payment","yes","no"),
("246","woocommerce_downloads_add_hash_to_filename","yes","yes"),
("247","woocommerce_prices_include_tax","no","yes"),
("248","woocommerce_tax_based_on","shipping","yes"),
("249","woocommerce_shipping_tax_class","inherit","yes"),
("250","woocommerce_tax_round_at_subtotal","no","yes"),
("251","woocommerce_tax_classes","","yes"),
("252","woocommerce_tax_display_shop","excl","yes"),
("253","woocommerce_tax_display_cart","excl","yes"),
("254","woocommerce_price_display_suffix","","yes"),
("255","woocommerce_tax_total_display","itemized","no"),
("256","woocommerce_enable_shipping_calc","yes","no"),
("257","woocommerce_shipping_cost_requires_address","no","yes"),
("258","woocommerce_ship_to_destination","billing","no"),
("259","woocommerce_shipping_debug_mode","no","yes"),
("260","woocommerce_enable_guest_checkout","yes","no"),
("261","woocommerce_enable_checkout_login_reminder","yes","no"),
("262","woocommerce_enable_signup_and_login_from_checkout","yes","no"),
("263","woocommerce_enable_myaccount_registration","yes","no"),
("264","woocommerce_registration_generate_username","yes","no"),
("265","woocommerce_registration_generate_password","yes","no"),
("266","woocommerce_erasure_request_removes_order_data","no","no"),
("267","woocommerce_erasure_request_removes_download_data","no","no"),
("268","woocommerce_allow_bulk_remove_personal_data","no","no"),
("269","woocommerce_registration_privacy_policy_text","Thông tin cá nhân của bạn sẽ được sử dụng để tăng trải nghiệm sử dụng website, quản lý truy cập vào tài khoản của bạn, và cho các mục đích cụ thể khác được mô tả trong [privacy_policy].","yes"),
("270","woocommerce_checkout_privacy_policy_text","Thông tin cá nhân của bạn sẽ được sử dụng để xử lý đơn hàng, tăng trải nghiệm sử dụng website, và cho các mục đích cụ thể khác đã được mô tả trong [privacy_policy].","yes"),
("271","woocommerce_delete_inactive_accounts","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("272","woocommerce_trash_pending_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("273","woocommerce_trash_failed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("274","woocommerce_trash_cancelled_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}","no"),
("275","woocommerce_anonymize_completed_orders","a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}","no"),
("276","woocommerce_email_from_name","Phụ Kiện Tốt - Phụ Kiện Công nghệ chính hãng","no"),
("277","woocommerce_email_from_address","admin@phukientot.vn","no"),
("278","woocommerce_email_header_image","","no"),
("279","woocommerce_email_footer_text","{site_title} &mdash; Built with {WooCommerce}","no"),
("280","woocommerce_email_base_color","#96588a","no"),
("281","woocommerce_email_background_color","#f7f7f7","no"),
("282","woocommerce_email_body_background_color","#ffffff","no"),
("283","woocommerce_email_text_color","#3c3c3c","no"),
("284","woocommerce_cart_page_id","3206","no"),
("285","woocommerce_checkout_page_id","3207","no"),
("286","woocommerce_myaccount_page_id","3208","no"),
("287","woocommerce_terms_page_id","","no"),
("288","woocommerce_force_ssl_checkout","no","yes"),
("289","woocommerce_unforce_ssl_checkout","no","yes"),
("290","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("291","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("292","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("293","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("294","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("295","woocommerce_myaccount_orders_endpoint","orders","yes"),
("296","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("297","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("298","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("299","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("300","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("301","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("302","woocommerce_logout_endpoint","customer-logout","yes"),
("303","woocommerce_api_enabled","no","yes"),
("304","woocommerce_allow_tracking","no","no"),
("305","woocommerce_show_marketplace_suggestions","yes","no"),
("306","woocommerce_single_image_width","500","yes"),
("307","woocommerce_thumbnail_image_width","500","yes"),
("308","woocommerce_checkout_highlight_required_fields","yes","yes"),
("309","woocommerce_demo_store","no","no"),
("310","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:9:\"/san-pham\";s:13:\"category_base\";s:17:\"danh-muc-san-pham\";s:8:\"tag_base\";s:16:\"tu-khoa-san-pham\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}","yes"),
("311","current_theme_supports_woocommerce","yes","yes"),
("312","woocommerce_queue_flush_rewrite_rules","no","yes"),
("315","default_product_cat","15","yes"),
("316","woocommerce_admin_notices","a:1:{i:0;s:6:\"update\";}","yes"),
("321","woocommerce_homescreen_enabled","yes","yes"),
("324","action_scheduler_lock_async-request-runner","1698656090","yes"),
("325","woocommerce_maxmind_geolocation_settings","a:1:{s:15:\"database_prefix\";s:32:\"zRmdiFq22uVssfLXQn8V7WcHSnq50llf\";}","yes"),
("327","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("328","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("329","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("330","widget_woocommerce_price_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("331","widget_woocommerce_product_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("332","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("333","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("334","widget_woocommerce_products","a:3:{i:2;a:7:{s:5:\"title\";s:18:\"Sản phẩm mới\";s:6:\"number\";i:5;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:3;a:7:{s:5:\"title\";s:18:\"Sản phẩm mới\";s:6:\"number\";i:5;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}","yes"),
("335","widget_woocommerce_recently_viewed_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("336","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("337","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("338","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("339","widget_upsell_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("343","woocommerce_admin_install_timestamp","1596016783","yes"),
("346","wc_admin_note_home_screen_feedback_homescreen_accessed","1596016783","yes"),
("347","wc_blocks_db_schema_version","260","yes"),
("348","woocommerce_meta_box_errors","a:0:{}","yes"),
("392","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes"),
("406","menu_icons_install","1596019018","yes"),
("411","menu-icons","a:2:{s:6:\"global\";a:1:{s:10:\"icon_types\";a:2:{i:0;s:5:\"image\";i:1;s:3:\"svg\";}}s:7:\"menu_23\";a:6:{s:10:\"hide_label\";s:0:\"\";s:8:\"position\";s:6:\"before\";s:14:\"vertical_align\";s:6:\"middle\";s:9:\"font_size\";s:3:\"1.2\";s:9:\"svg_width\";s:1:\"1\";s:10:\"image_size\";s:9:\"thumbnail\";}}","yes"),
("433","woocommerce_maybe_regenerate_images_hash","6ae426ca5a087a357f47d5e99b54c14e","yes"),
("614","category_children","a:0:{}","yes"),
("615","block_categories_children","a:0:{}","yes"),
("617","pa_dung-luong_children","a:0:{}","yes"),
("619","pa_trang-thai_children","a:0:{}","yes"),
("993","wpcf7","a:2:{s:7:\"version\";s:3:\"5.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1596103209;s:7:\"version\";s:3:\"5.2\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes"),
("1158","wp_installer_settings","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","yes"),
("1159","widget_woof_widget","a:2:{i:2;a:5:{s:5:\"title\";s:18:\"Lọc sản phẩm\";s:22:\"additional_text_before\";s:0:\"\";s:8:\"redirect\";s:0:\"\";s:24:\"woof_start_filtering_btn\";s:1:\"0\";s:11:\"ajax_redraw\";s:1:\"0\";}s:12:\"_multiwidget\";i:1;}","yes"),
("1160","woof_first_init","1","yes"),
("1161","woof_set_automatically","0","yes"),
("1162","woof_autosubmit","1","yes"),
("1163","woof_show_count","1","yes"),
("1164","woof_show_count_dynamic","0","yes"),
("1165","woof_hide_dynamic_empty_pos","0","yes"),
("1166","woof_try_ajax","0","yes"),
("1167","woof_checkboxes_slide","1","yes"),
("1168","woof_hide_red_top_panel","0","yes"),
("1169","woof_sort_terms_checked","0","yes"),
("1170","woof_filter_btn_txt","","yes"),
("1171","woof_reset_btn_txt","","yes"),
("1172","woof_settings","a:44:{s:11:\"items_order\";s:0:\"\";s:8:\"by_price\";a:6:{s:4:\"show\";s:1:\"0\";s:11:\"show_button\";s:1:\"0\";s:10:\"title_text\";s:0:\"\";s:6:\"ranges\";s:0:\"\";s:17:\"first_option_text\";s:0:\"\";s:15:\"ion_slider_step\";s:1:\"1\";}s:8:\"tax_type\";a:7:{s:18:\"product_visibility\";s:5:\"radio\";s:11:\"product_cat\";s:8:\"checkbox\";s:11:\"product_tag\";s:5:\"radio\";s:13:\"pa_dung-luong\";s:8:\"checkbox\";s:10:\"pa_mau-sac\";s:8:\"checkbox\";s:13:\"pa_trang-thai\";s:5:\"radio\";s:10:\"pa_xuat-xu\";s:8:\"checkbox\";}s:14:\"excluded_terms\";a:7:{s:18:\"product_visibility\";s:0:\"\";s:11:\"product_cat\";s:0:\"\";s:11:\"product_tag\";s:0:\"\";s:13:\"pa_dung-luong\";s:0:\"\";s:10:\"pa_mau-sac\";s:0:\"\";s:13:\"pa_trang-thai\";s:0:\"\";s:10:\"pa_xuat-xu\";s:0:\"\";}s:16:\"tax_block_height\";a:7:{s:18:\"product_visibility\";s:1:\"0\";s:11:\"product_cat\";s:1:\"0\";s:11:\"product_tag\";s:1:\"0\";s:13:\"pa_dung-luong\";s:1:\"0\";s:10:\"pa_mau-sac\";s:1:\"0\";s:13:\"pa_trang-thai\";s:1:\"0\";s:10:\"pa_xuat-xu\";s:1:\"0\";}s:16:\"show_title_label\";a:7:{s:18:\"product_visibility\";s:1:\"0\";s:11:\"product_cat\";s:1:\"1\";s:11:\"product_tag\";s:1:\"0\";s:13:\"pa_dung-luong\";s:1:\"1\";s:10:\"pa_mau-sac\";s:1:\"1\";s:13:\"pa_trang-thai\";s:1:\"0\";s:10:\"pa_xuat-xu\";s:1:\"1\";}s:18:\"show_toggle_button\";a:7:{s:18:\"product_visibility\";s:1:\"0\";s:11:\"product_cat\";s:1:\"0\";s:11:\"product_tag\";s:1:\"0\";s:13:\"pa_dung-luong\";s:1:\"0\";s:10:\"pa_mau-sac\";s:1:\"0\";s:13:\"pa_trang-thai\";s:1:\"0\";s:10:\"pa_xuat-xu\";s:1:\"0\";}s:13:\"dispay_in_row\";a:7:{s:18:\"product_visibility\";s:1:\"0\";s:11:\"product_cat\";s:1:\"0\";s:11:\"product_tag\";s:1:\"0\";s:13:\"pa_dung-luong\";s:1:\"0\";s:10:\"pa_mau-sac\";s:1:\"0\";s:13:\"pa_trang-thai\";s:1:\"0\";s:10:\"pa_xuat-xu\";s:1:\"0\";}s:16:\"custom_tax_label\";a:7:{s:18:\"product_visibility\";s:0:\"\";s:11:\"product_cat\";s:23:\"Danh mục sản phẩm\";s:11:\"product_tag\";s:0:\"\";s:13:\"pa_dung-luong\";s:13:\"Dung lượng\";s:10:\"pa_mau-sac\";s:10:\"Màu sắc\";s:13:\"pa_trang-thai\";s:0:\"\";s:10:\"pa_xuat-xu\";s:11:\"Xuất xứ\";}s:23:\"not_toggled_terms_count\";a:7:{s:18:\"product_visibility\";s:0:\"\";s:11:\"product_cat\";s:0:\"\";s:11:\"product_tag\";s:0:\"\";s:13:\"pa_dung-luong\";s:0:\"\";s:10:\"pa_mau-sac\";s:0:\"\";s:13:\"pa_trang-thai\";s:0:\"\";s:10:\"pa_xuat-xu\";s:0:\"\";}s:3:\"tax\";a:4:{s:11:\"product_cat\";s:1:\"1\";s:13:\"pa_dung-luong\";s:1:\"1\";s:10:\"pa_mau-sac\";s:1:\"1\";s:10:\"pa_xuat-xu\";s:1:\"1\";}s:11:\"icheck_skin\";s:8:\"flat_red\";s:12:\"overlay_skin\";s:7:\"default\";s:19:\"overlay_skin_bg_img\";s:0:\"\";s:18:\"plainoverlay_color\";s:0:\"\";s:25:\"default_overlay_skin_word\";s:0:\"\";s:10:\"use_chosen\";s:1:\"1\";s:17:\"use_beauty_scroll\";s:1:\"0\";s:15:\"ion_slider_skin\";s:8:\"skinNice\";s:25:\"woof_auto_hide_button_img\";s:0:\"\";s:25:\"woof_auto_hide_button_txt\";s:0:\"\";s:26:\"woof_auto_subcats_plus_img\";s:0:\"\";s:27:\"woof_auto_subcats_minus_img\";s:0:\"\";s:11:\"toggle_type\";s:4:\"text\";s:18:\"toggle_opened_text\";s:0:\"\";s:18:\"toggle_closed_text\";s:0:\"\";s:19:\"toggle_opened_image\";s:0:\"\";s:19:\"toggle_closed_image\";s:0:\"\";s:16:\"custom_front_css\";s:0:\"\";s:15:\"custom_css_code\";s:0:\"\";s:18:\"js_after_ajax_done\";s:0:\"\";s:12:\"init_only_on\";s:0:\"\";s:17:\"swoof_search_slug\";s:0:\"\";s:8:\"per_page\";s:2:\"-1\";s:14:\"non_latin_mode\";s:1:\"1\";s:17:\"optimize_js_files\";s:1:\"0\";s:20:\"hide_terms_count_txt\";s:1:\"0\";s:25:\"listen_catalog_visibility\";s:1:\"0\";s:23:\"disable_swoof_influence\";s:1:\"0\";s:16:\"cache_count_data\";s:1:\"0\";s:11:\"cache_terms\";s:1:\"0\";s:19:\"show_woof_edit_view\";s:1:\"1\";s:22:\"custom_extensions_path\";s:0:\"\";s:20:\"activated_extensions\";s:0:\"\";}","yes"),
("1173","woof_version","2.1.7","yes"),
("1174","woof_woocs_alert","a:1:{s:29:\"woocommerce-currency-switcher\";i:1;}","no"),
("1433","installer_repositories_with_theme","a:1:{i:0;s:7:\"toolset\";}","yes"),
("1439","wpseo","a:22:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:4:\"11.5\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:43:\"4xyFb5zfAI13fKR4ZxzQkz3YsH53ZFR70aiml_IIaGU\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";b:0;s:13:\"myyoast-oauth\";b:0;s:23:\"enable_metabox_insights\";b:0;s:23:\"enable_link_suggestions\";b:0;}","yes"),
("1440","wpseo_titles","a:128:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:30:\"Lỗi 404: không xác định\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:10:\"Danh mục\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:11:\"Trang chủ\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:17:\"Tìm kiếm với\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:14:\"person_logo_id\";i:0;s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:60:\"https://antam.net/wp-content/uploads/2022/07/logo-an-tam.png\";s:15:\"company_logo_id\";i:3309;s:12:\"company_name\";s:47:\"An Tâm - Máy tính, Phụ kiện chính hãng\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";s:8:\"category\";s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:12:\"title-blocks\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:15:\"metadesc-blocks\";s:0:\"\";s:14:\"noindex-blocks\";b:0;s:15:\"showdate-blocks\";b:0;s:25:\"display-metabox-pt-blocks\";b:1;s:25:\"post_types-blocks-maintax\";i:0;s:13:\"title-product\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-product\";s:0:\"\";s:15:\"noindex-product\";b:0;s:16:\"showdate-product\";b:0;s:26:\"display-metabox-pt-product\";b:1;s:26:\"post_types-product-maintax\";s:11:\"product_cat\";s:23:\"title-ptarchive-product\";s:54:\"Lưu trữ %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-product\";s:0:\"\";s:25:\"bctitle-ptarchive-product\";s:0:\"\";s:25:\"noindex-ptarchive-product\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:21:\"title-tax-product_cat\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_cat\";s:0:\"\";s:31:\"display-metabox-tax-product_cat\";b:1;s:23:\"noindex-tax-product_cat\";b:0;s:29:\"taxonomy-product_cat-ptparent\";s:7:\"product\";s:21:\"title-tax-product_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_tag\";s:0:\"\";s:31:\"display-metabox-tax-product_tag\";b:1;s:23:\"noindex-tax-product_tag\";b:0;s:29:\"taxonomy-product_tag-ptparent\";i:0;s:32:\"title-tax-product_shipping_class\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-product_shipping_class\";s:0:\"\";s:42:\"display-metabox-tax-product_shipping_class\";b:1;s:34:\"noindex-tax-product_shipping_class\";b:0;s:40:\"taxonomy-product_shipping_class-ptparent\";i:0;s:23:\"title-tax-pa_dung-luong\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-pa_dung-luong\";s:0:\"\";s:33:\"display-metabox-tax-pa_dung-luong\";b:1;s:25:\"noindex-tax-pa_dung-luong\";b:0;s:31:\"taxonomy-pa_dung-luong-ptparent\";i:0;s:20:\"title-tax-pa_mau-sac\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-pa_mau-sac\";s:0:\"\";s:30:\"display-metabox-tax-pa_mau-sac\";b:1;s:22:\"noindex-tax-pa_mau-sac\";b:0;s:28:\"taxonomy-pa_mau-sac-ptparent\";i:0;s:23:\"title-tax-pa_trang-thai\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-pa_trang-thai\";s:0:\"\";s:33:\"display-metabox-tax-pa_trang-thai\";b:1;s:25:\"noindex-tax-pa_trang-thai\";b:0;s:31:\"taxonomy-pa_trang-thai-ptparent\";i:0;s:20:\"title-tax-pa_xuat-xu\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-pa_xuat-xu\";s:0:\"\";s:30:\"display-metabox-tax-pa_xuat-xu\";b:1;s:22:\"noindex-tax-pa_xuat-xu\";b:0;s:28:\"taxonomy-pa_xuat-xu-ptparent\";i:0;s:23:\"page-analyse-extra-post\";s:0:\"\";s:23:\"page-analyse-extra-page\";s:0:\"\";s:25:\"page-analyse-extra-blocks\";s:0:\"\";s:26:\"taxonomy-category-ptparent\";s:7:\"product\";s:26:\"taxonomy-post_tag-ptparent\";s:1:\"0\";s:29:\"taxonomy-post_format-ptparent\";s:1:\"0\";}","yes"),
("1441","wpseo_social","a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}","yes"),
("1442","wpseo_flush_rewrite","1","yes"),
("1448","wpseo_current_version","16","no"),
("1449","wpseo_premium_version","11.5","yes"),
("1452","wpseo_onpage","a:2:{s:6:\"status\";i:-1;s:10:\"last_fetch\";i:1660298877;}","yes"),
("1686","font-awesome-conflict-detection","a:2:{s:20:\"detectConflictsUntil\";i:0;s:19:\"unregisteredClients\";a:0:{}}","yes"),
("1863","quickbuy_options","a:11:{s:6:\"enable\";s:1:\"1\";s:14:\"enable_payment\";s:1:\"1\";s:12:\"button_text1\";s:37:\"Đặt hàng không cần thanh toán\";s:12:\"button_text2\";s:51:\"Ship COD toàn quốc, thanh toán khi nhận hàng\";s:18:\"popup_infor_enable\";s:1:\"1\";s:11:\"popup_title\";s:13:\"Đặt mua %s\";s:10:\"popup_mess\";s:143:\"Bạn vui lòng nhập đúng số điện thoại để chúng tôi sẽ gọi xác nhận đơn hàng trước khi giao hàng. Xin cảm ơn!\";s:12:\"popup_sucess\";s:508:\"<div class=\"popup-message success\" style=\"color: #333;\">\r\n<p class=\"clearfix\" style=\"font-size: 22px; color: #00c700; text-align: center;\">Đặt hàng thành công!</p>\r\n<p class=\"clearfix\" style=\"color: #00c700; padding: 10px 0;\">Mã đơn hàng <span style=\"color: #333; font-weight: bold;\">#%%order_id%%</span></p>\r\n<p class=\"clearfix\">Chúng tôi sẽ liên hệ với bạn trong 12h tới. Cám ơn bạn đã cho chúng tôi cơ hội được phục vụ.\r\n\r\n</p>\r\n\r\n<div></div>\r\n<div></div>\r\n</div>\";s:11:\"popup_error\";s:71:\"Đặt hàng thất bại. Vui lòng đặt hàng lại. Xin cảm ơn!\";s:17:\"out_of_stock_mess\";s:12:\"Hết hàng!\";s:11:\"license_key\";s:0:\"\";}","yes"),
("1892","devvn_reviews_options","a:6:{s:8:\"img_size\";s:6:\"512000\";s:10:\"cmt_length\";s:2:\"10\";s:15:\"review_position\";s:0:\"\";s:22:\"review_position_action\";s:0:\"\";s:15:\"review_priority\";s:2:\"99\";s:11:\"license_key\";s:0:\"\";}","yes"),
("1990","woocommerce_thumbnail_cropping","1:1","yes"),
("1991","woocommerce_thumbnail_cropping_custom_height","5","yes"),
("3152","duplicator_pro_package_active","{\"Created\":\"2023-10-30 08:53:41\",\"Version\":\"3.8.4\",\"VersionWP\":\"6.3.2\",\"VersionDB\":\"10.6.15\",\"VersionPHP\":\"7.3.33\",\"VersionOS\":\"Linux\",\"ID\":null,\"Name\":\"20231030_antammaytinhphukien\",\"Hash\":\"43c441f59558f7aa2287_20231030085341\",\"NameHash\":\"20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341\",\"Type\":0,\"Notes\":\"\",\"StorePath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/antam.net\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20231030_antammaytinhphukien_43c441f59558f7aa2287_20231030085341_scan.json\",\"timer_start\":-1,\"Runtime\":null,\"ExeSize\":null,\"ZipSize\":0,\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":null,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/ai1wm-backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backups-dup-pro\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backupwordpress\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/content\\/cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/contents\\/cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/managewp\\/backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/old-cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/updraft\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/wfcache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/wishlist-backup\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.htaccess\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-config.php\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":null,\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/songkh15\\/public_html\\/antam.net\",\"Size\":193666593,\"Dirs\":null,\"DirCount\":2015,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":12784,\"file_count\":-1,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-snapshots\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/ai1wm-backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/backupwordpress\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/content\\/cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/contents\\/cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/managewp\\/backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/old-cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/updraft\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/wishlist-backup\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/wfcache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/cache\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[],\"Size\":[],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.htaccess\",\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"antam.net\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\",\"isDir\":true,\"childs\":{\".litespeed_flag\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\".litespeed_flag\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.litespeed_flag\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".wp-cli\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".wp-cli\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.wp-cli\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-config-sample.php\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-blog-header.php\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"readme.html\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"htaccess.orig1024355333\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"htaccess.orig1024355333\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/htaccess.orig1024355333\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config.php\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-links-opml.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-signup.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"installer-bootlog.txt\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"installer-bootlog.txt\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/installer-bootlog.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-activate.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-cron.php\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess.bk\":{\"id\":\"0_26\",\"parentId\":\"0\",\"name\":\".htaccess.bk\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.htaccess.bk\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"error_log\":{\"id\":\"0_27\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\"},\"TreeWarning\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"antam.net\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\",\"isDir\":true,\"childs\":{\".litespeed_flag\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\".litespeed_flag\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.litespeed_flag\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".wp-cli\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".wp-cli\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.wp-cli\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-config-sample.php\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-blog-header.php\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"readme.html\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"htaccess.orig1024355333\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"htaccess.orig1024355333\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/htaccess.orig1024355333\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config.php\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-links-opml.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-signup.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"installer-bootlog.txt\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"installer-bootlog.txt\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/installer-bootlog.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-activate.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-cron.php\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess.bk\":{\"id\":\"0_26\",\"parentId\":\"0\",\"name\":\".htaccess.bk\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/.htaccess.bk\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"error_log\":{\"id\":\"0_27\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/songkh15\\/public_html\\/antam.net\"}},\"ListDelimiter\":\";\\n\",\"throttleDelayInUs\":2,\"isOuterWPContentDir\":false},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":null,\"Size\":0,\"OptsSecureOn\":0,\"OptsSecurePass\":\"\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8mb4_unicode_ci\",\"latin1_swedish_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"songkh15_antam\",\"tablesBaseCount\":57,\"tablesFinalCount\":57,\"tablesRowCount\":6894,\"tablesSizeOnDisk\":8273796,\"varLowerCaseTables\":\"0\",\"version\":\"10.6.15\",\"versionComment\":\"MariaDB Server\",\"tableWiseRowCounts\":[]},\"Type\":\"MySQL\",\"Size\":null,\"File\":null,\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":null,\"Compatible\":\"\",\"Comments\":\"MariaDB Server\",\"dbStorePathPublic\":null},\"Status\":5,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":null,\"initialized\":false,\"installer_built\":false,\"archive_started\":false,\"archive_has_database\":false,\"archive_built\":false,\"database_script_built\":false,\"failed\":false,\"next_archive_file_index\":0,\"next_archive_dir_index\":0,\"retries\":0,\"current_build_mode\":-1,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":0,\"tableOffset\":0,\"totalRowOffset\":0,\"chunkIndex\":null,\"validationStage1\":false,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":false,\"doneFiltering\":false,\"doneCreates\":false,\"completed\":false,\"tablesToProcess\":[],\"startTime\":null,\"fileOffset\":0,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":0,\"tablesSchemaSizes\":[]},\"upload_infos\":[{\"storage_id\":\"-2\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":false,\"status_message_details\":\"\",\"started_timestamp\":null,\"stopped_timestamp\":null}],\"active_storage_id\":-1,\"template_id\":5}","yes"),
("3165","duplicator_pro_ui_view_state","a:4:{s:28:\"dup-settings-diag-opts-panel\";s:1:\"1\";s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:25:\"dpro-pack-installer-panel\";s:1:\"1\";}","yes"),
("4181","themeisle_sdk_notifications","a:2:{s:17:\"last_notification\";a:2:{s:2:\"id\";s:22:\"menu_icons_review_flag\";s:10:\"display_at\";i:1650685177;}s:24:\"last_notification_active\";i:1651034381;}","yes"),
("6573","menu_icons_logger_flag","no","yes"),
("6942","secret_key","YNJ|S$6-s|Gx]Bd]OtnFNrtP)>?7K.Jn<G0Yk|%z#K1k_FTSGQ%IaL~#R0#TJVsN","no"),
("7614","acf_version","5.12.2","yes"),
("9114","woocommerce_version","6.6.0","yes"),
("9117","woocommerce_onboarding_profile","a:1:{s:9:\"completed\";b:1;}","yes"),
("9132","menu_icons_translate_flag","no","yes"),
("9141","disallowed_keys","","no"),
("9142","comment_previously_approved","1","yes"),
("9143","auto_plugin_theme_update_emails","a:0:{}","no"),
("9144","finished_updating_comment_type","1","yes"),
("9145","db_upgraded","","yes"),
("9247","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:27:\"info.giuseart.com@gmail.com\";s:7:\"version\";s:5:\"5.5.9\";s:9:\"timestamp\";i:1650685186;}","no"),
("9528","woocommerce_sales_record_date","2023-10-28","yes"),
("9529","woocommerce_sales_record_amount","7900000","yes"),
("9791","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("9792","auto_update_core_dev","enabled","yes"),
("9793","auto_update_core_minor","enabled","yes"),
("9794","auto_update_core_major","unset","yes"),
("9795","wp_force_deactivated_plugins","a:0:{}","yes"),
("9807","https_detection_errors","a:0:{}","yes"),
("11397","litespeed.conf.__activation","4.6","yes"),
("11398","litespeed.purge.queue","X-LiteSpeed-Purge: public,609_","yes"),
("11399","litespeed.purge.queue2","-1","yes"),
("11400","litespeed.optimize.timestamp_purge_css","1651032466","yes"),
("11401","litespeed.gui.lscwp_whm_install","-1","yes"),
("11402","litespeed.cloud._summary","{\"curr_request.ver\":0,\"last_request.ver\":1651032466}","yes"),
("11532","menu_icons_review_flag","no","yes"),
("11553","woocommerce_db_version","6.4.0","yes"),
("11575","font-awesome-releases","a:2:{s:12:\"refreshed_at\";i:1651734813;s:4:\"data\";a:2:{s:6:\"latest\";s:6:\"5.15.4\";s:8:\"releases\";a:48:{s:5:\"5.0.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-VVoO3UHXsmXwXvf1kJx2jV3b1LbOfTqKL46DdeLG8z4pImkQ4GAP9GMy+MxHMDYG\";s:14:\"css/brands.css\";s:71:\"sha384-JT52EiskN0hkvVxJA8d2wg8W/tLxrC02M4u5+YAezNnBlY/N2yy3X51pKC1QaPkw\";s:19:\"css/fontawesome.css\";s:71:\"sha384-7mC9VNNEUg5vt0kVQGblkna/29L8CpTJ5fkpo0nlmTbfCoDXyuK/gPO3wx8bglOz\";s:15:\"css/regular.css\";s:71:\"sha384-JZ2w5NHrKZS6hqVAVlhUO3eHPVzjDZqOpWBZZ6opcmMwVjN7uoagKSSftrq8F0pn\";s:13:\"css/solid.css\";s:71:\"sha384-TQW9cJIp+U8M7mByg5ZKUQoIxj0ac36aOpNzqQ04HpwyrJivS38EQsKHO2rR5eit\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-X1ZQAmDHBeo7eaAJwWMyyA3mva9mMK10CpRFvX8PejR0XIUjwvGDqr2TwJqwbH9S\";s:9:\"js/all.js\";s:71:\"sha384-2CD5KZ3lSO1FK9XJ2hsLsEPy5/TBISgKIk2NSEcS03GbEnWEfhzd0x6DBIkqgPN1\";s:12:\"js/brands.js\";s:71:\"sha384-i3UPn8g8uJGiS6R/++68nHyfYAnr/lE/biTuWYbya2dONccicnZZPlAH6P8EWf28\";s:17:\"js/fontawesome.js\";s:71:\"sha384-tqpP2rDLsdWkeBrG3Jachyp0yzl/pmhnsdV88ySUFZATuziAnHWsHRSS97l5D9jn\";s:13:\"js/regular.js\";s:71:\"sha384-hXqI+wajk6jJu2DXwf2oqBg6q5+HqXM5yz9smX94pDjiLzH81gAuVtjter66i1Ct\";s:11:\"js/solid.js\";s:71:\"sha384-kbPfTyGdGugnvSKEBJCd6+vYipOQ6a+2np5O4Ty3sW7tgI0MpwPyAh+QwUpMujV9\";s:14:\"js/v4-shims.js\";s:71:\"sha384-BRge2B8T+0rmvB/KszFfdQ0PDvPnhV2J80JMKrnq21Fq6tHeKFhSIrdoroXvk7eB\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-bJB2Wn8ZuuMwYA12t6nmPqVTqT64ruKTAWqdxs/Oal3vexA7RPAo3FtVU5hIil2E\";s:14:\"css/brands.css\";s:71:\"sha384-F8vNf2eNIHep58ofQztLhhWsZXaTzzfZRqFfWmh7Cup7LqrF0HCtB6UCAIIkZZYZ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CTTGZltCsihOiEwOCbT7p1lhij8kYk6lapCladmNzxj4yXj/AKp6q3+CRoNN3UCG\";s:15:\"css/regular.css\";s:71:\"sha384-GtLUznQ3nMgus15JP1pAE2UH9HAQi8gjQTNfIT+Gq6zFPeeq3y+Xtxt5HUBFF0YO\";s:13:\"css/solid.css\";s:71:\"sha384-WEKepgUDOaHRK2/r+qA7W/Srd+36IIOmBm/+wm9aSz6acYC0LkyM9UJElLVNy95T\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-sV6Qj6KRPF7HrXfo5NK0evVt+YbNxUuGZU2udYKDAxwxPVTuEE6lofcZJhRMK4WT\";s:9:\"js/all.js\";s:71:\"sha384-xiGKJ+4CP2p2WkTifyjHDeZVAg1zBrnJV8LU33N7J+5BWp1biPcSpEJJY7hFiRLn\";s:12:\"js/brands.js\";s:71:\"sha384-V+scQ15NnQuKVajRBsSery7bV87d0xDAoCs4pB8ZcwW74+zzW5CkgRmIFOYw8kKX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-CxMnuVDquTXcsJnW1rAfSm4uzGr12HENF1oe+JRZm4jcQDerJ6VeA1XLvAso396r\";s:13:\"js/regular.js\";s:71:\"sha384-ihKlq3j4PocIYMPkNra+ieEVsLuFzj4rp1yjn3jq+La7r4G9kf9COpWfOI8SGapM\";s:11:\"js/solid.js\";s:71:\"sha384-KDEuZV2OBU0Q264kBX2Idu9gYr5z/fQrtvUsKfuKGEDkDxV0GBVN/qi3QoLZPmbJ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-0nloDHslShcnKvH94Zv8nb0zPlzTFCzfZGx9YxR2ngUWs9HXXHVx1PUQw0u9/7LE\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-KFTzeUQSHjcfuC8qqdFm+laWVqpkucx/3uXo41hhKQzUEtbNnNSk8KEEBZ+2lEQy\";s:14:\"css/brands.css\";s:71:\"sha384-J6h7hpR0mfr79Ck/ZfDrhN14FnkbkLbd+mm0yTw5spSpK08yOK/AB9IRR/Dcg8EJ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-l2oTZy4pLseT/J6oW0mwsjKPhjpTctOfU191uVonzezZiqw9PPcz4AMKsIAeyR4P\";s:15:\"css/regular.css\";s:71:\"sha384-cDXlx+8npD3wa2ahyeSZvsi9VlRrMmJVIB1rpK7Ftyq4cppWM9d2mBhrlOqYBljt\";s:13:\"css/solid.css\";s:71:\"sha384-ioYc/tyAAvPTKdlEWH/BDO/Fn0RGAWisNzyfZNt74mHfA6UPN2tzjD6Nm4ieQfBR\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-bnoXyQHIAXdkrtQTtvuajtPgmWqHQ8657dQ4vzySapygDMqzijBpEq96AwgX2u4N\";s:9:\"js/all.js\";s:71:\"sha384-4OPaVeLgwRHdGJplmRGxGcoGYwxBAdR8Qr9z/Av7blRYPlRIPtjTygdtpQlD1HHv\";s:12:\"js/brands.js\";s:71:\"sha384-68dqWCRgViK/UsBTW5vGfntS6GdBDT5D4KWUBXTf6IkF2NFFD+X/0QNs0FZaIELt\";s:17:\"js/fontawesome.js\";s:71:\"sha384-sBtO3o3oG61AtAKrg74kfk50JP0YHcRTwOXgTeUobbJJBgYiCcmtkh784fmHww23\";s:13:\"js/regular.js\";s:71:\"sha384-J0ggktpCvzBHSxd/a8EBQgQDIWBtASK5rhHMvGWuR/UyjuPgX0iCAcb3OlfhvlQz\";s:11:\"js/solid.js\";s:71:\"sha384-DX1/9hggbc1yKVl40n2dNF9OzLf9ZPwZm87WzIW+FinkgjSq18PXpUxOL4I0iS1+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-kysXtDCmCTYxM55rHL+9xPu6+Inoi3ZzZHvcxkXs+iPj5nymJKlauQdXyzubyD0b\";}s:3:\"pro\";a:0:{}}}s:5:\"5.0.4\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-DmABxgPhJN5jlTwituIyzIUk6oqyzf3+XuP7q3VfcWA2unxgim7OSSZKKf0KSsnh\";s:14:\"css/brands.css\";s:71:\"sha384-1beec9tTZuu+KrTudmvRnGpK81r78DKCAXdphCvdG+PR+n/WCczsYPqTBTvYsM7z\";s:19:\"css/fontawesome.css\";s:71:\"sha384-xdTUmhbcetyLRVL4PAriRajOve+/5pjOiy5sJABnhXMcRMVc9HI9s2KmOCjjDK/P\";s:15:\"css/regular.css\";s:71:\"sha384-nM5tBytXTc1HDZ/A3My2gNT2TxLk/M/5yFi0QrOxaZjBi7QpKUfA2QqT+fcSxSlg\";s:13:\"css/solid.css\";s:71:\"sha384-g2aKxiZcFezoVOq4MsjaxuBbSxSlXD/NRQ5GaPLfvCtcTLgP3fYZKKAGxCM/wMfe\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-MCR8qGTbdyK+hklwz1eKgGiAjT57F5HEJMs/uHRAwZ6GI5602TyGI89FyrbUwiIc\";s:9:\"js/all.js\";s:71:\"sha384-nVi8MaibAtVMFZb4R1zHUW/DsTJpG/YwPknbGABVOgk5s6Vhopl6XQD/pTCG/DKB\";s:12:\"js/brands.js\";s:71:\"sha384-dl3ONr32uA3YqpqKWzhXLs5k1YbKOn3dwiMbEP1S/XQMa3LPRwvJrhW7+lomL/uc\";s:17:\"js/fontawesome.js\";s:71:\"sha384-l7FyBM+wFIWpfmy8RYkWgEu/Me6Hrz98ijLu4nP3PkGbTtTCvtHB5ktI8hLEgEG3\";s:13:\"js/regular.js\";s:71:\"sha384-lwwoO5Gg19TptbILrLBjV28EVJ9RW3tD3cGyjCRn3OY9IuLua/YRlE47btZIXfMv\";s:11:\"js/solid.js\";s:71:\"sha384-4KkAk2UXMS9Xl3FoAAN43VJxRZ/emjElCz60xUTegPOZlbPLZGylvor2v7wQ0JNb\";s:14:\"js/v4-shims.js\";s:71:\"sha384-yfrMPoFcXUzdvECrvYRYE7wlxouXxjRSge5x6BlPPOb38tW4n0e8EW79RGU7VY0R\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-1RxicL8bcQJWgpr/clvtGVG7DVFJvDX/DVsJsbjKhXtdo8r5WVZQqB9AHTNPr08A\";s:14:\"css/brands.css\";s:71:\"sha384-sFwP5Zsnp6I4zQxUMPHvv8Bk16eEzU0YhaNbMCftDHPKDD+BR8WdXAHKL4xpipII\";s:19:\"css/fontawesome.css\";s:71:\"sha384-VFi8UvBDvM8muKO8ogMXi2j8vdJiu8hq1uxpX/NS8BsftBiJpheM5AuhFH1dvURx\";s:13:\"css/light.css\";s:71:\"sha384-4FGoKudkcpRXgx5UNFa5TxzaHUhnvCGFDeZKncEn9KJx/l07kcid3VbpwajrvrFW\";s:15:\"css/regular.css\";s:71:\"sha384-eyjlqgvgpHiWM0GoL4/hsTh22piTKmMTM+sfJYacddG2n9AEubqQB/w4CPJK1/1b\";s:13:\"css/solid.css\";s:71:\"sha384-TlWtvBj4TXNlpJC5Qq4aHel0R/dywVcP/6eOFC0qptQ71WWSxJCvuTajjGb1duS9\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-rHay3RzsgCtbjvDmBLThu6ESXlU4Al5STjlHSpNygnbeyt04OP1uKZVXB2Zy16+T\";s:9:\"js/all.js\";s:71:\"sha384-vV0064GQjt+TcoZxVPm/f6vyAivSNofFvOHKLWxcDl784Dzm9W4BBpoTvUG4vi5a\";s:12:\"js/brands.js\";s:71:\"sha384-/877azmwW/YhoBsPeM9dh61dNr5XGbuk24lyjPbFWyrPaZPyU2oxgOY6PE1OH4z4\";s:17:\"js/fontawesome.js\";s:71:\"sha384-7L9/YJQEf9kLPc6sdtoVIsuBNxCVi4OmHPcszcY685IJIcB52hgYoL1OiwTawJS/\";s:11:\"js/light.js\";s:71:\"sha384-iXxa9ExuZ0Fi2N2VO/buuWuAgYIUXNtOaJiKLa40Bjt43KJpzJdhg2TBHyBVqCPh\";s:13:\"js/regular.js\";s:71:\"sha384-YzSStfq1m16y1v5M97ViNRpiQUCVpagVVOkqlmww8otyjFkY6EXT4dShlKNuxRDu\";s:11:\"js/solid.js\";s:71:\"sha384-WJDZ/GI6pz1VoELs6i44T3f00fguksrLXIx3LXHdlaAzmOvX/mTK5j+qzHJdKejC\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8XZ16R7aSGin4NRuv6gn5xfbsvad5H8LR41g48iduwkfZEqDgXlvUjkJKgxqZUiW\";}}}s:5:\"5.0.6\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-VY3F8aCQDLImi4L+tPX4XjtiJwXDwwyXNbkH7SHts0Jlo85t1R15MlXVBKLNx+dj\";s:14:\"css/brands.css\";s:71:\"sha384-rK0EPNdv8UCeRNPzX+96ARRlf9hZM+OukGceDTdbPH30DYcSI1x5QyBU7d2I2kHX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-dbkYY2NmVwxaFrr4gq04oVh6w39ovmevsgD80Il1Od3hwpgREqyPb3XqbpaSwN4x\";s:15:\"css/regular.css\";s:71:\"sha384-HGbVnizaFNw8zW+vIol9xMwBFWdV7/k61278Zo1bnMy9dLmjv48D7rtpgYRTe5Pd\";s:13:\"css/solid.css\";s:71:\"sha384-GfC9nfESTZkjCPFbevBVig3FTd6wkjRRYMtj+qFgK8mMBvGIje2rrALgiBy6pwRL\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-U2b24h7gWqOYespg+vI5yiIn4ZYlTevT0N96xkGrw7ktP1gg9XwqEslsdTLJdlGg\";s:9:\"js/all.js\";s:71:\"sha384-0AJY8UERsBUKdWcyF3o2kisLKeIo6G4Tbd8Y6fbyw6qYmn4WBuqcvxokp8m2UzSD\";s:12:\"js/brands.js\";s:71:\"sha384-4iSpDug9fizYiQRPpPafdAh5NaF8yzNMjOvu3veWgaFm0iIo8y4vUi7f3Yyz5WP1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-rttr/ldR2uHigckjTCjMDe47ySeFVaL3Q7xUkJZir56u8Z8h/XnHJXHocgyfb25F\";s:13:\"js/regular.js\";s:71:\"sha384-G375DXNEVfALvsggywPWDYrRxNOvXaCYt/kiq/GXmbaDW8/B0XtbC8iuLpXXm1jF\";s:11:\"js/solid.js\";s:71:\"sha384-U0ZJ7q5xbT8hEoRqj61HzpvsqNOQ8bsHY2VqSRPqGOzjHXmmV70Aw+DBC/PT00p4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-L8zntmMOcCbOxXiL5Rjn6ubB7KunZiQ8U3bb9x6FFTGDEvVEESW9n+x49jm34K3W\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-ldFHeX3xCFvM4uf7m0mCMIoCPVwM71jopwqLZRldf+ojynoGVSxDiphfScLukkwO\";s:14:\"css/brands.css\";s:71:\"sha384-Ks7IvHjmJ4FIFxhK4iNrtW0rAVo1DlCYpe/nDsK8CnU+yactd38YiNE1GT018WPg\";s:19:\"css/fontawesome.css\";s:71:\"sha384-sATKZbJwxaEIU3unIoL1VMbIyrNNh7PlgnaiWlicWXeRA7qdnzfFzMP9AaN2wfTU\";s:13:\"css/light.css\";s:71:\"sha384-YWWfxaKIDrbFXuVQnpxASJDHmFl2K5f2vDgrcROb+rYycoqcQVdMlfu3U38boTg/\";s:15:\"css/regular.css\";s:71:\"sha384-CydLcYoDSbudHX/6hygyQD4jBMPsv91d/RwdtH1qxI79KG8kII/OzxKDwsswywA4\";s:13:\"css/solid.css\";s:71:\"sha384-uBARwTxpZ7FB08kQlCOS/dUaN3TrGGcHthrXYIhZBpdq7YtUdVDM1sAUH9NIozMl\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-BptPo+4C0N+fnMTnfw7ddW/zYUJhuNEe7edve8UrMbs+fCpfDJvJcC/lpa5Nvaky\";s:9:\"js/all.js\";s:71:\"sha384-FrB6Se1Wkxlx66xA4rPuOoOolLyQt5B1uptDmtLJSIVRJDbNkmE3QOLipnMuAbUW\";s:12:\"js/brands.js\";s:71:\"sha384-G12tjfNd/W8L4IrE5+f13LUbpzVowwhNDv+WNecvxjbaGN9bbSY7epBOqUlRqXnq\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ln5PcCmuH8v+AF9nt+HkM2GfXjsn1CtVc0n+ciM8+oe3nwGyPCceDVva7bUjNfo0\";s:11:\"js/light.js\";s:71:\"sha384-jzS22FYPy68IBBet2IRM5aQDOXjg9X1g+drXIVonDtyqGFCtUA0YIdgHdvCCX/fD\";s:13:\"js/regular.js\";s:71:\"sha384-M8TFIPAJNl8UIC8OP6GFcIE0SHkGN4zjwwjz+BBTz60XhNegOrZmjNtTQNKifmXX\";s:11:\"js/solid.js\";s:71:\"sha384-R/e3QvpS9m8HcN9b9l6nNo678ekTXL31kFY/XtRHSjrihDX8A2DF8HaXhdlAtzMx\";s:14:\"js/v4-shims.js\";s:71:\"sha384-X9eLyweB0LOTEGCwMARo9+zibrXQYmBMSrhFk4ncpT/WYnPIcpTg0IgBFDgzuPwL\";}}}s:5:\"5.0.8\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-3AB7yXWz4OeoZcPbieVW64vVXEwADiYyAEhwilzWsLw+9FgqpyjjStpPnpBO8o8S\";s:14:\"css/brands.css\";s:71:\"sha384-IiIL1/ODJBRTrDTFk/pW8j0DUI5/z9m1KYsTm/RjZTNV8RHLGZXkUDwgRRbbQ+Jh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-q3jl8XQu1OpdLgGFvNRnPdj5VIlCvgsDQTQB6owSOHWlAurxul7f+JpUOVdAiJ5P\";s:15:\"css/regular.css\";s:71:\"sha384-A/oR8MwZKeyJS+Y0tLZ16QIyje/AmPduwrvjeH6NLiLsp4cdE4uRJl8zobWXBm4u\";s:13:\"css/solid.css\";s:71:\"sha384-v2Tw72dyUXeU3y4aM2Y0tBJQkGfplr39mxZqlTBDUZAb9BGoC40+rdFCG0m10lXk\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-TGBI4yK0MJz2ga16RLBBt4xT4aoPMPmRYhfu1Kl5IJ0gsLyOBIKHEb49BtoO+lPS\";s:9:\"js/all.js\";s:71:\"sha384-SlE991lGASHoBfWbelyBPLsUlwY1GwNDJo3jSJO04KZ33K2bwfV9YBauFfnzvynJ\";s:12:\"js/brands.js\";s:71:\"sha384-sCI3dTBIJuqT6AwL++zH7qL8ZdKaHpxU43dDt9SyOzimtQ9eyRhkG3B7KMl6AO19\";s:17:\"js/fontawesome.js\";s:71:\"sha384-7ox8Q2yzO/uWircfojVuCQOZl+ZZBg2D2J5nkpLqzH1HY0C1dHlTKIbpRz/LG23c\";s:13:\"js/regular.js\";s:71:\"sha384-t7yHmUlwFrLxHXNLstawVRBMeSLcXTbQ5hsd0ifzwGtN7ZF7RZ8ppM7Ldinuoiif\";s:11:\"js/solid.js\";s:71:\"sha384-+Ga2s7YBbhOD6nie0DzrZpJes+b2K1xkpKxTFFcx59QmVPaSA8c7pycsNaFwUK6l\";s:14:\"js/v4-shims.js\";s:71:\"sha384-4CnzNxEP5RK316IYY2+W4hc05uJdfd+p9iNVeNG9Ws3Qxf5tKolysO9wu/8rloj2\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-OGsxOZf8qnUumoWWSmTqXMPSNI9URpNYN35fXDb5Cv5jT6OR673ah1e5q+9xKTq6\";s:14:\"css/brands.css\";s:71:\"sha384-VRONz34zTLl4P+DLYyJ8kP8C3tB1PGtqL5p8nBAvHuoc1u32bR3RHixrjffD8Fly\";s:19:\"css/fontawesome.css\";s:71:\"sha384-+5VkSw5C1wIu2iUZEfX77QSYRb5fhjmEsRn8u4r9Ma8mvu/GvTag4LDSEAw7RjXl\";s:13:\"css/light.css\";s:71:\"sha384-shmfBA2CRxp88gq8NcvWbEN8KExYU4uvQUBEG36BStGZ5k91nGKE4wDvvWvuimbu\";s:15:\"css/regular.css\";s:71:\"sha384-0w6MzzKHIB9cUlfWSmSp1Pj6XqGGDseWSMz1Yppk3UOc1dhYhpFx1AuCkMBECEvC\";s:13:\"css/solid.css\";s:71:\"sha384-+iHwwKZGTdlVFbv4fsKmLkogfdKlp47zQGkSMDN3ANc8kXjyKudKvQwinI5VH+2C\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-b2wDmqWyAwmI2rS5ut5UweBS1V32L/k1+2Oo7eCaHdXOS/1bFwC8AKevTI6N28LN\";s:9:\"js/all.js\";s:71:\"sha384-816IUmmhAwCMonQiPZBO/PTgzgsjHtpb78rpsLzldhb4HZjFzBl06Z3eu4ZuwHTz\";s:12:\"js/brands.js\";s:71:\"sha384-gJijC/2qM/p3zm2wHECHX1OMLdzlu61sNp7YfmFQxo+OyT9hO1orX7MmnHhaoXQ4\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ht3fAeBiX/rVmKVyMwONAIIt0aRoPzZgq1FzdRgR9zFo+Kcd8YDwUbFlTItfaYW4\";s:11:\"js/light.js\";s:71:\"sha384-mfSnp84URDGC1t+cg63LgVKwEs63ulRUpjNneyDZMGMAE9ZKUNZ85rMBMHucGLYP\";s:13:\"js/regular.js\";s:71:\"sha384-SIp/+zr0hyfSVIQPkAwB/L1h4fph6T3CmU4mE7IFtGJlgwoCko0Bye/1J0sjyh4v\";s:11:\"js/solid.js\";s:71:\"sha384-jTxqWCb7UqRDQDd2Nkuh5BkHe9k+ElbFLa3NaJfid5kBK/+cVktzVRXrw0isFWxf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-w/sFNq23wbOXJOUpFyISABLXk9tA4Z8r9hl80er2mobEwgS7VXXYDANaWyrCWe3/\";}}}s:5:\"5.0.9\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-5SOiIsAziJl6AWe0HWRKTXlfcSHKmYV4RBF18PPJ173Kzn7jzMyFuTtk8JA7QQG1\";s:14:\"css/brands.css\";s:71:\"sha384-ATC/oZittI09GYIoscTZKDdBr/kI3lCwzw3oBMnOYCPVNJ4i7elNlCxSgLfdfFbl\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Lyz+8VfV0lv38W729WFAmn77iH5OSroyONnUva4+gYaQTic3iI2fnUKtDSpbVf0J\";s:15:\"css/regular.css\";s:71:\"sha384-seionXF7gEANg+LFxIOw3+igh1ZAWgHpNR8SvE64G/Zgmjd918dTL55e8hOy7P4T\";s:13:\"css/solid.css\";s:71:\"sha384-29Ax2Ao1SMo9Pz5CxU1KMYy+aRLHmOu6hJKgWiViCYpz3f9egAJNwjnKGgr+BXDN\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Hl6tZnMfNiJHYyFxpmnRV8+pziARxY3X/4XWfFXldG7sdkkLv+Od2Gpc57P7C1g6\";s:9:\"js/all.js\";s:71:\"sha384-8iPTk2s/jMVj81dnzb/iFR2sdA7u06vHJyyLlAd4snFpCl/SnyUjRrbdJsw1pGIl\";s:12:\"js/brands.js\";s:71:\"sha384-qJKAzpOXfvmSjzbmsEtlYziSrpVjh5ROPNqb8UZ60myWy7rjTObnarseSKotmJIx\";s:17:\"js/fontawesome.js\";s:71:\"sha384-2IUdwouOFWauLdwTuAyHeMMRFfeyy4vqYNjodih+28v2ReC+8j+sLF9cK339k5hY\";s:13:\"js/regular.js\";s:71:\"sha384-BazKgf1FxrIbS1eyw7mhcLSSSD1IOsynTzzleWArWaBKoA8jItTB5QR+40+4tJT1\";s:11:\"js/solid.js\";s:71:\"sha384-P4tSluxIpPk9wNy8WSD8wJDvA8YZIkC6AQ+BfAFLXcUZIPQGu4Ifv4Kqq+i2XzrM\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9f5gaI9TkuYhi5O/inzfdOXx2nkIhDsLtXqBNmtY6/c5PoqXfd0U2DAjqQVSCXQh\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-L+XK540vkePe55E7PAfByfvW0XpsyYpsifTpgh/w8WvH6asVg/c2zqp0EfZfZTbF\";s:14:\"css/brands.css\";s:71:\"sha384-+LMmZxgyldhNCY6nei3oAWJjHbpbROtVb+f5Ux/nahA+Xjm3wcNdu7zyB39Yj38S\";s:19:\"css/fontawesome.css\";s:71:\"sha384-31qpW3hduWGiGey9tdI9rBBxiog5pxZbPiAlD6YKIgy0P2V1meprKhvpk+xJDkMw\";s:13:\"css/light.css\";s:71:\"sha384-wD8IB6DSQidXyIWfwBrsFwTaHTQDsgzyeqzhd1jNdBZHvGSa7KRGb6Q5sMlroCyk\";s:15:\"css/regular.css\";s:71:\"sha384-hJbmKHxbgrH79UtKxubo1UTe96bOL4Xfhjaqr0csD1UMPEPbeV+446QAC+IGxY+b\";s:13:\"css/solid.css\";s:71:\"sha384-k8v16DuQ4ZFtRfpTeqTW4tcHIj5tkvUNQm1QiLs90XiToLzyFeV+yxujHjSZ2wim\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-yVUvm1bVSmayKKt0YHPKotNQzlBvgNhEBbQ6U1d38bjpapXMVmE+SLXrpQ9td4Ij\";s:9:\"js/all.js\";s:71:\"sha384-DtPgXIYsUR6lLmJK14ZNUi11aAoezQtw4ut26Zwy9/6QXHH8W3+gjrRDT+lHiiW4\";s:12:\"js/brands.js\";s:71:\"sha384-yIJb2TJeTM04vupX+3lv0Qp9j0Pnk8Qm9UPYlXr3H0ROCHNNLoacpS++HWDabbzi\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8QYlVHotqQzcAVhJny7MO9ZR0hASr6cRCpURV+EobTTAv5wftkn4i+U6UrMqoCis\";s:11:\"js/light.js\";s:71:\"sha384-06sraYAcw8BzUjsPn5z8Qi/QAA2/ZJl5GN3LGtRp7k+tZpu7kw+sRNXDDTU4RkOt\";s:13:\"js/regular.js\";s:71:\"sha384-C6h/8oKUfY6cVuGfFSu9uGIlFkaD1u1j+ByYGFTdFbOpHOHpw39lKxqEpRgLQg6A\";s:11:\"js/solid.js\";s:71:\"sha384-nISI3wKDp2gWn9L91zXOKXZ6JPt2mteGTnaJAMfeNgAoeLKl2AQsWLH69HMmBXHa\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vuyo8HdrwozCl2DhHOJ40ytjEx9FGy0cqu8i5GHeIoSUm6MPgqCXAVoUIsudKfuE\";}}}s:6:\"5.0.10\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-+d0P83n9kaQMCwj8F4RJB66tzIwOKmrdb46+porD/OvrJ+37WqIM7UoBtwHO6Nlg\";s:14:\"css/brands.css\";s:71:\"sha384-KtmfosZaF4BaDBojD9RXBSrq5pNEO79xGiggBxf8tsX+w2dBRpVW5o0BPto2Rb2F\";s:19:\"css/fontawesome.css\";s:71:\"sha384-8WwquHbb2jqa7gKWSoAwbJBV2Q+/rQRss9UXL5wlvXOZfSodONmVnifo/+5xJIWX\";s:15:\"css/regular.css\";s:71:\"sha384-R7FIq3bpFaYzR4ogOiz75MKHyuVK0iHja8gmH1DHlZSq4tT/78gKAa7nl4PJD7GP\";s:13:\"css/solid.css\";s:71:\"sha384-HTDlLIcgXajNzMJv5hiW5s2fwegQng6Hi+fN6t5VAcwO/9qbg2YEANIyKBlqLsiT\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ucawWSvpdgQ67m4VQzI6qBOHIsGRoY2soJtCkkp15b6IaNCLgauWkbKR8SAuiDQ7\";s:9:\"js/all.js\";s:71:\"sha384-slN8GvtUJGnv6ca26v8EzVaR9DC58QEwsIk9q1QXdCU8Yu8ck/tL/5szYlBbqmS+\";s:12:\"js/brands.js\";s:71:\"sha384-6jhVhr5a+Z1nLr9h+fd7ocMEo847wnGFelCHddaOOACUeZNoQwFXTxh4ysXVam8u\";s:17:\"js/fontawesome.js\";s:71:\"sha384-M2FSA4xMm1G9m4CNXM49UcDHeWcDZNucAlz1WVHxohug0Uw1K+IpUhp/Wjg0y6qG\";s:13:\"js/regular.js\";s:71:\"sha384-JWLWlnwX0pRcCBsI3ZzOEyVDoUmngnFnbXR9VedCc3ko4R3xDG+KTMYmVciWbf4N\";s:11:\"js/solid.js\";s:71:\"sha384-Q7KAHqDd5trmfsv85beYZBsUmw0lsreFBQZfsEhzUtUn5HhpjVzwY0Aq4z8DY9sA\";s:14:\"js/v4-shims.js\";s:71:\"sha384-RLvgmog5EsZMMDnT3uJo6ScffPHTtMbhtV8pcT8kP5UJzlVRU1SP9Hccelk3zYZc\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-KwxQKNj2D0XKEW5O/Y6haRH39PE/xry8SAoLbpbCMraqlX7kUP6KHOnrlrtvuJLR\";s:14:\"css/brands.css\";s:71:\"sha384-cyAsyPMdnj21FGg6BEGfZdZ99a/opKBeFa8z5VoHPsPj+tLRYSxkRlPWnGkCJGyA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HE+OCjOJOPZavEcVffA6E24sIfY2RwV4JRieXa/3N5iCY8vgnTwZemElENQ8ak/K\";s:13:\"css/light.css\";s:71:\"sha384-k/d3hya1Xwx/V3yLAr7/6ibFaFIaN+xeY1eIv42A1Bn2HgfB+/YjLscji1sHLOkb\";s:15:\"css/regular.css\";s:71:\"sha384-D4yOV+i5oKU6w8CiadBDVtSim/UXmlmQfrIdRsuKT3nYhiF/Tb6YLQtyF9l0vqQF\";s:13:\"css/solid.css\";s:71:\"sha384-WjYgBJXUWNFTzFd4wNJuzUZx28GSgjzXrPO4LJrng96HFrI/nLrG1R5NET65v1yR\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-S/uB02cfkgX8kd+j6f3gmw/PPTg8xSiE/w6d8dE852PzHXkGBYLrqpWFse9hInR2\";s:9:\"js/all.js\";s:71:\"sha384-+1nLPoB0gaUktsZJP+ycZectl3GX7wP8Xf2PE/JHrb7X1u7Emm+v7wJMbAcPr8Ge\";s:12:\"js/brands.js\";s:71:\"sha384-OwdVp9K/baqiXthTvRnYzMcsTaqwG19SfDkTRc/GBIhK9eYlWVVBEvLlueA0STAP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-TxXqLyCP6HYGVtr9V1M1rQE7IMbBEZoDdOX+MFeYNbWNwopWKVQM8NyqtU2x+5t2\";s:11:\"js/light.js\";s:71:\"sha384-rv/n2A+UxOzR1qs4wrcOtJ7Ai5Hcn3QQ8tvEkOo5lCvqCD3xwpeO3KZP18JpSXr3\";s:13:\"js/regular.js\";s:71:\"sha384-QNGmoJVI8f07j7N4+DSn4Cdob1PTBJOR6jRGwUwqSPyL2HmvWaBPXuSXOcStGo9D\";s:11:\"js/solid.js\";s:71:\"sha384-m3J/Wb6KcNkFJIpCugSSJITG80sKhEA+16UCFdq1LnpMTOCXwwpeyrE1FmyqoArv\";s:14:\"js/v4-shims.js\";s:71:\"sha384-H+U1wWQdWbEtuQPJ4ZpMl8yWydI6xc/306L/NZkpGY8BGpeSpu39V20x03S3xcMw\";}}}s:6:\"5.0.12\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-G0fIWCsCzJIMAVNQPfjH08cyYaUtMwjJwqiRKxxE/rx96Uroj1BtIQ6MLJuheaO9\";s:14:\"css/brands.css\";s:71:\"sha384-Pln/erVatVEIIVh7sfyudOXs5oajCSHg7l5e2Me02e3TklmDuKEhQ8resTIwyI+w\";s:19:\"css/fontawesome.css\";s:71:\"sha384-rnr8fdrJ6oj4zli02To2U/e6t1qG8dvJ8yNZZPsKHcU7wFK3MGilejY5R/cUc5kf\";s:15:\"css/regular.css\";s:71:\"sha384-RGDxJbFQcd3/Rei8rYb+3xO3YREd0abxm8WfLkYj7j4HHo5ZVuNUGVx8H8GbpFTQ\";s:13:\"css/solid.css\";s:71:\"sha384-VxweGom9fDoUf7YfLTHgO0r70LVNHP5+Oi8dcR4hbEjS8UnpRtrwTx7LpHq/MWLI\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-N44Xrku5FaDiZLZ8lncIZLh+x9xiqk1r0NTlUJQ5xanSpdORyQHP4Zp2WQJ9GlpJ\";s:9:\"js/all.js\";s:71:\"sha384-Voup2lBiiyZYkRto2XWqbzxHXwzcm4A5RfdfG6466bu5LqjwwrjXCMBQBLMWh7qR\";s:12:\"js/brands.js\";s:71:\"sha384-BPIhZF7kZGuZzBS4SP/oIqzpxWuOUtsPLUTVGpGw+EtB1wKt1hv63jb2OCroS3EX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-6AOxTjzzZLvbTJayrLOYweuPckqh0rrB4Sj+Js8Vzgr85/qm2e0DRqi+rBzyK52J\";s:13:\"js/regular.js\";s:71:\"sha384-6XNKyHeL6pEPXURVNSKQ0lUP80a5FHqN0oFqSSS8Qviyy2u0KmCMJlQ5iLiAAPBg\";s:11:\"js/solid.js\";s:71:\"sha384-652/z7yNdGONCCBu0u5h5uF9voJhBdgruAuIDVheEaQ7O/ZC9wyyV+yZsYb32Wy7\";s:14:\"js/v4-shims.js\";s:71:\"sha384-STc8Gazx86A+NmeBWQTqa5Ob1wGSRQZevexYiUkKdiqZhi5LSZ28XYAvgptHK5HH\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-HX5QvHXoIsrUAY0tE/wG8+Wt1MwvaY28d9Zciqcj6Ob7Tw99tFPo4YUXcZw9l930\";s:14:\"css/brands.css\";s:71:\"sha384-M4owBK0KiG0Vz+G5z/8v8tBb1+w9ts66Z6xKkZEPgBwzISkrcNra4GxZcvJPyaGB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ZDxYpspDwfEsC0ZJDb74i/Rqjb1CnX3a69Dz9vXv4PvvlTEkgMI02TATTRNJoZ06\";s:13:\"css/light.css\";s:71:\"sha384-PWGGmWk9+xVydf1Gzso0ouaikBBKLu4nCY52q+tBUMq5iXmRhpgTuDkjbtxZ1rXT\";s:15:\"css/regular.css\";s:71:\"sha384-tYZB+BP2inzRg01pQhSlW4Tloc0ULXYGiBaf5kSB5Tb3+l84bJy+PKerqziKz3iv\";s:13:\"css/solid.css\";s:71:\"sha384-KY40QRrgoQAM9BPN+gm7JoK30M/P6QqKRCbXUS3uWbPfycyiVeEsPkGNMhcNL3DU\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ubRAMbpAKC+ULwg5mkUQLFReIXq1yeiKIcfV7cYp+rEaeINfEglYX6JOte80PCDk\";s:9:\"js/all.js\";s:71:\"sha384-quzri7saio48xMf3ED3HiI5YaItt68Q+0J3qc9EIfk1jk3QqCJhS24l6CZpUGfEe\";s:12:\"js/brands.js\";s:71:\"sha384-QlvHmHtevrYI4s/vdiK6chTDouw2pRA5av6ZLVtENubkoCgSZz4ZaXVvplQ1FRPs\";s:17:\"js/fontawesome.js\";s:71:\"sha384-CUrLKzrygRugRUPtEJ1u4nV4Ec6GnuDMRDGaxfoFXLI+sraWS6rqGg2Sjfs6BTet\";s:11:\"js/light.js\";s:71:\"sha384-z7YlG414oqy0TO7qY/nGfC8zd1LL8JAX3iNQ3iLybUIziHzaMYqBwUvhizEwV0Fd\";s:13:\"js/regular.js\";s:71:\"sha384-p/qo0lifpToZ0ubNiv1WFzlmYJU+BOenvU+evARCvCqALvbpZuqmZQ207vmYD6QL\";s:11:\"js/solid.js\";s:71:\"sha384-y//1Knkpeyl2S568g2ECqUA4n3MKf+kpj1/sfjUQbR1WtBPONceBHrQVMiAqfjLH\";s:14:\"js/v4-shims.js\";s:71:\"sha384-6+8zJP76v3EziONR2vMd32iSU3qbdicAE8KNp+NWniM6mBmvN80NlY+sbvCO+w7M\";}}}s:6:\"5.0.13\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:12:{s:11:\"css/all.css\";s:71:\"sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp\";s:14:\"css/brands.css\";s:71:\"sha384-VGCZwiSnlHXYDojsRqeMn3IVvdzTx5JEuHgqZ3bYLCLUBV8rvihHApoA1Aso2TZA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-GVa9GOgVQgOk+TNYXu7S/InPTfSDTtBalSgkgqQ7sCik56N9ztlkoTr2f/T44oKV\";s:15:\"css/regular.css\";s:71:\"sha384-EWu6DiBz01XlR6XGsVuabDMbDN6RT8cwNoY+3tIH+6pUCfaNldJYJQfQlbEIWLyA\";s:13:\"css/solid.css\";s:71:\"sha384-Rw5qeepMFvJVEZdSo1nDQD5B6wX0m7c5Z/pLNvjkB14W6Yki1hKbSEQaX9ffUbWe\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-LAtyQAMHxrIJzktG06ww5mJ0KQ+uCqQIJFjwj+ceCjUlZ2jkLwJZt1nBGw4KaFEZ\";s:9:\"js/all.js\";s:71:\"sha384-xymdQtn1n3lH2wcu0qhcdaOpQwyoarkgLVxC/wZ5q7h9gHtxICrpcaSUfygqZGOe\";s:12:\"js/brands.js\";s:71:\"sha384-G/XjSSGjG98ANkPn82CYar6ZFqo7iCeZwVZIbNWhAmvCF2l+9b5S21K4udM7TGNu\";s:17:\"js/fontawesome.js\";s:71:\"sha384-6OIrr52G08NpOFSZdxxz1xdNSndlD4vdcf/q2myIUVO0VsqaGHJsB0RaBE01VTOY\";s:13:\"js/regular.js\";s:71:\"sha384-IJ3h7bJ6KqiB70L7/+fc44fl+nKF5eOFkgM9l/zZii9xs7W2aJrwIlyHZiowN+Du\";s:11:\"js/solid.js\";s:71:\"sha384-tzzSw1/Vo+0N5UhStP3bvwWPq+uvzCMfrN1fEFe+xBmv1C/AtVX5K0uZtmcHitFZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-qqI1UsWtMEdkxgOhFCatSq+JwGYOQW+RSazfcjlyZFNGjfwT/T1iJ26+mp70qvXx\";}s:3:\"pro\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-oi8o31xSQq8S0RpBcb4FaLB8LJi9AT8oIdmS1QldR8Ui7KUQjNAnDlJjp55Ba8FG\";s:14:\"css/brands.css\";s:71:\"sha384-t3MQUMU0g3tY/0O/50ja6YVaEFYwPpOiPbrHk9p5DmYtkHJU2U1/ujNhYruOJwcj\";s:19:\"css/fontawesome.css\";s:71:\"sha384-LDuQaX4rOgqi4rbWCyWj3XVBlgDzuxGy/E6vWN6U7c25/eSJIwyKhy9WgZCHQWXz\";s:13:\"css/light.css\";s:71:\"sha384-d8NbeymhHpk+ydwT2rk4GxrRuC9pDL/3A6EIedSEYb+LE+KQ5QKgIWTjYwHj/NBs\";s:15:\"css/regular.css\";s:71:\"sha384-HLkkol/uuRVQDnHaAwidOxb1uCbd78FoGV/teF8vONYKRP9oPQcBZKFdi3LYDy/C\";s:13:\"css/solid.css\";s:71:\"sha384-drdlAcijFWubhOfj9OS/gy2Gs34hVhVT90FgJLzrldrLI+7E7lwBxmanEEhKTRTS\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-8YpCivPy+AkMdZ0uAvEP04Gs77AN/6mS5AmZqkCwniP51zSG8rCMaH06OYuC4iXd\";s:9:\"js/all.js\";s:71:\"sha384-d84LGg2pm9KhR4mCAs3N29GQ4OYNy+K+FBHX8WhimHpPm86c839++MDABegrZ3gn\";s:12:\"js/brands.js\";s:71:\"sha384-44Hl7UlQr9JXHFcZOp9qWHk2H1lrsAN/cG3GNgB2JqbciecuJ2/B9sjelOMttzBM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-BUkEHIKZJ0ussRY3zYfFL7R0LpqWmucr9K38zMTJWdGQywTjmzbejVSNIHuNEhug\";s:11:\"js/light.js\";s:71:\"sha384-+iGqamqASU/OvBgGwlIHH6HSEgiluzJvTqcjJy8IN9QG9aUfd0z0pKpTlH7TpU7X\";s:13:\"js/regular.js\";s:71:\"sha384-1bAvs6o5Yb7MMzvTI3oq2qkreCQFDXb6KISLBhrHR+3sJ/mm7ZWfnQVRwScbPEmd\";s:11:\"js/solid.js\";s:71:\"sha384-CucLC75yxFXtBjA/DCHWMS14abAUhf5HmFRdHyKURqqLqi3OrLsyhCyqp83qjiOR\";s:14:\"js/v4-shims.js\";s:71:\"sha384-LDfu/SrM7ecLU6uUcXDDIg59Va/6VIXvEDzOZEiBJCh148mMGba7k3BUFp1fo79X\";}}}s:5:\"5.1.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-lKuwvrZot6UHsBSfcMvOkWwlCMgc0TaWr+30HWe3a4ltaBwTZhyTEggF5tJv8tbt\";s:14:\"css/brands.css\";s:71:\"sha384-7xAnn7Zm3QC1jFjVc1A6v/toepoG3JXboQYzbM0jrPzou9OFXm/fY6Z/XiIebl/k\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ozJwkrqb90Oa3ZNb+yKFW2lToAWYdTiF1vt8JiH5ptTGHTGcN7qdoR1F95e0kYyG\";s:15:\"css/regular.css\";s:71:\"sha384-avJt9MoJH2rB4PKRsJRHZv7yiFZn8LrnXuzvmZoD3fh1aL6aM6s0BBcnCvBe6XSD\";s:13:\"css/solid.css\";s:71:\"sha384-TbilV5Lbhlwdyc4RuIV/JhD8NR+BfMrvz4BL5QFa2we1hQu6wvREr3v6XSRfCTRp\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-5aLiCANDiVeIiNfzcW+kXWzWdC6riDYfxLS6ifvejaqYOiEufCh0zVLMkW4nr8iC\";s:16:\"css/v4-shims.css\";s:71:\"sha384-epK5t6ciulYxBQbRDZyYJFVuWey/zPlkBIbv6UujFdGiIwQCeWOyv5PVp2UQXbr2\";s:9:\"js/all.js\";s:71:\"sha384-3LK/3kTpDE/Pkp8gTNp2gR/2gOiwQ6QaO7Td0zV76UFJVhqLl4Vl3KL1We6q6wR9\";s:12:\"js/brands.js\";s:71:\"sha384-ZqDZAkGUHrXxm3bvcTCmQWz4lt7QGLxzlqauKOyLwg8U0wYcYPDIIVTbZZXjbfsM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-juNb2Ils/YfoXkciRFz//Bi34FN+KKL2AN4R/COdBOMD9/sV/UsxI6++NqifNitM\";s:13:\"js/regular.js\";s:71:\"sha384-Y+AVd32cSTAMpwehrH10RiRmA28kvu879VbHTG58mUFhd+Uxl/bkAXsgcIesWn3a\";s:11:\"js/solid.js\";s:71:\"sha384-Z7p3uC4xXkxbK7/4keZjny0hTCWPXWfXl/mJ36+pW7ffAGnXzO7P+iCZ0mZv5Zt0\";s:14:\"js/v4-shims.js\";s:71:\"sha384-3qT9zZfeo1gcy2NmVv5dAhtOYkj91cMLXRkasOiRB/v+EU3G+LZUyk5uqZQdIPsV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-87DrmpqHRiY8hPLIr7ByqhPIywuSsjuQAfMXAE0sMUpY3BM7nXjf+mLIUSvhDArs\";s:14:\"css/brands.css\";s:71:\"sha384-C1HxUFJBptCeaMsYCbPUw8fdL2Cblu3mJZilxrfujE+7QLr8BfuzBl5rPLNM61F6\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PnWzJku7hTqk2JREATthkLpYeVVGcBbXG5yEzk7hD2HIr/VxffIDfNSR7p7u4HUy\";s:13:\"css/light.css\";s:71:\"sha384-ANTAgj8tbw0vj4HgQ4HsB886G2pH15LXbruHPCBcUcaPAtn66UMxh8HQcb1cH141\";s:15:\"css/regular.css\";s:71:\"sha384-6kuJOVhnZHzJdVIZJcWiMZVi/JwinbqLbVxIbR73nNqXnYJDQ5TGtf+3XyASO4Am\";s:13:\"css/solid.css\";s:71:\"sha384-rvfDcG9KDoxdTesRF/nZ/sj8CdQU+hy6JbNMwxUTqpoI2LaPK8ASQk6E4bgabrox\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-/h6SKuA/ysT91EgYEGm9B6Z6zlaxuvKeW/JB7FWdGwCFalafxmGzJE2a63hS1BLm\";s:16:\"css/v4-shims.css\";s:71:\"sha384-2RBBYH6GaI11IJzJ6V1eL7kXXON+epoQIt+HqpzQdBrtyT7gNwKPDxo2roxUbtW9\";s:9:\"js/all.js\";s:71:\"sha384-E5SpgaZcbSJx0Iabb3Jr2AfTRiFnrdOw1mhO19DzzrT9L+wCpDyHUG2q07aQdO6E\";s:12:\"js/brands.js\";s:71:\"sha384-QPbiRUBnwCr8JYNjjm7CB0QP9h4MLvWUZhsChFX6dLzRkY22/nAxVYqa5nUTd6PL\";s:17:\"js/fontawesome.js\";s:71:\"sha384-ckjcH5WkBMAwWPjTJiy7K2LaLp37yyCVKAs3DKjhPdo0lRCDIScolBzRsuaSu+bQ\";s:11:\"js/light.js\";s:71:\"sha384-77i21WTcIcnSPKxwR794RLUQitpNqm6K3Fxsjx8hgoc3ZZbPJu5orgvU/7xS3EFq\";s:13:\"js/regular.js\";s:71:\"sha384-S21AhcbZ5SXPXH+MH7JuToqmKYXviahLaD1s9yApRbu1JDiMjPBGQIw/3PCHKUio\";s:11:\"js/solid.js\";s:71:\"sha384-q6QALO/4RSDjqnloeDcGnkB0JdK3MykIi6dUW5YD66JHE3JFf8rwtV5AQdYHdE0X\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9gfBAY6DS3wT0yuvYN1aaA1Q9R0fYQHliQWLChuYDWJJ0wQJpoNZrzlcqd4+qqny\";}}}s:5:\"5.1.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-O8whS3fhG2OnA5Kas0Y9l3cfpmYjapjI0E4theH4iuMD+pLhbf6JI0jIMfYcK3yZ\";s:14:\"css/brands.css\";s:71:\"sha384-SYNjKRRe+vDW0KSn/LrkhG++hqCLJg9ev1jIh8CHKuEA132pgAz+WofmKAhPpTR7\";s:19:\"css/fontawesome.css\";s:71:\"sha384-0b7ERybvrT5RZyD80ojw6KNKz6nIAlgOKXIcJ0CV7A6Iia8yt2y1bBfLBOwoc9fQ\";s:15:\"css/regular.css\";s:71:\"sha384-QNorH84/Id/CMkUkiFb5yTU3E/qqapnCVt6k5xh1PFIJ9hJ8VfovwwH/eMLQTjGS\";s:13:\"css/solid.css\";s:71:\"sha384-S2gVFTIn1tJ/Plf+40+RRAxBCiBU5oAMFUJxTXT3vOlxtXm7MGjVj62mDpbujs4C\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-EH3TEAKYd7R0QbCS4OFuYoEpaXITVg5c/gdZ/beEaAbRjMGVuVLLFjiIKOneCzGZ\";s:16:\"css/v4-shims.css\";s:71:\"sha384-LCsPWAjCFLDeFHB5Y0SBIOqgC5othK8pIZiJAdbJDiN10B2HXEm1mFNHtED8cViz\";s:9:\"js/all.js\";s:71:\"sha384-BtvRZcyfv4r0x/phJt9Y9HhnN5ur1Z+kZbKVgzVBAlQZX4jvAuImlIz+bG7TS00a\";s:12:\"js/brands.js\";s:71:\"sha384-0inRy4HkP0hJ038ZyfQ4vLl+F4POKbqnaUB6ewmU4dWP0ki8Q27A0VFiVRIpscvL\";s:17:\"js/fontawesome.js\";s:71:\"sha384-NY6PHjYLP2f+gL3uaVfqUZImmw71ArL9+Roi9o+I4+RBqArA2CfW1sJ1wkABFfPe\";s:13:\"js/regular.js\";s:71:\"sha384-sAzYCvbTTKFOxT4VHu+ZjHRMXjvfjT6TAqOng28g4jba88Peg5+hkoVIqQKGjmj1\";s:11:\"js/solid.js\";s:71:\"sha384-GXi56ipjsBwAe6v5X4xSrVNXGOmpdJYZEEh/0/GqJ3JTHsfDsF8v0YQvZCJYAiGu\";s:14:\"js/v4-shims.js\";s:71:\"sha384-T69Lzd4bE7W8/vVrxvfsx45/AAKf6QmKEg5zSl0v9aZwo/pTKseq81mxdpARTQpx\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-xyMU7RufUdPGVOZRrc2z2nRWVWBONzqa0NFctWglHmt5q5ukL22+lvHAqhqsIm3h\";s:14:\"css/brands.css\";s:71:\"sha384-E5dVkWQIVhVPtBz/KK2TS7EM9l1+5XiWFPX7l3+5ayHPwDguGsHqof3GQbk55AS3\";s:19:\"css/fontawesome.css\";s:71:\"sha384-bHoj6f1b1CQ6zapOREeYBO/JnDjeV1fLuKn3KHnbqAAnkLva11KY3m8YyKPVXYLF\";s:13:\"css/light.css\";s:71:\"sha384-EGKQAl6ZrGi/zGxZ4ykVhc/A3tFVeBiLnneETILtcxQnZpo7ejmb4BkNa3zSgo4K\";s:15:\"css/regular.css\";s:71:\"sha384-AKIrAHbICIQF+NEqtykrcdzMjExDiKLa9hOyUVsr4PlHtktH7xaD10vO98UnPjuE\";s:13:\"css/solid.css\";s:71:\"sha384-Ux3tEr1RmnxCht2XbPkWWBuotwMVXKOe0PkWN/nmiD5CSV6Tyjl+Kr0J0iX1yd0q\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-++BmJ9x4V05AhCNnLr/RjPTY4BAFuhZsESUqH5hiwZspBvy7F+DRGvSH8tGHw9P/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TUicmScQcYANFcc4OQKEX6V1Zek9o9t+dwW/2tZoXmSigBk9JqfHxZZFlSo+0oRl\";s:9:\"js/all.js\";s:71:\"sha384-cHcg4nvWPIGArJhEgL2F5e09Cn1GyPQpNYKbPatFCpDefCbezZjPA3PhLozKTZnv\";s:12:\"js/brands.js\";s:71:\"sha384-KCMfKsP/3VgeibBQRMu4bT+9041Hi2v9PIz9FLOPJBEvxCBklc4o7tRwwQu4FWsT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EWJRWU7LQt+ri8YtDjTr8adATyP7y8DwlpE8zruoUC4nHNjtWZMU+iPYK+tFaV3U\";s:11:\"js/light.js\";s:71:\"sha384-0rp6k6cJIuLV1ORowDSSKr4VbEqb664PQUWdBvhJyt6IfkshVb0r6UlOkX6yVdaI\";s:13:\"js/regular.js\";s:71:\"sha384-Mw6yr+W+X+ckaAUbsPUb2BcU3Af9aSjmPMIlMr2iplN0VQIpscDWy/VwY5w0sz9w\";s:11:\"js/solid.js\";s:71:\"sha384-PyvJtlnGBA/R+hfVbHbnzfeT8G/iTORqPhR5WKGTQXlfmLe5bV+d64NECHG4sIMa\";s:14:\"js/v4-shims.js\";s:71:\"sha384-rJQjFeDWQReL3KmIeV81jB594CgKx/MmXyAgiuu88Jo253P+PSMgWzivZQtR6N6J\";}}}s:5:\"5.2.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-hWVjflwFxL6sNzntih27bfxkr27PmbbK/iSvJ+a4+0owXq79v+lsFkW54bOGbiDQ\";s:14:\"css/brands.css\";s:71:\"sha384-nT8r1Kzllf71iZl81CdFzObMsaLOhqBU1JD2+XoAALbdtWaXDOlWOZTR4v1ktjPE\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HbmWTHay9psM8qyzEKPc8odH4DsOuzdejtnr+OFtDmOcIVnhgReQ4GZBH7uwcjf6\";s:15:\"css/regular.css\";s:71:\"sha384-zkhEzh7td0PG30vxQk1D9liRKeizzot4eqkJ8gB3/I+mZ1rjgQk+BSt2F6rT2c+I\";s:13:\"css/solid.css\";s:71:\"sha384-wnAC7ln+XN0UKdcPvJvtqIH3jOjs9pnKnq9qX68ImXvOGz2JuFoEiCjT8jyZQX2z\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-jKeGgxY7zPT61fNXg6OMRDu8vsxOPRLMlgAIUHo1KVag4lyu5B03KsDLYOTMM4ld\";s:16:\"css/v4-shims.css\";s:71:\"sha384-W14o25dsDf2S/y9FS68rJKUyCoBGkLwr8owWTSTTHj4LOoHdrgSxw1cmNQMULiRb\";s:9:\"js/all.js\";s:71:\"sha384-4oV5EgaV02iISL2ban6c/RmotsABqE4yZxZLcYMAdG7FAPsyHYAPpywE9PJo+Khy\";s:12:\"js/brands.js\";s:71:\"sha384-4BRtleJgTYsMKIVuV1Z7lNE29r4MxwKR7u88TWG2GaXsmSljIykt/YDbmKndKGID\";s:17:\"js/fontawesome.js\";s:71:\"sha384-QcnrgQuRmocjIBY6ByWMmDvUg3HO4MSdVjY7ynJwZfvTDhVPPQOUI9TRzc6/7ZO1\";s:13:\"js/regular.js\";s:71:\"sha384-YdSTwqfKxyP06Jj3UzTeumv8M+Pme60+KND4oF+5r5VeUCvdkw7NhSzFYWbe00ba\";s:11:\"js/solid.js\";s:71:\"sha384-YmNA3b9AQuWW8KZguYfqJa/YhKNTwGVD5pQc1cN0ZAVRudFFtR17HR7rooNcVXe4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-rn4uxZDX7xwNq5bkqSbpSQ3s4tK9evZrXAO1Gv9WTZK4p1+NFsJvOQmkos19ebn2\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-TXfwrfuHVznxCssTxWoPZjhcss/hp38gEOH8UPZG/JcXonvBQ6SlsIF49wUzsGno\";s:14:\"css/brands.css\";s:71:\"sha384-Ei2oxwH0wpwmp7KPdhYnajC5fWDdMENOjDw9OfzWvcFcOGn0Egy+L5AAculaqBbD\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4eP+1rYQmuI3hxrmyE+GT/EIiNbF4R85ciN3jMpmIh+bU5Hz2IU7AdcVe+JS+AJz\";s:13:\"css/light.css\";s:71:\"sha384-pcDR01P1wNxsYZiEYdROCAYhU2u8VHOctLrYRonRFtkf/TGEQFWt0rqFbPGWlyn4\";s:15:\"css/regular.css\";s:71:\"sha384-g3XsWx0Sqi7JIjLKVnwUxEvqrxTMQPIf3PN+vTdWY2AhduP/rnj0rw89v0nbD4Ro\";s:13:\"css/solid.css\";s:71:\"sha384-B/E/KxBX31kY/5sew+X4c8e6ErosbqOOsA3t4k6VVmx8Hrz//v0tEUtXmUVx9X6Q\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-O6mvz45yC1vfdu/EgUxAoSGrP+sFtepMtj7eOQIW1G3WT9Sj5djActZC0hd/F42D\";s:16:\"css/v4-shims.css\";s:71:\"sha384-2QRS8Mv2zxkE2FAZ5/vfIJ7i0j+oF15LolHAhqFp9Tm4fQ2FEOzgPj4w/mWOTdnC\";s:9:\"js/all.js\";s:71:\"sha384-yBZ34R8uZDBb7pIwm+whKmsCiRDZXCW1vPPn/3Gz0xm4E95frfRNrOmAUfGbSGqN\";s:12:\"js/brands.js\";s:71:\"sha384-eg9wHuvEPj6+GlGomBRaMHLF0QfCnjdASWDKd84DMeM9phhyDaPFou/nHJBt0bz+\";s:17:\"js/fontawesome.js\";s:71:\"sha384-FQUuiJxt9F0hPc9IP3M5ndmqK53iBCGcy4ZSx8QirhYOIs8l7x+e1/zdswyZEigi\";s:11:\"js/light.js\";s:71:\"sha384-glAz6mCeiwAe/kHHHG/OvhrjA4+AH55ZfH8fwYp48YCY61POwUmOrH/oYOaF2Ujy\";s:13:\"js/regular.js\";s:71:\"sha384-8hKZY21U4J3r9N0GFl+24YnDkbRhs8y/nXT6BaZ+sOJDNmz+1DhFawE9UYL37XzB\";s:11:\"js/solid.js\";s:71:\"sha384-1j3ph9Rf+Aaz6rrizz6cdFxU9ZbUyvkbiwQ5+T/BY4I5mk37vUpTA8S9ZZOlfdWu\";s:14:\"js/v4-shims.js\";s:71:\"sha384-aoMjEUBUPf5GpXx1WJUeTZ/gBmGqQB1u8uUc2J5LW2xnQtJKkGulESZ+rkoj182s\";}}}s:5:\"5.3.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU\";s:14:\"css/brands.css\";s:71:\"sha384-rf1bqOAj3+pw6NqYrtaE1/4Se2NBwkIfeYbsFdtiR6TQz0acWiwJbv1IM/Nt/ite\";s:19:\"css/fontawesome.css\";s:71:\"sha384-1rquJLNOM3ijoueaaeS5m+McXPJCGdr5HcA03/VHXxcp2kX2sUrQDmFc3jR5i/C7\";s:15:\"css/regular.css\";s:71:\"sha384-ZlNfXjxAqKFWCwMwQFGhmMh3i89dWDnaFU2/VZg9CvsMGA7hXHQsPIqS+JIAmgEq\";s:13:\"css/solid.css\";s:71:\"sha384-VGP9aw4WtGH/uPAOseYxZ+Vz/vaTb1ehm1bwx92Fm8dTrE+3boLfF1SpAtB1z7HW\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-4K9ulTwOtsXr+7hczR7fImKfUZY5THwqvfxwPx1VUCEOt4qssi2Vm+kHY7NJQPoy\";s:16:\"css/v4-shims.css\";s:71:\"sha384-lmquXrF9qn7mMo6iRQ662vN44vTTVUBpcdtDFWPxD9uFPqC/aMn6pcQrTTupiv1A\";s:9:\"js/all.js\";s:71:\"sha384-kW+oWsYx3YpxvjtZjFXqazFpA7UP/MbiY4jvs+RWZo2+N94PFZ36T6TFkc9O3qoB\";s:12:\"js/brands.js\";s:71:\"sha384-2vdvXGQdnt+ze3ylY5ESeZ9TOxwxlOsldUzQBwtjvRpen1FwDT767SqyVbYrltjb\";s:17:\"js/fontawesome.js\";s:71:\"sha384-2OfHGv4zQZxcNK+oL8TR9pA+ADXtUODqGpIRy1zOgioC4X3+2vbOAp5Qv7uHM4Z8\";s:13:\"js/regular.js\";s:71:\"sha384-sqmLTIuB+bQgkyOcdJ/hAvXl51Z7qqdK/lcH/rt6sdvDKFincQWI+fVgcDZM6NMz\";s:11:\"js/solid.js\";s:71:\"sha384-GJiigN/ef2B3HMj0haY+eMmG4EIIrhWgGJ2Rv0IaWnNdWdbWPr1sRLkGz7xfjOFw\";s:14:\"js/v4-shims.js\";s:71:\"sha384-DtdEw3/pBQuSag11V3is/UZMjGkGMLDRBgk1UVAOvH6cYoqKjBmCEhePm13skjRV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-9ralMzdK1QYsk4yBY680hmsb4/hJ98xK3w0TIaJ3ll4POWpWUYaA2bRjGGujGT8w\";s:14:\"css/brands.css\";s:71:\"sha384-AOiME8p6xSUbTO/93cbYmpOihKrqxrLjvkT2lOpIov+udKmjXXXFLfpKeqwTjNTC\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Yz2UJoJEWBkb0TBzOd2kozX5/G4+z5WzWMMZz1Np2vwnFjF5FypnmBUBPH2gUa1F\";s:13:\"css/light.css\";s:71:\"sha384-9QuzjQIM/Un6pY9bKVJGLW8PauASO8Mf9y3QcsHhfZSXNyXGoXt/POh3VLeiv4mw\";s:15:\"css/regular.css\";s:71:\"sha384-pofSFWh/aTwxUvfNhg+LRpOXIFViguTD++4CNlmwgXOrQZj1EOJewBT+DmUVeyJN\";s:13:\"css/solid.css\";s:71:\"sha384-wJu5pIbEyJzi+kRgVKVQkPNKI104yNC+IAyK7XXEVGgPGe+LTEERIkpSZbc/wrOx\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Hmg9TonawJaGH8ayFFnEBwvkx61BYLPAOV7b/YDGQEVIs1jh9pWQigAavMuD+Vc/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1YFoQoO5Em1oxLErpWpJuswiqPFVHl8HLDUaLjJGJH8+Nra/Y1D6uOZkEgfH5OZf\";s:9:\"js/all.js\";s:71:\"sha384-eAVkiER0fL/ySiqS7dXu8TLpoR8d9KRzIYtG0Tz7pi24qgQIIupp0fn2XA1H90fP\";s:12:\"js/brands.js\";s:71:\"sha384-am5AyalpQCEfbKe6FYiGZc2vX080nrcueZmrbkljxLdQDJ5q5Vu9QDROD/QefEp1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-u3o36ga3mMU6/lK/zdiER4h7pPtAK7wBuN0DrZPH22v01RZL8bKZkULIjxcx2/X/\";s:11:\"js/light.js\";s:71:\"sha384-2R0W5LA7dXp3ze/WhvjXlUcDaHRhtGlKYxN9QMhGDdjmj2EI1bub5ysSwofJwGfI\";s:13:\"js/regular.js\";s:71:\"sha384-EbI+OvKb7noKOfu8MSi/vCbi0KWlM61MjHDmRk4/vwJkPsMIRcJggYLDGWv7VeYY\";s:11:\"js/solid.js\";s:71:\"sha384-U4vTrZsQ4ooEtzL162EZfTtCiJNTXOwGDBzV91//DI5L/h48ibzHBiHJmPLpx2hO\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8e1r0+5VTqCqkg/9vG+cnipytzBkEh9fpESgVwBZAizMkWRfiaTkdhgdnhLGwuPd\";}}}s:5:\"5.4.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz\";s:14:\"css/brands.css\";s:71:\"sha384-Px1uYmw7+bCkOsNAiAV5nxGKJ0Ixn5nChyW8lCK1Li1ic9nbO5pC/iXaq27X5ENt\";s:19:\"css/fontawesome.css\";s:71:\"sha384-BzCy2fixOYd0HObpx3GMefNqdbA7Qjcc91RgYeDjrHTIEXqiF00jKvgQG0+zY/7I\";s:15:\"css/regular.css\";s:71:\"sha384-4e3mPOi7K1/4SAx8aMeZqaZ1Pm4l73ZnRRquHFWzPh2Pa4PMAgZm8/WNh6ydcygU\";s:13:\"css/solid.css\";s:71:\"sha384-osqezT+30O6N/vsMqwW8Ch6wKlMofqueuia2H7fePy42uC05rm1G+BUPSd2iBSJL\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-2MWWLQq91kFwloAny7gkgoeV33bD/cE3A9ZbB2rCN/YAAR/VEHVoDq6vRJJYTaxM\";s:16:\"css/v4-shims.css\";s:71:\"sha384-YIDcSvDDaIskj/WDlWwjrNdK194YAGWc1CScdo2tXl3IQVS1zS07xQaoAFlXCf1P\";s:9:\"js/all.js\";s:71:\"sha384-L469/ELG4Bg9sDQbl0hvjMq8pOcqFgkSpwhwnslzvVVGpDjYJ6wJJyYjvG3u8XW7\";s:12:\"js/brands.js\";s:71:\"sha384-lc/yFuYW3B0EW9B2QSpod2KeBxq6/ZizGwAW6mRLUe3kKUVlSBfDIVZKwKIz/DBg\";s:17:\"js/fontawesome.js\";s:71:\"sha384-ISRc+776vRkDOTSbmnyoZFmwHy7hw2UR3KJpb4YtcfOyqUqhLGou8j5YmYnvQQJ4\";s:13:\"js/regular.js\";s:71:\"sha384-SQqzt64aAzh3UJ9XghcA//GE8+NxAIRcuCrrekyDokXP6Bbt/FYAFlV6VSPrZKwH\";s:11:\"js/solid.js\";s:71:\"sha384-agDKwSYPuGlC0wD14lKXXwb94jlUkbkoSugquwmKRKWv/nDXe1kApDS/gqUlRQmZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-/s2EnwEz7C3ziRundAGzeOAoGYffu84oY4SOHjhI/2Wqk3Z0usUm9bjdduzhZ9+z\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-POYwD7xcktv3gUeZO5s/9nUbRJG/WOmV6jfEGikMJu77LGYO8Rfs2X7URG822aum\";s:14:\"css/brands.css\";s:71:\"sha384-rmUpvtaCngUop5CYz7WL1LnqkMweXskxP+1AXmkuMSbImsUuy82bUYS4A8Syd3Pf\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PPeKwWhk5XZBVVq089DuhGmjaEVB1r+jdmx6jZrqzlef8ojhZXG+E/D6SP7uO1dk\";s:13:\"css/light.css\";s:71:\"sha384-DZAoxBcs4G15aUXLX4vKbO53ye8L8AB/zg07HOVhIMVclhx8rdWye0AJSQl51ehV\";s:15:\"css/regular.css\";s:71:\"sha384-xKPOvJDwdb/n5w2kh6cxds98Ae2d5N63xkIydEdoYeA2bxIKUmmyU9lZ9j58mLYS\";s:13:\"css/solid.css\";s:71:\"sha384-oT4lQmwnKx98HRnFgaGvgCdjtKOjep9CjfMdAOPtJU8Vy6NY3X34GfqL0H43ydJn\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-j2EtHJUHBAZF9vkmX0TSA/QqYMf0Npp9P2leJGZFDbLHbcI62HH8w7FRcUMNf8Q2\";s:16:\"css/v4-shims.css\";s:71:\"sha384-aaXKvb/d7l2hTm3ZDWCy5v4ct5zXIslt+70K4xalZPLu3ifrkYcG61m4u+DIQGEk\";s:9:\"js/all.js\";s:71:\"sha384-0+tugznPwCEvPiypW+OwmFjAQvRKlgI0ZZZW3nofNlLMmbYXbmNvfX/9up9XQSRs\";s:12:\"js/brands.js\";s:71:\"sha384-ShBqjf9lFG58e2NmhnbVlhAOPCWdzkPbBmAEcQ37Liu3TwOYxIizS7J1P3rRLJHm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8vKKeD0uIV/HXM5ym3RGB4O7rZ43fCdpiXqP047w7sEE3igcK0Y1U9ApEArcRBDJ\";s:11:\"js/light.js\";s:71:\"sha384-jlaccvPpizUbHU/8pYAsDEwhhBae8MUcYqHHsKkjFcFsEp3Y6LrVXh0GA84aAkTg\";s:13:\"js/regular.js\";s:71:\"sha384-MB7Bz/7e8sBWnZgblSLUfFOOi+V1PIkRG/Ex1NMeu0CovaXCzHyCMwAwOF+FAo1s\";s:11:\"js/solid.js\";s:71:\"sha384-KlTWIsOnBg7LJobQmLsv5fQ1qbx73K+o8/xhoUDoIba13SxF4bT5W2WgV3d8mZIw\";s:14:\"js/v4-shims.js\";s:71:\"sha384-e+EZ4XUeGXVd0FDmP/mFu7FFe+qVX738ayOS2AErNIPSLz5oZ3OgVa9zEyCds3HP\";}}}s:5:\"5.4.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-/rXc/GQVaYpyDdyxK+ecHPVYJSN9bmVFBvjA/9eOB+pb3F2w2N6fc5qB9Ew5yIns\";s:14:\"css/brands.css\";s:71:\"sha384-BCEeiNUiLzxxoeYaIu7jJqq0aVVz2O2Ig4WbWEmRQ2Dx/AAxNV1wMDBXyyrxw1Zd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-HU5rcgG/yUrsDGWsVACclYdzdCcn5yU8V/3V84zSrPDHwZEdjykadlgI6RHrxGrJ\";s:15:\"css/regular.css\";s:71:\"sha384-OEIzojYBMrmz48aIjVQj7VG38613/sxpP58OW9h5zBYC7biGFlv9tyu5kWmaAYlF\";s:13:\"css/solid.css\";s:71:\"sha384-uKQOWcYZKOuKmpYpvT0xCFAs/wE157X5Ua3H5onoRAOCNkJAMX/6QF0iXGGQV9cP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+moUZLBX5mmeUnjaImkzlTo5cXyQWAvzbqQapNFd7+dGIaap0koo0rtfe8lHD38R\";s:16:\"css/v4-shims.css\";s:71:\"sha384-SlbnWxwEHTVYxDLrpIRrG2BpsTpWALbJ6Tx5Fq+XNHRBL7xI6xwhVpuUGrrbLBXe\";s:9:\"js/all.js\";s:71:\"sha384-wp96dIgDl5BLlOXb4VMinXPNiB32VYBSoXOoiARzSTXY+tsK8yDTYfvdTyqzdGGN\";s:12:\"js/brands.js\";s:71:\"sha384-i1RNpxOOEnRm63Ii3TuV0aM8bJ+6Pv6XHpRSJbN7QlIzZIsl7m36R0GhOTTGN3F9\";s:17:\"js/fontawesome.js\";s:71:\"sha384-n1qPouQQJ9VNZnZeNZWSDiclpIOJwZBS2bkD6rEX+DTmMXTKXBVCZw2cGbU/I17z\";s:13:\"js/regular.js\";s:71:\"sha384-Uj7q9rRb3eJNp0j1kXwOBgEWDGbAiJ7Dcuz4hLRQdtza6pawbo/Bmwgr58THzHyR\";s:11:\"js/solid.js\";s:71:\"sha384-OQNCj138epg9A13jaL9L/d5vMlK2jyPL4aOgi37KYt07aZARbv/eFGp/wnrCxkW5\";s:14:\"js/v4-shims.js\";s:71:\"sha384-fzYnAZZYxpOQTjc3Y1eP04DGdMLAy+PeiZ8+ICh4FDLkJR/NJiAgKgK2vEpGx3au\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-zhaLg9HKxTxDljOPXpWHGn91XMDH+sYAWRSgvzHes290/ISyrNicGrd6BInTnx3L\";s:14:\"css/brands.css\";s:71:\"sha384-RjTk1OTKX8K8S4QfwhFOfbNSbQxLFgN6jqDw05QuBDDEbc/x6xlPtkPSO4vA1TtI\";s:19:\"css/fontawesome.css\";s:71:\"sha384-XkH+Vmez3OoFo52K+SkBE61xZ7vKh9tF35gL9Yf8rD3RtKUqIQGoTJTsLdR5u8rt\";s:13:\"css/light.css\";s:71:\"sha384-n0uyPlhqrQyWPPzm6+B9xDeZKCD81RgGRsTO7PQt3McgMXSR9zjhGaD5cXHwk+D8\";s:15:\"css/regular.css\";s:71:\"sha384-+OdrK32QtByk1ipA7b4+uLddrcWs2bx3nn37Dl5h98PW1AYKIrRZKveBl6AcpgcD\";s:13:\"css/solid.css\";s:71:\"sha384-SYCdBxlsgGngJi9eiKt5Tk6UtOJs1Jq5eU3yZDZ+hOe0GKk/obXhHy50IYVVdJro\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3f24zIRoR/ma/cnROK52rTVZpgCXKQ92/89RDq7GO7/9IxIl3VQV/tF6ecGgvUs8\";s:16:\"css/v4-shims.css\";s:71:\"sha384-ah4vMGE5UgKcCIB90FZl8BOcusXAVTm070n1UuOrNQA9QwkgnhqASrop/Oblr6wY\";s:9:\"js/all.js\";s:71:\"sha384-+lZy0zDh4RS9ZG6+Od6x6irKqoBH4NSy0m7IW8UGbzGZ/rupt9Cd9NdEb5S7+V9w\";s:12:\"js/brands.js\";s:71:\"sha384-LVdS6BqWBV1V0OyGzWK0HrGN4uDZbpO6hja1oVh86MhthieoER2crgKS/KsaiN8E\";s:17:\"js/fontawesome.js\";s:71:\"sha384-zMrS036pMtJ0Ukzo5x2YiTrYDGDaoeO8Yd0IHhI/PaEnfrY/nMHqvKME8C7dHhUE\";s:11:\"js/light.js\";s:71:\"sha384-hOiC7FL4572/E3aEEeWM6dF3ch/qFz59R91pAJqjYEKHBXN5u7e2oAYAgeSGF1VB\";s:13:\"js/regular.js\";s:71:\"sha384-f1yYCENdJ+9NE5J2T8weglyMCtTqRJOeGP9qaLwO43aYY0PVeuAfmsGgTegByFW6\";s:11:\"js/solid.js\";s:71:\"sha384-XlRgTEYU6HJ02+ZCuXW2/CgjnpV2+8FuQPTJSJ/+ZCQS5ZXRfIS5FHDRhMvOL++d\";s:14:\"js/v4-shims.js\";s:71:\"sha384-6TX+vqRZyQq+vB25wCb101/vY510EN37QZgs5f1dfG1+QYuIoQGdFFV8sx8W36AL\";}}}s:5:\"5.5.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-B4dIYHKNBt8Bc12p+WXckhzcICo0wtJAoU8YZTY5qE0Id1GSseTk6S+L3BlXeVIU\";s:14:\"css/brands.css\";s:71:\"sha384-QT2Z8ljl3UupqMtQNmPyhSPO/d5qbrzWmFxJqmY7tqoTuT2YrQLEqzvVOP2cT5XW\";s:19:\"css/fontawesome.css\";s:71:\"sha384-u5J7JghGz0qUrmEsWzBQkfvc8nK3fUT7DCaQzNQ+q4oEXhGSx+P2OqjWsfIRB8QT\";s:15:\"css/regular.css\";s:71:\"sha384-z3ccjLyn+akM2DtvRQCXJwvT5bGZsspS4uptQKNXNg778nyzvdMqiGcqHVGiAUyY\";s:13:\"css/solid.css\";s:71:\"sha384-rdyFrfAIC05c5ph7BKz3l5NG5yEottvO/DQ0dCrwD8gzeQDjYBHNr1ucUpQuljos\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-NKdowA6EzI4CWz/dLjoC7dhVj+KczesQbwkbt6y3aRTi1JPZBy2uOocsmHmYvkux\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TTjEZR8VsD+LjNa98drkrTRYhdUEaS3gAGE7PGnx2qkePR3fZtnVNoAfxPNyf+IQ\";s:9:\"js/all.js\";s:71:\"sha384-GqVMZRt5Gn7tB9D9q7ONtcp4gtHIUEW/yG7h98J7IpE3kpi+srfFyyB/04OV6pG0\";s:12:\"js/brands.js\";s:71:\"sha384-S2C955KPLo8/zc2J7kJTG38hvFV+SnzXM6hwfEUhGHw5wPo6uXbnbjSJgw3clO4G\";s:17:\"js/fontawesome.js\";s:71:\"sha384-bNOdVeWbABef8Lh4uZ8c3lJXVlHdf8W5hh1OpJ4dGyqIEhMmcnJrosjQ36Kniaqm\";s:13:\"js/regular.js\";s:71:\"sha384-XrvTJeiQ46fxxPrZP6fay5yejA2FV4G1XsS8E4Piz6Fz+7FaEFTw7A7GR972irVV\";s:11:\"js/solid.js\";s:71:\"sha384-Xgf/DMe1667bioB9X1UM5QX+EG6FolMT4K7G+6rqNZBSONbmPh/qZ62nBPfTx+xG\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vBDTb50BKnwbvJZ5ZC5dsGJNQydTI7ZoAjCeJkdta6nSewwGXCnppKI5lrIQX4Qu\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-j8y0ITrvFafF4EkV1mPW0BKm6dp3c+J9Fky22Man50Ofxo2wNe5pT1oZejDH9/Dt\";s:14:\"css/brands.css\";s:71:\"sha384-t0iPfoyIjBoVR2Kw/65HArpRWQy0/xKBUmdEVTs5VYBb/yiPZxMY6egc9MROr/Og\";s:19:\"css/fontawesome.css\";s:71:\"sha384-srL3Qh9R/n855m4o5fegS//B2q0R1md7z6ndDYaPj8iEp0j0IuKdFVWMY0JosKPF\";s:13:\"css/light.css\";s:71:\"sha384-33RmjeesW9BZ4wR2Gm3n4iBXOvGTto4znqL2kZleiRanWDxM59IHIq5RsbRioqxb\";s:15:\"css/regular.css\";s:71:\"sha384-UPs+YiUhgn0/I0swkJmk3PSj3SWmzDrM+S0S09xLI/UUmHBU7ivRHryI3uVL6H+m\";s:13:\"css/solid.css\";s:71:\"sha384-YIyAArzQv8q6Av1kr9cwxHhFcfNBUaolJindR2XO8E3OLp6z3d8My3oWLd33ET7M\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-a2sfkqnB9p/zq6OT4QhuD80qQZ70fGDmo4JUNqP5E7NIICvgRNPjIBkQE/Qcl3SN\";s:16:\"css/v4-shims.css\";s:71:\"sha384-SNyDPad7e8WM4Nu7W/f1x3qsDrLxMCvXurQfwNdp418WWmkkTQuPBGYDZA6rSg0X\";s:9:\"js/all.js\";s:71:\"sha384-3yBLeJ4waqGSAf4A8pjZ13UF7GuhgbdKnBQvIp/TkWoXtQbtwjlIPNjkDRJ46UCn\";s:12:\"js/brands.js\";s:71:\"sha384-oMyy7aPCmlH4ZGEaKHW+zAoaKDWIFh6iqJ53lusMpn+Kp8SN5nJ2kzkP1qd0+icb\";s:17:\"js/fontawesome.js\";s:71:\"sha384-oPma1F1txBbqTG+1O7BEx0A/qFtD+R661ULJLmI9RDQ0PfbRP1tQU3vBIBbJIAxL\";s:11:\"js/light.js\";s:71:\"sha384-SVEn5VmGP1fxV9V5TOZOTwL9dCg50Yb0Xn4fbV9Ic/kp8we6kv4zPVcs9seU0675\";s:13:\"js/regular.js\";s:71:\"sha384-gbY/GPDSEaMQ9cjqWLbLcaxUCtCeExO9oUEZLrOQHfFLoV5ouwIrqF6mGnjyIOc2\";s:11:\"js/solid.js\";s:71:\"sha384-VxezC2Q+YoC+yUILib+HlmOsFiqNzYtQIXsHYY6ST7QZVfgBNs2giKE97ijGMgUH\";s:14:\"js/v4-shims.js\";s:71:\"sha384-8sPM0eSaqmdF9ruedfsxEZfxVcIp0cwhosrBhWl/Q4t1eQSMXl6tYenNe87MraQ6\";}}}s:5:\"5.6.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-aOkxzJ5uQz7WBObEZcHvV5JvRW3TUc2rNPA7pe3AwnsUohiw1Vj2Rgx2KSOkF5+h\";s:14:\"css/brands.css\";s:71:\"sha384-oT8S/zsbHtHRVSs2Weo00ensyC4I8kyMsMhqTD4XrWxyi8NHHxnS0Hy+QEtgeKUE\";s:19:\"css/fontawesome.css\";s:71:\"sha384-J4287OME5B0yzlP80TtfccOBwJJt6xiO2KS14V7z0mVCRwpz+71z7lwP4yoFbTnD\";s:15:\"css/regular.css\";s:71:\"sha384-yWI8JeRmJFie/rrEn4skBd/XXXfUWuc7wAhaj9q71PzjdYD3JslHSEU7BXCCcVyP\";s:13:\"css/solid.css\";s:71:\"sha384-COsgLGwf6vbsibKzWojSqhIjQND/Sa0RWQ5BHFrKOz5JrUObnh5GEBUH2oZwITuM\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-nHELFCUV8tffuhz6PkFYcEl6VCneIQgaHNbLkOHukzJs12+rUiKwsVmVhbqhEAq7\";s:16:\"css/v4-shims.css\";s:71:\"sha384-HiCW4rrGA9WlUM512GMhD+YfcMidwWluZzyu+X55gfVYgAPrlIkG5BnHyAl/VHJO\";s:9:\"js/all.js\";s:71:\"sha384-z9ZOvGHHo21RqN5De4rfJMoAxYpaVoiYhuJXPyVmSs8yn20IE3PmBM534CffwSJI\";s:12:\"js/brands.js\";s:71:\"sha384-GEA3+tbEaglIUriKygE2OQX9k7YrAMJ5oZF0mb8Xx7hUmTTWDuQDtPY4l13jl99w\";s:17:\"js/fontawesome.js\";s:71:\"sha384-tHFnt8QELQGC1IJzcTUX5zFEnn/FLVa0ADTmxRyeSmWukJ4umWnJbwiMTkw/bKEK\";s:13:\"js/regular.js\";s:71:\"sha384-gy4pB6yY1j4DPCG6rZcE6NX1Lnqz8ZJEfotVUvCN2EGwlUS3WUHxcn8rrEOYiyiS\";s:11:\"js/solid.js\";s:71:\"sha384-akyniW0Jfrt1Z7kvRmaF2fkq9vuVQAPEGN4qq7s17l9PG3zz7FThoWnfVxpvnUn9\";s:14:\"js/v4-shims.js\";s:71:\"sha384-08SAgv7bDUyzB5O71dehOCZ42IpryGqW/G+GdxeFmBfaB71QIZWe5ZXBFKYFTEu4\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-rTQdcTFdT69CgbBErourkScWQ6j5WQ4aAoCF0UyPhog3PNysM/xz/kqshWKP4NLA\";s:14:\"css/brands.css\";s:71:\"sha384-84OQfm1oTwjnXmujNUnQC09L4G7mglZspQwfSNPvf5V3zAA1sdvqbIigA9AWY5DB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-NFsDS9VURN70zaqw67F1OtJ6MtdeCrHeGMD1KzqIv5ft0JiHgVtV7u+v09yR+iEZ\";s:13:\"css/light.css\";s:71:\"sha384-aofICWgqJQbZZCaWEU7H0ULLqXTBu/DAALblEYqLfQSjb2ASOw0tADOdJ5rmVDWL\";s:15:\"css/regular.css\";s:71:\"sha384-voao2F8iKUwwSMRhLJ982edrRSHOmc5v5rvQ/5aH5pvSAx1aoL6usygGSRz3jfHF\";s:13:\"css/solid.css\";s:71:\"sha384-RYuivM1ikcxEL+96Q/7B/CcvyswPRuOatldvqvk+Bm3hwVKZUjay1ohuPUyD9ZYk\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-NYMicmsVmKaI5/JVN8JamOLMuIrbzeu4Gc+cike3jcoDpaLfMtvWPJeNhnx8K8x0\";s:16:\"css/v4-shims.css\";s:71:\"sha384-L7wiz9NeFS+vFpG/jl0zBsE7EqrVfeNoaHhnvxlsfwihUr9FIbDnfQqv5r8o02wQ\";s:9:\"js/all.js\";s:71:\"sha384-rDdEqfkiaN9iEfS6XrBzTxL5wVFzBoMsyHmoAIl/T7VdxJvGYuM5bDlDOkmE6r3C\";s:12:\"js/brands.js\";s:71:\"sha384-TN18fDSDUbMxI3DK3z2G8Pl68N7jvVjWPBx8z0m7YhoWKnmGdKRJ6S90IcyeUXUy\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Oa9P+sg4Q/5Yo0a/UoRAG8zLSexWLxLgbPb12tgvs/swrfePVf6IdrwoW2RGV2pU\";s:11:\"js/light.js\";s:71:\"sha384-6DMqAgIR8HN9OqBF3zfhQ4Tmh+KO9Sf0QAwxGkiaKO51dFGBBxBTmdOSneYESZZ0\";s:13:\"js/regular.js\";s:71:\"sha384-LvwwgOzFfwTikawPye02NmwONhyBLBbmu04J+IuLBS6HdNHX3JnRqY80mscKVLTH\";s:11:\"js/solid.js\";s:71:\"sha384-71d190zi1266uo3WuvCJ77V1YdXxDfm5GPMySGFKTMHsoHaxKhPe5XkKaH9iPLWC\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Rr25noDuBAtBUFs9feRsF3EK8Pw5bWuhYxD7ztcDUJqR/eiCpNPGIeyO5Ago6pYW\";}}}s:5:\"5.6.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-gfdkjb5BdAXd+lj+gudLWI+BXq4IuLW5IT+brZEZsLFm++aCMlF1V92rMkPaX4PP\";s:14:\"css/brands.css\";s:71:\"sha384-whKHCkwP9f4MyD1vda26+XRyEg2zkyZezur14Kxc784RxUU1E7HvWVYj9EoJnUV7\";s:19:\"css/fontawesome.css\";s:71:\"sha384-WK8BzK0mpgOdhCxq86nInFqSWLzR5UAsNg0MGX9aDaIIrFWQ38dGdhwnNCAoXFxL\";s:15:\"css/regular.css\";s:71:\"sha384-l+NpTtA08hNNeMp0aMBg/cqPh507w3OvQSRoGnHcVoDCS9OtgxqgR7u8mLQv8poF\";s:13:\"css/solid.css\";s:71:\"sha384-aj0h5DVQ8jfwc8DA7JiM+Dysv7z+qYrFYZR+Qd/TwnmpDI6UaB3GJRRTdY8jYGS4\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ir31wc9kqVZclsGL3U5IucynDpj1TeEzDCvxEWqw8QuxLFETRgirOiygjXdjId3z\";s:16:\"css/v4-shims.css\";s:71:\"sha384-s0z+GcIRRdtdjGfnyKRFh9Oaw3aasU/TFotdFmreqjf+a+Mks2Umj0CrlN0S9lqi\";s:9:\"js/all.js\";s:71:\"sha384-R5JkiUweZpJjELPWqttAYmYM1P3SNEJRM6ecTQF05pFFtxmCO+Y1CiUhvuDzgSVZ\";s:12:\"js/brands.js\";s:71:\"sha384-rsLJp1pKbmeEMVcdsNJfAWZ9FQP5CrQt6Vikj/usZcTgrD28FhqYqKJn5XIaoXjm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-T6YzYwAGZAItTIkYlBzfwqa07o9R1AND3Lgt6Or6c5IdukY7tqShoryqwpKrpeIB\";s:13:\"js/regular.js\";s:71:\"sha384-+e+pqX41PD6VrFw9HZ3YKJHFT+SZoEMBmnMpLUpHrdd5BE46xHCrzap9c6kfTi9H\";s:11:\"js/solid.js\";s:71:\"sha384-8Lgyylu0vfTGCXDKe435hJgX8s96c19R+dvpH0NHKdX47GA7TmMj+BDiZZ76qqhT\";s:14:\"js/v4-shims.js\";s:71:\"sha384-LqOeBjW8oAuwB6xooSoyjAV+CcJLQGftH6m0Xoo+mhJ0TlEAVR9jBsAXXpeEJlyP\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-NJXGk7R+8gWGBdutmr+/d6XDokLwQhF1U3VA7FhvBDlOq7cNdI69z7NQdnXxcF7k\";s:14:\"css/brands.css\";s:71:\"sha384-2k7wpGHb3PA1OZUtSqAk+nIVo2wgBQdEoL1F/FnC+/HHi2bh3N9aSstY0Af72gka\";s:19:\"css/fontawesome.css\";s:71:\"sha384-GQK3B9PHv3SNzYUrdlEpL6CFKQlW/Co4va906SViL0F6U16Li47NXtvwWmFnetYk\";s:13:\"css/light.css\";s:71:\"sha384-QXb14MpvHKJr57ixwhGSXACaU/eGo/NwF/uWE97+C5QPdq8sLQhM1+WKDk6vando\";s:15:\"css/regular.css\";s:71:\"sha384-ThqFFlbk+2bnAn1zc61SL7r8sFUVUkFvtsT+jYr1Jy6xTlvdcqzcerrDGrHqWv6j\";s:13:\"css/solid.css\";s:71:\"sha384-pbj30780YbUh3WmbEAhOL8tHgoaU4xrdmAN+RewL6HsW9EOMIIE4+6rerMXTfJXq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-fjim8BUuF/D2Y8Qyr4U5iLdeKqzyQe927qD4SIdbPDyX2iSN6xNGhoyd2jTiw+Sx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-c2aTxrKw0nWEPlLqENAD5t3J3Ajs/o5LBudKFP44hexDYKKQTgRCAaECkBk+p3L9\";s:9:\"js/all.js\";s:71:\"sha384-ncMWtRMSOo+cLmfdaa6vmMGzBJKysBDF9tq5YK1MAnAjcyipdW2vgTS1jOntY4fs\";s:12:\"js/brands.js\";s:71:\"sha384-+4YdTIsot+hvYL7nKQ9cJs7OWaFvJ7ZTkVretfEoX8uDiTED9tumG/9RsRmlW3jX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ya+lFT8MCnVaSXkMxO4FEUsv4BG1VrVAMY0PiCnmJ4Sq57zoarae8T2EgioHiaMA\";s:11:\"js/light.js\";s:71:\"sha384-hy7ipunNmCKP7KpzkasGow2eTRYx9IbxV0BvBqlWLWRu8mlWMNrj9y6qOLEnxIuF\";s:13:\"js/regular.js\";s:71:\"sha384-8VWoI12VOwcfxYszEUreYXR4Jh1+oxv+mfsVISgPJTsc2Ftw4RC+bO719C+PunjY\";s:11:\"js/solid.js\";s:71:\"sha384-Pl3KUQLNwa33i6dvnL77HMDxZPk93eoi1kB5xZ0eGKgTEt39iQkHdSM6/w53By9e\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ts+GFi6rOAISeHC+EnLaj6AOSoosWr3TALIaYSeHCVsNHkGLlTtzdbMvolIe6tG7\";}}}s:5:\"5.6.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-UHRtZLI+pbxtHCWp1t77Bi1L4ZtiqrqD80Kn4Z8NTSRyMA2Fd33n5dQ8lWUE00s/\";s:14:\"css/brands.css\";s:71:\"sha384-1KLgFVb/gHrlDGLFPgMbeedi6tQBLcWvyNUN+YKXbD7ZFbjX6BLpMDf0PJ32XJfX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jLuaxTTBR42U2qJ/pm4JRouHkEDHkVqH0T1nyQXn1mZ7Snycpf6Rl25VBNthU4z0\";s:15:\"css/regular.css\";s:71:\"sha384-aubIA90W7NxJ+Ly4QHAqo1JBSwQ0jejV75iHhj59KRwVjLVHjuhS3LkDAoa/ltO4\";s:13:\"css/solid.css\";s:71:\"sha384-+0VIRx+yz1WBcCTXBkVQYIBVNEFH1eP6Zknm16roZCyeNg2maWEpk/l/KsyFKs7G\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-KHV7fADs212mr+U2tmuDnxozv2BzTX1qhxPoZ/lT2QcUFkjwat694MI3AzyiVJ+q\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-EIHISlAOj4zgYieurP0SdoiBYfGJKkgWedPHH4jCzpCXLmzVsw1ouK59MuUtP4a1\";s:12:\"js/brands.js\";s:71:\"sha384-VLgz+MgaFCnsFLiBwE3ItNouuqbWV2ZnIqfsA6QRHksEAQfgbcoaQ4PP0ZeS0zS5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-treYPdjUrP4rW5q82SnECO7TPVAz4bpas16yuE9F5o7CeBn2YYw1yr5oC8s8Mf8t\";s:13:\"js/regular.js\";s:71:\"sha384-V+AkgA1cZ+p3DRK63AHCaXvO68V7B5eHoxl7QVN21zftbkFn/sGAIVR7vmQL3Zhp\";s:11:\"js/solid.js\";s:71:\"sha384-F4BRNf3onawQt7LDHDJm/hwm3wBtbLIfGk1VSB/3nn3E+7Rox1YpYcKJMsmHBJIl\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-LRlmVvLKVApDVGuspQFnRQJjkv0P7/YFrw84YYQtmYG4nK8c+M+NlmYDCv0rKWpG\";s:14:\"css/brands.css\";s:71:\"sha384-1KLgFVb/gHrlDGLFPgMbeedi6tQBLcWvyNUN+YKXbD7ZFbjX6BLpMDf0PJ32XJfX\";s:19:\"css/fontawesome.css\";s:71:\"sha384-toEUmnrGu+eq8XUD6ovsr/vFX+R3v9+FUGAnpef+uwGKMCeqZkcZfkXQ0Pls5WS7\";s:13:\"css/light.css\";s:71:\"sha384-ouQ4uivIto2ZdBS6+torZMbImJhWA6/m7/CAGY9z0FNDmoAF6uWAEnavvIsR1EBt\";s:15:\"css/regular.css\";s:71:\"sha384-IXqJGQI1K0IzdpdY2ASrRbDgPr1rUKzDAA90uL7iX1hPQf6Tkve9Z82TUVWm9aje\";s:13:\"css/solid.css\";s:71:\"sha384-5XPOduYq6F78ZOuHxFHpQJCD2l7aCHCf0+o8qKTD2VfqJTgPT3YkyuBGsDSrVsic\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-KHV7fADs212mr+U2tmuDnxozv2BzTX1qhxPoZ/lT2QcUFkjwat694MI3AzyiVJ+q\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-4Gm0M5DjJ0zGaEtLu0ztNIoHWiuJ5rKiaVlpZKeNqXAW49eIIa2ymxb3C4c3uEXR\";s:12:\"js/brands.js\";s:71:\"sha384-VLgz+MgaFCnsFLiBwE3ItNouuqbWV2ZnIqfsA6QRHksEAQfgbcoaQ4PP0ZeS0zS5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-treYPdjUrP4rW5q82SnECO7TPVAz4bpas16yuE9F5o7CeBn2YYw1yr5oC8s8Mf8t\";s:11:\"js/light.js\";s:71:\"sha384-E2rKHkorMllWJmt2GKXlwZ3+kPl6i3FrJ8ihFkf6F7F/AtGvuXY21bQC8mhz2Po+\";s:13:\"js/regular.js\";s:71:\"sha384-nX7teCj1FtQErhxXjr+JWXfe4EjU6KlgeVBHAzQ/L95eWzwx+W1+HuQGmxZT9VkS\";s:11:\"js/solid.js\";s:71:\"sha384-2ZaaAuh8tTVN1nHRrlXAX1tz8fGhZDgusJdBI5BBGycCq37AUonw8dHlPpx7iD6N\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-lZN37f5QGtY3VHgisS14W3ExzMWZxybE1SJSEsQp9S+oqd12jhcu+A56Ebc1zFSJ\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-qD/MNBVMm3hVYCbRTSOW130+CWeRIKbpot9/gR1BHkd7sIct4QKhT1hOPd+2hO8K\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-av0fZBtv517ppGAYKqqaiTvWEK6WXW7W0N1ocPSPI/wi+h8qlgWck2Hikm5cxH0E\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-uyhTADGMAJuHgGNdH+rozTpOkfXUORTgjTmMBtxR8ISQjOs+IIWb8UBn9ixSd4xo\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-av0fZBtv517ppGAYKqqaiTvWEK6WXW7W0N1ocPSPI/wi+h8qlgWck2Hikm5cxH0E\";s:11:\"js/light.js\";s:71:\"sha384-Vs12SjRkIvphC81scjUNowpLYnSOLOrSGxOwVe00oEvWto49wVgjd6BfdeCPcArI\";s:13:\"js/regular.js\";s:71:\"sha384-JZmzMsvgUATRcNmXpyJHLhiqsREsPN/GBj7O5ifVfRU1o4vBp2dsjawGzYzl0QVW\";s:11:\"js/solid.js\";s:71:\"sha384-OzCiQJ65BS/RiwFjTWyem+uRtZ4/LnrVVbwHTT8fR5Q9rYqAaavyOK51RDxkXQzm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-eVEQC9zshBn0rFj4+TU78eNA19HMNigMviK/PU/FFjLXqa/GKPgX58rvt5Z8PLs7\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Qmms7kHsbqYnKkSwiePYzreT+ufFVSNBhfLOEp0sEEfEVdORDs/aEnGaJy/l4eoy\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-5atZgfYD4MHp6kAnxjw4yM3binN4Yh5XXKAIO6m2kIB9CqdRUladdvTdffLnTK3N\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Qmms7kHsbqYnKkSwiePYzreT+ufFVSNBhfLOEp0sEEfEVdORDs/aEnGaJy/l4eoy\";s:11:\"js/light.js\";s:71:\"sha384-ua13CrU9gkzyOVxhPFl96iHgwnYTuTZ96YYiG08m1fYLvz8cVyHluzkzK9WcFLpT\";s:13:\"js/regular.js\";s:71:\"sha384-SdSeoV46BZSFmxvlUQwl3ImF6ton2ST4pPzYOmTTkFUm+UjdzORM0pTtF0sIHydx\";s:11:\"js/solid.js\";s:71:\"sha384-eLZVpmyzMTRsfwRGkcmyu0PXR5qqYDBCSh5PoYLdWFfDmMIibSuru0Blk+nq1Vfm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.7.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4aon80D8rXCGx9ayDt85LbyUHeMWd3UiBaWliBlJ53yzm9hqN21A+o1pqoyK04h+\";s:15:\"css/regular.css\";s:71:\"sha384-IG162Tfx2WTn//TRUi9ahZHsz47lNKzYOp0b6Vv8qltVlPkub2yj9TVwzNck6GEF\";s:13:\"css/solid.css\";s:71:\"sha384-r/k8YTFqmlOaqRkZuSiE9trsrDXkh07mRaoGBMoDcmA58OHILZPsk29i2BsFng1B\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-DrjN/yxBJAblffPf548CARk30Xz2Glal7YO5kqQ8c8GHgrAMXZN2ZDTGwV9xTDJF\";s:9:\"js/all.js\";s:71:\"sha384-0pzryjIRos8mFBWMzSSZApWtPl/5++eIfzYmTgBBmXYdhvxPc+XcFEk+zJwDgWbP\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-xl26xwG2NVtJDw2/96Lmg09++ZjrXPc89j0j7JHjLOdSwHDHPHiucUjfllW0Ywrq\";s:13:\"js/regular.js\";s:71:\"sha384-Gxfqh68NuE4s0o2renzieYkDYVbdJynynsdrB7UG9yEvgpS9TVM+c4bknWfQXUBg\";s:11:\"js/solid.js\";s:71:\"sha384-6FXzJ8R8IC4v/SKPI8oOcRrUkJU8uvFK6YJ4eDY11bJQz4lRw5/wGthflEOX8hjL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-miy+FCz1uGOaEWy6IaOB4X2pp60+e6jaSECmnvz+qo7Os/Q1oflHUIrS0JdfNafk\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-6jHF7Z3XI3fF4XZixAuSu0gGKrXwoX/w3uFPxC56OtjChio7wtTGJWRW53Nhx6Ev\";s:14:\"css/brands.css\";s:71:\"sha384-BKw0P+CQz9xmby+uplDwp82Py8x1xtYPK3ORn/ZSoe6Dk3ETP59WCDnX+fI1XCKK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-iD1qS/uJjE9q9kecNUe9R4FRvcinAvTcPClTz7NI8RI5gUsJ+eaeJeblG1Ex0ieh\";s:13:\"css/light.css\";s:71:\"sha384-puvvQVSC+mXL7INuI0i5Q7QkwwIyYIBJ7caGHiUXD7FndtoyNd78NxgvuBJAYI2m\";s:15:\"css/regular.css\";s:71:\"sha384-4Cp0kYV2i1JFDfp6MQAdlrauJM+WTabydjMk5iJ7A9D+TXIh5zQMd5KXydBCAUN4\";s:13:\"css/solid.css\";s:71:\"sha384-j+2fZ2qAg9GyYKkVpuwm+HLQVz6EYCaTqS3KKx8oectYXMgm4bRmohzCfEvi5j7J\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-3oHRxwaq4aKTY0NVNLfynvnb/U7E0MGiosKUE4cNMIDRezfXvssVlwQ+xsuBLbXf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-U1d6UqL28bnGVHunjKzlOZ8IatZ4il21uTor0FijL3224okgH54hOnOVB50CDK0M\";s:9:\"js/all.js\";s:71:\"sha384-I3Hhe9TkmlsxzooTtbRzdeLbmkFQE9DVzX/19uTZfHk1zn/uWUyk+a+GyrHyseSq\";s:12:\"js/brands.js\";s:71:\"sha384-zJ8/qgGmKwL+kr/xmGA6s1oXK63ah5/1rHuILmZ44sO2Bbq1V3p3eRTkuGcivyhD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-xl26xwG2NVtJDw2/96Lmg09++ZjrXPc89j0j7JHjLOdSwHDHPHiucUjfllW0Ywrq\";s:11:\"js/light.js\";s:71:\"sha384-ua13CrU9gkzyOVxhPFl96iHgwnYTuTZ96YYiG08m1fYLvz8cVyHluzkzK9WcFLpT\";s:13:\"js/regular.js\";s:71:\"sha384-SdSeoV46BZSFmxvlUQwl3ImF6ton2ST4pPzYOmTTkFUm+UjdzORM0pTtF0sIHydx\";s:11:\"js/solid.js\";s:71:\"sha384-eLZVpmyzMTRsfwRGkcmyu0PXR5qqYDBCSh5PoYLdWFfDmMIibSuru0Blk+nq1Vfm\";s:14:\"js/v4-shims.js\";s:71:\"sha384-q8jijYZFNY4pjTA22Qe+33WWGmm0tpPPfMEdUxmXNoEkN5YeCMJYxGcl+XiCckQh\";}}}s:5:\"5.8.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-Mmxa0mLqhmOeaE8vgOSbKacftZcsNYDjQzuCOm6D02luYSzBG8vpaOykv9lFQ51Y\";s:14:\"css/brands.css\";s:71:\"sha384-5G2m52y/zN053yjBCyNXXotYpL2r5k1wg9aakiM5OgK9kdcCB68EECUce5vZiz/8\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Sbwc59I1SOoVoCGgBCwAe/M1j5a9cHixHv/7x9vOxORnT73jUaxyK0paobkk3JSt\";s:15:\"css/regular.css\";s:71:\"sha384-Vma7aWQBdmjVfr98uRd1HcA/r6wPYrlNrIvQBJhDCvZi3X9gVuHtqUKUYep/1KKk\";s:13:\"css/solid.css\";s:71:\"sha384-n4xPrkfCJ3FzmPwM/Nf1QQu7Qx6oDcsbMp+qPOxrJ5w0Tq19ZWd9ylcMWkzKEpwP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-5ywFB7dcUP6RcAWMLvCE58MQE5YMXWSPjly1IqItdN0w0TqoJD+w68U7C3ShoZRk\";s:16:\"css/v4-shims.css\";s:71:\"sha384-IaQiZkMW7NRKIS04GeT98++WyQ6RNaEQlHoHoDrhU+hhCJE4EkfL7itJyj/vanQT\";s:9:\"js/all.js\";s:71:\"sha384-ukiibbYjFS/1dhODSWD+PrZ6+CGCgf8VbyUH7bQQNUulL+2r59uGYToovytTf4Xm\";s:12:\"js/brands.js\";s:71:\"sha384-Gt4maPu5ZO/PkTh32sKMYmmCLGuWtMkv5YBtFZpx4Tu+Of3kFZPYBw9iD/pi4L6s\";s:17:\"js/fontawesome.js\";s:71:\"sha384-TAztyRuTlqgZ97tz982rMo44MRC58wyCC0pqKZY3cKWJNkK00qMd3DhQ7R25jpCe\";s:13:\"js/regular.js\";s:71:\"sha384-IQnlolMpq26nEj6AOd6JOnY2jqCa69uFBqCGBCWSm4EFZYprebVtp3Z2xVLMElvs\";s:11:\"js/solid.js\";s:71:\"sha384-prcFDC6iTvvWsx2iSZtbDdeMVWWOtxcQXXagr9uPHwi42uae31Y3Q17eehHuC0JL\";s:14:\"js/v4-shims.js\";s:71:\"sha384-l9bFz0TmR1ecMQdb9mzBeiLLX3z0mqeK0Bsxhim3nnHB9PoA6o3FUumLH7K6W6/D\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-/pOR6TNYPdUaQQQRKQ4XHznZ4U2K/Lscb3u6jshUngC/31fLTuyX9FZb24gp4O3J\";s:14:\"css/brands.css\";s:71:\"sha384-OxPYtFc8yWHWBo2MFY4rHs5dKcTpNGuyft0hQ+K/vSUJA21jrxi+Py412o2wMvsL\";s:19:\"css/fontawesome.css\";s:71:\"sha384-/0C3VuTlEzBany89/Wf2OJLSGrduLCC28kuoGL/PCGJjGj01pVtiqOcgZZ9AtlET\";s:13:\"css/light.css\";s:71:\"sha384-YmipRqYc8Wly1koaxcpAPTnvJIqXBN4Ue5+l0drZn34sdM+UufP6v8D8/s9xxXOI\";s:15:\"css/regular.css\";s:71:\"sha384-iUhpWyroENmdb/oNEGUdCk4J+TfFOm/SNYi79nN/Hb1aQgjofylAAuRTUfpK2yP1\";s:13:\"css/solid.css\";s:71:\"sha384-maIT5Qg1FqlJhNYpN2IgLAb5XPLY8CqZ7tKBQyjHh+nx/7JXsI5bp+8JHnUgeuyw\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-BUeh/IoVXY+o863GdrQzogOOSo3ABFpxuc9xZhQVnsM2T2vKmrpHGZwaEqqX/SZs\";s:16:\"css/v4-shims.css\";s:71:\"sha384-lRITDKAHusCdCcsQiEA2IIoqExMRD36Tbn9CZj00L8klRpDyMeOoPSv6ubcNAHux\";s:9:\"js/all.js\";s:71:\"sha384-gUdv3ElxXd3gVdbCqjppYoQanRONrQDSdaZY3zn1KeASeS8YGy+T/JDaD2ohyarV\";s:12:\"js/brands.js\";s:71:\"sha384-XLy4uPbRNbMJUgEm6JLmHI784E68XjgSbheIn0fP/6GdZtCcsZmlXvceAGvhzKCh\";s:17:\"js/fontawesome.js\";s:71:\"sha384-aoV9M7ZLyivlmo8GKrkeWiOUQzBnYBpP6U8gW7WXfhssy+HtO87KzowcBokSiK3g\";s:11:\"js/light.js\";s:71:\"sha384-+itlrN2dvS1RqmWnkLQkDqzANbdKqtt6JyQfE/DXxFnhg/PXf0ufRBCSp0c6q81i\";s:13:\"js/regular.js\";s:71:\"sha384-GoKOHat5yLSUYiGMfLJkuCErUZrNlW+2FeFYuKOt7sUWbqvMQOqfB+mdpfCU/8Q4\";s:11:\"js/solid.js\";s:71:\"sha384-jOmpRjxTFmJAVhf7+H7o9joWtQWHRZLdr+B25WojM1yfhB9wFkDvQ3x0VDDn4aAI\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gaNKDFtFZuAyZDkB8Wov1Vl24lMu5MD5MXLmUSu+4HzB8tTVwemJnhqN4Zuj27wd\";}}}s:5:\"5.8.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf\";s:14:\"css/brands.css\";s:71:\"sha384-n9+6/aSqa9lBidZMRCQHTHKJscPq6NW4pCQBiMmHdUCvPN8ZOg2zJJTkC7WIezWv\";s:19:\"css/fontawesome.css\";s:71:\"sha384-vd1e11sR28tEK9YANUtpIOdjGW14pS87bUBuOIoBILVWLFnS+MCX9T6MMf0VdPGq\";s:15:\"css/regular.css\";s:71:\"sha384-FKw7x8fCxuvzBwOJmhTJJsKzBl8dnN9e2R4+pXRfYoHivikuHkzWyhKWDSMcGNK8\";s:13:\"css/solid.css\";s:71:\"sha384-QokYePQSOwpBDuhlHOsX0ymF6R/vLk/UQVz3WHa6wygxI5oGTmDTv8wahFOSspdm\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-acBDV8BDMPEP50gJeFdMIg9yE8eOPuFdBV9r+2F492NUbKhURdQvglFkG0Q+0rlE\";s:16:\"css/v4-shims.css\";s:71:\"sha384-knhdgIEP1JBPHETtXGyUk1FXV22kd1ZAN8yyExweAKAfztV5+kSBjUff4pHDG38c\";s:9:\"js/all.js\";s:71:\"sha384-g5uSoOSBd7KkhAMlnQILrecXvzst9TdC09/VM+pjDTCM+1il8RHz5fKANTFFb+gQ\";s:12:\"js/brands.js\";s:71:\"sha384-rUOIFHM3HXni/WG5pzDhA1e2Js5nn4bWudTYujHbbI9ztBIxK54CL4ZNZWwcBQeD\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EMmnH+Njn8umuoSMZ3Ae3bC9hDknHKOWL2e9WJD/cN6XLeAN7tr5ZQ0Hx5HDHtkS\";s:13:\"js/regular.js\";s:71:\"sha384-Uc9toywOA44owltk1MWl0lQZ+L0mBzJkLQcdif6+JtG9izvok9DLJtCZX57Uq3k2\";s:11:\"js/solid.js\";s:71:\"sha384-IA6YnujJIO+z1m4NKyAGvZ9Wmxrd4Px8WFqhFcgRmwLaJaiwijYgApVpo1MV8p77\";s:14:\"js/v4-shims.js\";s:71:\"sha384-DWlD0qU0+4WTFKXrFbt8wXq/1NHvOGT8vwllYM0W2gIeqgaCC3bZ0U464mDtbR70\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-Bx4pytHkyTDy3aJKjGkGoHPt3tvv6zlwwjc3iqN7ktaiEMLDPqLSZYts2OjKcBx1\";s:14:\"css/brands.css\";s:71:\"sha384-9Wenwezdk1eEhfcpps+Heco4zWw6KuZ2VlevoPomUwWYYZd3nBX0kZ1hBV2zSIKF\";s:19:\"css/fontawesome.css\";s:71:\"sha384-4HqGlagEHMyfaDQVabl1wx7GCtGw6hDl3sKJEhqQjOCrXrvizhaA2j4hK8Piewtr\";s:13:\"css/light.css\";s:71:\"sha384-3SMOAKCN8LYSMjkWz1ChDg4pHSLtD+LuKXaZoHxE1oyDneLR6Ebjm3XHMHO9fWu3\";s:15:\"css/regular.css\";s:71:\"sha384-ELBQxbOyxSZRtZPNO1mVgYkEzMOXFNmQY6CLV1nw+4IZoiHWeuwYTnABxPxxsuBE\";s:13:\"css/solid.css\";s:71:\"sha384-MkkthiFx7890Rev6vwUJO4gRT4yuH5tqMm/Wl4/n9/qptaBpiGcMyjfgq2K4h394\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-LnvOeE4ntog9dzgq63i0OoI6jKPp3p0y693Fh4Fd4eOyx/UsAw0kHXbLKqML1p9R\";s:16:\"css/v4-shims.css\";s:71:\"sha384-68zdIccmue/irEHOgRiyNsWTZAGftSb6RkEtUhgaD+8213AXnbThq7m3WsO+B02H\";s:9:\"js/all.js\";s:71:\"sha384-GBwm0s/0wYcqnK/JmrCoRqWYIWzFiGEucsfFqkB76Ouii5+d4R31vWHPQtfhv55b\";s:12:\"js/brands.js\";s:71:\"sha384-b4zU5X+9uCyU5wpeWBsEIFph6tTD8ERLbUs93uYGQGNqzbcfPDeY6c4jMhTAfBri\";s:17:\"js/fontawesome.js\";s:71:\"sha384-w6QYwIdCVqcYkHtaFutVu3VlDeu+pBFvlp7e0/tygMFwnWTl13KuVYfsp0ediPpA\";s:11:\"js/light.js\";s:71:\"sha384-avwGKnev1pyXYEbWxXSg9S4rpTsws+5vQpoj76SfcccEzOL162Ei8+z4a6AlaMeE\";s:13:\"js/regular.js\";s:71:\"sha384-lv9QOXVC8fPRX14JTtgPGx1JjQPfjnqnp+bTlEnrW2FRawdJ4V8oe4Yq4kdfgJIp\";s:11:\"js/solid.js\";s:71:\"sha384-sJjbbGVKgAaulHq0KZK5MsUx9YmPj+4G3oY2vmW12iBNEFkkhObBezK0ZhSXchIs\";s:14:\"js/v4-shims.js\";s:71:\"sha384-J8Vif9iMSqb5RK45yq6+dnrM1lTP1oQcIHtKpoH0irzUJD/1gCK0pQgIr0hO+hta\";}}}s:5:\"5.8.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-oS3vJWv+0UjzBfQzYUhtDYW+Pj2yciDJxpsK1OYPAYjqT085Qq/1cq5FLXAZQ7Ay\";s:14:\"css/brands.css\";s:71:\"sha384-i2PyM6FMpVnxjRPi0KW/xIS7hkeSznkllv+Hx/MtYDaHA5VcF0yL3KVlvzp8bWjQ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-sri+NftO+0hcisDKgr287Y/1LVnInHJ1l+XC7+FOabmTTIK0HnE2ID+xxvJ21c5J\";s:15:\"css/regular.css\";s:71:\"sha384-hCIN6p9+1T+YkCd3wWjB5yufpReULIPQ21XA/ncf3oZ631q2HEhdC7JgKqbk//4+\";s:13:\"css/solid.css\";s:71:\"sha384-ioUrHig76ITq4aEJ67dHzTvqjsAP/7IzgwE7lgJcg2r7BRNGYSK0LwSmROzYtgzs\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PLvJTjM1QH/74H66d1I1vU8KYsjkbjSJn87gUIUsIO6Xjf8fRO8Hxdevr46EkV7M\";s:16:\"css/v4-shims.css\";s:71:\"sha384-XyBa62YmP9n5OJlz31oJcSVUqdJJ1dgQZriaAHtKZn/8Bu8KJ+PMJ/jjVGvhwvQi\";s:9:\"js/all.js\";s:71:\"sha384-DJ25uNYET2XCl5ZF++U8eNxPWqcKohUUBUpKGlNLMchM7q4Wjg2CUpjHLaL8yYPH\";s:12:\"js/brands.js\";s:71:\"sha384-GtvEzzhN52RvAD7CnSR7TcPw555abR8NK28tAqa/GgIDk59o0TsaK6FHglLstzCf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ia7KZbX22R7DDSbxNmxHqPQ15ceNzg2U4h5A8dy3K47G2fV1k658BTxXjp7rdhXa\";s:13:\"js/regular.js\";s:71:\"sha384-iFYyWQkY/Zvsdq3IIxRJI2FBoXPj6g73ok7rIH3sZGulA7E5PvFqB5BOELomUuyh\";s:11:\"js/solid.js\";s:71:\"sha384-+2/MEhV42Ne5nONkjLVCZFGh5IaEQmfXyvGlsibBiATelTFbVGoLB1sqhczi0hlf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-5i8QG9UXrCZePXfj1ac87dq22tNtGoJ22fmjXaJI8iIy072+ZKv1NZHbsTMfYvnV\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-xVVam1KS4+Qt2OrFa+VdRUoXygyKIuNWUUUBZYv+n27STsJ7oDOHJgfF0bNKLMJF\";s:14:\"css/brands.css\";s:71:\"sha384-BeZiOfMYSXjscewXEIJ0PDoBy27u+zVSTP5ZuW3kjEZKCn7pOB7v+oQVtAtHfY0v\";s:19:\"css/fontawesome.css\";s:71:\"sha384-fqilzf6i0kkOYm+DT4UC9pWzYf4/eFdJKroY1jZyE7n8eYLujyYM9VCucGf/LdVD\";s:13:\"css/light.css\";s:71:\"sha384-0WqtEOayxoyo7wgxUc5l2RvIbaWTyny0LrJbwsKhrKXUyopxvaNFLIoob4dXRwLO\";s:15:\"css/regular.css\";s:71:\"sha384-jyNdSTwsauV6/i9u6sKFOZBrxlr4QREAY295HsNy8laz4LYryhnPdz0ewFVERKfV\";s:13:\"css/solid.css\";s:71:\"sha384-dUUyoHgD2BplZp1AnRbRu0HPC5jscpJEJaJjqnBh7Y5PT1gW7cM6BQEgrcOsSa7e\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+BcpgpzTfqttc/C2LUPzGXIGunaa/aIuSC/BPO2BBqqMbHNRCF7d3DU54LxbCzTS\";s:16:\"css/v4-shims.css\";s:71:\"sha384-TpRSvWoRbPKMMxDvVZgEa9wxoOZyawahRkC2P+ksDRxjPSvZjhEf5nU7pqSWBCQF\";s:9:\"js/all.js\";s:71:\"sha384-RLPiEwcAdrH2NjFcwJipJtlFoIN1xvqPYeeDX5yYtSNu+HTIkQCDvPQ9thsUnPUS\";s:12:\"js/brands.js\";s:71:\"sha384-NBtHk407eZGNubj82MbaKt5CrNLfhnYmCbpjSyDk/nWemMXE/mfvm3c1MPjfnWmU\";s:17:\"js/fontawesome.js\";s:71:\"sha384-b7K10RWf2Q3m26zPrKzM95th5yJnxEw+vpCzNITZFKV8UgxPgHb61bS0xFkKdV2I\";s:11:\"js/light.js\";s:71:\"sha384-BMiulaMo0kY9ExzwDFFjsXkU373Br7qSwYa/hdDlWEWEkE3flk4mBFvMwlpye3Aw\";s:13:\"js/regular.js\";s:71:\"sha384-uMEQdPXvyCTabszTyCxRRMDh/xIcRlT/fpq2DKkcjR6+lOqq2111EL0C1OiRVu1E\";s:11:\"js/solid.js\";s:71:\"sha384-9fQzIUDeLlrPRI2CT9AqVv6Yr0JgEY0+rr7ngyaatQAQrEHhCv5CvG8F8UFdgk7u\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Ts0FauTmSRKZNl+Uw+WC04UuoVYd2gXlJ+OcUvb1NDrV2XmDcgCr8PPv5MY/7KZR\";}}}s:5:\"5.9.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:13:{s:11:\"css/all.css\";s:71:\"sha384-i1LQnF23gykqWXg6jxC2ZbCbUMxyw5gLZY6UiUS98LYV5unm8GWmfkIS6jqJfb4E\";s:14:\"css/brands.css\";s:71:\"sha384-vfTtNoEyqnxivzqkzc+mvlVeCWPGwMlIIkeTkt0mcUQNmFLyyXxY5SgZIkKQIXRK\";s:19:\"css/fontawesome.css\";s:71:\"sha384-NnhYAEceBbm5rQuNvCv6o4iIoPZlkaWfvuXVh4XkRNvHWKgu/Mk2nEjFZpPQdwiz\";s:15:\"css/regular.css\";s:71:\"sha384-5E/NXotaQSDJW8gq/9pxwQHSPRrb21suHuLPqOIlgob8QC8ltM13i6HLujrhWmBL\";s:13:\"css/solid.css\";s:71:\"sha384-ypqxM+6jj5ropInEPawU1UEhbuOuBkkz59KyIbbsTu4Sw62PfV3KUnQadMbIoAzq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Bfk4oyOug+rBqsciYilQ+iwazXsMTURz/M6Gfx7fb02KNeW5VHwt7aHTXWNU9B2W\";s:16:\"css/v4-shims.css\";s:71:\"sha384-zpflLcSaYRmTsnK2LTOdvChgML+Tt/4aE2szcblLVBXd8Jq/HGz6rhZqZ+4TkK75\";s:9:\"js/all.js\";s:71:\"sha384-7Gk1S6elg570RSJJxILsRiq8o0CO99g1zjfOISrqjFUCjxHDn3TmaWoWOqt6eswF\";s:12:\"js/brands.js\";s:71:\"sha384-CZZj1HZWqgh/CGR22Lnl6+fZC6IDR10ga+wECjipCR3zId+7ZxZP1JNI+YgdzyO/\";s:17:\"js/fontawesome.js\";s:71:\"sha384-RXRrB6R44g3RRohoKLAOK5MjNq4PVvz7iZErCckeyobGIJLpTP2qq6xjJFuKnfZu\";s:13:\"js/regular.js\";s:71:\"sha384-xrLv+W4OudHJZ6QDKuv+el28Wyr4OMO0qSQuBiPqhBsnSGKdGct/ElQm+2/fx/eS\";s:11:\"js/solid.js\";s:71:\"sha384-kDWpGOpzLEy85/cK1Df/ba6PkpDHAKUGOX4YHEt0sFzHdrTY1rGmT/gYHN3zCcF0\";s:14:\"js/v4-shims.js\";s:71:\"sha384-npD7syUhXOZUTbAzJEyIPGq/8gGAhBmei7JkUwUki9hAtz9oPkFJwx5f3vGb7SOi\";}s:3:\"pro\";a:15:{s:11:\"css/all.css\";s:71:\"sha384-vlOMx0hKjUCl4WzuhIhSNZSm2yQCaf0mOU1hEDK/iztH3gU4v5NMmJln9273A6Jz\";s:14:\"css/brands.css\";s:71:\"sha384-wRa49NRotGDh34aLO1Hjbu65qHSTF/ZNSBm7uTpMUa2EQ1Csq7Zlswm+FR9hcWtn\";s:19:\"css/fontawesome.css\";s:71:\"sha384-QSCxeayZXa6bvOhHReoQRGN7utvnOnY3JoBHGxM61JQQ1EXA7AT3m7dnlHXLhnCj\";s:13:\"css/light.css\";s:71:\"sha384-/ggAGHSQWxssDRflcj0aeAlGN2rNgsnWOLv1ZU5FEvjQWxP53glq5pNPjtfldVVN\";s:15:\"css/regular.css\";s:71:\"sha384-FrLF2uGffV1P93pQZme192v/cHRu1XlgjMreWAScHPPjBz/p9pNTx/bTV83x8peQ\";s:13:\"css/solid.css\";s:71:\"sha384-KyLwW4NRDhAz4RVatBCvFATniD3ze5rJvP1usxUFectdGgG8n+7OTcZug8s4bj5H\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-dwNK02s77FqYOBDJpF4ttbI23g2UUTrI9euJ+OQGonHAy4W1kCpAyV7ozLK24GWz\";s:16:\"css/v4-shims.css\";s:71:\"sha384-tlZ/hMWxtcO6JxnBPYGsa5Oiu1gmAqp/bY7s7G6m5OOCJvcNQ6Fo39YHu4Elr+Hf\";s:9:\"js/all.js\";s:71:\"sha384-nKdXFHC25mX+ztWymakpQ8nRykznAcZ+yHi9XETJ8CuVvvSGeg/0QCPhvDb41hUb\";s:12:\"js/brands.js\";s:71:\"sha384-4Md2NBtJT8CgVnGaoonPkhRdMvGcFRH/nATvRJ0+2VsJ5bjySPpBil+KbSC+9yFv\";s:17:\"js/fontawesome.js\";s:71:\"sha384-nFIVFc2+uHHcH70YEBnMC6UmUjVxcQ0rZJe7u58lz5aUDQRz0l3xFmVSdao7Ag/K\";s:11:\"js/light.js\";s:71:\"sha384-C6XejYBP1H4YOZVReSXSBion6LKXOt7htNgjRlcKQSsMnL+/Ok1vyvI5EQs1/H1e\";s:13:\"js/regular.js\";s:71:\"sha384-GlXg5Pw5UjuoWpx2tbE3LsctnmBsngO5u5c+nK1slAwSuwN86zPzez+sFxncM+Tc\";s:11:\"js/solid.js\";s:71:\"sha384-pAEZwWHMzeWUPLx+edoghTzc+LBoBSIWMNFPeZGDiFDP6WL4g+EHr7DhQMUpjSLZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-A2MQ6ZItVBjKp0Efdmi8Xze6uRApxGoHzuGImgZGk6JfuaQ9Vkcev6HtJSQzftWE\";}}}s:6:\"5.10.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-0c38nfCMzF8w8DBI+9nTWzApOpr1z0WuyswL4y6x/2ZTtmj/Ki5TedKeUcFusC/k\";s:14:\"css/brands.css\";s:71:\"sha384-19EzMRnOAF4Gg36FukRf0Bee26rnZC49Ld5mFG+8XiQ8ddeKQYj7Rnl12YxIoHe6\";s:19:\"css/fontawesome.css\";s:71:\"sha384-YYaKmJMZQbIhKGKC1QGjVKSQ3s9OlZitN6xQQEPksarSkM0WNkq5Kke0yehyNwyT\";s:15:\"css/regular.css\";s:71:\"sha384-OVGJJ0J6OIuVjxoE5rUQPFweGgzO0xT+HKN5IChh3LTrsWQKjHocfKq+nk/8DogN\";s:13:\"css/solid.css\";s:71:\"sha384-dHM1276IWlmmltsiRRg04ASaTBbgAqnnjneOemUaqff0rqTtVHw5qqKE5i0k4Qll\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-oBn2TNb41FLJEvg05fPEoAhWHErn7PR1FiyT6NjQkoPzDDg1n/e/GrwRgh34gDmQ\";s:16:\"css/v4-shims.css\";s:71:\"sha384-R4Ah6+FGj2TWi1SbbJo01aRwLwdNunBoW4ALQ4SdcDpyQpKoP0pTL3Ce0Hf0oMOh\";s:9:\"js/all.js\";s:71:\"sha384-BfzGEucsDAHnSR99xBvG8cNHx7h6sEbKJejtvqlMrN8nMi3gP2ds+sMAjWfWnZyn\";s:12:\"js/brands.js\";s:71:\"sha384-SgCx6DCTHwPNfTrT8PeDNKVR+bLsTKTVnBbtZYSLgfp4dd+KGa6j4/Jy96HTd0nw\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-yhpUSfH+AXwjqsle/7pS92NQZivmuHw41bqBfGxkaV4ftpRTE9Z6MNd2oh9x/BBm\";s:17:\"js/fontawesome.js\";s:71:\"sha384-LMbxIMq/Ra43sLL8MF9d0C8NDym6Cp7d2rtvvZUd5n4EuGE3GSYBmf6JV41EB7+y\";s:13:\"js/regular.js\";s:71:\"sha384-eX5P9jt8OdQQ4ME1Y4Q90r5k0qCw55F9jie73NYjcSEHIYYV+x3MW3XgqK7HDuOG\";s:11:\"js/solid.js\";s:71:\"sha384-WvtEEwvz7coGHFMqz/gUsacHkjubSgzLIieTORXey1KIpl+/r1Sk5owMdBxnGFHy\";s:14:\"js/v4-shims.js\";s:71:\"sha384-RT+uACaLSP2jOOLdRXKvxcgxA/WNa36UYkM14r9ODCgz51g7frfTdR+Jv3q46NW3\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p\";s:14:\"css/brands.css\";s:71:\"sha384-/BwiSb9M4ZqztN8bEG+VrC9ohWSBX3qEV95+/+gBJoE4+zG3KqcLj8ShUhBIALSm\";s:15:\"css/duotone.css\";s:71:\"sha384-R3QzTxyukP03CMqKFe0ssp5wUvBPEyy9ZspCB+Y01fEjhMwcXixTyeot+S40+AjZ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-eHoocPgXsiuZh+Yy6+7DsKAerLXyJmu2Hadh4QYyt+8v86geixVYwFqUvMU8X90l\";s:13:\"css/light.css\";s:71:\"sha384-2CRj/5C4pwyS5v+q0KXxQ39b3qsKQNE6T+9FFaAOlps/XjJcK+M20aMUxuQtRLaZ\";s:15:\"css/regular.css\";s:71:\"sha384-pWItZRjB6NLzlrnwcL+2alve4CtHiaLj9W5ZwGPgy6dtMzCPsGv/qEcRvrbVkW5i\";s:13:\"css/solid.css\";s:71:\"sha384-Zbnz7QaugaSWTYmuSFTHGzMLxXAu2vzmqJhA/DS3bnaZGJaatH8apOWXfFaP6PMh\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-85qDq8Thytv8iDkEBcdksps8EZiX4DEo3vh6Ijk38Xi4RVm37Ttn+HU9rsXho2fN\";s:16:\"css/v4-shims.css\";s:71:\"sha384-y51MGgwaeLjbh5fbY1GJ6PypnEoMkGu8MoR1HRE/p/hHfiEE1G9bK/79bstJpyYk\";s:9:\"js/all.js\";s:71:\"sha384-G/ZR3ntz68JZrH4pfPJyRbjW+c0+ojii5f+GYiYwldYU69A+Ejat6yIfLSxljXxD\";s:12:\"js/brands.js\";s:71:\"sha384-8TDwqaS9Kr9a/3cVS6+XkvWUM1tz6XdS8s2urD5rXY1Cz22kPF77ZuG1gIWaz6kZ\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-JB1N15Wp6AIOL3sQ9Tm4a0kATlQy9/+/nLmU9B2wv4K4gGNAUFZEU7qDcxIPJLXy\";s:13:\"js/duotone.js\";s:71:\"sha384-PcDzzpTJzDDda2YUM4EY5ZqnZQ3DTIFtoaAn7t07N0UIY1HVyaxIHRzROmFBd48z\";s:17:\"js/fontawesome.js\";s:71:\"sha384-8YSeMunSTZdDZy7rZxfG3NqC3KnYaCKxTJMm9yoILgIoMpXeTKDrV8TeV9C5ItEc\";s:11:\"js/light.js\";s:71:\"sha384-sEc8iKGnMxm+Dm4AQabXbw0DKZU9FtFrWMppMOsxaUZsLL5pcpQs4aL/OfefTw7g\";s:13:\"js/regular.js\";s:71:\"sha384-wNQjNuGVt9TzLWqaxsZvH5uIDIxEkpSCeSPg6nF2ud6AK9jXY9yMFA6CbcZrr+cZ\";s:11:\"js/solid.js\";s:71:\"sha384-Vh+IVHoo4c4JXOfJBoUxIiEJf6bB443zoyGtwY8WbBmCU+7fAq9QX9JLtFcNSPZl\";s:14:\"js/v4-shims.js\";s:71:\"sha384-vzU1ar4oP9lOG/JJdj1q/+3aatI/ZbpyHIMelvsAi2Ee8gCiTIb/YhqRymLLZkje\";}}}s:6:\"5.10.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-wxqG4glGB3nlqX0bi23nmgwCSjWIW13BdLUEYC4VIMehfbcro/ATkyDsF/AbIOVe\";s:14:\"css/brands.css\";s:71:\"sha384-+B+cmd37r9agFUqHw5ABups/+o97SqA/Y6S5b3ly2q0ABacloQs0HZOQAX1NpJhF\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jUGOH+gYMCfz2jbO6DW8vojES/a323h7dcoT6qI7Bvod9mew/wwTZryjccmaMOkf\";s:15:\"css/regular.css\";s:71:\"sha384-gr19od0wAxe2+mYHEXvS7Y1ppn+ESoAQzTYGPauVJYyAYYl0NBQaKveeQnzez2Rm\";s:13:\"css/solid.css\";s:71:\"sha384-VUnOJnDrNS0aVOhF6puq5SPJOP5oOvIO6n54m14E2/OHv6DU1gklJ4EImoD382c5\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-94OQehjHMl3lApC2tWmjwtxlB0oEtSE2zrTdf8uuWEaDEkkCxXK/w0vFs5J5WPU1\";s:16:\"css/v4-shims.css\";s:71:\"sha384-i1lF6V7EeiD7KOgGLtAvJiK1GAQx4ogzG6B9gpEaDuHSLZuM3sFtPZrI6H2Gzqs6\";s:9:\"js/all.js\";s:71:\"sha384-aC/bNmpJEYrEVX5KNHN+m0CmvycQX9wDnYv8X2gdXQjrbtDP5OcU5DRiXwL6bPwr\";s:12:\"js/brands.js\";s:71:\"sha384-BZIBcmKlroIkWe3e13MZbUHZdmagAU/8cnXo9mIW5p5wzf+/U5ULLQ8TVioSuCnC\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-A6TzAYakDQ9XwDY1hOPxAxI/3t6kol61Ed9hvHegEwcENzAE0vLojG6wItQDmclf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-NXKh+ixIINN/JHIorH6fcTNwaAekBk2v7azch6cKmQm7wtb0yBt8ctqn1FAspAW5\";s:13:\"js/regular.js\";s:71:\"sha384-7Sk1mIxPYoZb2I3YK86sPsPMftKqv0aWP+dgX//x1mF1mSOYydXmX7DbtHN99bea\";s:11:\"js/solid.js\";s:71:\"sha384-dc4FEGpFyXnyL9DbieF6I8Xzipdt7GRHX6k8RM/ow6+IDISjPeeTwTiAkNzjv2OI\";s:14:\"js/v4-shims.js\";s:71:\"sha384-BtUWeH6hQDQGUZewQDmWRMisAxvs1LtqoVQgmbFptFnH1GpBw2b2vZenxfFmRtOS\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-y++enYq9sdV7msNmXr08kJdkX4zEI1gMjjkw0l9ttOepH7fMdhb7CePwuRQCfwCr\";s:14:\"css/brands.css\";s:71:\"sha384-9J78p9RP9gty/jk0TJPvYSzmYYCH4cRRkDMnZGxZNh1wdaXLvXzIk90EWrxjjqr9\";s:15:\"css/duotone.css\";s:71:\"sha384-Na50X0DRTNz+Sc+4XbFXONmaknKHBHw6gvRZ4coLQCl7ZLXziulq+4wvTZxkaM+U\";s:19:\"css/fontawesome.css\";s:71:\"sha384-OvQaO09Stu8nVnOdc+6B3WjpKg9dfBxoakdLxJKAYgsz62+DzBUCvWRxPl9LRVSq\";s:13:\"css/light.css\";s:71:\"sha384-CL557/BMzDSg/4ctPpKDphHJgLqpdJ5rvOklcaHzLHpX+qsgd4V/xao6Rya4xKMQ\";s:15:\"css/regular.css\";s:71:\"sha384-yLDdP4XFV3JqISKN0JaZ0kdyks9S+U2o9uBmNbmZh85yjdF/kpu+oY3/eXQcGHhT\";s:13:\"css/solid.css\";s:71:\"sha384-BrYpEWmuPyxLgVmvUGa111AoxZ3kKwiG4TVjjewWZV9vww+dTLWpmEffDSEg9Gf5\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-V8iByeksgr2la9ceLV1jNv7uWdzI3pYZLNzgYqWmQuQZa7khs4d6QC84YnMWoKxx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-rql5zubvrhoXpo5buqgoiKryiT02OHCEtveKZrj4NX/C2Kuy7W2P7vl+RVzBUl9m\";s:9:\"js/all.js\";s:71:\"sha384-FW78RPcSpi13vjx77nPWQIrQbNSLkPBopb0qGzLCxD2x4Kr6FA8V05C/6cpgkKPL\";s:12:\"js/brands.js\";s:71:\"sha384-DGr5D3fYhGn4bylN+nFRaxvPt6s4FjV7B5EhOOFUKW0JKU2vco3q3xtgSZeeEYpw\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-++EkH6KNUkbsGzUhPmRa5yboy873FnCrHLPNWnvcfYOzCCShCQHtdQ3RQTt3WDsW\";s:13:\"js/duotone.js\";s:71:\"sha384-QwVJpiaupNLHQYsfQUftqzWXMT+SsU4AKnlvxDGzNjTq5xPXRbG/ohsvyIEyK2uf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-v97MeHGTkmNphZhn+D7412xlPlc61o4jy6CouRwKfNltfXH68HcYhmQBr2j/J/Vp\";s:11:\"js/light.js\";s:71:\"sha384-TZInz5PvbxRzxSlGI1WYKmrrBBk/XTTZymO6w+smmSVD6RFpfZd+JtSye/viSFxA\";s:13:\"js/regular.js\";s:71:\"sha384-ZlV+aQMpcvCEqNPe9qTu/S6+eBL+DfRjOxr9wtsoZyGnJ/vwQk/U2SZhZ8tJqH5F\";s:11:\"js/solid.js\";s:71:\"sha384-WtnuXyp6MLUsHy3FAqJyL7aL0a/mdUjPwIs/Ub7FXJZufo/0qH9aFsTDY5Q6Bx3m\";s:14:\"js/v4-shims.js\";s:71:\"sha384-P9HMMmM/ObyzYMvKfF0Xf40MYwNdkI08AwhSyCsAVlmXZkJ9GaI0Z23pozRg8HAe\";}}}s:6:\"5.10.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-rtJEYb85SiYWgfpCr0jn174XgJTn4rptSOQsMroFBPQSGLdOC5IbubP6lJ35qoM9\";s:14:\"css/brands.css\";s:71:\"sha384-qVnmyLTtnGPGEN3HDG2MCEOXWH1Yk/i70lKRuV+gMCDQg+jblQlFGPf1mejWUyYG\";s:19:\"css/fontawesome.css\";s:71:\"sha384-hM7EQerc09E4O3zhtvF2iqcB4ZkEu9xkLQndhXdGGCEJ/sB4JK54SuKGmIC35UTf\";s:15:\"css/regular.css\";s:71:\"sha384-zuVEAfuEXYtKnHpmwmkhzwMdR2uek5gePU1XveESmScyRJHbncv8rLEAt+ofv7ze\";s:13:\"css/solid.css\";s:71:\"sha384-qPldrzmea0i8jhonuql0da/kQWeaXdQl+krGXcTQUdRUGHcXBfSrBbZLbyMcCWcF\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-G0mvrlfkz9DnjBCRmY8Wf7nC8wTxDsHE3pGAc7/4rDLh5+v9Z00qi/uyjjcDf1nf\";s:16:\"css/v4-shims.css\";s:71:\"sha384-updXts+unDswrMsYxLc5R+HfSmF8CuEIOe48Rj3DoVoPUIImOT1fs26H/tr/H9gC\";s:9:\"js/all.js\";s:71:\"sha384-QMu+Y+eu45Nfr9fmFOlw8EqjiUreChmoQ7k7C1pFNO8hEbGv9yzsszTmz+RzwyCh\";s:12:\"js/brands.js\";s:71:\"sha384-0kDL5YEgNJjL/kNToZYEds3evLmosarb6OU2eKqRYu6O28jcJc121tjUC40sG9VB\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-Hg1lNcVEsyCqBb1J4/U9X9IW2DEhAKIBfBIE0J0eiWGEX9LEpEULwcsqoAb6HDgG\";s:17:\"js/fontawesome.js\";s:71:\"sha384-5WtMZ7frOu4PgR22YgRSlercgEU28i5Zn39Svk6+2cg1MOigLDSsvXccsmJO2Wxp\";s:13:\"js/regular.js\";s:71:\"sha384-CYi/gunDGMYA12KV546MNRqsjbbWSyKgPjA9BwVMBQmIMhzVrjyUJwkV9uujzHLJ\";s:11:\"js/solid.js\";s:71:\"sha384-RbVpZhfPW/1SmcShwIOauawY5vJWxTCeEnmiUCiY2SbkrbKuSGTqJ9NnBUmcP95A\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gDM1aRghQ5DRg+fSCROSYawrJhbAHqa6Teb2Br0qRJtb+vRJlyU4U4xnmN5cwJ9j\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-XxNLWSzCxOe/CFcHcAiJAZ7LarLmw3f4975gOO6QkxvULbGGNDoSOTzItGUG++Q+\";s:14:\"css/brands.css\";s:71:\"sha384-hIpb1kefRKjC/r6WxN0S6Nai7+AuherqCoHKD0HNdXkbzJkZcS4o62bJ7ODiBWAu\";s:15:\"css/duotone.css\";s:71:\"sha384-B6+5TXCEkY2Io8b+v2Ki0aEWnpCFgBYkOzXAHY3oQ4tr90JpQC1RErwFbvJ9CRt8\";s:19:\"css/fontawesome.css\";s:71:\"sha384-1sdMwbsd8X7Y+nVcEr/4D35smQEaEd6Qz+R00Y+NPUkG8MyRa97RrX5I4nqDt6X7\";s:13:\"css/light.css\";s:71:\"sha384-dlxpRYGi8Pjg49IqtrDIVZmCOQZ//oDKDkoqbn/IXrwwQDP4Uf0ys6+eH1z9sfhV\";s:15:\"css/regular.css\";s:71:\"sha384-hKM7KqUOh6F2PI59uEhofbDs/5qHHdJEULlmNWJEQcu3D/5/vl5zpwBrveC4GAbI\";s:13:\"css/solid.css\";s:71:\"sha384-FCdq+BRoY+lV7Zy7HKKQ4zoywYLRyasGk6IrmrXfmYs0xIgL0QrPeEPTu3T4Uqcc\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+OTv1mrGtdzHGeAuFSVKpPvaMXNpUu+W+Xs4xYz2RgUlrBctmMyE3noRImN5j+ot\";s:16:\"css/v4-shims.css\";s:71:\"sha384-88Tda+TyAtJK9/cRRXAWdJjyE56Tg4ai2x7RoSEqSVodcInAoV0HNQ2ofaGCidyr\";s:9:\"js/all.js\";s:71:\"sha384-lowSFbzpSYKDOsvnpi2JVneSnkrbVjOTwcHOWpC+tj/YT1mxTDIB3ZqbtllmfUSC\";s:12:\"js/brands.js\";s:71:\"sha384-nyTyvpFz3BvQZucRUSSEDlyivN7GAC2Xhgl9M92o/rt/KfEZ7LkqusFXlCjM4DvC\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-eYjh/PZbsWw6lqYWtDM+NlcRs3pUkOk8r4mxv/x0xDjmYPXTxPKQ8ZNXxOnd0UCL\";s:13:\"js/duotone.js\";s:71:\"sha384-2j1n2yG+7lkO9CjnN1DSQOGJoDEaJPEr+TPmTer3pK/yD3bQ/Kk8bqJyS3LfCK26\";s:17:\"js/fontawesome.js\";s:71:\"sha384-sy0tjZ+ivgcg2wUVVEmLMO5wfntWOSyQaD7AQec0iXINci5JAP92T8sM4YldYQIA\";s:11:\"js/light.js\";s:71:\"sha384-vh/BsPXkl02OgBjk1HJkukipMWFU6vHADY4W3u9BXIrKjcRFw5Y5XikVLoLElHee\";s:13:\"js/regular.js\";s:71:\"sha384-p89srWlrnSOel/vi/SpBD/wyTTJhu+27jcfOazOCUnLTpcxG+NVuYs/okkO2JBox\";s:11:\"js/solid.js\";s:71:\"sha384-JzK2muq5DGAdfmBP1xyuFUAYGceTmP/Y84tZvRxkdtsjwuIcd8Hpf1D+5izeBUQP\";s:14:\"js/v4-shims.js\";s:71:\"sha384-z089sTZgTLfns4lyNCTpVbdQA6JAhOs6JXwRH4ig0M6EHPg+Lzp/hdcx2OHQn/v8\";}}}s:6:\"5.11.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-XLYVh3ZsmvjnjODXg/qvDYjcINmPLORACP+Tk6qA3jNLbStl84PzAeEz2Su02511\";s:14:\"css/brands.css\";s:71:\"sha384-ngkCSSyhFgmeG9/8GICGMwnX44Q70/NN2XuNgrpMHOAjXVjYwTvtQML/2+2EH5mm\";s:19:\"css/fontawesome.css\";s:71:\"sha384-saSWCOAroWA1DTfG19axC5l7ej+/lsLpGrQjthhULGGw0FKZqZmxdjRhWqjypqgH\";s:15:\"css/regular.css\";s:71:\"sha384-NJ6bXu66piTFdxVfLXmQuxcjGye4blIA4H2DybHqY1WFdYSxbKQo6W0G53caD7MY\";s:13:\"css/solid.css\";s:71:\"sha384-1Ln0i7HCe1LMHO25AgX/9s/3XzTLIMev2SYgQz8xSyXSa3775gIb15NIpJoDRYDg\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-utbeJwkEmotPPgnsjR2cFDH5mR1JrU1EX02CRdVYlT6MuuLA6/jK0M1UcDXBVNa1\";s:16:\"css/v4-shims.css\";s:71:\"sha384-QZ/09hWMymER1waFUW4M2iM55h3bf5FVf516rOAYf9G2mHSpAj+oo/6jrxhxiVq4\";s:9:\"js/all.js\";s:71:\"sha384-Zgm+jt84FBq52ezxzG1WPrUHXPTLraCVSuBDiGgz/mX0FZxgdkTZNephFvciYglv\";s:12:\"js/brands.js\";s:71:\"sha384-FYnxcuBilMBfd4M0z3ZhTEWrorBL6P6mqaDWsYN46z3iJszwg7yqVAft8mxPhWQf\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-nDF1UhY85TnH6TtkBtlcaTXQh2EGA+oy54oi//hchZ6BIO8n0yZOdEDcqy3Lj6SH\";s:17:\"js/fontawesome.js\";s:71:\"sha384-+4PGPfaOiBMXBdbxBpjj3c78flBTf1SoDBBbEHY2P8SuIKsjNJ59vjhjpMClcRVk\";s:13:\"js/regular.js\";s:71:\"sha384-sPFXZNRvY5NMeQlqaEJyF/3Lrrcqi+EowkFdHnHe2B5/GSLq+RN8eAfpDiFzWveB\";s:11:\"js/solid.js\";s:71:\"sha384-abaNJNBN26YUz3JKjkP/eHqZP+7EaMLIkyR/I4JNQXin7CWBKc81Tmgh2//K2gfd\";s:14:\"js/v4-shims.js\";s:71:\"sha384-uQinggJhGToi55IHZla+hhoeR3xafp4JLhuIZzag3QFHKDyLLolL8IuCRM2aLdxy\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-eRd7BE4pd4YyGL79iaO+/+GQtuNU464XOqRShZHNdRwR66wJIzi0UirzOFzuoMOo\";s:14:\"css/brands.css\";s:71:\"sha384-/DL+sGDGYNVXNSXzx8omqgYJuKJWhPfJC0j3sM06CPE7CKypUtyAtAburBBMbhWn\";s:15:\"css/duotone.css\";s:71:\"sha384-JrGJDz5LRxQ3s3dW4Av8oo0oPABX1FQPzGwpVizHFqVT7RXKd2suPslh8/k6EFvo\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ASwVckljSlVqrp7J4fCNW1Zfqp4GBw13f/oq/bwtr1KNG1j5lzKrfTpvoivwJZpS\";s:13:\"css/light.css\";s:71:\"sha384-SE3odAKV/Li06jtOem3j03b4qHD5AfOLS3ip3Ie7HS0QtdLJuRozlFcEiBnKhIjj\";s:15:\"css/regular.css\";s:71:\"sha384-v0Phnxb9e1tIN8ABEpuqr9+U98eA2hbSnnxnIFWqTyvwFd4QjVV9NOCl19hLotTv\";s:13:\"css/solid.css\";s:71:\"sha384-23irw3gzc0cirSOm9k0vC4Cb8339DDxFatLW9p83F4RsFK/1HuRvePKAltYrdlBX\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-c8uzxHbCxkqcTDgRCHmj0nVIK7Z72qzR5ciNuZIQQKWVMb0Trzdh3g9EmdybHyb/\";s:16:\"css/v4-shims.css\";s:71:\"sha384-+/X59I6aJtu7U5st0yw42TmOgz2GTi80ici4b4Zr3fVKaib7AhAhXm17vhXVqNN6\";s:9:\"js/all.js\";s:71:\"sha384-jaxx6ehyna+t5i9JERhQruWpH3C/xGZQJz6/+xqO5C/eWWJ7ysIZIe9BAULfRy+f\";s:12:\"js/brands.js\";s:71:\"sha384-om6tKqxNyejPYGBkAEpF5czG8EOB93m9G17YUGoJgRtei7kJnA4P4+w73UfDPtLl\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-I8WM/bXtfWQr8u2t0OIaUfJNpTd6LnCbNnrQpaKQN4/Pdek5IOtrXdpcXpLwzCoc\";s:13:\"js/duotone.js\";s:71:\"sha384-tit+/K18O6+uMPCuvEcobuzvT7aFly7Raxqnszuar7OzNloVr2oIugu9S/T3MNgn\";s:17:\"js/fontawesome.js\";s:71:\"sha384-kAYceFs9TzH4f4HsWzAZvbE7yJRTcOUe2UeJVCdVV8AYbspSlxAIwUg7yGHrtSKe\";s:11:\"js/light.js\";s:71:\"sha384-zam67iVIo4OJbdPFYrgsf4Te4l96q61wYKpT72nLO78ICkwXk27OlsN4SQYHOlI6\";s:13:\"js/regular.js\";s:71:\"sha384-8QzBYxpPIH9HEZ96HhicnkJ8XYzELjI6YQabAc2ANT0wExEgzeKwnNdQM3B0YPzX\";s:11:\"js/solid.js\";s:71:\"sha384-vTIqr5UHlJnlDEDAZB19P3NuSQy0Ynbzj7w5ofBkLPpN1bb7N2uZ/z0GNZGCIFxW\";s:14:\"js/v4-shims.js\";s:71:\"sha384-56L2fWZDluSTJKVxfc7PF+HoFsBrcdkn/Wj79nB2pzTgaYmqLT5T2pn6PLbMvHHq\";}}}s:6:\"5.11.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-IT8OQ5/IfeLGe8ZMxjj3QQNqT0zhBJSiFCL3uolrGgKRuenIU+mMS94kck/AHZWu\";s:14:\"css/brands.css\";s:71:\"sha384-UMAQJEtrY4iFRXQIYIXWfTd0GPzHrhSPK1SJ3fEeGGgtkC3m5qhKESA0yOXahpmJ\";s:19:\"css/fontawesome.css\";s:71:\"sha384-8dpIy0am6bmWHK+abUbC1sgkCSD6WstSMjjNB7JVa+rprKurA6xisqNHg6DESJWW\";s:15:\"css/regular.css\";s:71:\"sha384-5JoPxivOfpG9KRKbjXkqhwpMZ7vvAATGi77NPd6sC2ruJrWa/hKqoLBIWC1n1N/U\";s:13:\"css/solid.css\";s:71:\"sha384-20Qlvv++Kgw8B9SXDkUX4JrITPco1UXcaB1mkymQFgx8cM9azG2Ig9Sy3khBpWip\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-jv39B+1DxC6iSROYUwIeI9RUDrl9ckXFPOOlys2dTXchRTodXzqX0lm6GUwN4iLA\";s:16:\"css/v4-shims.css\";s:71:\"sha384-iJU+Et4BsM2cUxdymLmM7B8IF6IkyAYIcJRKroT/XuA5+2bWL9u+KJ1ZItC4bcdo\";s:9:\"js/all.js\";s:71:\"sha384-4Uei2cJ8mOycRxb1dxppaomro+V4vHdGuT3NfYGpENdgukEOcOrNB43OdzBiHdpZ\";s:12:\"js/brands.js\";s:71:\"sha384-q5JjSRgEoLV9cBFXvjGX8xxIxWN+LcGaDFBxSid/9XwjhecfXMQK9Ak7bcPSFT0M\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-LqGhhRx8iThhBm6ytksB4x9veweiV+qNa2soZmn8V37E4Nohq1ccRoaSr4o8YAGQ\";s:17:\"js/fontawesome.js\";s:71:\"sha384-jwx8I0tSvPLf7ZV1KwBdmXpCHgduVujQNEzmHuLEiCYql63uV/C9TCtdBU7E5TL/\";s:13:\"js/regular.js\";s:71:\"sha384-W1XmDNwB/NY1P/H0BiR107pc9NC7aTrPvwXbrZewndT3nyrmFm/7IIc0AxxcHQ/N\";s:11:\"js/solid.js\";s:71:\"sha384-kDwQ866HvlesMeZEZYvoa7AceBir+K+jB/0PVVSs/1bX0JtTvAm3aFEgOCOCt3c3\";s:14:\"js/v4-shims.js\";s:71:\"sha384-gtnOUe72T7BrqVgxbkcbbwZGJLyyHFFtefPxPZ5t/rmQ7vMNXbxml7JJkSNfHmkV\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-sr3GDThhNP8BxHFoTK4zKFgOjcrT8vzaiLwnwU+yB31BCaNj3QMX6YVXcv8AeBAy\";s:14:\"css/brands.css\";s:71:\"sha384-4sG0FgVejJMQM47pqYyG+7afeARX2P0HYkQ8JCKf3ZqTcpJ3/SWefUFX8kdm8eYV\";s:15:\"css/duotone.css\";s:71:\"sha384-q4v2/qv2HhGIAcd04NDH2XuGq8Bzu+xNYUI3gcKFfWt09m/dgZlvUC0rQJ3KtGg/\";s:19:\"css/fontawesome.css\";s:71:\"sha384-O68Og25nY+MZZRUiP6gm7XPDuHsNC5DgKWEoxn6+3CFcGLRXuFihbGO/8c5Ned0i\";s:13:\"css/light.css\";s:71:\"sha384-Rg8mXhpzJH99uBsgdsCp9zXjkcsw/pm+s4Kgu/56eRQSd8SAszYc6hssH5MLusHl\";s:15:\"css/regular.css\";s:71:\"sha384-RjVm0cyaQYehIEaR5Tt+JDfgnUUtY7GP/N4rEglG6DxLUhzozRl6HTH5NfPQ0X1/\";s:13:\"css/solid.css\";s:71:\"sha384-/SNkE+jEmgiOubdXCmBU+e2fWH200um/crHWjo/Rni9rhQuxT4demqM/PAyc+tXU\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-9q0WPwNHncxttx1Sf3c/G9lszy6f82L4rYAYW+JF0PRBNvJ1mVyYivrsep7J+Fud\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1oMR0RRrEohmWSZo0t/tezQF1gyGc/b73Bba+qyZLEGdTAPORCf4p+pQm/iycsgj\";s:9:\"js/all.js\";s:71:\"sha384-7DVhSuOn0R5KmazSuDzmwQHOIPfU4+n8x8AifcGCoSOGATBJh55ZY41LSL37PB6m\";s:12:\"js/brands.js\";s:71:\"sha384-QRf6gn0gPrg4U0aYZ5s/Sx7xXy9gplYMzh82CI51530v89R9s9xGG8ljaSqYflQU\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-jKcJk7TgESeW6RZgq9/e8kTr0jRQ/JvaM//YDKwhF9wyvXk8lQs27OQ6cgv3FXTt\";s:13:\"js/duotone.js\";s:71:\"sha384-CeUA4+L5GZZwc5CGnvQVaT/Yrv5HuRydWW/QDCiXZnuORKxut4zKDa2WUaCS7fvo\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hvER25BD06AWxsJLW7cQmGKjQp9PSZttpMIo36kIq2TTPEhP4lIT3VMFul89Ym6d\";s:11:\"js/light.js\";s:71:\"sha384-qvh52W5+cWrTxhfM559wBnsSqplMQIEjQkHnAE8c6MViBcH1OKvI1u4IGR+26hZK\";s:13:\"js/regular.js\";s:71:\"sha384-owKa0I4sfD0ooTioBE3KJEbjcmAZi2LeCbkqHr7/vkUeG/U5OyCGxYlcz8axgnSe\";s:11:\"js/solid.js\";s:71:\"sha384-hNm7JVaYkbmX1gZWRwOXVFKJ3onp68grA2bFGmFSMCQueJbgNvKR+iItAjM/PiuT\";s:14:\"js/v4-shims.js\";s:71:\"sha384-1MuEmp8vgjvrraTYbqRjvuZbLs+vFg2oeN+87QTVYX2EAXM90T4bzBm7HIFFzAp7\";}}}s:6:\"5.11.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-KA6wR/X5RY4zFAHpv/CnoG2UW1uogYfdnP67Uv7eULvTveboZJg0qUpmJZb5VqzN\";s:14:\"css/brands.css\";s:71:\"sha384-tft2+pObMD7rYFMZlLUziw/8QrQeKHU4GYYvA5jVaggC74ZrYdTASheA2vckPcX5\";s:19:\"css/fontawesome.css\";s:71:\"sha384-+pqJl+lfXqeZZHwVRNTbv2+eicpo+1TR/AEzHYYDKfAits/WRK21xLOwzOxZzJEZ\";s:15:\"css/regular.css\";s:71:\"sha384-zgXo5aJZxI4cJSgWSRtbv7q4JB6PzrmOTAWiZt2CqN25ifeKsCuQZ/pUNoPgjcTb\";s:13:\"css/solid.css\";s:71:\"sha384-doPVn+s3XZuxfJLS7K1E+sUl25XMZtTVb3O46RyV3JDU2ehfc0Aks4z0ufFpA2WC\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PCpLTPQTGcSAXFltutjYRSDJAXJItRY88oa9XgNyYJuwrgJGx+uNVmtGSDS2PPvL\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/EdpJd7d6gGFiQ/vhh7iOjiZdf4+6K4al/XrX6FxxZwDSrAdWxAynr4p/EA/vyPQ\";s:9:\"js/all.js\";s:71:\"sha384-b3ua1l97aVGAPEIe48b4TC60WUQbQaGi2jqAWM90y0OZXZeyaTCWtBTKtjW2GXG1\";s:12:\"js/brands.js\";s:71:\"sha384-b2GpqFrJizV0BUEdbrITdOA5HnxnlrErt7MlEERWd6NSJ32rHeibEvyyCuA13OAS\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-b1XIrGvAvE1F4q9vHz2OmkU7bBKvxebE+Q/bW+d4lG90kACkPFm/ZQuS9tlTwVD+\";s:17:\"js/fontawesome.js\";s:71:\"sha384-EYYaHDhIRoBhd/Ir/1fPnxg9rZLk/55lKtlNT5KrIcONoCS2kjf7ZWzMoCLLACeo\";s:13:\"js/regular.js\";s:71:\"sha384-vIxiYcREJ+yKr8tRXG0gCdepcyuhCTkHwiTdG0qVTHSQvjO0pmllh1QAy93JYsE5\";s:11:\"js/solid.js\";s:71:\"sha384-Mf3ap7OwO+bjTkzM1RsrothLh38uKXvMWJ2TQPXGHqZcqfeI/cyCV+sfV0IDnBDq\";s:14:\"js/v4-shims.js\";s:71:\"sha384-G5fIV0dSzZ1nDQSh+B5u3TRX2UtPcd5UWyi2WS1fZIpJQ/JpJCdShAZ+wmILZ7Qd\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-zrnmn8R8KkWl12rAZFt4yKjxplaDaT7/EUkKm7AovijfrQItFWR7O/JJn4DAa/gx\";s:14:\"css/brands.css\";s:71:\"sha384-dd+UlUKIkNDLBFy2GZJRdMODxfdUjx/PanzxBbsXaRBkyjHzUeDX3mj6q53uL825\";s:15:\"css/duotone.css\";s:71:\"sha384-tHth4ugEmPOZTBSN4Hi2oYiHY6vpxIL8clasFZidKyR6Gm34+U6wx6A9eZHqTs2W\";s:19:\"css/fontawesome.css\";s:71:\"sha384-bQakmC+XBF+eCf93fSR/57kAeX91i0BDyXyj8My8/e/3Bcno5zhEGM02xNvpXV+2\";s:13:\"css/light.css\";s:71:\"sha384-yNf+8hATd/MoR/yfZG0nBBtjTfxZEM1rJos9BgjBaVuLcu711wcecTXBlfS91nfj\";s:15:\"css/regular.css\";s:71:\"sha384-H5RIR1XTDkiiLdUTNtbYvWKpNd2qsPBeGzpT5PD495znZL9JCA7119EMPNfCASw1\";s:13:\"css/solid.css\";s:71:\"sha384-LkNnzh6wVxsC0m3vcQ0T5L6csSYpgSYniG/AKJqWBsHT7PVpeO0QHkBw4dW1WfVu\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-Mh++Qzb28x/RVEo6SYO87IyopQpwhzveyGIVg/AfbCLCEHUINYcCy24fkArgPFNc\";s:16:\"css/v4-shims.css\";s:71:\"sha384-A1hDH1BUL9ZdoEFsPEJY4LRFhu70QJj+RaY50Zoqd568i+ONa9LHCI+uoWDT0Lut\";s:9:\"js/all.js\";s:71:\"sha384-S++1cFhwpxbtRScUliTyprAMK33gMHbukurY4rNyt9CxIniGm6PfioUsQPoAITQJ\";s:12:\"js/brands.js\";s:71:\"sha384-NuqRsJYX4n2gSY6iMRHPZJxtpR40C8Lc/CV66yyeP1Vu5W2QSuVyPxMRpRIGihE+\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-GLrjh9czojGY48hc8pYlf/3FRNEBu9OWvNAta7SMilmijx8+ciGGVZyD+VwV4FVP\";s:13:\"js/duotone.js\";s:71:\"sha384-uO8Ntsr5QW0kAl13UUiYRBDhu3foxlKI+jZjPBApRxFDX2tgO/GYiCXIYiGixOU5\";s:17:\"js/fontawesome.js\";s:71:\"sha384-FdPoPmNNPrerz9uF/cNSTyPmNCRf6b81QDEPk0JlXAaailLV3DT9yA8plMzyffNZ\";s:11:\"js/light.js\";s:71:\"sha384-zE0WHJZIhNaysmywEoQBm6THN0uK5wAyfKWoN6lJPGOlrMB8hf0Yt4/+bex9jZi2\";s:13:\"js/regular.js\";s:71:\"sha384-+3mzeMYwSyHPQfOsqYlwcE3OSC7aI/+DjyVLkBxqWP9O+JyoEtzidrSonbNKh1uy\";s:11:\"js/solid.js\";s:71:\"sha384-9I7yL3g1YvBlMZjZ0bWzPqP1m3Ic5t3EgFq/MqNm2r8FUxDVowt7dO4S1IFleLqZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-+Onl+wOd5BbZvaC8Q/mQUO3lZAqsUyD+xqhS57VlU7gIpqXBMcS9Tw94A9uMZRwX\";}}}s:6:\"5.12.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-REHJTs1r2ErKBuJB0fCK99gCYsVjwxHrSU0N7I1zl9vZbggVJXRMsv/sLlOAGb4M\";s:14:\"css/brands.css\";s:71:\"sha384-ouytoyjvzHVJu1m+KEtJ+2Ys+WFsXUlknprEuQAUs62XNn0shj9U2QeTwdJQmPR1\";s:19:\"css/fontawesome.css\";s:71:\"sha384-VoScp22LWX8GkkUAmdkkkj+rz+/r84lmCD6FALIryJxjwBSz6kE6oebSlamQx19e\";s:15:\"css/regular.css\";s:71:\"sha384-uUtN9GUP/RxDz5kko+qO6znqTP45OrABIxrrPhm8tax1s1huRxYCF7xDm+YunNDB\";s:13:\"css/solid.css\";s:71:\"sha384-9AfJF7pZ+RYk3wXpf8ge6fc3XhPaW3Xl57Qj/mSzPckn9Tu8zJ9qUipWq+/utX20\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-e3I5IwYfes9z/NL+oosxhrbsLa9R8TaEY+Krsm07Fcz7q/R+8nswvn20QsrR8tsb\";s:16:\"css/v4-shims.css\";s:71:\"sha384-AL44/7DEVqkvY9j8IjGLGZgFmHAjuHa+2RIWKxDliMNIfSs9g14/BRpYwHrWQgz6\";s:9:\"js/all.js\";s:71:\"sha384-S+e0w/GqyDFzOU88KBBRbedIB4IMF55OzWmROqS6nlDcXlEaV8PcFi4DHZYfDk4Y\";s:12:\"js/brands.js\";s:71:\"sha384-NLUhiMQCi+OH3uxQu0Ems+2GYt6KJ89f90f4kZlK0BoDB63kHZqAICPl7nQHppJy\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-PpGSW7GgJeChJyQc4XW1MIgUrRkMZudoPYOYAqGERZ+w8ammaWDBQvHM3Qp85XCV\";s:17:\"js/fontawesome.js\";s:71:\"sha384-aolToWrR1Hn3EFHDZtvTl0mtjuJJKLxSu/6b2tlr1g9dS+RLt6QVshweU+2e1v6V\";s:13:\"js/regular.js\";s:71:\"sha384-LCyqT0dvDekY5RP1UquYgUJARvp4tHVJocO5ICwoWSyVoSXrKpJrRrDYxj7+ukHO\";s:11:\"js/solid.js\";s:71:\"sha384-QsXs4eh2k/7mk3dvvNMhJJDjh8UQ++vWm4e7ULJ1UZTbOv3wQOzn+4ULg5iLW+Ph\";s:14:\"js/v4-shims.js\";s:71:\"sha384-NNQFVmb048Dmy0GH4ex0kGVcjxaPeY6JA1+ImM4Lsfr4HOD5CNMvCSoIfjeJJWX9\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-ekOryaXPbeCpWQNxMwSWVvQ0+1VrStoPJq54shlYhR8HzQgig1v5fas6YgOqLoKz\";s:14:\"css/brands.css\";s:71:\"sha384-z3CBOpMFSI4D+GXPvBsSW5vXhm4MEzWuC/CycHv+vsuzuztOzPpomZimFLeWNOgk\";s:15:\"css/duotone.css\";s:71:\"sha384-SnqCl1xqt09zXtBnCqJWrwMR2wbeWfxeAEB8e2QuoHdWNY1V5k0HrDi889EMHehh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CtsKDnRWWHDhjRZ5qgpCFCGpib2FU2SChFu0xRt81grgvXq1P+lbpROQoBLxlU4o\";s:13:\"css/light.css\";s:71:\"sha384-i+ivMdAc0+wLEnd+UdXLpYGNTbyn/0Rjz7EqmkqEOkfat5/2T+S63wn3WDk6h4Yh\";s:15:\"css/regular.css\";s:71:\"sha384-hCQzyeTkj8xmAEG5HT7Hx6t6DUkpTM34rr6FHL04J4AWtPtryU6EjsEDb+Gf17KD\";s:13:\"css/solid.css\";s:71:\"sha384-U9f9KTMQ1TBvUUFLpp6FgAy1M59lrF3q3rYTHPRVtT8OzY3xyyFUzKevJFYHEbhq\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-CpTDS+d/m1rbSfuYxoVJXNCmq6ovovJAD1qgFE+K1Vf5N/n5Nt5yEoZq1UovRsXR\";s:16:\"css/v4-shims.css\";s:71:\"sha384-w49b1IAwJTEsYuPUW2QuSzpWNnhksbL+b/1q2eGObJ2CVV/HO5ubRS4jyMLB4cGs\";s:9:\"js/all.js\";s:71:\"sha384-t1m5KR+UJYhp5D1IG6cS5MuYjxDyh/lIkrB1YUpSPfGxgR4r7pA2xW+KoAfcE5IZ\";s:12:\"js/brands.js\";s:71:\"sha384-L2A2TL70Fg2x6gHvF0zTdYDo163eb/op5YdWXAr/rWfprmIjt6Ib+mdHv60yzNh2\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-Tj7c3TfdpwGV2RqPFYgEbtUTrY+wJeAPDMsuUTvdrbMDWlP6gpUN6LNbXNf1C8BA\";s:13:\"js/duotone.js\";s:71:\"sha384-wAGnJyD+rhKARbazT5ohAk3YosShbJZGkuSG5lrKQOfQpG+7Q7o6ZmAvNqeJ7mFf\";s:17:\"js/fontawesome.js\";s:71:\"sha384-YdKgBdzRKP5F/uorpoOtlS1fRNfveZicpRkkQTn0pQdqGWQs6AMr7Jby3mA/G53+\";s:11:\"js/light.js\";s:71:\"sha384-VuS+lIluvKV9KjbEENEaZi4Ixed0QRYlUr6DI6+U1vj/rOfMP7wl84Z53+fMZXM5\";s:13:\"js/regular.js\";s:71:\"sha384-lS00sjHGt6pxefm2C7siOngllQ0WM3NoXEgwBb79KI3nh2iB5F/vkL7q09F/Z3tj\";s:11:\"js/solid.js\";s:71:\"sha384-ejND26kSb92qqj9cH70EMoR8jytCElYWiCB0v+JkXBz6+2ccBkNJkJZuMmrXY9L+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-xCtgvUZSTFqAix3U6PrST0KLLMXPkzVPwXq3AbYkoKi81K4Ppryd5D8lUII1MeU+\";}}}s:6:\"5.12.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-v8BU367qNbs/aIZIxuivaU55N5GPF89WBerHoGA4QTcbUjYiLQtKdrfXnqAcXyTv\";s:14:\"css/brands.css\";s:71:\"sha384-+2AYGyI2bR10NExh4Lu/3NQmpNxck8EcRE7aATrMi9QQ9OAKQAQw1bcrlWkp0tdM\";s:19:\"css/fontawesome.css\";s:71:\"sha384-C1VkjHy10mh0wo7rz2xEDdqrfn5C+AJpaCpUyScFHzKb0mnAU3I//2RrdAE+LfQ6\";s:15:\"css/regular.css\";s:71:\"sha384-ZYhRqsbjqPY5BrYAS/7RLN0cbKU9T2MfB24Lb42Gyv2BHvW5sujo7gc5gXEReTq9\";s:13:\"css/solid.css\";s:71:\"sha384-yiUBjfJC2dVbhAEtVzEfH+R8ZQJ91V1C+Vtr1ZDTX+gUBZWrNyVrs/Nvc1fzi8GP\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-XBFwYq8dzGeC/rGkEgveavwuEU0D16mIKfWeCX6deYzhMUaa8GX4CgA5c/YHP2xo\";s:16:\"css/v4-shims.css\";s:71:\"sha384-C8a18+Gvny8XkjAdfto/vjAUdpGuPtl1Ix/K2BgKhFaVO6w4onVVHiEaN9h9XsvX\";s:9:\"js/all.js\";s:71:\"sha384-ZbbbT1gw3joYkKRqh0kWyRp32UAvdqkpbLedQJSlnI8iLQcFVxaGyrOgOJiDQTTR\";s:12:\"js/brands.js\";s:71:\"sha384-KASsDRWwlErb8dTf+e5TxRXMnbXrVlbPbn1hS5B/yS4vNsF7mHHO+Gw1bBDhcyOt\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-fHnSzPZE3xYvvXY0y51vln9J+Jd0eK4HughCkcA0NsBpmAGgU97n65RbDqUgnWf1\";s:17:\"js/fontawesome.js\";s:71:\"sha384-H4naMsxnUrIT8qihjWfwIKXi5biIYnqUsQ+vIJGZIKfA+7/O3FxgvMrdH77X+aID\";s:13:\"js/regular.js\";s:71:\"sha384-yUk5aOIIy62R2bRFbFq0+bo+ChWYs75cusETAJ1KYvEMRiEbQZmNU6u+PK60t536\";s:11:\"js/solid.js\";s:71:\"sha384-OSCcNUu98kEBVxq0vZaBr0wdmmd2ojuJwvWuSRKD0V10PWmvTetja8mxGfZm5PsV\";s:14:\"js/v4-shims.js\";s:71:\"sha384-/OZ1Lht4J1/FfstamqqFX1tF7PkDWDKbvat1bkWByC2KRJwGzm/H2bVuw8N4SD8y\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-TxKWSXbsweFt0o2WqfkfJRRNVaPdzXJ/YLqgStggBVRREXkwU7OKz+xXtqOU4u8+\";s:14:\"css/brands.css\";s:71:\"sha384-oRjDIXtfHT9YAjxHLAbf8PsJklTJN+dl7PmnAlOTYJhNAspi+/xgU4f12vi5xGzz\";s:15:\"css/duotone.css\";s:71:\"sha384-qrJ30c8jzW/3IOQRl4RddzzMsw3YIUWq5YhHW/8D8EJnS+5J13GpCGVEVI3ELc/W\";s:19:\"css/fontawesome.css\";s:71:\"sha384-k8n1hWo+b1vuRb6E3KATGC++lfNDnJTtJ6pS2BFF3tp/OshnO7uhzoOj/zJbGfwg\";s:13:\"css/light.css\";s:71:\"sha384-iUpVK/Fzq7teRSWAUmJsnlccV1OgC2fMpgreA8gxAm68UxbZPiMu3GP4IbKdKIUh\";s:15:\"css/regular.css\";s:71:\"sha384-QprxpKrx/cRYKXmWVkM97ert3857dCN6bbf6cRMELoa1+IYdsHoqweHwJksEfb0j\";s:13:\"css/solid.css\";s:71:\"sha384-uef1Ib3WhVuFbw7CZtyE+4IDCiKe1/bGU0vJ2naf8VQHKAeA67yU344LBk/H6nhx\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-GucW5chDMZnyGPL1yaIe1GOHu/X7ixbmNjinYEIVr8a4Q4ewZjgipeXJhVi1lsrd\";s:16:\"css/v4-shims.css\";s:71:\"sha384-58YCAaXf5eAJ+1vna1eEUPuU+Ez6EhIPG77PXmK7QciGJsDNAHt2D8ke3vDio+Hz\";s:9:\"js/all.js\";s:71:\"sha384-RiuSF/PBDHssKXqYfH16Hw3famw7Xg29hNO7Lg636dZXUg42q2UtNLPsGfihOxT9\";s:12:\"js/brands.js\";s:71:\"sha384-yrJPiY+1PdmFAwIfz5kqOJt6qBz7DmhXnjLZWLQ9FopoqnhHIBdOQk6hafYoSquV\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-bIg1sG9EStRr/9ohrrZJs0/uTEvUEEOO+NWuOAsIj3a1ZCHqvWUW6w975b4BSbqI\";s:13:\"js/duotone.js\";s:71:\"sha384-1EFXmt5rBEAK6aeEt/mZiYu0QhdFqz7oRm0Kc4xKyZ2IkrQYBc5F77PWXv3Jl4jY\";s:17:\"js/fontawesome.js\";s:71:\"sha384-P6BxA/EZmb6ypE1RKWOU6G8Ww/wI6w4R6uP6u9mkq3uaBehDQxHOLax3fLvDqkvt\";s:11:\"js/light.js\";s:71:\"sha384-08D3jBd9Co2q3IJB/9qnaukQ4ZhFWVLATRpNirJUQ+yQ/oUORDPfJ7Z2OWySf7/A\";s:13:\"js/regular.js\";s:71:\"sha384-zw99I3pdjnsTnY9W+2pz18pxMpOw12uAiVqYL4dZJOf0Lm8dio2v03Y0L2wzECI7\";s:11:\"js/solid.js\";s:71:\"sha384-Jr2b2cxzFQ84TxM+s7yh1jUu1f4FLCHQQDT3ZeBYZNQo+xvCw52PmB7GbC9yqSqA\";s:14:\"js/v4-shims.js\";s:71:\"sha384-sLzGuPzMXKEht2hBPBvC5ere217qvxFZ1AogesHLWdB5ojWBInm4wE4J+HV7PB6z\";}}}s:6:\"5.13.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-Bfad6CLCknfcloXFOyFnlgtENryhrpZCe29RTifKEixXQZ38WheV+i/6YWSzkz3V\";s:14:\"css/brands.css\";s:71:\"sha384-yZSrIKdp94pouX5Mo4J2MnZUIAuHlZhe3H2c4FRXeUcHvI2k0zNtPrBu8p3bjun5\";s:19:\"css/fontawesome.css\";s:71:\"sha384-syoT0d9IcMjfxtHzbJUlNIuL19vD9XQAdOzftC+llPALVSZdxUpVXE0niLOiw/mn\";s:15:\"css/regular.css\";s:71:\"sha384-rbtXN6sVGIr49U/9DEVUaY55JgfUhjDiDo3EC0wYxfjknaJamv0+cF3XvyaovFbC\";s:13:\"css/solid.css\";s:71:\"sha384-fZFUEa75TqnWs6kJuLABg1hDDArGv1sOKyoqc7RubztZ1lvSU7BS+rc5mwf1Is5a\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-zMDYkJEHc2iapAk7o9HXGGD5N2+GGhOFQPDdNTYvlcc0gBA5r7r5f0aSYeCvm0qn\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/7iOrVBege33/9vHFYEtviVcxjUsNCqyeMnlW/Ms+PH8uRdFkKFmqf9CbVAN0Qef\";s:9:\"js/all.js\";s:71:\"sha384-ujbKXb9V3HdK7jcWL6kHL1c+2Lj4MR4Gkjl7UtwpSHg/ClpViddK9TI7yU53frPN\";s:12:\"js/brands.js\";s:71:\"sha384-c4QRk2vaIFBj+66H3IMCeLBpgmeNbFV8HqOs55qMib1v/dM3JXdodyctPNa9hTyl\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-sDmAMseQ6ZkNcFsP2c8NLyUmSqzUpn9PdoWqr/IP+mXZANSiuN9/09SKaEaMJ39l\";s:17:\"js/fontawesome.js\";s:71:\"sha384-/uNTArWag0fq+MOMnITxuc/uQTqh5NVc+1x0LO4xG//FFwUa8Xff8zrZXIpETdf9\";s:13:\"js/regular.js\";s:71:\"sha384-5FWE8IhPJgMtacw/tJgCapT/ag4ftBYmykFO3KUsozTQ9JKaQhH2oX7RZdCDyWxg\";s:11:\"js/solid.js\";s:71:\"sha384-dCJKkv4KgC8c4IlevkK2DC4yY+rQidnMOt91EmILDbdn8M6cdsjaUbf6awWnsCaZ\";s:14:\"js/v4-shims.js\";s:71:\"sha384-XrjUu+3vbvZoLzAa5lC50XIslajkadQ9kvvTTq0odZ+LCoNEGqomuCdORdHv6wZ6\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-IIED/eyOkM6ihtOiQsX2zizxFBphgnv1zbe1bKA+njdFzkr6cDNy16jfIKWu4FNH\";s:14:\"css/brands.css\";s:71:\"sha384-YJugi/aYht+lwnwrJEOZp+tAEQ+DxNy2WByHkJcz+0oxlJu8YMSeEwsvZubB8F/E\";s:15:\"css/duotone.css\";s:71:\"sha384-oRY9z8lvkaf2a1RyLPsz9ba5IbYiz1X/udoO3kZH3WM+gidZ+eELnojAqaBwvAmB\";s:19:\"css/fontawesome.css\";s:71:\"sha384-tSxOKkJ+YPQOZg1RZd01upxL2FeeFVkHtkL0+04oWgcm9jnvH+EQNLxhpaNYblG2\";s:13:\"css/light.css\";s:71:\"sha384-HLeT9I9TL5c2ujLOZhv6z58D+FdF5R//KTyhCOiYBp1ZX9ZEdaVKPxZmzPx/tMWY\";s:15:\"css/regular.css\";s:71:\"sha384-BPtrG4jSUTPogkW6mA5hAGjvJapJnnMa8tKHQOR9MnrINanXN/IGDInK/SngoAFb\";s:13:\"css/solid.css\";s:71:\"sha384-9mSry5MRUHIfL5zghm8hV6FRKJIMfpofq3NWCyo+Kko5c16y0um8WfF5lB2EGIHJ\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-9WuNcdGCglpaefA1oUecTWMQL/+LmrCJiJJM+pDHX+82lfkj1CKUYLc6DZJQ+1/s\";s:16:\"css/v4-shims.css\";s:71:\"sha384-/WH+7sthk7TduL5PHd16Jew3Hd7eKInsAclAq/MoZWeyR4bMgUj12MSN79PtHEjc\";s:9:\"js/all.js\";s:71:\"sha384-Z0e6PSokCQP510gixgZGPs+obVv8eogS/eS2+/7lLSMOfmLnWBgPQppPispQXGUM\";s:12:\"js/brands.js\";s:71:\"sha384-T90KA1rFqB4OFs7EjJ9EGjXJkOXPhELY4hLaFVnB0LaTNUFGn3QyzNJZh307KVVc\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-8g5Au/J6e7pPZjkCDisd8Jd9psYpdlosRUbac9lOdXAADXrNgc20T1Xc24eIy3I7\";s:13:\"js/duotone.js\";s:71:\"sha384-dkbWEvgccxMcr38iB9BWNiExUnolXcLY54hGUJkFUqThvx5XsvcEervgRgRWz5fl\";s:17:\"js/fontawesome.js\";s:71:\"sha384-bU46hq+Od2wfS4XGCT7Ab5XmYYYY8LURSiGsr4YLIrUWBPeImW/B+OkFEcHhOzuF\";s:11:\"js/light.js\";s:71:\"sha384-ipYj2yPBG2ozjlrUCd6AheWkvEpqcCQNY7yxX8wDoIJc5Lr1zVXAE4sKB3hVfjfT\";s:13:\"js/regular.js\";s:71:\"sha384-5CC2/v59nxbyM1595fgM84ERvZXK5WbpCnB9/dd1gTJc2LyitbiKhULkaiXZNj6V\";s:11:\"js/solid.js\";s:71:\"sha384-Imz7xdjp2/vTu6azMFMusPHfSLwcYmj5ZWzOXv3esrLD8IDP9AMA28bwpJZwaR1g\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ZbnNry/TJ2Ald71QRyefS1elxArPz0oOfiNFxpfSO0Yb5lnnftVJMFbENL3j0hCf\";}}}s:6:\"5.13.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-xxzQGERXS00kBmZW/6qxqJPyxW3UR0BPsL4c8ILaIWXva5kFi7TxkIIaMiKtqV1Q\";s:14:\"css/brands.css\";s:71:\"sha384-pmyS4Hp0pc0tA0poF+AKYeURgyIgYLt12rD/6gLC98rTImbSYIe75vT2/3jK4zIh\";s:19:\"css/fontawesome.css\";s:71:\"sha384-O6duc3QftgMWW3awKiGYswymy288kVFZgGWC/4YCl48Y0codWJRgs8DA0N4dX/zx\";s:15:\"css/regular.css\";s:71:\"sha384-aDoEE1PtWF0YZqVk7el3O+QPApPko7v9/7VYyuzjhHWwJ3cmn0m7xE3/FkHSpPNT\";s:13:\"css/solid.css\";s:71:\"sha384-wG7JbYjXVhle8f17qIp6KJaO/5PsPzOrT76RgvdRGLHj0yXZZ3jg98yb0GNRv1+M\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-CFCaxC5Lp+1aYrNgJjxz8bNrgnzVPnSxma3pb+m90jym25B+q2vYd3JfLQR00SNn\";s:16:\"css/v4-shims.css\";s:71:\"sha384-KkCLkpBvvcSnFQn3PbNkSgmwKGj7ln8pQe/6BOAE0i+/fU9QYEx5CtwduPRyTNob\";s:9:\"js/all.js\";s:71:\"sha384-heKROmDHlJdBb+n64p+i+wLplNYUZPaZmp2HZ4J6KCqzmd33FJ8QClrOV3IdHZm5\";s:12:\"js/brands.js\";s:71:\"sha384-Ay9V1h0l5sywM7gJ5YvOc05QytfKqZAElRgqU5kPcIIUAUBqLOYwu9gnW6p5t/FN\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-xDU4X/EdF/mFSa0TktUKBTHd/td1gTc+xWNLKdYcvrAUZExjiWhDnrLM4lGkqzeH\";s:17:\"js/fontawesome.js\";s:71:\"sha384-4NJBLvz0eHSgtSVDb+VOLh4cxmVluIBqCaNw97NvJAo18r+qV9pze1g4YnhB/X6Y\";s:13:\"js/regular.js\";s:71:\"sha384-omrmE/gvA72r1j409JaSn3V6w5f7Mx7GZpjB8xqS4nLwGpT7Zj2obev62Y9QcCZr\";s:11:\"js/solid.js\";s:71:\"sha384-81RFXCmeESYg4G/uFGo6Tu/eeK3klw0oKItW3nPhi2BuryJcE4lkOkwWsW6jzoNz\";s:14:\"js/v4-shims.js\";s:71:\"sha384-CtI1i5e/58ZMUgZkT75wgboNZAbEXBNToPY17SfEmfyKvGuJW7DP418LdXkjI++F\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-B9BoFFAuBaCfqw6lxWBZrhg/z4NkwqdBci+E+Sc2XlK/Rz25RYn8Fetb+Aw5irxa\";s:14:\"css/brands.css\";s:71:\"sha384-e0CAD3LQqbxBCI1WW9pe35Vr+ogbg41axplGx9yY6Woaw6h+zHnB7v4sVuZjHDnK\";s:15:\"css/duotone.css\";s:71:\"sha384-jZslG/z2CMKpawOGi2BzAUH7QBRu5umkFNeP0Op1SZksaT8WGx5MuZazFfE/XR9h\";s:19:\"css/fontawesome.css\";s:71:\"sha384-eKHMjnfl7jrOmk1Fw4dpPDTetBHFOho47C/omrsmBVN2ii45aI8s97OUFVtGg1CR\";s:13:\"css/light.css\";s:71:\"sha384-N45G0WPo8CMcXE4y+hOnuWLp2TJxNbhk/YbM4GQEymB5fPGzOXVH+er/7Z15oBjl\";s:15:\"css/regular.css\";s:71:\"sha384-h1Eirl+AlKkBdUtIMW1hm36KarFrx3iEfjcnTYKeeUdZTOsT8hLDc0lnlNG2jPn5\";s:13:\"css/solid.css\";s:71:\"sha384-F78AVlY1oEzT5bXRSwVzraqWTcbpglP7ILEEE3rmu1gIfm/TUo5gpdN4YVfvp7Xj\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ZFFudtU+0nvUFj6ogUZSspaq7QhLb6JJX6jSIu5UiZAbZMhnBJfNwZahptQ4MQ/i\";s:16:\"css/v4-shims.css\";s:71:\"sha384-He820UjOck3Qu+A0dH2+CmHOeYAYN0kqRW3s6hHC/Jzu8IXSeZF2pn+lgVpz4KuJ\";s:9:\"js/all.js\";s:71:\"sha384-RFburpZVVirucdjarLLIoBiT+LY5YuPB8XboZYWRuWpElr46csH7Ia2nsHfkfBZF\";s:12:\"js/brands.js\";s:71:\"sha384-bM9U2rf0yP/4jsztQkRVwJnqtVcLJzwAMaVgd4sfQYxxm0ru+TieQ4ZaxKW4vsyo\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-DuzRvwD99f8XqXEPIxkpB1F+Ik6c2AZMj6gWcEDwFUCAgtVSelRH9Dos4SMxw/+i\";s:13:\"js/duotone.js\";s:71:\"sha384-uABtWM9HIHso7RIYTkd4w0zB8IgL/hTcPNyYTVA62Qw0lK3umduLb+vIYtXCd6W8\";s:17:\"js/fontawesome.js\";s:71:\"sha384-Ta21ZAqXVyXVqLCnHENnO2ULnrJQzNdGFAbMR1nbZOSV7PcTcZVIWZJCCcRYy2Q4\";s:11:\"js/light.js\";s:71:\"sha384-+8Y6x3Roex77ZBdaQqtTN2QKu/TIOdzoswRYxryfW9ELmUxMTYLgzdz5nlA/3ndC\";s:13:\"js/regular.js\";s:71:\"sha384-sSHWg/dKYjGSJU6C17C2qGImASfPcJqy2BaW/iTzifkPJmzprIMH1tl4/tIbWq8M\";s:11:\"js/solid.js\";s:71:\"sha384-VBOdkc1roPM6EIGTBi2yraUNs04SZ9+TsLzF0vIecIKYf6oXYxAYgjzMpH8UdZYh\";s:14:\"js/v4-shims.js\";s:71:\"sha384-iwdWtJevtQK06+Bbqeb7Oo+osfnPQWsHQWR+5SeND0soWVUGjfyRC2XdttrYI2j+\";}}}s:6:\"5.14.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-HzLeBuhoNPvSl5KYnjx0BT+WB0QEEqLprO+NBkkk5gbc67FTaL7XIGa2w1L0Xbgc\";s:14:\"css/brands.css\";s:71:\"sha384-MiOGyNsVTeSVUjE9q/52dpdZjrr7yQAjVRUs23Bir5NhrTq0YA0rny4u/qe4dxNj\";s:19:\"css/fontawesome.css\";s:71:\"sha384-PRy/NDAXVTUcXlWA3voA+JO/UMtzWgsYuwMxjuu6DfFPgzJpciUiPwgsvp48fl3p\";s:15:\"css/regular.css\";s:71:\"sha384-e46AbGhCSICtPh8xpc35ZioOrHg2PGsH1Bpy/vyr9AhEMVhttzxc+2GSMSP+Y60P\";s:13:\"css/solid.css\";s:71:\"sha384-TN9eFVoW87zV3Q7PfVXNZFuCwsmMwkuOTOUsyESfMS9uwDTf7yrxXH78rsXT3xf0\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-PB7dcmSOBXciTYYzTvxdvcCEy4k3woMwwVAtsIA3LUQyKW21C7UL9EcGtd6IRNLc\";s:16:\"css/v4-shims.css\";s:71:\"sha384-9aKO2QU3KETrRCCXFbhLK16iRd15nC+OYEmpVb54jY8/CEXz/GVRsnM73wcbYw+m\";s:9:\"js/all.js\";s:71:\"sha384-3Nqiqht3ZZEO8FKj7GR1upiI385J92VwWNLj+FqHxtLYxd9l+WYpeqSOrLh0T12c\";s:12:\"js/brands.js\";s:71:\"sha384-V7gsTxvUZaeC6NAsCa24o3WvPOXwSsUM8/SBgy+fxlzWL3xEGXHsAv2E3UO5zKcZ\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-uMs7U5rgbKM9mJ/p05oZ+z+8uK1lwLhl96KWxP5odG0wm26IfhzgKQ0ktZnc2PYP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-DNo9bmYZCHLtp0n0l0XA2UsoRHX1nx38aRP+p9yoP5A8kVTfeWG3aySMOq5FD/v3\";s:13:\"js/regular.js\";s:71:\"sha384-zHXcIX0meH+eFgqCa9QdLtYfc+0p7KcF4fVB+gMVFjV6rzYv+LxSIuF5i2eGVDlt\";s:11:\"js/solid.js\";s:71:\"sha384-4RG3cEPIlCBy6VNzxM9ZoEwZW+65ed5JDOfaJAnQqwV6ha/jZDJTXjFmvjFM4bk4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-g+ezV6Pq6549QkJkkz2wmW/wpazNaliTdSg/HX4bKsQ7S8cfyMOiyAfzfWPtlVR9\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-VhBcF/php0Z/P5ZxlxaEx1GwqTQVIBu4G4giRWxTKOCjTxsPFETUDdVL5B6vYvOt\";s:14:\"css/brands.css\";s:71:\"sha384-DkuHshSFBB5Ozmaoq36ICABPCsIIbamipzuH7NO0sxDIDrJloLD43yBzNLI3gxS6\";s:15:\"css/duotone.css\";s:71:\"sha384-QRFqAT1IRNAzMGALiXfanFtQEBoLDPPh1vnrMbxHa+UeJkCTHO3TpYXHQ+GK1pKg\";s:19:\"css/fontawesome.css\";s:71:\"sha384-CAxg0L30Vie2vI3AniQ4UA+pSswoJmr/MK5Dl5DP9YlE1nzJn4z5updw5S3i/Nsn\";s:13:\"css/light.css\";s:71:\"sha384-LmKkPHDqucxgmrtLKWrMGZc5nnHQYAdFkSzMtl1OcvTZn4pebmVziSZPtp27MA6u\";s:15:\"css/regular.css\";s:71:\"sha384-izRgjQadEFrlAsdFZjlQ4v6Ff2E0R02RwYZwdL8lrt398rQmLNOFYYNk9qQoqjDP\";s:13:\"css/solid.css\";s:71:\"sha384-qJugmlTDyF5CNuv00JB+04BCmCVi5C2ZZhsIVMX0wxWr7U3ZuOsmO+nOLtoTxeWG\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-EjLtrKO3gucE2cOzLw8A5aJpQ9oXEJTxlTkbLrrL4JR7xGLPI8B1fyK3ygNxeLxq\";s:16:\"css/v4-shims.css\";s:71:\"sha384-oydBLEZZlqJqf0OWwXyyj91mRqrL25j/VMAvTl0BA0iIMoJGDTSksMDnqkl+TWLA\";s:9:\"js/all.js\";s:71:\"sha384-8nFttujfhbCh3CZJ34J+BtLPrg9cGflbku3ZQUTUewA7mqA8TG5Uip4fzQRbERs0\";s:12:\"js/brands.js\";s:71:\"sha384-9112PiGcvkxlUNBecZ0rk0c6zEGUKlR/enlHdLy0Xu42kfHEbIKsFVBsmEn+6cEt\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-9rbnCwKDHzpLDHYvYRqRWcyLZc3anAu+oe1dRxPOk7RcqBzjAv7CYTvAQJGkUNXS\";s:13:\"js/duotone.js\";s:71:\"sha384-HFlrQxjzjMUAiYmFuUKrkp90VMEpD/dpb8unLEWH5QXnUs2xHw5zd8aiztrPBLbT\";s:17:\"js/fontawesome.js\";s:71:\"sha384-XULY2W1C7bGq9gruRvsk8Zyhq33b1/TgBBKzJ+8dzWkJm0kObgcry2qU+Qf+HOZw\";s:11:\"js/light.js\";s:71:\"sha384-a8Ul+Nmi3glFYXvks3ShdxGHyk09LsZ3+TIjDr2vj9lMx2F29TqTJm7U0EutxFdH\";s:13:\"js/regular.js\";s:71:\"sha384-B8V2/SCNt/naDJB0LkeljUBBYYhGFm/rUVnNsFYlutzbeSTTzVEqxRo8SN3tuHSl\";s:11:\"js/solid.js\";s:71:\"sha384-CjNAVlgtLE9uQuDgWphA+b5vXjcy5spSSezhnbGWUZl0VDkAxzeU8elFOdDs4qaU\";s:14:\"js/v4-shims.js\";s:71:\"sha384-kN/8Lc85No/I30OsF5JSmBzc0W1W0AvgBJGA1eEtVSfaiIeg8oPTJ8CerHqDREVn\";}}}s:6:\"5.15.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-vp86vTRFVJgpjF9jiIGPEEqYqlDwgyBgEF109VFjmqGmIY/Y4HV4d3Gp2irVfcrp\";s:14:\"css/brands.css\";s:71:\"sha384-/feuykTegPRR7MxelAQ+2VUMibQwKyO6okSsWiblZAJhUSTF9QAVR0QLk6YwNURa\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ijEtygNrZDKunAWYDdV3wAZWvTHSrGhdUfImfngIba35nhQ03lSNgfTJAKaGFjk2\";s:15:\"css/regular.css\";s:71:\"sha384-APzfePYec2VC7jyJSpgbPrqGZ365g49SgeW+7abV1GaUnDwW7dQIYFc+EuAuIx0c\";s:13:\"css/solid.css\";s:71:\"sha384-yo370P8tRI3EbMVcDU+ziwsS/s62yNv3tgdMqDSsRSILohhnOrDNl142Df8wuHA+\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-wvKQCF3aHjf73vG90/oO/tFarRthMbxfbW1DeHM+eJJYWmiFLJ0DyCzE1aSFHazB\";s:16:\"css/v4-shims.css\";s:71:\"sha384-WCuYjm/u5NsK4s/NfnJeHuMj6zzN2HFyjhBu/SnZJj7eZ6+ds4zqIM3wYgL59Clf\";s:9:\"js/all.js\";s:71:\"sha384-9/D4ECZvKMVEJ9Bhr3ZnUAF+Ahlagp1cyPC7h5yDlZdXs4DQ/vRftzfd+2uFUuqS\";s:12:\"js/brands.js\";s:71:\"sha384-GUtlu2Qit8cdodM5DbKnbDIWFJA8nWCVEwETZXY2xvKV1TFLtD/AL+bCOsPyh05M\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-sefi04js7ZytQojQsuOy097ewgefakplyIWjkCI75Wz1IxHB/9NAAinmgLG3uDt/\";s:17:\"js/fontawesome.js\";s:71:\"sha384-v0OPwyxrMWxEgAVlmUqvjeEr48Eh/SOZ2DRtVYJCx1ZNDfWBfNMWUjwUwBCJgfO4\";s:13:\"js/regular.js\";s:71:\"sha384-i9Vys31h0tPXNeAe12HKp4zkBi0S3LAH4OGYRSWKSrdnPYTS4pQgCc/HakrenJBh\";s:11:\"js/solid.js\";s:71:\"sha384-oKbh94nlFq571cjny1jaIBlQwzTJW4KYExGYjslYSoG/J/w68zUI+KHPRveXB6EY\";s:14:\"js/v4-shims.js\";s:71:\"sha384-IEHK9LKBXJdi7Y/gik7R6VYPuwx8hMiwQuaOh7BQUQ9rKmWr2N04KYFdmt5Xi0qG\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-9ZfPnbegQSumzaE7mks2IYgHoayLtuto3AS6ieArECeaR8nCfliJVuLh/GaQ1gyM\";s:14:\"css/brands.css\";s:71:\"sha384-YgEKO0tR8hhGPO9Dv3YGK+GstKp44//D72dbOA0oTX+7myWawnkifErid6FIpP9W\";s:15:\"css/duotone.css\";s:71:\"sha384-bXXzjCj9fg9FACS6tpRWhBsNqQ7j7swH/U3MKTJrZuRbF3ktmj9g/lie7L3CNSTd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RFOcGND+1HYm6OyEAF5WKkoZnwv/cXQpCX6KduKC1vAKAoohkNYWNPhkx4fsH9Fn\";s:13:\"css/light.css\";s:71:\"sha384-yWmEVLm9kM0L2w+XPDQQUv6tARNHEYPPwdDplMiVced5iOVoiUIToRveagZ56DVa\";s:15:\"css/regular.css\";s:71:\"sha384-pvlGSUiPzTZa8YsqGs23BENlf3D4ddnLRdl2q5R1ekGw7nnWJZ0AK74DUr0mzLTH\";s:13:\"css/solid.css\";s:71:\"sha384-LRz1HmzqffP7wO7piC0QSObi89cOdpFP7qMIx/UZ+qK2TdoDBdl+LidxFVnYu23p\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-mFHdQxElacASluqApikB6+SUGnAOWouxc19KqW5eZGoZ+b4A/Cj6pMUCGn6g1uZ+\";s:16:\"css/v4-shims.css\";s:71:\"sha384-r35xeRHwDKxzFjeApFdZuwo9D/nV4p0BPL4BxIVmsyKQGWWBaxG59Gr/9x7IfVog\";s:9:\"js/all.js\";s:71:\"sha384-Vipr9QSlUeD/qnhkau6GBnZnUmVkbaRZ0PgB1KjvWa1UoNBKnuzg1TgbJJn2a12T\";s:12:\"js/brands.js\";s:71:\"sha384-rdZ4AVYAMfVJRjRJzozK2JY6LOdLxKdUkHuegulAuMdllLH7M9AllgBLuYmBe+zm\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-qgGl/EYa0JYIveAO7M9W/hshMqlMyo0G/QHio/5D5r1ZbZxAoqcTTReeL4gRrL4m\";s:13:\"js/duotone.js\";s:71:\"sha384-4qqOVq7ZvSMSgZij30G8q1kOs7pBiAWrSVKqWRv32l99D/qqXlMpFQK8wLSfeQEZ\";s:17:\"js/fontawesome.js\";s:71:\"sha384-whiLNjPVOuBfSNjL/tLtRWANHP97vxmZ5OoUK496MOTzH07UdmxDLsnSBgvvjLNf\";s:11:\"js/light.js\";s:71:\"sha384-AEYbWLXnCyDCeopMCsF+A4qHLchpzJ4wMnZiE74Bcp6qLWwXIJCWY0ASqAf0qYrf\";s:13:\"js/regular.js\";s:71:\"sha384-wM50oZlS/21q6M6tlw0EWan+0yFpuRC/PrPeimdGxjCjfx45F0x3NZggS5uFp5uv\";s:11:\"js/solid.js\";s:71:\"sha384-PezVa2U3+0USHwNA7bgvfA+uSS1IPVdTat51a5IgvNGHUJjcvsj+TheZ6X30JybM\";s:14:\"js/v4-shims.js\";s:71:\"sha384-MafE1kr6MZ6PhxNeH0/kvg7f5ramk1tE+y/dBi4C6WgxaKU4mNGRxPNxcEZ5maAx\";}}}s:6:\"5.15.2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-vSIIfh2YWi9wW0r9iZe7RJPrKwp6bG+s9QZMoITbCckVJqGCCRhc+ccxNcdpHuYu\";s:14:\"css/brands.css\";s:71:\"sha384-RTi1U6SIW2G3kUi5NslKQjA34F8CsQCVduJO50jqtxhR2KY++LR7KZS2886EwXrk\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Hx1dya9ptAdKu2hLNR5C2Cwgm+wCfwD0VMGE6jk5OUxxa9I58YfxOCwEtRog+3wk\";s:15:\"css/regular.css\";s:71:\"sha384-GMkIgTgosuQEt2PEwBHI7MMRsrQplN2sT/7bzPOIxG+Hn37iTlZXFb37m6uE+iHj\";s:13:\"css/solid.css\";s:71:\"sha384-6qO6EOFIDfvv6uzAzozX/BvMu/qkIIHxWYOVMjpVjX+NtPuNyd3YiOEflKIIV2ka\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-6iJDq4HKs21oqDV0KkGhh5uve3aJBXwTX0ACa8Fp5Sx7fcZtIumvT+GSzqSEsceV\";s:16:\"css/v4-shims.css\";s:71:\"sha384-1CjXmylX8++C7CVZORGA9EwcbYDfZV2D4Kl1pTm3hp2I/usHDafIrgBJNuRTDQ4f\";s:9:\"js/all.js\";s:71:\"sha384-vuFJ2JiSdUpXLKGK+tDteQZBqNlMwAjhZ3TvPaDfN9QmbPb7Q8qUpbSNapQev3YF\";s:12:\"js/brands.js\";s:71:\"sha384-CFHIjJ6e4s9fugmZkgMS+xAN9t3pMb8WzxVLSL61rvRx/NfBorLHHVF+7/xxhpll\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-SY45zU2Pf71PV9B/kvEgK9jzpEbe14MiprEwrg1VcbXdBcjXbNTPwoXfp6A+ntJG\";s:17:\"js/fontawesome.js\";s:71:\"sha384-PIP1h/CVyNo59Pr+vM6s86Zkm82HEv890eKMTpB5eqJZFZQwZuMwf73Sy5SzVrK8\";s:13:\"js/regular.js\";s:71:\"sha384-ghS5pTGfZccQRYN4cnBH4kBWGY/ePY4j4VKfFliJmM6ZYomFMIo462PxXa2RGqWR\";s:11:\"js/solid.js\";s:71:\"sha384-rKdfCFMYG2O/K+5WQDPmcKngEtAvqyIxYkazidXjp48yEiCcl//F6lxZ9cZ8MhM+\";s:14:\"js/v4-shims.js\";s:71:\"sha384-VxtQ3wW8qt0QTDld0MGEB9IMEOyCOtvOXC7I0JU3T01V6NR+C6MP5HxC+tGNkhdV\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-yJpxAFV0Ip/w63YkZfDWDTU6re/Oc3ZiVqMa97pi8uPt92y0wzeK3UFM2yQRhEom\";s:14:\"css/brands.css\";s:71:\"sha384-rsNdgxJGzM0RuTegPn4p1eHXocyvt3ZbnTifPXmOewdRLCOqzP22d/M+WxbRiwSN\";s:15:\"css/duotone.css\";s:71:\"sha384-E4/odus3ylondNThYB3uIGSZpewOhvhh0QD8x2p7S0ot6p/JcbVd//lr7cMEUIBc\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RZW433tEsVW3OLEaC2n31z0V1DmyQdjrwNKMRLBjyZQ7r4RU0PxYhkvjKCsZMCO3\";s:13:\"css/light.css\";s:71:\"sha384-oJib4m7hS3ZSiUXjFvObb+ZFf2AGOBOUX+MFk3CuBZwz8LQSe3d3EgZHHJBkJGXT\";s:15:\"css/regular.css\";s:71:\"sha384-ffFT2jJN64hGajTqkZsA2KE2SDBO2Gcmb0wr10fRLpKNDWYcl3M3KsLuzQHg5QAh\";s:13:\"css/solid.css\";s:71:\"sha384-PfqDBw8PmSrNcYq7F4SvYoZekYP2x84SYAyG41rncZdySTjSS9eWEE7ynvJRElQY\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-MeQL8xjLhct6yZa8AXEQOD0yWeV925K9YrlcgspMC+IdCbI3q1b8B7VX8NS6N3lS\";s:16:\"css/v4-shims.css\";s:71:\"sha384-vfegZgYJmcP2K/VrhAwtTtU1OgvF83Y8zoQ524YvQFIGowI3tr8C6wvpWUsSLUZA\";s:9:\"js/all.js\";s:71:\"sha384-ZbBwfM248+qoG5GJvuV2PmK9gvlW3dXpgC/jeIn45pWWroL3v+5K1ZAth+gs165y\";s:12:\"js/brands.js\";s:71:\"sha384-K53M8ZRlon+Wd3MVzcIEU1NZXEh4h98NnLM8WZ/7E98pbg0J1q17tKGgr45c5qCs\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-whZrbu3lLf9+EK7QxSHsdpAWM0drsjefOTFm3zfcUhZSInAwLaIrdOd2Qd8MKDMW\";s:13:\"js/duotone.js\";s:71:\"sha384-nTarcZNLMStpbHz1QpoaqVDyKoUrzncdV+zZ040hkinCtVKl8gTXSiyUM4h0K48M\";s:17:\"js/fontawesome.js\";s:71:\"sha384-dy2wSTcBbCGnFNjThZw/FfuNbPeoGoOSWgX7HmvH3PKcJ0Se3w3CZnalamfRuLpE\";s:11:\"js/light.js\";s:71:\"sha384-gL1IbgNyLHskDPg9uinrWBfxmDsla3neHzcEAIjbzQTx6W69Jvs9S/fRBXUt6FbW\";s:13:\"js/regular.js\";s:71:\"sha384-9JMXUFvwOD5rSQZs74FEC4SsybjccRbbwK7iiQiriFSd4sPr7pB7/ghp1KZH7tCr\";s:11:\"js/solid.js\";s:71:\"sha384-oVJ5+ellTPbci7MOrfl59xerw0M0RnQEGG0jx/JlNyOpkvrXHaZUCfKJUs08+gVi\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ht5Q/pi1VU6byhn9MctthIZ2kSBqK5GhhR9gnTzPM+BJlAyCymRS3xx74c9twxdh\";}}}s:6:\"5.15.3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-SZXxX4whJ79/gErwcOYf+zWLeJdY/qpuqC4cAa9rOGUstPomtqpuNWT9wdPEn2fk\";s:14:\"css/brands.css\";s:71:\"sha384-V5Z1KgRRJyY878qCx7+zUeTDm0FgjoYrbmSortFqRPGz+Ue6XDe4uIiMqB3tB/wd\";s:19:\"css/fontawesome.css\";s:71:\"sha384-wESLQ85D6gbsF459vf1CiZ2+rr+CsxRY0RpiF1tLlQpDnAgg6rwdsUF1+Ics2bni\";s:15:\"css/regular.css\";s:71:\"sha384-Dn9L7vwedvmbdep+J8U5Zbrp+ES46dt8pm8ZMUu9iOR9isC4+Y/KP1h4StrDd/F+\";s:13:\"css/solid.css\";s:71:\"sha384-LA8Ug4T/nhVkyhrSmSirsoAo9iDrBk8E7U80aSPeD+w3vO8PzOJIS6agGcbIwwX0\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-C4KLoR3asMHYArL0nLQXEaFZIFfRMiV0Ul0DvsMfSMZ+YLJwFu0Rpxix+EZwqxOy\";s:16:\"css/v4-shims.css\";s:71:\"sha384-C2B+KlPW+WkR0Ld9loR1x3cXp7asA0iGVodhCoJ4hwrWm/d9qKS59BGisq+2Y0/D\";s:9:\"js/all.js\";s:71:\"sha384-haqrlim99xjfMxRP6EWtafs0sB1WKcMdynwZleuUSwJR0mDeRYbhtY+KPMr+JL6f\";s:12:\"js/brands.js\";s:71:\"sha384-oEE/PrsvhwsuT1MjC4sgnz39CQ84HoPt8jwH0RLyJDdDOKulN+UEbm9IgJW0aTu5\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-OwOgf6Oss8Oh+cy6VnIGLlcyMhaaOPN+3gyLv2UyvjybuPrTNNgJljGYEAqSglUM\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hD97VKS04Rv8VYShf782apVZOVP6bVH/ubzrWXIIbKOwnD6gsDIcB29K03FL1A9J\";s:13:\"js/regular.js\";s:71:\"sha384-bPKzNk+f6IzEi89cU+jf3bwWzJQqo+U1/QYUijuD7XD9WO3MSrrAVVEglIOCo6VD\";s:11:\"js/solid.js\";s:71:\"sha384-9xA4r2/2cctd+IZZKLvI1hmeHZ5Yp8xXkS6J8inDtdyZCqhEHVcTGmSUCbNED5Ae\";s:14:\"js/v4-shims.js\";s:71:\"sha384-oJX16kNznlRQV8hvYpOXlQKGc8xQj+HgmxViFoFiQgx0jZ4QKELTQecpcx905Pkg\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-iKbFRxucmOHIcpWdX9NTZ5WETOPm0Goy0WmfyNcl52qSYtc2Buk0NCe6jU1sWWNB\";s:14:\"css/brands.css\";s:71:\"sha384-GTxp/8UKFkexlguDtPsFi90d++F9f26nZCM99OSQo69514FK7Of5mgM9Efhs5O9L\";s:15:\"css/duotone.css\";s:71:\"sha384-nuPd13VLdsw5iBtqelv9tQ6l6+CteSUrmoT5enzHVJodx7WdNUYXNwgVpA7bgsXn\";s:19:\"css/fontawesome.css\";s:71:\"sha384-DHjwMcq12OEB4DQ+qulZDDroaXZqm7h9V6AjiP/RuUF8NhxUa8x6UWdv1AeZS+90\";s:13:\"css/light.css\";s:71:\"sha384-IvEgf1JJYgCtB5fP9nmT3uC7DY96POpmhUjo/98B8FMju1w295nj5yGBfwgD3MYj\";s:15:\"css/regular.css\";s:71:\"sha384-Z3GHSXKByZgv1Ri9CiFq0jYUQ982JHZOOg4awUHcuVBjTxwNd+PVQO1/PSwChyzK\";s:13:\"css/solid.css\";s:71:\"sha384-Ymp/JSUSR6EuZ4KjxcliW8lJ7wkYBR6oasX7EMi6SG0QBPmNUDAEG9rd7Ogy0Ca/\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-n/+zO4Fk1/R4EL7q+xf44zBEgvFziVgA7BUNwfjcGjHq/X6U0v25ESHqN/l5Wprm\";s:16:\"css/v4-shims.css\";s:71:\"sha384-yV4xIIsecn1iqxJy3IC5YyRSLwtkkFuOvfPvj1hGH5NLLej9Cum4hPOUL2uQYfQ6\";s:9:\"js/all.js\";s:71:\"sha384-OF9QwbqmlzSPpIxe2GYS8lkGFyaFfrgUPD2J3qj8zGVps17Y/x8EK2U8PEl6UrpH\";s:12:\"js/brands.js\";s:71:\"sha384-5u0zCiPDAEBQPvGxnai1VRZiSs9yQmyspSLrg0Fc7ru5CeddU1cef/24itMCpcWb\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-W0jz7GGBNDbeSyOhqqJrtOVDFLX4Qlqm/5K4RqM9ZpPIZL6tmDCMkEIheypFOiSK\";s:13:\"js/duotone.js\";s:71:\"sha384-rutYU6OuFfIS5MmBE4wrpMhP633bNlRHqn/SFpcetMTKr+rsBxnoTd80mkHI7wum\";s:17:\"js/fontawesome.js\";s:71:\"sha384-hwdDrjZFQbBwoFcHZZ/6e61XHiwY9csS0Wxi8i5jUgTurxmYITntaGLFYCssX7By\";s:11:\"js/light.js\";s:71:\"sha384-soVEahH07bOeX1Nlhdi4VQ+yvDpIGN9A/qbzm/PgfDrpvh7AaCTyMkQNk1spjHbf\";s:13:\"js/regular.js\";s:71:\"sha384-GR++czVV+1briVrgT0SHxwKuKqqXqfkRb2NxZ8O4rad/c/iKIn85PDSaZQ3cjiAZ\";s:11:\"js/solid.js\";s:71:\"sha384-JwTquvZ50ZD4wvDw99MHsjx621x02jCoiXBKy103wTwDMBbDLmhRcCV4v9mq5CV4\";s:14:\"js/v4-shims.js\";s:71:\"sha384-xczhE4W0SRyRFalFfxUKqclGdqLDVnc/F118WebJIQ/QyS3XKXIHXTieQKG1rG/+\";}}}s:6:\"5.15.4\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-DyZ88mC6Up2uqS4h/KRgHuoeGwBcD4Ng9SiP4dIRy0EXTlnuz47vAwmeGwVChigm\";s:14:\"css/brands.css\";s:71:\"sha384-S5yUroXKhsCryF2hYGm7i8RQ/ThL96qmmWD+lF5AZTdOdsxChQktVW+cKP/s4eav\";s:19:\"css/fontawesome.css\";s:71:\"sha384-jLKHWM3JRmfMU0A5x5AkjWkw/EYfGUAGagvnfryNV3F9VqM98XiIH7VBGVoxVSc7\";s:15:\"css/regular.css\";s:71:\"sha384-e7wK18mMVsIpE/BDLrCQ99c7gROAxr9czDzslePcAHgCLGCRidxq1mrNCLVF2oaj\";s:13:\"css/solid.css\";s:71:\"sha384-Tv5i09RULyHKMwX0E8wJUqSOaXlyu3SQxORObAI08iUwIalMmN5L6AvlPX2LMoSE\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-meSUsKN46Q06zfndZ6zDskLd5vJrCPwgb2izpfSMfWpQLijQApceQWIsbpLy2lAF\";s:16:\"css/v4-shims.css\";s:71:\"sha384-Vq76wejb3QJM4nDatBa5rUOve+9gkegsjCebvV/9fvXlGWo4HCMR4cJZjjcF6Viv\";s:9:\"js/all.js\";s:71:\"sha384-rOA1PnstxnOBLzCLMcre8ybwbTmemjzdNlILg8O7z1lUkLXozs4DHonlDtnE7fpc\";s:12:\"js/brands.js\";s:71:\"sha384-xf4z6gHzXeY6YwFJm8AKcD9SSq8TsfF4+UJj1JxzwQHk+VNATxkknGEzmdtYV0w1\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-b4+d5l6vwWgdPDCbk4SG+VPRplFp3JtWehGqKvfat/MWON5/PSWvf0l89dpfUDUG\";s:17:\"js/fontawesome.js\";s:71:\"sha384-dPBGbj4Uoy1OOpM4+aRGfAOc0W37JkROT+3uynUgTHZCHZNMHfGXsmmvYTffZjYO\";s:13:\"js/regular.js\";s:71:\"sha384-EEuk6Tk/hsJ0IJMUp+btTmHLuWPGGIm8I3xmxRawuWaY1xqWEm3EKVdnHNlYX+6t\";s:11:\"js/solid.js\";s:71:\"sha384-/BxOvRagtVDn9dJ+JGCtcofNXgQO/CCCVKdMfL115s3gOgQxWaX/tSq5V8dRgsbc\";s:14:\"js/v4-shims.js\";s:71:\"sha384-bx00wqJq+zY9QLCMa/zViZPu1f0GJ3VXwF4GSw3GbfjwO28QCFr4qadCrNmJQ/9N\";}s:3:\"pro\";a:18:{s:11:\"css/all.css\";s:71:\"sha384-rqn26AG5Pj86AF4SO72RK5fyefcQ/x32DNQfChxWvbXIyXFePlEktwD18fEz+kQU\";s:14:\"css/brands.css\";s:71:\"sha384-Q9/9nfR6hUHbM3NjqxA59j5l/9c23JjwDDuPsV5SKplBvgLpFDtJmukyC2oCwp28\";s:15:\"css/duotone.css\";s:71:\"sha384-Zi3Yce9z7/mhFiZHlM/DEBTnheymZyqrjMoWYPP8xtNCl+LtJKnaJ0vaGnPfqc/i\";s:19:\"css/fontawesome.css\";s:71:\"sha384-ig3RKyui4sECvuz+WE8EmFYy7sjRvEvy82mmhfV7ljRieb+0f8eEZKxHv2KC0+io\";s:13:\"css/light.css\";s:71:\"sha384-zCLzLBaV9kpBZtwZ72K00PI4UjqXZhrzMeVtYGOOHqL2N5PXSVw2MtJjaWTKYDHW\";s:15:\"css/regular.css\";s:71:\"sha384-sDvgA98ePLM7diZOYxIrDEITlUxoFxdt0CPuqjdLr/w62pPuOc73uFoigWEnVpDa\";s:13:\"css/solid.css\";s:71:\"sha384-2aj01VFITmYatwqdIKc7PHVmhLqFnnkVCilBk0Uj/fGoczNJXKvV45XlyHr/HU9g\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-cHJCnE8H1fC+puOpWCd6OSOmJ1q8KxWtIm/JUpb9705KggGjyKbMzryJWJDw2OPb\";s:16:\"css/v4-shims.css\";s:71:\"sha384-sKQhO4q55X7e4nIIO+wnutVfpIITv8+QJG6hE15hThUjV3ssIxUGT4VAoAGYmOU5\";s:9:\"js/all.js\";s:71:\"sha384-8nTbev/iV1sg3ESYOAkRPRDMDa5s0sknqroAe9z4DiM+WDr1i/VKi5xLWsn87Car\";s:12:\"js/brands.js\";s:71:\"sha384-MwpSaMFXAxVGLfxKR0S/SL1BvfRLmlowKeqIE/yF7uW5ax+r1fqRs12asOCkF9Jf\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-my7QwPFkgZPqsrDx/vNCyAMQw86Ee5ZUeCUBA7CF0l9rWFcxoH+h+NdSGyYBh2pq\";s:13:\"js/duotone.js\";s:71:\"sha384-AFpIAPhppteteZyLTXU8oPEbmuNz5WwwWSVAKJxuEn51LibO/iPZ+fC5DzmLJzoo\";s:17:\"js/fontawesome.js\";s:71:\"sha384-RTs6cAeLGZoCPlBxXNxYfQnVIrvTagXGxIhrXFjWgp4i4E5urdGFLlkfbsk1Nd+L\";s:11:\"js/light.js\";s:71:\"sha384-6EhWHErkaXt19GTK7f+5rRc16ekdzvItcFycGZi1GS/AycADXj7L2tkZ9z2O71ot\";s:13:\"js/regular.js\";s:71:\"sha384-WWzdx7E114gkDQnLVS/7s5WUTa5KQUqY5D8LGqBB7y132sxhUbrIHfqde9aenKnJ\";s:11:\"js/solid.js\";s:71:\"sha384-DfpPYefTs8qX3aeMuUJxalewnmVXDDtxcIJFo+Bz1qrNTaoEwMIaZkfoWx404GvG\";s:14:\"js/v4-shims.js\";s:71:\"sha384-9lueRrgA8PnJBSmeS0/jHPFpZZ/hC/7n/XNQhCroAsZSoTtaEj6Q+ewHcpgFPqFw\";}}}s:11:\"6.0.0-beta1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-QTEmscQJYWW3qGP+JMq44fmHSM1SbRIn3hxdZ0RBhX7yzbDOmdhCzVDY/nCs7Yfh\";s:14:\"css/brands.css\";s:71:\"sha384-YxspAfDWGMmVGaoWFDjr/ceg8QdLKNj76+YDQ3iXiX1d64PMg/rVRUQMIcd7loDR\";s:19:\"css/fontawesome.css\";s:71:\"sha384-Y63uHbYQVeMm+hkTj/YJpPSWvwA7maoOgWIcH/L/Zil8zxKQNclQIgNioLyE+zQT\";s:15:\"css/regular.css\";s:71:\"sha384-3+YTU1oGJl/DJPoU+JvGaD8K0waHM6gIPSWeabncnJ1y/LzxnMdPNvXxvbJtzkH4\";s:13:\"css/solid.css\";s:71:\"sha384-SVoL9P0p4yDjJ7K7qukXf8FBr4TcwUEZpvnQv80juxlb+QtrhT0zH3Gidw6aACkN\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-bhQY/O7CPf/LJ1fFQ19Hb4zwFDg7vUCZT9GLZM4RVTzxhZCINjHGSM7VaB36hnHe\";s:16:\"css/v4-shims.css\";s:71:\"sha384-4q5P4wLQvP0vMZgsfSOPe2qSqfL+Y76J/5hi9QW1QqtZ0qdgSrcFRIv5MgSNtFX4\";s:9:\"js/all.js\";s:71:\"sha384-s6zGSTvDy4KZ4ncPlsj+2l4ATGBt+gXsKFfd4lR4QKFl2RgB4iOoqZzDkRqndbvR\";s:12:\"js/brands.js\";s:71:\"sha384-gksSOJLGNOMoFqSuS5Ki/PIhYoVzeS8bWP7Gg6b/6gY3FXNGW3ZwRY12rkFGpvz9\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-JsmVGsnClQ/8mX7vDm+8UJ9XHlqIuwxPIKrIkpXt4mJZiaeCzg/uXxY3OjB7MajC\";s:17:\"js/fontawesome.js\";s:71:\"sha384-PkZHTzZps6BUB70Jc6Ujwh17lPpgjVJlG98uCR+Dg+bsDNAHk7UbcsVq9pUY0QM5\";s:13:\"js/regular.js\";s:71:\"sha384-i/4zUQF6PMLPil02YpE9smRx7XTQ0/bwaSlMl4QZRk0yFj0PCJqkv231+5hjbcsq\";s:11:\"js/solid.js\";s:71:\"sha384-ufQzc6WFPbylIrm5F6yJOtKS4KCrT6hoEuGPNEMv+9Y2ZVmEC0Jt5Tqf25Q2hOa8\";s:14:\"js/v4-shims.js\";s:71:\"sha384-3dTEd1SkEJhxEBZpeAOJF+PzflHEdVc87NLQ1dQd1UFpZNiygckU0Ku29kJavA2Q\";}s:3:\"pro\";a:0:{}}}s:11:\"6.0.0-beta2\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:14:{s:11:\"css/all.css\";s:71:\"sha384-H8oq+jCbb0QVbhroj1DucOj59MYLAHR4vQPc0ClgJJzMS/YL7OcRJfM/ehkfKqhU\";s:14:\"css/brands.css\";s:71:\"sha384-9RVmH5wLHK5upannGNFElXHKDeCRaoz+RuosjPpGqwUmn2+p5J5IBUd0P726kTk3\";s:19:\"css/fontawesome.css\";s:71:\"sha384-m+NmQ9JGB4PGDECPUaU3EyjsUk6jyyMoM53D/n//nHSADtoSKusJc/BF/ZffIvI0\";s:15:\"css/regular.css\";s:71:\"sha384-mwb6xqj3Cg9cBoRZDNp2p4Sv49gYTCgHVLVwbErL3sJCA+RJ3Xhwq19ezzyT1KqX\";s:13:\"css/solid.css\";s:71:\"sha384-sBOgtFigRpSU/zNyZLGNKX6O+VrUJzHdITsX3+nGRutcAaSdRMmnc8LOJk8XzoDM\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-/ShrxWgDzY0RmtJK6gusdzSMS1yYysWIr6y1FFEG9B7naj2HqXMNxatmNRgmRDCx\";s:16:\"css/v4-shims.css\";s:71:\"sha384-wA6dLShvXgKngeGUYrFpv9/zgLLUtPxBL9y1OD9u5uQmeT3wWxvZVue3BO4xo4f0\";s:9:\"js/all.js\";s:71:\"sha384-vwquPQ7YyWL/EWINiNcgCpPP9Wbx44bLyI1NbrUJmEacQGGGWUzpERymaTAjvS9H\";s:12:\"js/brands.js\";s:71:\"sha384-X5eSej258z73rxsuRybt1adaWo6MobuyduuEYgYhbJMavb1jXYBhCqd1ZwRC9/7W\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-MOke50TwkELSa34Yzu6DEGxTlT3Wdn5DynHvqLANi/pFPBZxRDnFhJnD6mE/GuoP\";s:17:\"js/fontawesome.js\";s:71:\"sha384-vo5XH3GmQrg9pkTZYURBhzEXm7Xslw9fD0z49HVMvdquMGvwTiUKJP4he5iFSPot\";s:13:\"js/regular.js\";s:71:\"sha384-UDm7R3v5rW8y32ssB0WDalZIS8AztwsdQERaPBHTRLStI7Bfr/fhWLuXr5nYZG8M\";s:11:\"js/solid.js\";s:71:\"sha384-f199SbfL8tgeze5wETQ87SF+anBX6Dmf9bWZSBvW02HFz602Fqhv1u1iCnKgdbls\";s:14:\"js/v4-shims.js\";s:71:\"sha384-Teg5BVlogMJp4To5SNk5eS6Ct/+y3KN9D/UWWXr4e2JhUbT1rgnLDWGXp/TG/0a/\";}s:3:\"pro\";a:0:{}}}s:11:\"6.0.0-beta3\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-5e2ESR8Ycmos6g3gAKr1Jvwye8sW4U1u/cAKulfVJnkakCcMqhOudbtPnvJ+nbv7\";s:14:\"css/brands.css\";s:71:\"sha384-Lzg1sLP4sLS8KyVySlmRH4QzbOnIzlp/h2MYRTDkxMPKwaD+zxathmN655nRjRSG\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RAtjHVFRUZs4Tif4stxk4r1UN31mhO2m2ii67jtwlyWDXls6IDZ6/N2bHxt3bA48\";s:15:\"css/regular.css\";s:71:\"sha384-TvfVCWnd24+5zZ+qmyScSguhYpT7YtOajZ0b4IVLn3+T3dFYzXkgu/EE/Nrf2km5\";s:13:\"css/solid.css\";s:71:\"sha384-4veAyGk1Tas2qyx7CD/29iLDa8aarX6vdaWWVPD7K/m8FdvH9ae9yFNbWOxmP1hZ\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-MLxC4sgXwbw5k1vFBDb68XNAF7UdJ7e1ibhu+ySJnAakTpweYCcq7jCcQpd5nJjU\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-LJQ43yQLnfgXK8pn645vHWEmSJrVqisZaieRPj7NGV7cCzlL/B67BDv8gMRBS53i\";s:16:\"css/v4-shims.css\";s:71:\"sha384-zCIuCI9fw3QOcUPL5/7JfB3Qw6sjEimma+57eLWmHPHyVgqGmX5XLwGi3Ak5fLzQ\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-W7b35mq2oJvzl9StEqMDWhapHEgwLh3/iohOpz2RopU0+3/eOmb8eubYCz0OwUcj\";s:9:\"js/all.js\";s:71:\"sha384-6e7nA5mhBVXnMIAtGPETl10C7oipDhu2IN/lyxyjAJG+KzNtRLqrqFJN5wJ+6/qU\";s:12:\"js/brands.js\";s:71:\"sha384-zY1eKUaz/NWcOf6xnU5eePxV3anVtTTAlu33RytBcT9jGz8dstwzZbVpp2l609NT\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-rN+BHnX2WMsUD7VYL6PykWIyqG6SyEu6IdhgM42fLyWqC7JlY2k76ufmZvMFU43a\";s:17:\"js/fontawesome.js\";s:71:\"sha384-W1qlouWJA+8MQIORaSCnwNHhaPuAMwQGosDEwU/g4kkawDb4WwLy3ZWVpa/KtRXb\";s:13:\"js/regular.js\";s:71:\"sha384-Axuj5+DJ+mQA38QqwpWCujH6bCefx3brdTdN+ffhy6oxdqSvs1evxn4iX828SSe6\";s:11:\"js/solid.js\";s:71:\"sha384-9d1SM0Z1PczSHlc0bwe5j/n1kjp14H06SgMcxbmNkp6ZSQa6CqneEHKQkfVGPcR7\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ZkRpffzN60bZU7hfI/zFR3Nv603593UFKpz6QAm3FUAUqGa60uzGmuEGLB5BZNsY\";}s:3:\"pro\";a:0:{}}}s:5:\"6.0.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-3B6NwesSXE7YJlcLI9RpRqGf2p/EgVH8BgoKTaUrmKNDkHPStTQ3EyoYjCGXaOTS\";s:14:\"css/brands.css\";s:71:\"sha384-Adcde+txsvO9VVaHmK9GsiU0ps9W6rwF+IlMCjHpCeU5j18z8lenKNx6AV7OuQKy\";s:19:\"css/fontawesome.css\";s:71:\"sha384-caIQK8zI/KcZVq2HWogTcGbcxd9c0Alp2SDcy0eOHIjipClzJQ8HEkSNcoXtKq+w\";s:15:\"css/regular.css\";s:71:\"sha384-CAcRRHVEmhGr2UjS0hlffWvnfewfvVqvDJP03d3f3NctPBCvDfPMY6L8r4to10MT\";s:13:\"css/solid.css\";s:71:\"sha384-zW4IamLJkgRrzYFdEixnM4hbhScK8Q/B0aYHqhGxQf6jrj1pxNaEzS7n65YVdFsW\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-+FYTcfgXTek/jHYrY62q/wv2/QxcumMqXHB/9ZHrAwFBiACe0XD+xXBvrlpG93Qd\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-K7jXM/Fd0TzcNoMz1bK2/PRaJLYkgynKTlUyKXatOFEovvEO1Zownee30wS0rxq4\";s:16:\"css/v4-shims.css\";s:71:\"sha384-Mo3tUbn02WJ1eXNOTbemz64sjSQx9PEUk4o3BJbDNrfhSAfbPobKWeqYpV3xkTBC\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-iYWocEeLglluGxouLD/E0jzilCIbE6LTAKof7ZPB7/YSAogAA6bLTJyo2T98POzn\";s:9:\"js/all.js\";s:71:\"sha384-l+HksIGR+lyuyBo1+1zCBSRt6v4yklWu7RbG0Cv+jDLDD9WFcEIwZLHioVB4Wkau\";s:12:\"js/brands.js\";s:71:\"sha384-ZCobqGyWQ2Qg///QRAi+jqRlO/9aWmMHd6tb0emtG9QBX9t77I71IHg19T90mlfk\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-5v1FR2qOT+wEONoibSzBiWIvpXEOyyRuvOtNOfwijR3h4K7tg12vL4TNx4iSsQWX\";s:17:\"js/fontawesome.js\";s:71:\"sha384-pULjvYk4ZbCHxvgkOUhY3s6wbSkRp/9WHqh+NdM+FkmDQsdJeg2XyOHSEQ0AZlr4\";s:13:\"js/regular.js\";s:71:\"sha384-7XHlSs/t85udVElMnHlVDct1GXjA01UIyQLQRbYc3bxChziaGT776dBUgqd/o82r\";s:11:\"js/solid.js\";s:71:\"sha384-IWq2srnodX6Z+US+NFdwALHXDvdogKkBx7sUMzfypASSeqsNzF+gAS48WnkPcYbf\";s:14:\"js/v4-shims.js\";s:71:\"sha384-ybkuz/OxDnyDU81HhdheMi5FjVHdKkPPnnfX2H5pClfR9x+aAMkenwEbVe0AdPt9\";}s:3:\"pro\";a:0:{}}}s:5:\"6.1.0\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-eLT4eRYPHTmTsFGFAzjcCWX+wHfUInVWNm9YnwpiatljsZOwXtwV2Hh6sHM6zZD9\";s:14:\"css/brands.css\";s:71:\"sha384-E8UvjEv9HnIyjcD0D2Nfr/M7y5wA7GK+DoLhh5Sbfd0MtCSpdREBn8Wc/SdeaBDA\";s:19:\"css/fontawesome.css\";s:71:\"sha384-RLM8Rxp/DcBfCfSI3bGwwoMMxxy34D2e58WAqXmmdnh0WYlAQ8jeOB3A1ed5KUSm\";s:15:\"css/regular.css\";s:71:\"sha384-luZMTbX5lx1yPkwYfjdCtbXx2AL3j1H+ffZ1LJSuxepC2TKyGzv3zkgftThS/BDN\";s:13:\"css/solid.css\";s:71:\"sha384-ltWlpN+Dl8XfKEnC9oW+dDRF8Z7jsYkxQ/WMRoJ2VHH5G2nQZ4if2NWwmV0ybzZ7\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-gLJsqV+iGZdsakTXDecPQLbmHTTUB6vIJ2ukjLJTPa+YXsdHu5alOSYZZTagrVSG\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-WTcUA4jr+YtMif40YOsaoMazuo9cigaWqC7Vrj6PjPzPt/VegPK08OEyRvvIauzD\";s:16:\"css/v4-shims.css\";s:71:\"sha384-k1PPow2i4/GbflsJCusORB91wBmXUDdw6pOkXu2vQWXIsmLbIL0t/aA7FroyJf1r\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-SXOfPW9HC6/r4BP4QoUVZNVol9D+ncClNpAseJsRONb9L1F7QgV6ltEXcLnYJv9H\";s:9:\"js/all.js\";s:71:\"sha384-vLLEq/Un/eZFmXAu4Xxf8F00RSSMzPcI7iDiT6hpB4zFpezCEGhb5daeR8PLyrLI\";s:12:\"js/brands.js\";s:71:\"sha384-cNUzI2P088AN66Vx9jSolJDKuj/ZWgTtbwYleQo9MedrXul9DrmthXUDN2iFVk9u\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-te3/sj8uC87v52yVrB6zr3Fm5m0AyGLAHYUIx853+yLbLffUUfXrdztSp/yFACrc\";s:17:\"js/fontawesome.js\";s:71:\"sha384-n82ItqkVbr/bDMKi4caJ2ZLCgihjr3y0aF69FTVAfwQmyFRVucR9QvBKz7DliBNY\";s:13:\"js/regular.js\";s:71:\"sha384-/wcH7fFePVuXUD0zgIUKgQwvWV21321nbGpvX01SjmZ01yE/n68/Wp8rBxpsKI/+\";s:11:\"js/solid.js\";s:71:\"sha384-A4ZBrBkKFVj3yXr0kIOFHs3vCQDJSHAU9OiRxm9X42e+amWJl68HpDCbONxiMp12\";s:14:\"js/v4-shims.js\";s:71:\"sha384-WqC1w5exlfB7/5UiHTZp/YAnoS9Ovlzh55EwGjzaMxZZtL1omDGlh7KehDlpgKUr\";}s:3:\"pro\";a:0:{}}}s:5:\"6.1.1\";a:1:{s:3:\"sri\";a:2:{s:4:\"free\";a:16:{s:11:\"css/all.css\";s:71:\"sha384-/frq1SRXYH/bSyou/HUp/hib7RVN1TawQYja658FEOodR/FQBKVqT9Ol+Oz3Olq5\";s:14:\"css/brands.css\";s:71:\"sha384-GjGxypaJovIS9KvmJ0F1G5aXPEfMvk9dMgnwAAw7UOfX7zTQZMapUiXX/+8HlctD\";s:19:\"css/fontawesome.css\";s:71:\"sha384-zIaWifL2YFF1qaDiAo0JFgsmasocJ/rqu7LKYH8CoBEXqGbb9eO+Xi3s6fQhgFWM\";s:15:\"css/regular.css\";s:71:\"sha384-i84Ve3MkmiZYhWmYDjLPpHYYvg36qy5F11ipncNWsQMTrwZ8nGSSX3Q2QnmwEGdR\";s:13:\"css/solid.css\";s:71:\"sha384-DhmF1FmzR9+RBLmbsAts3Sp+i6cZMWQwNTRsew7pO/e4gvzqmzcpAzhDIwllPonQ\";s:19:\"css/svg-with-js.css\";s:71:\"sha384-ET/prSuhSJFD66MbC3j2l1MrZtW8jdamNc+wmMcmh804U+5Isyo29kVkPjr+4+9P\";s:20:\"css/v4-font-face.css\";s:71:\"sha384-DPkhMKJRq9+6LzxVlr0poYa5+EQVr/onntse7iwk6coJonLqzoCBzSKF6ccKoXRm\";s:16:\"css/v4-shims.css\";s:71:\"sha384-4Jczmr1SlicmtiAiHGxwWtSzLJAS97HzJsKGqfC0JtZktLrPXIux1u6GJNVRRqiN\";s:20:\"css/v5-font-face.css\";s:71:\"sha384-QmV/KObe6h/Mb8GC5urJmE9hmFaZDtdnqpCUz9P9nDHFgMeDXyI6IARqnuDRkYu1\";s:9:\"js/all.js\";s:71:\"sha384-xBXmu0dk1bEoiwd71wOonQLyH+VpgR1XcDH3rtxrLww5ajNTuMvBdL5SOiFZnNdp\";s:12:\"js/brands.js\";s:71:\"sha384-jUDsa+5FKZnKIWUpGkvYZHGEx5UxPEu6XJtEMH9ZGXZZkUNVWX1vs+a51vHKs3EY\";s:24:\"js/conflict-detection.js\";s:71:\"sha384-SgqpzfPaFrGdMcCtSUb4dAD1aDr5a93AfPBL+tk14acF93aGDvasqDcPFbHe24pS\";s:17:\"js/fontawesome.js\";s:71:\"sha384-9zErGp+biBilRrlpD1l3ExnaqXc8QLITlNpGtb4OL6W1JChl0wwmDNs4U/0UA8L8\";s:13:\"js/regular.js\";s:71:\"sha384-5ZhDHsI9yoa8E6DaGJCLj2Lgi8w4KE42IQi4jvmqYVCaza4Iqi8/hSniWspK7fUs\";s:11:\"js/solid.js\";s:71:\"sha384-KPytPVc+hwHwX9HXl4tA7SWJ0Sob6StzjVRoxC4Q4U0JgXujpuVrkBxR0Hsf8A25\";s:14:\"js/v4-shims.js\";s:71:\"sha384-lUDzd+x9AFWWpLYlM0ZCD+x586cN20gzVDrjHh8HUz22j1QwqTKQGkmd64bfBeZi\";}s:3:\"pro\";a:0:{}}}}}}","no"),
("11576","font-awesome","a:8:{s:6:\"usePro\";b:0;s:10:\"technology\";s:7:\"webfont\";s:14:\"pseudoElements\";b:1;s:8:\"kitToken\";N;s:8:\"apiToken\";b:0;s:7:\"version\";s:6:\"5.14.0\";s:6:\"compat\";b:1;s:11:\"dataVersion\";i:4;}","yes"),
("11593","woocommerce_downloads_redirect_fallback_allowed","no","no"),
("11595","woocommerce_attribute_lookup_direct_updates","no","yes"),
("11596","woocommerce_merchant_email_notifications","no","no"),
("11597","woocommerce_analytics_enabled","yes","yes"),
("11598","woocommerce_paypal_settings","a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:120:\"Trả thông qua Paypal; bạn có thể thanh toán với thẻ tín dụng nếu bạn không có tài khoản PayPal.\";s:5:\"email\";s:27:\"info.giuseart.com@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:27:\"info.giuseart.com@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:3:\"yes\";}","yes"),
("11599","woocommerce_inbox_variant_assignment","4","yes"),
("11611","woocommerce_task_list_hidden_lists","a:1:{i:0;s:5:\"setup\";}","yes"),
("11612","wc_remote_inbox_notifications_wca_updated","","no"),
("11615","wc_remote_inbox_notifications_stored_state","O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:0;s:22:\"there_are_now_products\";b:1;}","no"),
("11640","woocommerce_admin_version","3.3.2","yes"),
("11672","woocommerce_task_list_tracked_completed_tasks","a:5:{i:0;s:13:\"store_details\";i:1;s:8:\"products\";i:2;s:8:\"payments\";i:3;s:8:\"purchase\";i:4;s:14:\"store_creation\";}","yes"),
("11673","woocommerce_task_list_completed_lists","a:2:{i:0;s:8:\"extended\";i:1;s:19:\"extended_two_column\";}","yes"),
("11686","woocommerce_refund_returns_page_id","3201","yes"),
("11691","woocommerce_cod_settings","a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:35:\"Trả tiền mặt khi nhận hàng\";s:11:\"description\";s:33:\"Trả tiền mặt khi giao hàng\";s:12:\"instructions\";s:33:\"Trả tiền mặt khi giao hàng\";s:18:\"enable_for_methods\";a:0:{}s:18:\"enable_for_virtual\";s:3:\"yes\";}","yes"),
("11692","woocommerce_cheque_settings","a:4:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:22:\"Kiểm tra thanh toán\";s:11:\"description\";s:187:\"Vui lòng gửi chi phiếu của bạn đến Tên cửa hàng, Đường của cửa hàng, Thị trấn của cửa hàng, Bang / Hạt của cửa hàng, Mã bưu điện cửa hàng.\";s:12:\"instructions\";s:0:\"\";}","yes"),
("11693","woocommerce_bacs_settings","a:11:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:28:\"Chuyển khoản ngân hàng\";s:11:\"description\";s:226:\"Thực hiện thanh toán vào ngay tài khoản ngân hàng của chúng tôi. Vui lòng sử dụng Mã đơn hàng của bạn trong phần Nội dung thanh toán. Đơn hàng sẽ đươc giao sau khi tiền đã chuyển.\";s:12:\"instructions\";s:0:\"\";s:15:\"account_details\";s:0:\"\";s:12:\"account_name\";s:0:\"\";s:14:\"account_number\";s:0:\"\";s:9:\"sort_code\";s:0:\"\";s:9:\"bank_name\";s:0:\"\";s:4:\"iban\";s:0:\"\";s:3:\"bic\";s:0:\"\";}","yes"),
("11694","woocommerce_attribute_lookup_enabled","yes","yes"),
("11697","woocommerce_gateway_order","a:4:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;s:6:\"paypal\";i:3;}","yes"),
("16599","flatsome_wupdates","a:1:{s:6:\"errors\";a:1:{i:0;s:193:\"The purchase code is already registered on another site. Please go to <a href=\"https://account.uxthemes.com\" target=\"_blank\" rel=\"noopener noreferrer\">your account</a> and manage your licenses.\";}}","yes"),
("16600","flatsome_update_cache","a:2:{s:12:\"last_checked\";i:1698655711;s:7:\"version\";s:6:\"3.15.5\";}","yes"),
("16654","woocommerce_task_list_prompt_shown","1","yes"),
("16793","woocommerce_admin_last_orders_milestone","1","yes"),
("36266","wpseo-gsc-refresh_token","1//0e_tEAAUMj9pRCgYIARAAGA4SNwF-L9IrnexChXR8GudG40DZIvY84SY-s-TDmRNoRVnE7uJpUCG1nT90N1h8_4L887u6goy7TQQ","yes"),
("36267","wpseo-gsc-access_token","a:5:{s:13:\"refresh_token\";s:103:\"1//0e_tEAAUMj9pRCgYIARAAGA4SNwF-L9IrnexChXR8GudG40DZIvY84SY-s-TDmRNoRVnE7uJpUCG1nT90N1h8_4L887u6goy7TQQ\";s:12:\"access_token\";s:228:\"ya29.A0AVA9y1vL8A2XvK9NR9Q5dxKulXbNJZsUeXtnVZZcfXrZIW8Dy2v57GXVeeMzWAcvc2i2P2DvMqueQ43cbnLPBvOtnShLKsGRTPDMdyuakf2pBDQ2UFFA1pQanWZkB-4FkkgkoExY75le1c9nahMzVh9XvIOpdawYUNnWUtBVEFTQVRBU0ZRRTY1ZHI4NnB4UTNmREpiamhBQXowTlpzSzRLZw0166\";s:7:\"expires\";i:1658614815;s:10:\"expires_in\";i:3599;s:7:\"created\";i:1658586016;}","yes"),
("36269","wpseo-gsc","a:1:{s:7:\"profile\";s:18:\"https://antam.net/\";}","yes"),
("36272","wpseo_gsc_issues_counts","a:0:{}","yes"),
("36298","woocommerce_task_list_reminder_bar_hidden","yes","yes"),
("46909","user_count","1","no"),
("51334","_transient_woocommerce_webhook_ids_status_active","a:0:{}","yes"),
("51335","_transient_wc_attribute_taxonomies","a:4:{i:0;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:10:\"dung-luong\";s:15:\"attribute_label\";s:13:\"Dung lượng\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"1\";}i:1;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"2\";s:14:\"attribute_name\";s:7:\"mau-sac\";s:15:\"attribute_label\";s:10:\"Màu sắc\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"1\";}i:2;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"3\";s:14:\"attribute_name\";s:10:\"trang-thai\";s:15:\"attribute_label\";s:13:\"Trạng thái\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"1\";}i:3;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"4\";s:14:\"attribute_name\";s:7:\"xuat-xu\";s:15:\"attribute_label\";s:11:\"Xuất xứ\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"1\";}}","yes"),
("51341","_transient_jetpack_autoloader_plugin_paths","a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}","yes"),
("51369","_transient_devvn_add_cmt_count_review_32961","a:0:{}","yes"),
("51370","_transient_devvn_add_cmt_count_review_32962","a:0:{}","yes"),
("51371","_transient_devvn_add_cmt_count_review_32963","a:0:{}","yes"),
("51372","_transient_devvn_add_cmt_count_review_32964","a:0:{}","yes"),
("51373","_transient_devvn_add_cmt_count_review_32965","a:0:{}","yes"),
("51374","_transient_devvn_add_cmt_count_review_32960","a:0:{}","yes"),
("51377","_transient_shipping-transient-version","1658294785","yes"),
("51380","_transient_devvn_add_cmt_count_review_33011","a:0:{}","yes"),
("51381","_transient_devvn_add_cmt_count_review_33012","a:0:{}","yes"),
("51382","_transient_devvn_add_cmt_count_review_33013","a:0:{}","yes"),
("51383","_transient_devvn_add_cmt_count_review_33014","a:0:{}","yes"),
("51384","_transient_devvn_add_cmt_count_review_33015","a:0:{}","yes"),
("51385","_transient_devvn_add_cmt_count_review_33010","a:0:{}","yes"),
("51413","_transient_woocommerce_reports-transient-version","1698506855","yes"),
("51439","_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs","1699178487","no"),
("51440","_transient_woocommerce_admin_remote_inbox_notifications_specs","a:63:{s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:118:\"https://woocommerce.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:135:\"https://woocommerce.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:251:\"WooCommerce Shipping & Tax helps get your store \"ready to sell\" as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:17:25\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:391:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:148:\"https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:47:\"woocommerce-payments-august-2022-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"Action required: Please update WooCommerce Payments\";s:7:\"content\";s:213:\"An updated secure version of WooCommerce Payments is available – please ensure that you’re using the latest patch version. For more information on what action you need to take, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:9:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:44:17\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"3.9\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"4.5.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.1\";}}}s:46:\"woocommerce-payments-august-2022-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-payments-august-2022-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"WooCommerce Payments has been automatically updated\";s:7:\"content\";s:265:\"You’re now running the latest secure version of WooCommerce Payments. We’ve worked with the WordPress Plugins team to deploy a security update to stores running WooCommerce Payments (version 3.9 to 4.5). For further information, please review the article below.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:96:\"https://developer.woocommerce.com/2022/08/09/woocommerce-payments-3-9-4-4-5-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-08-09 14:41:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:47:\"woocommerce-payments-august-2022-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.1\";}}}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:155:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:143:\"https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:178:\"https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woopay-beta-merchantrecruitment-short-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:64:\"woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:161:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:36\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:20\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test A\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 00:01:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTB\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test B\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 20:58:43\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test C\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:03:33\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test D\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:32:09\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-activate-button-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:72:\"woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:169:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:18:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:45:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:44:\"woocommerce-WCstripe-May-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-WCstripe-May-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your store requires a security update for the WooCommerce Stripe plugin</strong>. Please update the WooCommerce Stripe plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCStripe-May-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCStripe-May-2023-updated-needed-Plugin-Settings-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-31 19:54:10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.1\";}}}s:47:\"woocommerce-WCPayments-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-WCPayments-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Security update of WooCommerce Payments\";s:7:\"content\";s:187:\"<strong>Your store requires a security update for the WooCommerce Payments plugin</strong>. Please update the WooCommerce Payments plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"woocommerce-WCPayments-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woocommerce-WCPayments-June-2023-updated-needed-Dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:20:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:52\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.2.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.9.1\";}}}s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Subscriptions\";s:7:\"content\";s:197:\"<strong>Your store requires a security update for the WooCommerce Subscriptions plugin</strong>. Please update the WooCommerce Subscriptions plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCSubscriptions-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCSubscriptions-June-2023-updated-needed-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.1.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.1.2\";}}}s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: Security update of WooCommerce Returns and Warranty Requests extension\";s:7:\"content\";s:270:\"<strong>Your store requires a security update for the Returns and Warranty Requests extension</strong>.  Please update to the latest version of the WooCommerce Returns and Warranty Requests extension immediately to address a potential vulnerability discovered on May 31.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-02 23:53:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-warranty\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.1.8\";}}}s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:65:\"Action required: Security update of WooCommerce One Page Checkout\";s:7:\"content\";s:232:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce One Page Checkout extension</strong>. The fix for this vulnerability was released for this extension on June 13th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-21 14:05:46\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:29:\"woocommerce-one-page-checkout\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.4.0\";}}}s:40:\"woocommerce-WCGC-July-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce GoCardless Extension\";s:7:\"content\";s:205:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce GoCardless extension</strong>. The fix for this vulnerability was released on July 4th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-04 15:36:07\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:30:\"woocommerce-gateway-gocardless\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.5.6\";}}}s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Scheduled FedEx API outage — July 2023\";s:7:\"content\";s:277:\"On July 16 there will be a full outage of the FedEx API from 04:00 to 08:00 AM UTC. Due to planned maintenance by FedEx, you\'ll be unable to provide FedEx shipping rates during this time. Follow the link below for more information and recommendations on how to minimize impact.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:125:\"https://woocommerce.com/document/fedex/?utm_medium=product&utm_source=inbox_note&utm_campaign=learn-more#july-2023-api-outage\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-05 18:19:17\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-shipping-fedex\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-07-17 00:00:00\";}}}s:35:\"wcship-2023-07-hazmat-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wcship-2023-07-hazmat-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: USPS HAZMAT compliance update for WooCommerce Shipping & Tax extension\";s:7:\"content\";s:251:\"<strong>Your store requires an update for the WooCommerce Shipping extension</strong>. Please update to the latest version of the WooCommerce Shipping &amp; Tax extension immediately to ensure compliance with new USPS HAZMAT rules currently in effect.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"plugin-list\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:23:\"admin.php?page=wc-admin\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-11 20:26:59\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-services\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.3.0\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Action required: Security update for WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your shop requires an important security update for the  WooCommerce Stripe plugin</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.2\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}}}s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:144:\"<strong>Your store has been updated to the latest secure version of the WooCommerce Stripe plugin</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}s:46:\"woocommerce-WooPayments-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WooPayments-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:78:\"Action required: Security update for WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:201:\"<strong>Your shop requires an important security update for the WooPayments (WooCommerce Payments) extension</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:46:\"woocommerce-WooPayments-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.8.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"6.2.1\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}}}s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:60:\"Security update of WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:147:\"<strong>Your store has been updated to the more secure version of WooPayments (WooCommerce Payments)</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:13\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}s:24:\"avalara_q3-2023_noAvaTax\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"avalara_q3-2023_noAvaTax\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Automatically calculate VAT in real time\";s:7:\"content\";s:284:\"Take the effort out of determining tax rates and sell confidently across borders with automated tax management from Avalara AvaTax— including built-in VAT calculation when you sell into or across the EU and UK. Save time and stay compliant when you let Avalara do the heavy lifting.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"avalara_q3-2023_noAvaTax\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Automate my sales tax\";}}s:3:\"url\";s:131:\"https://woocommerce.com/products/woocommerce-avatax/?utm_source=inbox_note&utm_medium=product&utm_campaign=avalara_q3-2023_noAvaTax\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-08 22:32:23\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-08-09 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-avatax\";}}}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:30;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:100;s:9:\"operation\";s:1:\">\";}}}s:38:\"woo-activation-survey-blockers-22AUG23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:38:\"woo-activation-survey-blockers-22AUG23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"How can we help you get that first sale?\";s:7:\"content\";s:211:\"Your feedback is vital. Please take a minute to share your experience of setting up your new store and whether anything is preventing you from making those first few sales. Together, we can make Woo even better!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woo-activation-survey-blockers-survey-button-22AUG23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Take our short survey\";}}s:3:\"url\";s:54:\"https://woocommerce.survey.fm/getting-started-with-woo\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-22 15:54:58\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\"<=\";s:4:\"days\";i:30;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";i:0;}}}s:44:\"woocommerce-usermeta-Sept2023-productvendors\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Your store requires a security update\";s:7:\"content\";s:339:\"<strong>Your shop needs an update to address a vulnerability in WooCommerce.</strong> The fix was released on Sept 15. Please update WooCommerce to the latest version immediately. <a href=\"https://developer.woocommerce.com/2023/09/16/woocommerce-vulnerability-reintroduced-from-7-0-1/\" />Read our developer update</a> for more information.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:11:\"plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-09-20 00:50:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-product-vendors\";}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"8.1.1\";}}}s:55:\"wc_com_in_person_payments_card_sale_US_inbox_note_q4_23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:55:\"wc_com_in_person_payments_card_sale_US_inbox_note_q4_23\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Save 35% on a WooPayments card reader\";s:7:\"content\";s:310:\"Have you been thinking about selling your products or services in person? Now’s the perfect time to do so, as we’re discounting our M2 card readers by 35%! Securely process payments wherever your business takes you, with full store and inventory sync. Don’t miss out — this offer ends October 29, 2023.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"wc_com_in_person_payments_card_sale_US_inbox_note_q4_23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:8:\"Save 35%\";}}s:3:\"url\";s:158:\"https://woocommerce.com/products/m2-card-reader/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_com_in_person_payments_card_sale_US_inbox_note_q4_23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-13 00:05:39\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-10-29 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:10;s:9:\"operation\";s:1:\">\";}}}s:55:\"wc_com_in_person_payments_card_sale_UK_inbox_note_q4_23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:55:\"wc_com_in_person_payments_card_sale_UK_inbox_note_q4_23\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Save 35% on a WooPayments card reader\";s:7:\"content\";s:318:\"Have you been thinking about selling your products or services in person? Now’s the perfect time to do so, as we’re discounting our WisePad 3 card readers by 35%! Securely process payments wherever your business takes you, with full store and inventory sync. Don’t miss out — this offer ends 29th October 2023.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"wc_com_in_person_payments_card_sale_UK_inbox_note_q4_23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:8:\"Save 35%\";}}s:3:\"url\";s:164:\"https://woocommerce.com/products/wisepad3-card-reader/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_com_in_person_payments_card_sale_UK_inbox_note_q4_23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-13 00:05:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-10-29 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"UK\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:10;s:9:\"operation\";s:1:\">\";}}}s:55:\"wc_com_in_person_payments_card_sale_CA_inbox_note_q4_23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:55:\"wc_com_in_person_payments_card_sale_CA_inbox_note_q4_23\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Save 35% on a WooPayments card reader\";s:7:\"content\";s:317:\"Have you been thinking about selling your products or services in person? Now’s the perfect time to do so, as we’re discounting our WisePad 3 card readers by 35%! Securely process payments wherever your business takes you, with full store and inventory sync. Don’t miss out — this offer ends October 29, 2023.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"wc_com_in_person_payments_card_sale_CA_inbox_note_q4_23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:8:\"Save 35%\";}}s:3:\"url\";s:164:\"https://woocommerce.com/products/wisepad3-card-reader/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_com_in_person_payments_card_sale_CA_inbox_note_q4_23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-13 00:05:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-10-29 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:10;s:9:\"operation\";s:1:\">\";}}}s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Security update for WooCommerce Stripe Gateway\";s:7:\"content\";s:201:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce Stripe Gateway</strong>. The fix for this vulnerability was released on October 17. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:36:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-18 00:01:58\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.5.4\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.6\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.9.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.0.2\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.1.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.2.2\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.3.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.4.6\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.7.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.8.3\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.9.3\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.0.5\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.1.3\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.3.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.4.3\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.5.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.6.1\";}}}s:23:\"wc_admin_WooPay_Q4_2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:23:\"wc_admin_WooPay_Q4_2023\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Convert more sales with our fastest checkout yet\";s:7:\"content\";s:258:\"Enable WooPay and offer the only single-click checkout experience built by Woo, for Woo. Give shoppers the power to pay instantly and securely speed through checkout, even if it\'s their first visit. Add it for free with one tap in your WooPayments dashboard.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:23:\"wc_admin_WooPay_Q4_2023\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Get started today\";}}s:3:\"url\";s:141:\"https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_admin_WooPay_Q4_2023\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:10:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-27 17:20:29\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-11-03 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:10;s:9:\"operation\";s:1:\">\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:7;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:8;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}i:9;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:15:\"data.account_id\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:21:\"acct_1LTAQF2EovLjg4D0\";s:7:\"default\";b:0;}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:15:\"data.account_id\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:21:\"acct_1LT92K2EF8r2i5A2\";s:7:\"default\";b:0;}}}}}}","no");

INSERT INTO `wp_options` VALUES 
("51522","_transient_product_query-transient-version","1698504685","yes"),
("51523","_transient_product-transient-version","1690964024","yes"),
("51528","_transient_devvn_add_cmt_count_review_33161","a:0:{}","yes"),
("51529","_transient_devvn_add_cmt_count_review_33162","a:0:{}","yes"),
("51530","_transient_devvn_add_cmt_count_review_33163","a:0:{}","yes"),
("51531","_transient_devvn_add_cmt_count_review_33164","a:0:{}","yes"),
("51532","_transient_devvn_add_cmt_count_review_33165","a:0:{}","yes"),
("51533","_transient_devvn_add_cmt_count_review_33160","a:0:{}","yes"),
("51547","_transient_devvn_add_cmt_count_review_32931","a:0:{}","yes"),
("51548","_transient_devvn_add_cmt_count_review_32932","a:0:{}","yes"),
("51549","_transient_devvn_add_cmt_count_review_32933","a:0:{}","yes"),
("51550","_transient_devvn_add_cmt_count_review_32934","a:0:{}","yes"),
("51551","_transient_devvn_add_cmt_count_review_32935","a:0:{}","yes"),
("51552","_transient_devvn_add_cmt_count_review_32930","a:0:{}","yes"),
("51741","_transient_devvn_add_cmt_count_review_33051","a:0:{}","yes"),
("51742","_transient_devvn_add_cmt_count_review_33052","a:0:{}","yes"),
("51743","_transient_devvn_add_cmt_count_review_33053","a:0:{}","yes"),
("51744","_transient_devvn_add_cmt_count_review_33054","a:0:{}","yes"),
("51745","_transient_devvn_add_cmt_count_review_33055","a:0:{}","yes"),
("51746","_transient_devvn_add_cmt_count_review_33050","a:0:{}","yes"),
("51990","_transient_devvn_add_cmt_count_review_32761","a:0:{}","yes"),
("51991","_transient_devvn_add_cmt_count_review_32762","a:0:{}","yes"),
("51992","_transient_devvn_add_cmt_count_review_32763","a:0:{}","yes"),
("51993","_transient_devvn_add_cmt_count_review_32764","a:0:{}","yes"),
("51994","_transient_devvn_add_cmt_count_review_32765","a:0:{}","yes"),
("51995","_transient_devvn_add_cmt_count_review_32760","a:0:{}","yes"),
("52008","_transient_devvn_add_cmt_count_review_32711","a:0:{}","yes"),
("52009","_transient_devvn_add_cmt_count_review_32712","a:0:{}","yes"),
("52010","_transient_devvn_add_cmt_count_review_32713","a:0:{}","yes"),
("52011","_transient_devvn_add_cmt_count_review_32714","a:0:{}","yes"),
("52012","_transient_devvn_add_cmt_count_review_32715","a:0:{}","yes"),
("52013","_transient_devvn_add_cmt_count_review_32710","a:0:{}","yes"),
("52027","_transient_devvn_add_cmt_count_review_32981","a:0:{}","yes"),
("52028","_transient_devvn_add_cmt_count_review_32982","a:0:{}","yes"),
("52029","_transient_devvn_add_cmt_count_review_32983","a:0:{}","yes"),
("52030","_transient_devvn_add_cmt_count_review_32984","a:0:{}","yes"),
("52031","_transient_devvn_add_cmt_count_review_32985","a:0:{}","yes"),
("52032","_transient_devvn_add_cmt_count_review_32980","a:0:{}","yes"),
("52100","_transient_devvn_add_cmt_count_review_21331","a:0:{}","yes"),
("52101","_transient_devvn_add_cmt_count_review_21332","a:0:{}","yes"),
("52102","_transient_devvn_add_cmt_count_review_21333","a:0:{}","yes"),
("52103","_transient_devvn_add_cmt_count_review_21334","a:0:{}","yes"),
("52104","_transient_devvn_add_cmt_count_review_21335","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"9\";s:15:\"comment_post_ID\";s:4:\"2133\";s:14:\"comment_author\";s:11:\"ninhbinhweb\";s:20:\"comment_author_email\";s:27:\"info.giuseart.com@gmail.com\";s:18:\"comment_author_url\";s:17:\"https://antam.net\";s:17:\"comment_author_IP\";s:12:\"27.71.81.210\";s:12:\"comment_date\";s:19:\"2020-07-31 23:02:45\";s:16:\"comment_date_gmt\";s:19:\"2020-07-31 16:02:45\";s:15:\"comment_content\";s:24:\"San pham tots gia hop ly\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52105","_transient_devvn_add_cmt_count_review_21330","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"9\";s:15:\"comment_post_ID\";s:4:\"2133\";s:14:\"comment_author\";s:11:\"ninhbinhweb\";s:20:\"comment_author_email\";s:27:\"info.giuseart.com@gmail.com\";s:18:\"comment_author_url\";s:17:\"https://antam.net\";s:17:\"comment_author_IP\";s:12:\"27.71.81.210\";s:12:\"comment_date\";s:19:\"2020-07-31 23:02:45\";s:16:\"comment_date_gmt\";s:19:\"2020-07-31 16:02:45\";s:15:\"comment_content\";s:24:\"San pham tots gia hop ly\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52130","_transient_devvn_add_cmt_count_review_32481","a:0:{}","yes"),
("52131","_transient_devvn_add_cmt_count_review_32482","a:0:{}","yes"),
("52132","_transient_devvn_add_cmt_count_review_32483","a:0:{}","yes"),
("52133","_transient_devvn_add_cmt_count_review_32484","a:0:{}","yes"),
("52134","_transient_devvn_add_cmt_count_review_32485","a:0:{}","yes"),
("52135","_transient_devvn_add_cmt_count_review_32480","a:0:{}","yes"),
("52143","_transient_devvn_add_cmt_count_review_32621","a:0:{}","yes"),
("52144","_transient_devvn_add_cmt_count_review_32622","a:0:{}","yes"),
("52145","_transient_devvn_add_cmt_count_review_32623","a:0:{}","yes"),
("52146","_transient_devvn_add_cmt_count_review_32624","a:0:{}","yes"),
("52147","_transient_devvn_add_cmt_count_review_32625","a:0:{}","yes"),
("52148","_transient_devvn_add_cmt_count_review_32620","a:0:{}","yes"),
("52156","_transient_devvn_add_cmt_count_review_32441","a:0:{}","yes"),
("52157","_transient_devvn_add_cmt_count_review_32442","a:0:{}","yes"),
("52158","_transient_devvn_add_cmt_count_review_32443","a:0:{}","yes"),
("52159","_transient_devvn_add_cmt_count_review_32444","a:0:{}","yes"),
("52160","_transient_devvn_add_cmt_count_review_32445","a:0:{}","yes"),
("52161","_transient_devvn_add_cmt_count_review_32440","a:0:{}","yes"),
("52174","_transient_devvn_add_cmt_count_review_19421","a:0:{}","yes"),
("52175","_transient_devvn_add_cmt_count_review_19422","a:0:{}","yes"),
("52176","_transient_devvn_add_cmt_count_review_19423","a:0:{}","yes"),
("52177","_transient_devvn_add_cmt_count_review_19424","a:0:{}","yes"),
("52178","_transient_devvn_add_cmt_count_review_19425","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"4\";s:15:\"comment_post_ID\";s:4:\"1942\";s:14:\"comment_author\";s:12:\"khách hàng\";s:20:\"comment_author_email\";s:20:\"khuong3012@gmail.com\";s:18:\"comment_author_url\";s:0:\"\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-26 08:46:20\";s:16:\"comment_date_gmt\";s:19:\"2018-03-26 01:46:20\";s:15:\"comment_content\";s:27:\"Hàng tốt cảm ơn bạn\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"0\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52179","_transient_devvn_add_cmt_count_review_19420","a:2:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"4\";s:15:\"comment_post_ID\";s:4:\"1942\";s:14:\"comment_author\";s:12:\"khách hàng\";s:20:\"comment_author_email\";s:20:\"khuong3012@gmail.com\";s:18:\"comment_author_url\";s:0:\"\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-26 08:46:20\";s:16:\"comment_date_gmt\";s:19:\"2018-03-26 01:46:20\";s:15:\"comment_content\";s:27:\"Hàng tốt cảm ơn bạn\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"0\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}i:1;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"3\";s:15:\"comment_post_ID\";s:4:\"1942\";s:14:\"comment_author\";s:5:\"admin\";s:20:\"comment_author_email\";s:20:\"khuong3012@gmail.com\";s:18:\"comment_author_url\";s:30:\"http://hungyen.thaibinhweb.com\";s:17:\"comment_author_IP\";s:14:\"103.74.119.251\";s:12:\"comment_date\";s:19:\"2018-03-24 15:08:44\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 08:08:44\";s:15:\"comment_content\";s:4:\"ngon\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52187","_transient_devvn_add_cmt_count_review_21281","a:0:{}","yes"),
("52188","_transient_devvn_add_cmt_count_review_21282","a:0:{}","yes"),
("52189","_transient_devvn_add_cmt_count_review_21283","a:0:{}","yes"),
("52190","_transient_devvn_add_cmt_count_review_21284","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:2:\"11\";s:15:\"comment_post_ID\";s:4:\"2128\";s:14:\"comment_author\";s:11:\"ninhbinhweb\";s:20:\"comment_author_email\";s:27:\"info.giuseart.com@gmail.com\";s:18:\"comment_author_url\";s:17:\"https://antam.net\";s:17:\"comment_author_IP\";s:13:\"118.71.165.93\";s:12:\"comment_date\";s:19:\"2020-08-15 14:08:55\";s:16:\"comment_date_gmt\";s:19:\"2020-08-15 07:08:55\";s:15:\"comment_content\";s:21:\"quá quá tốt luôn\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.125 Safari/537.36\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52191","_transient_devvn_add_cmt_count_review_21285","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"7\";s:15:\"comment_post_ID\";s:4:\"2128\";s:14:\"comment_author\";s:10:\"Thanh Pham\";s:20:\"comment_author_email\";s:18:\"thanhppm@gmail.com\";s:18:\"comment_author_url\";s:0:\"\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-24 15:01:13\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 08:01:13\";s:15:\"comment_content\";s:11:\"Đẹp quá\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"0\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52192","_transient_devvn_add_cmt_count_review_21280","a:3:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:2:\"11\";s:15:\"comment_post_ID\";s:4:\"2128\";s:14:\"comment_author\";s:11:\"ninhbinhweb\";s:20:\"comment_author_email\";s:27:\"info.giuseart.com@gmail.com\";s:18:\"comment_author_url\";s:17:\"https://antam.net\";s:17:\"comment_author_IP\";s:13:\"118.71.165.93\";s:12:\"comment_date\";s:19:\"2020-08-15 14:08:55\";s:16:\"comment_date_gmt\";s:19:\"2020-08-15 07:08:55\";s:15:\"comment_content\";s:21:\"quá quá tốt luôn\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.125 Safari/537.36\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}i:1;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"7\";s:15:\"comment_post_ID\";s:4:\"2128\";s:14:\"comment_author\";s:10:\"Thanh Pham\";s:20:\"comment_author_email\";s:18:\"thanhppm@gmail.com\";s:18:\"comment_author_url\";s:0:\"\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-24 15:01:13\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 08:01:13\";s:15:\"comment_content\";s:11:\"Đẹp quá\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"0\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}i:2;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"6\";s:15:\"comment_post_ID\";s:4:\"2128\";s:14:\"comment_author\";s:10:\"Thanh Pham\";s:20:\"comment_author_email\";s:18:\"thanhppm@gmail.com\";s:18:\"comment_author_url\";s:0:\"\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-24 14:53:11\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 07:53:11\";s:15:\"comment_content\";s:24:\"Sản phẩm rất tốt\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"0\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52200","_transient_devvn_add_cmt_count_review_21251","a:0:{}","yes"),
("52201","_transient_devvn_add_cmt_count_review_21252","a:0:{}","yes"),
("52202","_transient_devvn_add_cmt_count_review_21253","a:0:{}","yes"),
("52203","_transient_devvn_add_cmt_count_review_21254","a:0:{}","yes"),
("52204","_transient_devvn_add_cmt_count_review_21255","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:2:\"10\";s:15:\"comment_post_ID\";s:4:\"2125\";s:14:\"comment_author\";s:11:\"ninhbinhweb\";s:20:\"comment_author_email\";s:27:\"info.giuseart.com@gmail.com\";s:18:\"comment_author_url\";s:17:\"https://antam.net\";s:17:\"comment_author_IP\";s:12:\"27.71.81.210\";s:12:\"comment_date\";s:19:\"2020-07-31 23:04:11\";s:16:\"comment_date_gmt\";s:19:\"2020-07-31 16:04:11\";s:15:\"comment_content\";s:14:\"Sanr phaam tot\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52205","_transient_devvn_add_cmt_count_review_21250","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:2:\"10\";s:15:\"comment_post_ID\";s:4:\"2125\";s:14:\"comment_author\";s:11:\"ninhbinhweb\";s:20:\"comment_author_email\";s:27:\"info.giuseart.com@gmail.com\";s:18:\"comment_author_url\";s:17:\"https://antam.net\";s:17:\"comment_author_IP\";s:12:\"27.71.81.210\";s:12:\"comment_date\";s:19:\"2020-07-31 23:04:11\";s:16:\"comment_date_gmt\";s:19:\"2020-07-31 16:04:11\";s:15:\"comment_content\";s:14:\"Sanr phaam tot\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:121:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52316","_transient_devvn_add_cmt_count_review_32671","a:0:{}","yes"),
("52317","_transient_devvn_add_cmt_count_review_32672","a:0:{}","yes"),
("52318","_transient_devvn_add_cmt_count_review_32673","a:0:{}","yes"),
("52319","_transient_devvn_add_cmt_count_review_32674","a:0:{}","yes"),
("52320","_transient_devvn_add_cmt_count_review_32675","a:0:{}","yes"),
("52321","_transient_devvn_add_cmt_count_review_32670","a:0:{}","yes"),
("52634","_transient_devvn_add_cmt_count_review_32571","a:0:{}","yes"),
("52635","_transient_devvn_add_cmt_count_review_32572","a:0:{}","yes"),
("52636","_transient_devvn_add_cmt_count_review_32573","a:0:{}","yes"),
("52637","_transient_devvn_add_cmt_count_review_32574","a:0:{}","yes"),
("52638","_transient_devvn_add_cmt_count_review_32575","a:0:{}","yes"),
("52639","_transient_devvn_add_cmt_count_review_32570","a:0:{}","yes"),
("52647","_transient_devvn_add_cmt_count_review_19671","a:0:{}","yes"),
("52648","_transient_devvn_add_cmt_count_review_19672","a:0:{}","yes"),
("52649","_transient_devvn_add_cmt_count_review_19673","a:0:{}","yes"),
("52650","_transient_devvn_add_cmt_count_review_19674","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"5\";s:15:\"comment_post_ID\";s:4:\"1967\";s:14:\"comment_author\";s:5:\"admin\";s:20:\"comment_author_email\";s:20:\"khuong3012@gmail.com\";s:18:\"comment_author_url\";s:30:\"http://hungyen.thaibinhweb.com\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-24 15:21:56\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 08:21:56\";s:15:\"comment_content\";s:4:\"hiii\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52651","_transient_devvn_add_cmt_count_review_19675","a:0:{}","yes"),
("52652","_transient_devvn_add_cmt_count_review_19670","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"5\";s:15:\"comment_post_ID\";s:4:\"1967\";s:14:\"comment_author\";s:5:\"admin\";s:20:\"comment_author_email\";s:20:\"khuong3012@gmail.com\";s:18:\"comment_author_url\";s:30:\"http://hungyen.thaibinhweb.com\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-24 15:21:56\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 08:21:56\";s:15:\"comment_content\";s:4:\"hiii\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"1\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52703","_transient_devvn_add_cmt_count_review_21351","a:0:{}","yes"),
("52704","_transient_devvn_add_cmt_count_review_21352","a:0:{}","yes"),
("52705","_transient_devvn_add_cmt_count_review_21353","a:0:{}","yes"),
("52706","_transient_devvn_add_cmt_count_review_21354","a:0:{}","yes"),
("52707","_transient_devvn_add_cmt_count_review_21355","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"8\";s:15:\"comment_post_ID\";s:4:\"2135\";s:14:\"comment_author\";s:10:\"Thanh Pham\";s:20:\"comment_author_email\";s:18:\"thanhppm@gmail.com\";s:18:\"comment_author_url\";s:0:\"\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-24 14:59:02\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 07:59:02\";s:15:\"comment_content\";s:11:\"Rất tốt\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"0\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("52708","_transient_devvn_add_cmt_count_review_21350","a:1:{i:0;O:10:\"WP_Comment\":18:{s:10:\"comment_ID\";s:1:\"8\";s:15:\"comment_post_ID\";s:4:\"2135\";s:14:\"comment_author\";s:10:\"Thanh Pham\";s:20:\"comment_author_email\";s:18:\"thanhppm@gmail.com\";s:18:\"comment_author_url\";s:0:\"\";s:17:\"comment_author_IP\";s:14:\"103.74.119.247\";s:12:\"comment_date\";s:19:\"2018-03-24 14:59:02\";s:16:\"comment_date_gmt\";s:19:\"2018-03-24 07:59:02\";s:15:\"comment_content\";s:11:\"Rất tốt\";s:13:\"comment_karma\";s:1:\"0\";s:16:\"comment_approved\";s:1:\"1\";s:13:\"comment_agent\";s:0:\"\";s:12:\"comment_type\";s:6:\"review\";s:14:\"comment_parent\";s:1:\"0\";s:7:\"user_id\";s:1:\"0\";s:11:\"\0*\0children\";N;s:21:\"\0*\0populated_children\";b:0;s:14:\"\0*\0post_fields\";a:21:{i:0;s:11:\"post_author\";i:1;s:9:\"post_date\";i:2;s:13:\"post_date_gmt\";i:3;s:12:\"post_content\";i:4;s:10:\"post_title\";i:5;s:12:\"post_excerpt\";i:6;s:11:\"post_status\";i:7;s:14:\"comment_status\";i:8;s:11:\"ping_status\";i:9;s:9:\"post_name\";i:10;s:7:\"to_ping\";i:11;s:6:\"pinged\";i:12;s:13:\"post_modified\";i:13;s:17:\"post_modified_gmt\";i:14;s:21:\"post_content_filtered\";i:15;s:11:\"post_parent\";i:16;s:4:\"guid\";i:17;s:10:\"menu_order\";i:18;s:9:\"post_type\";i:19;s:14:\"post_mime_type\";i:20;s:13:\"comment_count\";}}}","yes"),
("53766","_transient_health-check-site-status-result","{\"good\":13,\"recommended\":4,\"critical\":3}","yes"),
("54131","new_admin_email","tamnguyen.tuu@gmail.com","yes"),
("54145","rewrite_rules","a:216:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:15:\"locations\\.kml$\";s:27:\"index.php?sitemap=locations\";s:11:\"cua-hang/?$\";s:27:\"index.php?post_type=product\";s:41:\"cua-hang/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:36:\"cua-hang/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:28:\"cua-hang/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/schema-preview/?$\";s:57:\"index.php?category=$matches[1]&schema-preview=$matches[3]\";s:27:\"tag/(.+?)/schema-preview/?$\";s:57:\"index.php?post_tag=$matches[1]&schema-preview=$matches[3]\";s:28:\"type/(.+?)/schema-preview/?$\";s:60:\"index.php?post_format=$matches[1]&schema-preview=$matches[3]\";s:35:\"/dung-luong/(.+?)/schema-preview/?$\";s:62:\"index.php?pa_dung-luong=$matches[1]&schema-preview=$matches[3]\";s:32:\"/mau-sac/(.+?)/schema-preview/?$\";s:59:\"index.php?pa_mau-sac=$matches[1]&schema-preview=$matches[3]\";s:35:\"/trang-thai/(.+?)/schema-preview/?$\";s:62:\"index.php?pa_trang-thai=$matches[1]&schema-preview=$matches[3]\";s:32:\"/xuat-xu/(.+?)/schema-preview/?$\";s:59:\"index.php?pa_xuat-xu=$matches[1]&schema-preview=$matches[3]\";s:32:\"blocks/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"blocks/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"blocks/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"blocks/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"blocks/(.+?)/embed/?$\";s:39:\"index.php?blocks=$matches[1]&embed=true\";s:25:\"blocks/(.+?)/trackback/?$\";s:33:\"index.php?blocks=$matches[1]&tb=1\";s:33:\"blocks/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&paged=$matches[2]\";s:40:\"blocks/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&cpage=$matches[2]\";s:30:\"blocks/(.+?)/wc-api(/(.*))?/?$\";s:47:\"index.php?blocks=$matches[1]&wc-api=$matches[3]\";s:38:\"blocks/(.+?)/schema-preview(/(.*))?/?$\";s:55:\"index.php?blocks=$matches[1]&schema-preview=$matches[3]\";s:36:\"blocks/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"blocks/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"blocks/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?blocks=$matches[1]&page=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"block_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?block_categories=$matches[1]&feed=$matches[2]\";s:52:\"block_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?block_categories=$matches[1]&feed=$matches[2]\";s:33:\"block_categories/([^/]+)/embed/?$\";s:49:\"index.php?block_categories=$matches[1]&embed=true\";s:45:\"block_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?block_categories=$matches[1]&paged=$matches[2]\";s:27:\"block_categories/([^/]+)/?$\";s:38:\"index.php?block_categories=$matches[1]\";s:56:\"danh-muc-san-pham/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:51:\"danh-muc-san-pham/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:32:\"danh-muc-san-pham/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:44:\"danh-muc-san-pham/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:26:\"danh-muc-san-pham/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:57:\"tu-khoa-san-pham/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:52:\"tu-khoa-san-pham/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:33:\"tu-khoa-san-pham/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:45:\"tu-khoa-san-pham/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:27:\"tu-khoa-san-pham/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:51:\"dung-luong/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?pa_dung-luong=$matches[1]&feed=$matches[2]\";s:46:\"dung-luong/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?pa_dung-luong=$matches[1]&feed=$matches[2]\";s:27:\"dung-luong/([^/]+)/embed/?$\";s:46:\"index.php?pa_dung-luong=$matches[1]&embed=true\";s:39:\"dung-luong/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?pa_dung-luong=$matches[1]&paged=$matches[2]\";s:21:\"dung-luong/([^/]+)/?$\";s:35:\"index.php?pa_dung-luong=$matches[1]\";s:48:\"mau-sac/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?pa_mau-sac=$matches[1]&feed=$matches[2]\";s:43:\"mau-sac/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?pa_mau-sac=$matches[1]&feed=$matches[2]\";s:24:\"mau-sac/([^/]+)/embed/?$\";s:43:\"index.php?pa_mau-sac=$matches[1]&embed=true\";s:36:\"mau-sac/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?pa_mau-sac=$matches[1]&paged=$matches[2]\";s:18:\"mau-sac/([^/]+)/?$\";s:32:\"index.php?pa_mau-sac=$matches[1]\";s:51:\"trang-thai/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?pa_trang-thai=$matches[1]&feed=$matches[2]\";s:46:\"trang-thai/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?pa_trang-thai=$matches[1]&feed=$matches[2]\";s:27:\"trang-thai/([^/]+)/embed/?$\";s:46:\"index.php?pa_trang-thai=$matches[1]&embed=true\";s:39:\"trang-thai/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?pa_trang-thai=$matches[1]&paged=$matches[2]\";s:21:\"trang-thai/([^/]+)/?$\";s:35:\"index.php?pa_trang-thai=$matches[1]\";s:48:\"xuat-xu/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?pa_xuat-xu=$matches[1]&feed=$matches[2]\";s:43:\"xuat-xu/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?pa_xuat-xu=$matches[1]&feed=$matches[2]\";s:24:\"xuat-xu/([^/]+)/embed/?$\";s:43:\"index.php?pa_xuat-xu=$matches[1]&embed=true\";s:36:\"xuat-xu/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?pa_xuat-xu=$matches[1]&paged=$matches[2]\";s:18:\"xuat-xu/([^/]+)/?$\";s:32:\"index.php?pa_xuat-xu=$matches[1]\";s:36:\"san-pham/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"san-pham/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"san-pham/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"san-pham/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"san-pham/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"san-pham/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"san-pham/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:29:\"san-pham/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:49:\"san-pham/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:44:\"san-pham/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:37:\"san-pham/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:44:\"san-pham/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:34:\"san-pham/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:42:\"san-pham/([^/]+)/schema-preview(/(.*))?/?$\";s:56:\"index.php?product=$matches[1]&schema-preview=$matches[3]\";s:40:\"san-pham/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"san-pham/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"san-pham/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:25:\"san-pham/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"san-pham/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"san-pham/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"san-pham/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"san-pham/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"san-pham/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=24&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:25:\"schema-preview(/(.*))?/?$\";s:37:\"index.php?&schema-preview=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:33:\"(.?.+?)/schema-preview(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&schema-preview=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:33:\"([^/]+)/schema-preview(/(.*))?/?$\";s:53:\"index.php?name=$matches[1]&schema-preview=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes"),
("54146","wpseo_gsc_last_fetch","1658586016","no"),
("54287","wpseo_taxonomy_meta","a:1:{s:11:\"product_cat\";a:1:{i:15;a:2:{s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:2:\"30\";}}}","yes"),
("54289","wpseo-premium-redirects-base","a:2:{i:0;a:4:{s:6:\"origin\";s:24:\"danh-muc-san-pham/bao-ve\";s:3:\"url\";s:35:\"danh-muc-san-pham/do-choi-cong-nghe\";s:4:\"type\";i:301;s:6:\"format\";s:5:\"plain\";}i:1;a:4:{s:6:\"origin\";s:35:\"danh-muc-san-pham/do-choi-cong-nghe\";s:3:\"url\";s:34:\"danh-muc-san-pham/do-dung-tien-ich\";s:4:\"type\";i:301;s:6:\"format\";s:5:\"plain\";}}","no"),
("54290","wpseo-premium-redirects-export-plain","a:2:{s:24:\"danh-muc-san-pham/bao-ve\";a:2:{s:3:\"url\";s:35:\"danh-muc-san-pham/do-choi-cong-nghe\";s:4:\"type\";i:301;}s:35:\"danh-muc-san-pham/do-choi-cong-nghe\";a:2:{s:3:\"url\";s:34:\"danh-muc-san-pham/do-dung-tien-ich\";s:4:\"type\";i:301;}}","no"),
("54291","wpseo-premium-redirects-export-regex","a:0:{}","no"),
("54418","_transient_devvn_add_cmt_count_review_33461","a:0:{}","yes"),
("54419","_transient_devvn_add_cmt_count_review_33462","a:0:{}","yes"),
("54420","_transient_devvn_add_cmt_count_review_33463","a:0:{}","yes"),
("54421","_transient_devvn_add_cmt_count_review_33464","a:0:{}","yes"),
("54422","_transient_devvn_add_cmt_count_review_33465","a:0:{}","yes"),
("54423","_transient_devvn_add_cmt_count_review_33460","a:0:{}","yes"),
("54471","_transient_devvn_add_cmt_count_review_33511","a:0:{}","yes"),
("54472","_transient_devvn_add_cmt_count_review_33512","a:0:{}","yes");

INSERT INTO `wp_options` VALUES 
("54473","_transient_devvn_add_cmt_count_review_33513","a:0:{}","yes"),
("54474","_transient_devvn_add_cmt_count_review_33514","a:0:{}","yes"),
("54475","_transient_devvn_add_cmt_count_review_33515","a:0:{}","yes"),
("54476","_transient_devvn_add_cmt_count_review_33510","a:0:{}","yes"),
("54492","_transient_devvn_add_cmt_count_review_33601","a:0:{}","yes"),
("54493","_transient_devvn_add_cmt_count_review_33602","a:0:{}","yes"),
("54494","_transient_devvn_add_cmt_count_review_33603","a:0:{}","yes"),
("54495","_transient_devvn_add_cmt_count_review_33604","a:0:{}","yes"),
("54496","_transient_devvn_add_cmt_count_review_33605","a:0:{}","yes"),
("54497","_transient_devvn_add_cmt_count_review_33600","a:0:{}","yes"),
("54513","_transient_devvn_add_cmt_count_review_33631","a:0:{}","yes"),
("54514","_transient_devvn_add_cmt_count_review_33632","a:0:{}","yes"),
("54515","_transient_devvn_add_cmt_count_review_33633","a:0:{}","yes"),
("54516","_transient_devvn_add_cmt_count_review_33634","a:0:{}","yes"),
("54517","_transient_devvn_add_cmt_count_review_33635","a:0:{}","yes"),
("54518","_transient_devvn_add_cmt_count_review_33630","a:0:{}","yes"),
("63216","_transient_orders-transient-version","1698506850","yes"),
("70011","_transient_devvn_add_cmt_count_review_33841","a:0:{}","yes"),
("70012","_transient_devvn_add_cmt_count_review_33842","a:0:{}","yes"),
("70013","_transient_devvn_add_cmt_count_review_33843","a:0:{}","yes"),
("70014","_transient_devvn_add_cmt_count_review_33844","a:0:{}","yes"),
("70015","_transient_devvn_add_cmt_count_review_33845","a:0:{}","yes"),
("70016","_transient_devvn_add_cmt_count_review_33840","a:0:{}","yes"),
("70052","product_cat_children","a:0:{}","yes"),
("70098","_transient_devvn_add_cmt_count_review_33911","a:0:{}","yes"),
("70099","_transient_devvn_add_cmt_count_review_33912","a:0:{}","yes"),
("70100","_transient_devvn_add_cmt_count_review_33913","a:0:{}","yes"),
("70101","_transient_devvn_add_cmt_count_review_33914","a:0:{}","yes"),
("70102","_transient_devvn_add_cmt_count_review_33915","a:0:{}","yes"),
("70103","_transient_devvn_add_cmt_count_review_33910","a:0:{}","yes"),
("70156","rank_math_known_post_types","a:5:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";s:10:\"attachment\";s:10:\"attachment\";s:6:\"blocks\";s:6:\"blocks\";s:7:\"product\";s:7:\"product\";}","yes"),
("70157","rank_math_modules","a:14:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:10;s:10:\"content-ai\";i:11;s:16:\"instant-indexing\";i:12;s:12:\"redirections\";i:13;s:9:\"local-seo\";}","yes"),
("70158","rank-math-options-general","a:48:{s:19:\"strip_category_base\";s:3:\"off\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:17:\"https://antam.net\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:11:\" %filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:2:\"on\";s:21:\"breadcrumbs_separator\";s:2:\"»\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:11:\"Trang chủ\";s:26:\"breadcrumbs_archive_format\";s:10:\"Danh mục\";s:25:\"breadcrumbs_search_format\";s:17:\"Tìm kiếm với\";s:21:\"breadcrumbs_404_label\";s:30:\"Lỗi 404: không xác định\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";i:100;s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";s:2:\"90\";s:21:\"console_email_reports\";b:0;s:23:\"console_email_frequency\";s:7:\"monthly\";s:27:\"link_builder_links_per_page\";s:1:\"7\";s:29:\"link_builder_links_per_target\";s:1:\"1\";s:22:\"wc_remove_product_base\";s:3:\"off\";s:23:\"wc_remove_category_base\";s:3:\"off\";s:31:\"wc_remove_category_parent_slugs\";s:3:\"off\";s:18:\"rss_before_content\";s:0:\"\";s:17:\"rss_after_content\";s:49:\"The post %POSTLINK% appeared first on %BLOGLINK%.\";s:19:\"wc_remove_generator\";s:2:\"on\";s:24:\"remove_shop_snippet_data\";s:2:\"on\";s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:8:\"advanced\";s:21:\"content_ai_post_types\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:6:\"blocks\";i:3;s:7:\"product\";}s:15:\"analytics_stats\";s:2:\"on\";s:14:\"google_updates\";s:2:\"on\";s:12:\"baidu_verify\";s:0:\"\";s:13:\"google_verify\";s:43:\"4xyFb5zfAI13fKR4ZxzQkz3YsH53ZFR70aiml_IIaGU\";s:11:\"bing_verify\";s:0:\"\";s:13:\"yandex_verify\";s:0:\"\";s:18:\"breadcrumbs_prefix\";s:0:\"\";}","yes"),
("70159","rank-math-options-titles","a:176:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:7:\"company\";s:19:\"knowledgegraph_name\";s:47:\"An Tâm - Máy tính, Phụ kiện chính hãng\";s:19:\"local_business_type\";s:12:\"Organization\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:11:\"09:00-17:00\";}}s:20:\"opening_hours_format\";s:3:\"off\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";s:3:\"off\";s:23:\"disable_author_archives\";s:3:\"off\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:35:\"%name%, Author at %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:3:\"off\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:55:\"You searched for %searchphrase% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page not found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:3:\"off\";s:13:\"pt_post_title\";s:31:\"%title% %page% %sep% %sitename%\";s:19:\"pt_post_description\";s:0:\"\";s:14:\"pt_post_robots\";a:0:{}s:21:\"pt_post_custom_robots\";s:2:\"on\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:3:\"off\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:31:\"%title% %page% %sep% %sitename%\";s:19:\"pt_page_description\";s:0:\"\";s:14:\"pt_page_robots\";a:0:{}s:21:\"pt_page_custom_robots\";s:2:\"on\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:3:\"off\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:31:\"%title% %page% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:0:\"\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";s:2:\"on\";s:34:\"pt_attachment_default_rich_snippet\";s:3:\"off\";s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_attachment_add_meta_box\";s:2:\"on\";s:15:\"pt_blocks_title\";s:31:\"%title% %page% %sep% %sitename%\";s:21:\"pt_blocks_description\";s:0:\"\";s:16:\"pt_blocks_robots\";a:0:{}s:23:\"pt_blocks_custom_robots\";s:2:\"on\";s:30:\"pt_blocks_default_rich_snippet\";s:3:\"off\";s:30:\"pt_blocks_default_article_type\";s:7:\"Article\";s:30:\"pt_blocks_default_snippet_name\";s:11:\"%seo_title%\";s:30:\"pt_blocks_default_snippet_desc\";s:17:\"%seo_description%\";s:32:\"pt_blocks_slack_enhanced_sharing\";s:3:\"off\";s:19:\"pt_blocks_ls_use_fk\";s:6:\"titles\";s:22:\"pt_blocks_add_meta_box\";s:2:\"on\";s:22:\"pt_blocks_bulk_editing\";s:7:\"editing\";s:26:\"pt_blocks_link_suggestions\";s:2:\"on\";s:16:\"pt_product_title\";s:31:\"%title% %page% %sep% %sitename%\";s:22:\"pt_product_description\";s:0:\"\";s:17:\"pt_product_robots\";a:0:{}s:24:\"pt_product_custom_robots\";s:2:\"on\";s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:24:\"pt_product_archive_title\";s:46:\"Lưu trữ %pt_plural% %page% %sep% %sitename%\";s:33:\"pt_product_slack_enhanced_sharing\";s:3:\"off\";s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";s:2:\"on\";s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";s:2:\"on\";s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:0:{}s:26:\"pt_web-story_custom_robots\";s:3:\"off\";s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";s:3:\"off\";s:25:\"pt_web-story_add_meta_box\";s:3:\"off\";s:18:\"tax_category_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:19:\"tax_category_robots\";a:0:{}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:2:\"on\";s:24:\"tax_category_description\";s:0:\"\";s:35:\"tax_category_slack_enhanced_sharing\";s:3:\"off\";s:18:\"tax_post_tag_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:0:{}s:25:\"tax_post_tag_add_meta_box\";s:2:\"on\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:0:\"\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:3:\"off\";s:21:\"tax_post_format_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:22:\"tax_post_format_robots\";a:1:{i:0;s:7:\"noindex\";}s:28:\"tax_post_format_add_meta_box\";s:2:\"on\";s:29:\"tax_post_format_custom_robots\";s:2:\"on\";s:27:\"tax_post_format_description\";s:0:\"\";s:38:\"tax_post_format_slack_enhanced_sharing\";s:3:\"off\";s:21:\"tax_product_cat_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:22:\"tax_product_cat_robots\";a:0:{}s:28:\"tax_product_cat_add_meta_box\";s:2:\"on\";s:29:\"tax_product_cat_custom_robots\";s:2:\"on\";s:27:\"tax_product_cat_description\";s:0:\"\";s:38:\"tax_product_cat_slack_enhanced_sharing\";s:3:\"off\";s:21:\"tax_product_tag_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:22:\"tax_product_tag_robots\";a:0:{}s:28:\"tax_product_tag_add_meta_box\";s:2:\"on\";s:29:\"tax_product_tag_custom_robots\";s:2:\"on\";s:27:\"tax_product_tag_description\";s:0:\"\";s:38:\"tax_product_tag_slack_enhanced_sharing\";s:3:\"off\";s:23:\"tax_pa_dung-luong_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:24:\"tax_pa_dung-luong_robots\";a:0:{}s:30:\"tax_pa_dung-luong_add_meta_box\";s:2:\"on\";s:31:\"tax_pa_dung-luong_custom_robots\";s:2:\"on\";s:29:\"tax_pa_dung-luong_description\";s:0:\"\";s:40:\"tax_pa_dung-luong_slack_enhanced_sharing\";s:3:\"off\";s:20:\"tax_pa_mau-sac_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:21:\"tax_pa_mau-sac_robots\";a:0:{}s:27:\"tax_pa_mau-sac_add_meta_box\";s:2:\"on\";s:28:\"tax_pa_mau-sac_custom_robots\";s:2:\"on\";s:26:\"tax_pa_mau-sac_description\";s:0:\"\";s:37:\"tax_pa_mau-sac_slack_enhanced_sharing\";s:3:\"off\";s:23:\"tax_pa_trang-thai_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:24:\"tax_pa_trang-thai_robots\";a:0:{}s:30:\"tax_pa_trang-thai_add_meta_box\";s:2:\"on\";s:31:\"tax_pa_trang-thai_custom_robots\";s:2:\"on\";s:29:\"tax_pa_trang-thai_description\";s:0:\"\";s:40:\"tax_pa_trang-thai_slack_enhanced_sharing\";s:3:\"off\";s:20:\"tax_pa_xuat-xu_title\";s:39:\"%term% Archives %page% %sep% %sitename%\";s:21:\"tax_pa_xuat-xu_robots\";a:0:{}s:27:\"tax_pa_xuat-xu_add_meta_box\";s:2:\"on\";s:28:\"tax_pa_xuat-xu_custom_robots\";s:2:\"on\";s:26:\"tax_pa_xuat-xu_description\";s:0:\"\";s:37:\"tax_pa_xuat-xu_slack_enhanced_sharing\";s:3:\"off\";s:31:\"remove_product_cat_snippet_data\";s:2:\"on\";s:31:\"remove_product_tag_snippet_data\";s:2:\"on\";s:9:\"local_seo\";s:2:\"on\";s:26:\"author_archive_description\";s:0:\"\";s:24:\"date_archive_description\";s:0:\"\";s:24:\"pt_page_primary_taxonomy\";s:1:\"0\";s:30:\"pt_attachment_primary_taxonomy\";s:1:\"0\";s:26:\"pt_blocks_primary_taxonomy\";s:1:\"0\";s:30:\"pt_product_archive_description\";s:0:\"\";s:19:\"social_url_facebook\";s:0:\"\";s:20:\"twitter_author_names\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:19:\"knowledgegraph_logo\";s:60:\"https://antam.net/wp-content/uploads/2022/07/logo-an-tam.png\";s:22:\"knowledgegraph_logo_id\";s:4:\"3309\";s:23:\"homepage_facebook_title\";s:0:\"\";s:29:\"homepage_facebook_description\";s:0:\"\";s:34:\"pt_download_slack_enhanced_sharing\";s:3:\"off\";s:39:\"tax_product_shipping_class_add_meta_box\";s:2:\"on\";}","yes"),
("70160","rank-math-options-sitemap","a:21:{s:14:\"items_per_page\";i:1000;s:14:\"include_images\";s:2:\"on\";s:22:\"include_featured_image\";s:3:\"off\";s:19:\"ping_search_engines\";s:2:\"on\";s:13:\"exclude_roles\";a:6:{s:11:\"contributor\";s:11:\"Contributor\";s:10:\"subscriber\";s:10:\"Subscriber\";s:8:\"customer\";s:8:\"Customer\";s:12:\"shop_manager\";s:12:\"Shop manager\";s:13:\"wpseo_manager\";s:11:\"SEO Manager\";s:12:\"wpseo_editor\";s:10:\"SEO Editor\";}s:15:\"pt_post_sitemap\";s:2:\"on\";s:15:\"pt_page_sitemap\";s:2:\"on\";s:21:\"pt_attachment_sitemap\";s:3:\"off\";s:17:\"pt_blocks_sitemap\";s:2:\"on\";s:18:\"pt_product_sitemap\";s:2:\"on\";s:20:\"pt_web-story_sitemap\";s:3:\"off\";s:20:\"tax_category_sitemap\";s:3:\"off\";s:20:\"tax_post_tag_sitemap\";s:3:\"off\";s:23:\"tax_post_format_sitemap\";s:3:\"off\";s:23:\"tax_product_cat_sitemap\";s:3:\"off\";s:23:\"tax_product_tag_sitemap\";s:3:\"off\";s:25:\"tax_pa_dung-luong_sitemap\";s:3:\"off\";s:22:\"tax_pa_mau-sac_sitemap\";s:3:\"off\";s:25:\"tax_pa_trang-thai_sitemap\";s:3:\"off\";s:22:\"tax_pa_xuat-xu_sitemap\";s:3:\"off\";s:13:\"exclude_posts\";s:0:\"\";}","yes"),
("70161","rank-math-options-instant-indexing","a:2:{s:15:\"bing_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:16:\"indexnow_api_key\";s:32:\"de696c832cfa436e924bd7f00427e17c\";}","yes"),
("70164","rank_math_version","1.0.95.1","yes"),
("70165","rank_math_db_version","1","yes"),
("70166","rank_math_install_date","1660735428","yes"),
("70172","rank_math_pro_google_updates","[{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/august-2023-core-update\\/\",\"title\":\"August 2023 Core Update\",\"content\":\"Google released a core update to its search ranking algorithm on August 22, 2023, and this will take up to two weeks to fully roll out.\",\"date\":\"1692662400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-update-july-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (July 2023)\",\"content\":\"Google might have rolled out another unconfirmed update to its search algorithm on July 14th, 2023. The fluctuations from this update is so extreme that several SERP tracking tools displayed figures they had never shown before.\",\"date\":\"1689292800\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-update-28-29-june-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (28th \\u0026amp; 29th June 2023)\",\"content\":\"Several SERP tracking tools indicate that Google might have updated its search ranking algorithm between June 28 and 29, 2023. However, there was no announcement from Google about this possible update.\",\"date\":\"1687910400\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-update-14-june-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (14th June 2023)\",\"content\":\"Google has recently updated its search ranking algorithm on June 14, 2023, and several SEOs reported spikes in their Google rankings. \",\"date\":\"1686700800\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-algorithm-update-mid-may-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (10th \\u0026amp; 11th May 2023)\",\"content\":\"Google might have rolled out an unconfirmed update to its search ranking algorithm between May 10, 2023, and May 11, 2023. Several website tracking tools detected unusual spikes in the traffic and rankings.\",\"date\":\"1683676800\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-algorithm-update-may-2023\\/\",\"title\":\"Unconfirmed Google Search Ranking Algorithm Update (1st \\u0026amp; 2nd May 2023)\",\"content\":\"Google may have recently launched an update to its search ranking algorithm. The effect of the update was evident on May 1st \\u0026amp; 2nd, 2023, as several SEOs reported spikes in their traffic and conversions.\",\"date\":\"1682899200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/april-2023-reviews-update\\/\",\"title\":\"April 2023 Reviews Update\",\"content\":\"Google announced another update to its reviews system. The April 2023 Reviews update started rolling out on 12th April 2023 and was completed on 25th April 2023.\",\"date\":\"1681257600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/march-2023-core-algorithm-update\\/\",\"title\":\"March 2023 Core Algorithm Update\",\"content\":\"Google announced rolling out the core algorithm update on March 15, 2023. The rollout is completed on March 28, 2023.\",\"date\":\"1678838400\",\"status\":\"confirmed\"}]","no"),
("70174","rank_math_registration_skip","1","yes"),
("70175","rank_math_review_notice_date","1661945044","no"),
("70176","rank_math_review_posts_converted","1","yes"),
("70177","_transient_rank_math_first_submenu_id","rank-math","yes"),
("70178","rank_math_pro_version","2.15.0","yes"),
("70179","rank_math_wizard_completed","1","yes"),
("70180","_transient__rank_math_conflicting_plugins","a:1:{i:0;s:40:\"wordpress-seo-premium/wp-seo-premium.php\";}","yes"),
("70187","_transient__rank_math_site_type","webshop","yes"),
("70188","rank_math_google_analytic_profile","a:3:{s:7:\"country\";s:3:\"all\";s:7:\"profile\";b:0;s:19:\"enable_index_status\";b:0;}","yes"),
("70189","rank_math_analytics_all_services","a:1:{s:5:\"sites\";a:1:{i:0;b:0;}}","yes"),
("70190","rank_math_google_analytic_options","a:10:{s:10:\"account_id\";b:0;s:11:\"property_id\";b:0;s:7:\"view_id\";b:0;s:14:\"measurement_id\";b:0;s:11:\"stream_name\";b:0;s:7:\"country\";s:3:\"all\";s:12:\"install_code\";b:0;s:12:\"anonymize_ip\";b:0;s:11:\"local_ga_js\";b:0;s:16:\"exclude_loggedin\";b:0;}","yes"),
("70194","rank_math_is_configured","1","yes"),
("70196","rank_math_analytics_installed","1","yes"),
("70197","rank_math_analytics_pro_installed","1","yes"),
("70198","action_scheduler_migration_status","complete","yes"),
("70199","rank_math_yoast_block_posts","a:2:{s:5:\"posts\";a:0:{}s:5:\"count\";i:0;}","yes"),
("70201","rank_math_old_schema_data","a:0:{}","yes"),
("70203","rank_math_sitemap_cache_files","a:5:{s:46:\"rank_math_9a15afeead5a8a34c07eab06c3cb6404.xml\";s:5:\"local\";s:46:\"rank_math_b1c4848d5d4386fa298dece120c333d0.xml\";s:9:\"locations\";s:46:\"rank_math_4733289d3461d230b5f007e20f94166f.xml\";s:6:\"blocks\";s:46:\"rank_math_97bfe9f1d942341db350b2b349b45e63.xml\";s:4:\"page\";s:46:\"rank_math_6671cd9027711f950df8cff18c3202dd.xml\";s:7:\"product\";}","yes"),
("70205","rank_math_content_ai_viewed","1","yes"),
("79674","rank_math_review_notice_added","1","no"),
("86659","rank_math_indexnow_log","a:10:{i:0;a:5:{s:3:\"url\";s:34:\"https://antam.net/bao-hanh-laptop/\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663315204;}i:1;a:5:{s:3:\"url\";s:38:\"https://antam.net/chinh-sach-bao-hanh/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663315451;}i:2;a:5:{s:3:\"url\";s:38:\"https://antam.net/chinh-sach-bao-hanh/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663315541;}i:3;a:5:{s:3:\"url\";s:38:\"https://antam.net/chinh-sach-bao-hanh/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663315847;}i:4;a:5:{s:3:\"url\";s:38:\"https://antam.net/chinh-sach-bao-hanh/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663315934;}i:5;a:5:{s:3:\"url\";s:39:\"https://antam.net/huong-dan-thanh-toan/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663316788;}i:6;a:5:{s:3:\"url\";s:39:\"https://antam.net/huong-dan-thanh-toan/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663316866;}i:7;a:5:{s:3:\"url\";s:29:\"https://antam.net/?page_id=18\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663317081;}i:8;a:5:{s:3:\"url\";s:29:\"https://antam.net/?page_id=20\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663317087;}i:9;a:5:{s:3:\"url\";s:37:\"https://antam.net/huong-dan-mua-hang/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1663317383;}}","no"),
("160099","_transient_woocommerce_admin_payment_method_promotion_specs","a:1:{s:20:\"woocommerce_payments\";O:8:\"stdClass\":8:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:20:\"WooCommerce Payments\";s:7:\"content\";s:369:\"Payments made simple, with no monthly fees – designed exclusively for WooCommerce stores. Accept credit cards, debit cards, and other popular payment methods.<br/><br/>By clicking “Install”, you agree to the <a href=\"https://wordpress.com/tos/\" target=\"_blank\">Terms of Service</a> and <a href=\"https://automattic.com/privacy/\" target=\"_blank\">Privacy policy</a>.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:19:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}}}}s:9:\"sub_title\";s:865:\"<img class=\"wcpay-visa-icon wcpay-icon\" src=\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/visa.svg\" alt=\"Visa\"><img class=\"wcpay-mastercard-icon wcpay-icon\" src=\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/mastercard.svg\" alt=\"Mastercard\"><img class=\"wcpay-amex-icon wcpay-icon\" src=\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/amex.svg\" alt=\"Amex\"><img class=\"wcpay-googlepay-icon wcpay-icon\" src=\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/googlepay.svg\" alt=\"Googlepay\"><img class=\"wcpay-applepay-icon wcpay-icon\" src=\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/icons/applepay.svg\" alt=\"Applepay\">\";s:15:\"additional_info\";O:8:\"stdClass\":1:{s:18:\"experiment_version\";s:2:\"v2\";}}}","no"),
("169011","_transient_devvn_add_cmt_count_review_34161","a:0:{}","yes"),
("169012","_transient_devvn_add_cmt_count_review_34162","a:0:{}","yes"),
("169013","_transient_devvn_add_cmt_count_review_34163","a:0:{}","yes"),
("169014","_transient_devvn_add_cmt_count_review_34164","a:0:{}","yes"),
("169015","_transient_devvn_add_cmt_count_review_34165","a:0:{}","yes"),
("169016","_transient_devvn_add_cmt_count_review_34160","a:0:{}","yes"),
("245471","_site_transient_timeout_font-awesome-last-used-release","1721367720","no"),
("245472","_site_transient_font-awesome-last-used-release","a:5:{s:7:\"version\";s:6:\"5.14.0\";s:7:\"use_pro\";b:0;s:7:\"use_svg\";b:0;s:17:\"use_compatibility\";b:1;s:9:\"resources\";a:2:{s:3:\"all\";O:32:\"FortAwesome\\FontAwesome_Resource\":2:{s:9:\"\0*\0source\";s:56:\"https://use.fontawesome.com/releases/v5.14.0/css/all.css\";s:16:\"\0*\0integrity_key\";s:71:\"sha384-HzLeBuhoNPvSl5KYnjx0BT+WB0QEEqLprO+NBkkk5gbc67FTaL7XIGa2w1L0Xbgc\";}s:8:\"v4-shims\";O:32:\"FortAwesome\\FontAwesome_Resource\":2:{s:9:\"\0*\0source\";s:61:\"https://use.fontawesome.com/releases/v5.14.0/css/v4-shims.css\";s:16:\"\0*\0integrity_key\";s:71:\"sha384-9aKO2QU3KETrRCCXFbhLK16iRd15nC+OYEmpVb54jY8/CEXz/GVRsnM73wcbYw+m\";}}}","no"),
("278648","_transient_global_styles_phu-kien","body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}","no"),
("281116","_transient_timeout_wc_var_prices_1970","1698850020","no"),
("281117","_transient_wc_var_prices_1970","{\"version\":\"1690964024\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":[],\"regular_price\":[],\"sale_price\":[]}}","no"),
("281118","_transient_timeout_wc_var_prices_1972","1698850020","no"),
("281119","_transient_wc_var_prices_1972","{\"version\":\"1690964024\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":[],\"regular_price\":[],\"sale_price\":[]}}","no"),
("281226","_transient_timeout_wc_term_counts","1698921623","no"),
("281227","_transient_wc_term_counts","a:12:{i:88;s:1:\"4\";i:91;s:1:\"1\";i:89;s:1:\"8\";i:81;s:1:\"1\";i:85;s:1:\"1\";i:83;s:1:\"1\";i:86;s:1:\"1\";i:15;s:2:\"20\";i:22;s:0:\"\";i:90;s:1:\"4\";i:45;s:1:\"4\";i:93;s:1:\"1\";}","no"),
("285701","_transient_timeout_wc_shipping_method_count_legacy","1699908248","no"),
("285702","_transient_wc_shipping_method_count_legacy","a:2:{s:7:\"version\";s:10:\"1658294785\";s:5:\"value\";i:0;}","no"),
("287418","_transient_timeout_wc_product_children_1972","1700440952","no"),
("287419","_transient_wc_product_children_1972","a:2:{s:3:\"all\";a:0:{}s:7:\"visible\";a:0:{}}","no"),
("287420","_transient_timeout_wc_child_has_weight_1972","1700440952","no"),
("287421","_transient_wc_child_has_weight_1972","0","no"),
("287422","_transient_timeout_wc_child_has_dimensions_1972","1700440952","no"),
("287423","_transient_wc_child_has_dimensions_1972","0","no"),
("287680","rank_math_notifications","a:0:{}","yes"),
("289638","_transient_timeout_menu_icons_all_languages","1698864753","no"),
("289639","_transient_menu_icons_all_languages","a:1:{s:12:\"translations\";a:19:{i:0;a:7:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2018-12-21 13:24:58\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}}i:1;a:7:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2019-11-25 09:48:10\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:76:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}}i:2;a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2019-01-22 19:36:06\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:3;a:7:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2020-05-12 13:42:44\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:4;a:7:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2019-07-02 22:44:46\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:5;a:7:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2019-03-15 15:26:07\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:6;a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2019-07-02 22:43:48\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:7;a:7:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2022-03-17 08:15:29\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:8;a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2022-03-16 12:13:59\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:9;a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2020-07-14 15:07:34\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:10;a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2021-08-12 06:00:36\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}}i:11;a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2020-11-09 10:46:44\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}}i:12;a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2022-08-16 14:31:28\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:13;a:7:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2022-06-19 09:50:50\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:86:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:14;a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2022-01-13 09:16:22\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:15;a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2021-09-29 15:04:06\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}}i:16;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2021-11-06 18:21:50\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}}i:17;a:7:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2019-06-20 17:06:02\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}}i:18;a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:7:\"0.12.12\";s:7:\"updated\";s:19:\"2019-10-25 16:12:02\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/menu-icons/0.12.12/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}}}}","no"),
("290376","_transient_timeout_wc_product_children_1970","1701010563","no"),
("290377","_transient_wc_product_children_1970","a:2:{s:3:\"all\";a:0:{}s:7:\"visible\";a:0:{}}","no"),
("290378","_transient_timeout_wc_child_has_weight_1970","1701010563","no"),
("290379","_transient_wc_child_has_weight_1970","0","no"),
("290380","_transient_timeout_wc_child_has_dimensions_1970","1701010563","no"),
("290381","_transient_wc_child_has_dimensions_1970","0","no"),
("290760","_transient_timeout_woocommerce_admin_remote_free_extensions_specs","1699109476","no"),
("290761","_transient_woocommerce_admin_remote_free_extensions_specs","a:5:{s:10:\"obw/basics\";O:8:\"stdClass\":3:{s:3:\"key\";s:10:\"obw/basics\";s:5:\"title\";s:14:\"Get the basics\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:154:\"Accept credit cards and other popular payment methods with <a href=\"https://woocommerce.com/products/woocommerce-payments\" target=\"_blank\">WooPayments</a>\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce Shipping\";s:11:\"description\";s:119:\"Print shipping labels with <a href=\"https://woocommerce.com/products/shipping\" target=\"_blank\">WooCommerce Shipping</a>\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:13:\"product_types\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:5:\"count\";}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";i:1;s:7:\"default\";a:0:{}s:9:\"operation\";s:2:\"!=\";}}i:1;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:15:\"product_types.0\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";s:9:\"downloads\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:2:\"!=\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"woocommerce-services:shipping\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"WooCommerce Tax\";s:11:\"description\";s:111:\"Get automated sales tax with <a href=\"https://woocommerce.com/products/tax\" target=\"_blank\">WooCommerce Tax</a>\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Jetpack\";s:11:\"description\";s:110:\"Enhance speed and security with <a href=\"https://woocommerce.com/products/jetpack\" target=\"_blank\">Jetpack</a>\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:7:\"jetpack\";}}}}}s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";}}}s:8:\"obw/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:8:\"obw/grow\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:5:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:115:\"Level up your email marketing with <a href=\"https://woocommerce.com/products/mailpoet\" target=\"_blank\">MailPoet</a>\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:8:\"mailpoet\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";}i:1;O:8:\"stdClass\":7:{s:4:\"name\";s:23:\"Codisto for WooCommerce\";s:11:\"description\";s:210:\"Sell on Amazon, eBay, Walmart and more directly from WooCommerce with  <a href=\"https://woocommerce.com/pt-br/products/amazon-ebay-integration/?quid=c247a85321c9e93e7c3c6f1eb072e6e5\" target=\"_blank\">Codisto</a>\";s:9:\"image_url\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/codistoconnect.png\";s:10:\"manage_url\";s:31:\"admin.php?page=codisto-settings\";s:14:\"is_built_by_wc\";b:1;s:10:\"is_visible\";b:0;s:3:\"key\";s:14:\"codistoconnect\";}i:2;O:8:\"stdClass\":8:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:127:\"Drive sales with <a href=\"https://woocommerce.com/products/google-listings-and-ads\" target=\"_blank\">Google Listings and Ads</a>\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google-listings-and-ads\";}}}}}s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:76:\"Get your products in front of Pinners searching for ideas and things to buy.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";}i:4;O:8:\"stdClass\":7:{s:4:\"name\";s:24:\"Facebook for WooCommerce\";s:11:\"description\";s:141:\"List products and create ads on Facebook and Instagram with <a href=\"https://woocommerce.com/products/facebook/\">Facebook for WooCommerce</a>\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:24:\"facebook-for-woocommerce\";}}}s:15:\"task-list/reach\";O:8:\"stdClass\":3:{s:3:\"key\";s:15:\"task-list/reach\";s:5:\"title\";s:22:\"Reach out to customers\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:111:\"Create and send purchase follow-up emails, newsletters, and promotional campaigns straight from your dashboard.\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailpoet.svg\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:12:\"mailpoet:alt\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Mailchimp\";s:11:\"description\";s:78:\"Send targeted campaigns, recover abandoned carts and much more with Mailchimp.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailchimp.svg\";s:10:\"manage_url\";s:36:\"admin.php?page=mailchimp-woocommerce\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:25:\"mailchimp-for-woocommerce\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Klaviyo\";s:11:\"description\";s:138:\"Grow and retain customers with intelligent, impactful email and SMS marketing automation and a consolidated view of customer interactions.\";s:9:\"image_url\";s:95:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/klaviyo.png\";s:10:\"manage_url\";s:31:\"admin.php?page=klaviyo_settings\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:7:\"klaviyo\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:29:\"Creative Mail for WooCommerce\";s:11:\"description\";s:99:\"Create on-brand store campaigns, fast email promotions and customer retargeting with Creative Mail.\";s:9:\"image_url\";s:121:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/creative-mail-by-constant-contact.png\";s:10:\"manage_url\";s:27:\"admin.php?page=creativemail\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:33:\"creative-mail-by-constant-contact\";}}}s:14:\"task-list/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:14:\"task-list/grow\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:5:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:134:\"Reach more shoppers and drive sales for your store. Integrate with Google to list your products for free and launch paid ad campaigns.\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:27:\"google-listings-and-ads:alt\";}i:1;O:8:\"stdClass\":7:{s:4:\"name\";s:22:\"TikTok for WooCommerce\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/tiktok.svg\";s:11:\"description\";s:118:\"Grow your online sales by promoting your products on TikTok to over one billion monthly active users around the world.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MY\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PH\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VN\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TH\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"KR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IL\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UA\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TR\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SA\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:159:\"Get your products in front of Pinterest users searching for ideas and things to buy. Get started with Pinterest and make your entire product catalog browsable.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"pinterest-for-woocommerce:alt\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:24:\"Facebook for WooCommerce\";s:11:\"description\";s:55:\"List products and create ads on Facebook and Instagram.\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:28:\"facebook-for-woocommerce:alt\";}i:4;O:8:\"stdClass\":7:{s:4:\"name\";s:23:\"Codisto for WooCommerce\";s:11:\"description\";s:65:\"Sell on Amazon, eBay, Walmart and more directly from WooCommerce.\";s:9:\"image_url\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/codistoconnect.png\";s:10:\"manage_url\";s:31:\"admin.php?page=codisto-settings\";s:14:\"is_built_by_wc\";b:1;s:10:\"is_visible\";b:0;s:3:\"key\";s:18:\"codistoconnect:alt\";}}}s:17:\"obw/core-profiler\";O:8:\"stdClass\":3:{s:3:\"key\";s:17:\"obw/core-profiler\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:8:{i:0;O:8:\"stdClass\":10:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:89:\"Securely accept payments and manage payment activity straight from your store\'s dashboard\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";s:5:\"label\";s:25:\"Get paid with WooPayments\";s:9:\"image_url\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:53:\"https://woocommerce.com/products/woocommerce-payments\";s:16:\"install_priority\";i:5;}i:1;O:8:\"stdClass\":9:{s:4:\"name\";s:20:\"WooCommerce Shipping\";s:11:\"description\";s:76:\"Print USPS and DHL labels directly from your dashboard and save on shipping.\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"woocommerce-services:shipping\";s:5:\"label\";s:47:\"Print shipping labels with WooCommerce Shipping\";s:9:\"image_url\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:44:\"https://woocommerce.com/woocommerce-shipping\";s:16:\"install_priority\";i:3;}i:2;O:8:\"stdClass\":10:{s:4:\"name\";s:7:\"Jetpack\";s:11:\"description\";s:84:\"Save time on content creation — unlock high-quality blog posts and pages using AI.\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";s:5:\"label\";s:48:\"Boost content creation with Jetpack AI Assistant\";s:9:\"image_url\";s:114:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-jetpack.svg\";s:15:\"learn_more_link\";s:40:\"https://woocommerce.com/products/jetpack\";s:16:\"install_priority\";i:8;}i:3;O:8:\"stdClass\":10:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:56:\"Get your products in front of a highly engaged audience.\";s:9:\"image_url\";s:116:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-pinterest.svg\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";s:5:\"label\";s:37:\"Showcase your products with Pinterest\";s:15:\"learn_more_link\";s:58:\"https://woocommerce.com/products/pinterest-for-woocommerce\";s:16:\"install_priority\";i:2;}i:4;O:8:\"stdClass\":10:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:71:\"Send purchase follow-up emails, newsletters, and promotional campaigns.\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";s:5:\"label\";s:34:\"Reach your customers with MailPoet\";s:9:\"image_url\";s:115:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-mailpoet.svg\";s:15:\"learn_more_link\";s:41:\"https://woocommerce.com/products/mailpoet\";s:16:\"install_priority\";i:7;}i:5;O:8:\"stdClass\":11:{s:4:\"name\";s:21:\"Google Listings & Ads\";s:11:\"description\";s:83:\"Reach millions of active shoppers across Google with free product listings and ads.\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";s:5:\"label\";s:38:\"Drive sales with Google Listings & Ads\";s:15:\"learn_more_link\";s:56:\"https://woocommerce.com/products/google-listings-and-ads\";s:16:\"install_priority\";i:6;}i:6;O:8:\"stdClass\":9:{s:4:\"name\";s:15:\"WooCommerce Tax\";s:11:\"description\";s:94:\"Automatically calculate how much sales tax should be collected – by city, country, or state.\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";s:5:\"label\";s:44:\"Get automated tax rates with WooCommerce Tax\";s:9:\"image_url\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-woo.svg\";s:15:\"learn_more_link\";s:36:\"https://woocommerce.com/products/tax\";s:16:\"install_priority\";i:4;}i:7;O:8:\"stdClass\":10:{s:4:\"name\";s:22:\"TikTok for WooCommerce\";s:9:\"image_url\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/core-profiler/logo-tiktok.svg\";s:11:\"description\";s:64:\"Create advertising campaigns and reach one billion global users.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MY\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PH\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VN\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TH\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"KR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IL\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UA\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"TR\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SA\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";s:5:\"label\";s:31:\"Create ad campaigns with TikTok\";s:15:\"learn_more_link\";s:55:\"https://woocommerce.com/products/tiktok-for-woocommerce\";s:16:\"install_priority\";i:1;}}}}","no"),
("290762","_site_transient_timeout_browser_e3f8101c41b40572973227d0a64620d0","1699109478","no"),
("290763","_site_transient_browser_e3f8101c41b40572973227d0a64620d0","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"118.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no"),
("290764","_site_transient_timeout_php_check_0260183cef5829810c63d4ec9ff87fd1","1699109480","no"),
("290765","_site_transient_php_check_0260183cef5829810c63d4ec9ff87fd1","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:0;}","no"),
("290770","_transient_timeout_themeisle_sdk_feed_items","1698677481","no"),
("290771","_transient_themeisle_sdk_feed_items","a:5:{i:0;a:3:{s:5:\"title\";s:21:\"What Is Indexability?\";s:4:\"date\";i:1698415200;s:4:\"link\";s:40:\"https://themeisle.com/blog/indexability/\";}i:1;a:3:{s:5:\"title\";s:61:\"Wordfence Security vs iThemes Security: Which Should You Use?\";s:4:\"date\";i:1698408000;s:4:\"link\";s:66:\"https://themeisle.com/blog/wordfence-security-vs-ithemes-security/\";}i:2;a:3:{s:5:\"title\";s:51:\"PopularFX Theme Review: Everything You Need to Know\";s:4:\"date\";i:1698400800;s:4:\"link\";s:50:\"https://themeisle.com/blog/popularfx-theme-review/\";}i:3;a:3:{s:5:\"title\";s:64:\"Bluehost vs Squarespace: Which Is Better for Starting a Website?\";s:4:\"date\";i:1698395400;s:4:\"link\";s:51:\"https://themeisle.com/blog/bluehost-vs-squarespace/\";}i:4;a:3:{s:5:\"title\";s:14:\"What Is HTTPS?\";s:4:\"date\";i:1698328800;s:4:\"link\";s:33:\"https://themeisle.com/blog/https/\";}}","no"),
("290774","_transient_timeout_wc_report_orders_stats_e9709ddbbf880de203c8d3dbab39f27d","1699109485","no"),
("290775","_transient_wc_report_orders_stats_e9709ddbbf880de203c8d3dbab39f27d","a:2:{s:7:\"version\";s:10:\"1663316281\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:5:{i:0;a:6:{s:8:\"interval\";s:7:\"2023-43\";s:10:\"date_start\";s:19:\"2023-10-23 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-22 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-28 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-28 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:1;a:6:{s:8:\"interval\";s:7:\"2023-42\";s:10:\"date_start\";s:19:\"2023-10-16 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-15 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-22 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-22 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:2;a:6:{s:8:\"interval\";s:7:\"2023-41\";s:10:\"date_start\";s:19:\"2023-10-09 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-08 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-15 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-15 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:3;a:6:{s:8:\"interval\";s:7:\"2023-40\";s:10:\"date_start\";s:19:\"2023-10-02 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-01 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-08 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-08 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:4;a:6:{s:8:\"interval\";s:7:\"2023-39\";s:10:\"date_start\";s:19:\"2023-10-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-09-30 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-01 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:5;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}","no"),
("290776","_transient_timeout_wc_report_orders_stats_4d49d32712dc6a35e336bd63ce93a971","1699109485","no"),
("290777","_transient_wc_report_orders_stats_4d49d32712dc6a35e336bd63ce93a971","a:2:{s:7:\"version\";s:10:\"1663316281\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:5:{i:0;a:6:{s:8:\"interval\";s:7:\"2023-43\";s:10:\"date_start\";s:19:\"2023-10-23 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-22 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-28 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-28 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:1;a:6:{s:8:\"interval\";s:7:\"2023-42\";s:10:\"date_start\";s:19:\"2023-10-16 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-15 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-22 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-22 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:2;a:6:{s:8:\"interval\";s:7:\"2023-41\";s:10:\"date_start\";s:19:\"2023-10-09 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-08 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-15 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-15 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:3;a:6:{s:8:\"interval\";s:7:\"2023-40\";s:10:\"date_start\";s:19:\"2023-10-02 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-01 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-08 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-08 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}i:4;a:6:{s:8:\"interval\";s:7:\"2023-39\";s:10:\"date_start\";s:19:\"2023-10-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-09-30 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-01 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:5;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}","no"),
("290778","_transient_timeout_wc_report_products_stats_7f2df765ff2ca91bfd0109f86d22823e","1699109485","no"),
("290779","_transient_wc_report_products_stats_7f2df765ff2ca91bfd0109f86d22823e","a:2:{s:7:\"version\";s:10:\"1663316281\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:5:{i:0;a:6:{s:8:\"interval\";s:7:\"2023-43\";s:10:\"date_start\";s:19:\"2023-10-23 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-22 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-28 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-28 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:1;a:6:{s:8:\"interval\";s:7:\"2023-42\";s:10:\"date_start\";s:19:\"2023-10-16 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-15 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-22 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-22 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:2;a:6:{s:8:\"interval\";s:7:\"2023-41\";s:10:\"date_start\";s:19:\"2023-10-09 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-08 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-15 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-15 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:3;a:6:{s:8:\"interval\";s:7:\"2023-40\";s:10:\"date_start\";s:19:\"2023-10-02 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-01 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-08 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-08 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:4;a:6:{s:8:\"interval\";s:7:\"2023-39\";s:10:\"date_start\";s:19:\"2023-10-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-09-30 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-01 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":6:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:14:\"products_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:5;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}","no"),
("290780","_transient_timeout_wc_report_variations_stats_7e5cb199aeba5ebd560c8cf9aaf98a94","1699109485","no"),
("290781","_transient_wc_report_variations_stats_7e5cb199aeba5ebd560c8cf9aaf98a94","a:2:{s:7:\"version\";s:10:\"1663316281\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:5:{i:0;a:6:{s:8:\"interval\";s:7:\"2023-43\";s:10:\"date_start\";s:19:\"2023-10-23 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-22 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-28 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-28 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:1;a:6:{s:8:\"interval\";s:7:\"2023-42\";s:10:\"date_start\";s:19:\"2023-10-16 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-15 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-22 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-22 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:2;a:6:{s:8:\"interval\";s:7:\"2023-41\";s:10:\"date_start\";s:19:\"2023-10-09 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-08 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-15 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-15 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:3;a:6:{s:8:\"interval\";s:7:\"2023-40\";s:10:\"date_start\";s:19:\"2023-10-02 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-01 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-08 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-08 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}i:4;a:6:{s:8:\"interval\";s:7:\"2023-39\";s:10:\"date_start\";s:19:\"2023-10-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-09-30 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-01 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":5:{s:10:\"items_sold\";i:0;s:11:\"net_revenue\";d:0;s:12:\"orders_count\";i:0;s:16:\"variations_count\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:5;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}","no"),
("290782","_transient_timeout_wc_report_orders_stats_70ad3de8c4c50e5418cddbeae9699c28","1699109485","no"),
("290783","_transient_wc_report_orders_stats_70ad3de8c4c50e5418cddbeae9699c28","a:2:{s:7:\"version\";s:10:\"1663316281\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":4:{s:11:\"net_revenue\";d:0;s:8:\"products\";i:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:28:{i:0;a:6:{s:8:\"interval\";s:10:\"2023-10-01\";s:10:\"date_start\";s:19:\"2023-10-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-09-30 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-01 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:1;a:6:{s:8:\"interval\";s:10:\"2023-10-02\";s:10:\"date_start\";s:19:\"2023-10-02 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-01 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-02 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-02 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:2;a:6:{s:8:\"interval\";s:10:\"2023-10-03\";s:10:\"date_start\";s:19:\"2023-10-03 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-02 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-03 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-03 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:3;a:6:{s:8:\"interval\";s:10:\"2023-10-04\";s:10:\"date_start\";s:19:\"2023-10-04 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-03 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-04 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-04 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:4;a:6:{s:8:\"interval\";s:10:\"2023-10-05\";s:10:\"date_start\";s:19:\"2023-10-05 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-04 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-05 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-05 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:5;a:6:{s:8:\"interval\";s:10:\"2023-10-06\";s:10:\"date_start\";s:19:\"2023-10-06 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-05 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-06 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-06 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:6;a:6:{s:8:\"interval\";s:10:\"2023-10-07\";s:10:\"date_start\";s:19:\"2023-10-07 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-06 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-07 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-07 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:7;a:6:{s:8:\"interval\";s:10:\"2023-10-08\";s:10:\"date_start\";s:19:\"2023-10-08 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-07 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-08 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-08 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:8;a:6:{s:8:\"interval\";s:10:\"2023-10-09\";s:10:\"date_start\";s:19:\"2023-10-09 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-08 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-09 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-09 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:9;a:6:{s:8:\"interval\";s:10:\"2023-10-10\";s:10:\"date_start\";s:19:\"2023-10-10 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-09 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-10 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-10 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:10;a:6:{s:8:\"interval\";s:10:\"2023-10-11\";s:10:\"date_start\";s:19:\"2023-10-11 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-10 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-11 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-11 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:11;a:6:{s:8:\"interval\";s:10:\"2023-10-12\";s:10:\"date_start\";s:19:\"2023-10-12 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-11 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-12 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-12 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:12;a:6:{s:8:\"interval\";s:10:\"2023-10-13\";s:10:\"date_start\";s:19:\"2023-10-13 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-12 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-13 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-13 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:13;a:6:{s:8:\"interval\";s:10:\"2023-10-14\";s:10:\"date_start\";s:19:\"2023-10-14 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-13 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-14 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-14 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:14;a:6:{s:8:\"interval\";s:10:\"2023-10-15\";s:10:\"date_start\";s:19:\"2023-10-15 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-14 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-15 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-15 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:15;a:6:{s:8:\"interval\";s:10:\"2023-10-16\";s:10:\"date_start\";s:19:\"2023-10-16 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-15 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-16 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-16 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:16;a:6:{s:8:\"interval\";s:10:\"2023-10-17\";s:10:\"date_start\";s:19:\"2023-10-17 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-16 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-17 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-17 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:17;a:6:{s:8:\"interval\";s:10:\"2023-10-18\";s:10:\"date_start\";s:19:\"2023-10-18 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-17 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-18 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-18 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:18;a:6:{s:8:\"interval\";s:10:\"2023-10-19\";s:10:\"date_start\";s:19:\"2023-10-19 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-18 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-19 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-19 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:19;a:6:{s:8:\"interval\";s:10:\"2023-10-20\";s:10:\"date_start\";s:19:\"2023-10-20 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-19 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-20 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-20 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:20;a:6:{s:8:\"interval\";s:10:\"2023-10-21\";s:10:\"date_start\";s:19:\"2023-10-21 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-20 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-21 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-21 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:21;a:6:{s:8:\"interval\";s:10:\"2023-10-22\";s:10:\"date_start\";s:19:\"2023-10-22 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-21 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-22 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-22 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:22;a:6:{s:8:\"interval\";s:10:\"2023-10-23\";s:10:\"date_start\";s:19:\"2023-10-23 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-22 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-23 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-23 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:23;a:6:{s:8:\"interval\";s:10:\"2023-10-24\";s:10:\"date_start\";s:19:\"2023-10-24 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-23 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-24 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-24 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:24;a:6:{s:8:\"interval\";s:10:\"2023-10-25\";s:10:\"date_start\";s:19:\"2023-10-25 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-24 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-25 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-25 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:25;a:6:{s:8:\"interval\";s:10:\"2023-10-26\";s:10:\"date_start\";s:19:\"2023-10-26 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-25 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-26 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-26 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:26;a:6:{s:8:\"interval\";s:10:\"2023-10-27\";s:10:\"date_start\";s:19:\"2023-10-27 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-26 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-27 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-27 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}i:27;a:6:{s:8:\"interval\";s:10:\"2023-10-28\";s:10:\"date_start\";s:19:\"2023-10-28 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2023-10-27 17:00:00\";s:8:\"date_end\";s:19:\"2023-10-28 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2023-10-28 16:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":3:{s:11:\"net_revenue\";d:0;s:13:\"coupons_count\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:28;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}","no"),
("290784","_transient_timeout_wc_low_stock_count","1701096685","no"),
("290785","_transient_wc_low_stock_count","0","no"),
("290786","_transient_timeout_wc_outofstock_count","1701096685","no"),
("290787","_transient_wc_outofstock_count","0","no"),
("290821","_transient_timeout_wc_related_3346","1698703039","no"),
("290822","_transient_wc_related_3346","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3346\";a:3:{i:0;s:4:\"3351\";i:1;s:4:\"3360\";i:2;s:4:\"3363\";}}","no"),
("290824","thwcfd_since","1698506178","no"),
("290834","wc_fields_billing","a:11:{s:18:\"billing_first_name\";a:17:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:18:\"billing_first_name\";s:5:\"label\";s:13:\"Họ và Tên\";s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"validate\";s:0:\"\";s:10:\"title_type\";s:0:\"\";s:8:\"required\";i:1;s:7:\"checked\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:0;s:13:\"show_in_order\";i:0;s:7:\"options\";s:0:\"\";s:12:\"autocomplete\";s:10:\"given-name\";s:8:\"priority\";i:10;s:6:\"custom\";i:0;}s:17:\"billing_last_name\";a:9:{s:5:\"label\";s:4:\"Họ\";s:8:\"required\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-last\";}s:12:\"autocomplete\";s:11:\"family-name\";s:8:\"priority\";i:20;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:15:\"billing_company\";a:9:{s:5:\"label\";s:13:\"Tên công ty\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:12:\"autocomplete\";s:12:\"organization\";s:8:\"priority\";i:30;s:8:\"required\";b:0;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:15:\"billing_country\";a:10:{s:4:\"type\";s:7:\"country\";s:5:\"label\";s:20:\"Quốc gia/Khu vực\";s:8:\"required\";b:1;s:5:\"class\";a:3:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";i:2;s:23:\"update_totals_on_change\";}s:12:\"autocomplete\";s:7:\"country\";s:8:\"priority\";i:40;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:17:\"billing_address_1\";a:17:{s:4:\"type\";s:4:\"text\";s:4:\"name\";s:17:\"billing_address_1\";s:5:\"label\";s:12:\"Địa chỉ\";s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:12:\"Địa chỉ\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"validate\";s:0:\"\";s:10:\"title_type\";s:0:\"\";s:8:\"required\";i:1;s:7:\"checked\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:0;s:13:\"show_in_order\";i:0;s:7:\"options\";s:0:\"\";s:12:\"autocomplete\";s:13:\"address-line1\";s:8:\"priority\";i:50;s:6:\"custom\";i:0;}s:17:\"billing_address_2\";a:11:{s:5:\"label\";s:28:\"Apartment, suite, unit, etc.\";s:11:\"label_class\";a:0:{}s:11:\"placeholder\";s:39:\"Apartment, suite, unit, etc. (optional)\";s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:13:\"form-row-last\";}s:12:\"autocomplete\";s:13:\"address-line2\";s:8:\"priority\";i:60;s:8:\"required\";b:0;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:12:\"billing_city\";a:9:{s:5:\"label\";s:21:\"Tỉnh / Thành phố\";s:8:\"required\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:12:\"autocomplete\";s:14:\"address-level2\";s:8:\"priority\";i:70;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:13:\"billing_state\";a:13:{s:4:\"type\";s:5:\"state\";s:5:\"label\";s:12:\"Bang / Hạt\";s:8:\"required\";b:0;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"validate\";a:1:{i:0;s:5:\"state\";}s:12:\"autocomplete\";s:14:\"address-level1\";s:8:\"priority\";i:80;s:13:\"country_field\";s:15:\"billing_country\";s:7:\"country\";s:2:\"VN\";s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:16:\"billing_postcode\";a:10:{s:5:\"label\";s:16:\"Mã bưu điện\";s:8:\"required\";b:0;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"validate\";a:1:{i:0;s:8:\"postcode\";}s:12:\"autocomplete\";s:11:\"postal-code\";s:8:\"priority\";i:90;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:13:\"billing_phone\";a:11:{s:5:\"label\";s:20:\"Số điện thoại\";s:8:\"required\";b:1;s:4:\"type\";s:3:\"tel\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"validate\";a:1:{i:0;s:5:\"phone\";}s:12:\"autocomplete\";s:3:\"tel\";s:8:\"priority\";i:100;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:13:\"billing_email\";a:11:{s:5:\"label\";s:18:\"Địa chỉ email\";s:8:\"required\";b:1;s:4:\"type\";s:5:\"email\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"validate\";a:1:{i:0;s:5:\"email\";}s:12:\"autocomplete\";s:14:\"email username\";s:8:\"priority\";i:110;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}}","no"),
("290843","wc_fields_shipping","a:9:{s:19:\"shipping_first_name\";a:9:{s:5:\"label\";s:4:\"Tên\";s:8:\"required\";b:1;s:5:\"class\";a:1:{i:0;s:14:\"form-row-first\";}s:12:\"autocomplete\";s:10:\"given-name\";s:8:\"priority\";i:10;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:18:\"shipping_last_name\";a:9:{s:5:\"label\";s:4:\"Họ\";s:8:\"required\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-last\";}s:12:\"autocomplete\";s:11:\"family-name\";s:8:\"priority\";i:20;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:16:\"shipping_company\";a:9:{s:5:\"label\";s:13:\"Tên công ty\";s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:12:\"autocomplete\";s:12:\"organization\";s:8:\"priority\";i:30;s:8:\"required\";b:0;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:16:\"shipping_country\";a:10:{s:4:\"type\";s:7:\"country\";s:5:\"label\";s:20:\"Quốc gia/Khu vực\";s:8:\"required\";b:1;s:5:\"class\";a:3:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";i:2;s:23:\"update_totals_on_change\";}s:12:\"autocomplete\";s:7:\"country\";s:8:\"priority\";i:40;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:18:\"shipping_address_1\";a:10:{s:5:\"label\";s:12:\"Địa chỉ\";s:11:\"placeholder\";s:12:\"Địa chỉ\";s:8:\"required\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:14:\"form-row-first\";}s:12:\"autocomplete\";s:13:\"address-line1\";s:8:\"priority\";i:50;s:6:\"custom\";i:0;s:7:\"enabled\";i:1;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:18:\"shipping_address_2\";a:11:{s:5:\"label\";s:28:\"Apartment, suite, unit, etc.\";s:11:\"label_class\";a:0:{}s:11:\"placeholder\";s:39:\"Apartment, suite, unit, etc. (optional)\";s:5:\"class\";a:2:{i:0;s:13:\"address-field\";i:1;s:13:\"form-row-last\";}s:12:\"autocomplete\";s:13:\"address-line2\";s:8:\"priority\";i:60;s:8:\"required\";b:0;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:13:\"shipping_city\";a:9:{s:5:\"label\";s:21:\"Tỉnh / Thành phố\";s:8:\"required\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:12:\"autocomplete\";s:14:\"address-level2\";s:8:\"priority\";i:70;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:14:\"shipping_state\";a:13:{s:4:\"type\";s:5:\"state\";s:5:\"label\";s:12:\"Bang / Hạt\";s:8:\"required\";b:0;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"validate\";a:1:{i:0;s:5:\"state\";}s:12:\"autocomplete\";s:14:\"address-level1\";s:8:\"priority\";i:80;s:13:\"country_field\";s:16:\"shipping_country\";s:7:\"country\";s:2:\"VN\";s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}s:17:\"shipping_postcode\";a:10:{s:5:\"label\";s:16:\"Mã bưu điện\";s:8:\"required\";b:0;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"validate\";a:1:{i:0;s:8:\"postcode\";}s:12:\"autocomplete\";s:11:\"postal-code\";s:8:\"priority\";i:90;s:6:\"custom\";i:0;s:7:\"enabled\";i:0;s:13:\"show_in_email\";i:1;s:13:\"show_in_order\";i:1;}}","no"),
("290852","_transient_wc_count_comments","O:8:\"stdClass\":7:{s:14:\"total_comments\";i:8;s:3:\"all\";i:5;s:8:\"approved\";s:1:\"5\";s:4:\"spam\";s:1:\"3\";s:9:\"moderated\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}","yes"),
("290939","_transient_timeout_wc_related_3301","1698702973","no"),
("290940","_transient_wc_related_3301","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3301\";a:3:{i:0;s:4:\"3293\";i:1;s:4:\"3298\";i:2;s:4:\"3316\";}}","no"),
("290957","_transient_timeout_wc_related_3244","1698703022","no"),
("290958","_transient_wc_related_3244","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3244\";a:7:{i:0;s:4:\"3248\";i:1;s:4:\"3257\";i:2;s:4:\"3262\";i:3;s:4:\"3267\";i:4;s:4:\"3271\";i:5;s:4:\"3276\";i:6;s:4:\"3305\";}}","no"),
("290967","_transient_timeout_wc_related_3257","1698703012","no"),
("290968","_transient_wc_related_3257","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3257\";a:7:{i:0;s:4:\"3244\";i:1;s:4:\"3248\";i:2;s:4:\"3262\";i:3;s:4:\"3267\";i:4;s:4:\"3271\";i:5;s:4:\"3276\";i:6;s:4:\"3305\";}}","no"),
("291226","_transient_timeout_wc_related_3316","1698702969","no"),
("291227","_transient_wc_related_3316","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3316\";a:3:{i:0;s:4:\"3293\";i:1;s:4:\"3298\";i:2;s:4:\"3301\";}}","no"),
("291229","_transient_timeout_wc_related_3298","1698702978","no"),
("291230","_transient_wc_related_3298","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3298\";a:3:{i:0;s:4:\"3293\";i:1;s:4:\"3301\";i:2;s:4:\"3316\";}}","no"),
("291231","_transient_timeout_wc_related_3293","1698702982","no"),
("291232","_transient_wc_related_3293","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3293\";a:3:{i:0;s:4:\"3298\";i:1;s:4:\"3301\";i:2;s:4:\"3316\";}}","no"),
("291235","_transient_timeout_wc_related_3305","1698702993","no"),
("291236","_transient_wc_related_3305","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3305\";a:7:{i:0;s:4:\"3244\";i:1;s:4:\"3248\";i:2;s:4:\"3257\";i:3;s:4:\"3262\";i:4;s:4:\"3267\";i:5;s:4:\"3271\";i:6;s:4:\"3276\";}}","no"),
("291237","_transient_timeout_wc_related_3276","1698702997","no"),
("291238","_transient_wc_related_3276","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3276\";a:7:{i:0;s:4:\"3244\";i:1;s:4:\"3248\";i:2;s:4:\"3257\";i:3;s:4:\"3262\";i:4;s:4:\"3267\";i:5;s:4:\"3271\";i:6;s:4:\"3305\";}}","no"),
("291239","_transient_timeout_wc_related_3271","1698703001","no"),
("291240","_transient_wc_related_3271","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3271\";a:7:{i:0;s:4:\"3244\";i:1;s:4:\"3248\";i:2;s:4:\"3257\";i:3;s:4:\"3262\";i:4;s:4:\"3267\";i:5;s:4:\"3276\";i:6;s:4:\"3305\";}}","no"),
("291241","_transient_timeout_wc_related_3267","1698733799","no"),
("291242","_transient_wc_related_3267","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3267\";a:7:{i:0;s:4:\"3244\";i:1;s:4:\"3248\";i:2;s:4:\"3257\";i:3;s:4:\"3262\";i:4;s:4:\"3271\";i:5;s:4:\"3276\";i:6;s:4:\"3305\";}}","no"),
("291243","_transient_timeout_wc_related_3262","1698703008","no"),
("291244","_transient_wc_related_3262","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3262\";a:7:{i:0;s:4:\"3244\";i:1;s:4:\"3248\";i:2;s:4:\"3257\";i:3;s:4:\"3267\";i:4;s:4:\"3271\";i:5;s:4:\"3276\";i:6;s:4:\"3305\";}}","no"),
("291245","_transient_timeout_wc_related_3416","1698690550","no"),
("291246","_transient_wc_related_3416","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3416\";a:19:{i:0;s:4:\"1942\";i:1;s:4:\"1944\";i:2;s:4:\"1946\";i:3;s:4:\"1947\";i:4;s:4:\"1949\";i:5;s:4:\"1951\";i:6;s:4:\"1953\";i:7;s:4:\"1955\";i:8;s:4:\"1957\";i:9;s:4:\"1959\";i:10;s:4:\"1965\";i:11;s:4:\"1967\";i:12;s:4:\"1970\";i:13;s:4:\"1972\";i:14;s:4:\"1973\";i:15;s:4:\"1975\";i:16;s:4:\"1979\";i:17;s:4:\"2135\";i:18;s:4:\"3296\";}}","no"),
("291247","_transient_timeout_wc_related_3360","1698738826","no"),
("291248","_transient_wc_related_3360","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3360\";a:3:{i:0;s:4:\"3346\";i:1;s:4:\"3351\";i:2;s:4:\"3363\";}}","no"),
("291249","_transient_timeout_wc_related_3351","1698703036","no"),
("291250","_transient_wc_related_3351","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3351\";a:3:{i:0;s:4:\"3346\";i:1;s:4:\"3360\";i:2;s:4:\"3363\";}}","no"),
("291254","_transient_timeout_299d19969726a407c1c44ae284610f4a","1698690598","no"),
("291255","_transient_299d19969726a407c1c44ae284610f4a","a:1:{s:24:\"woof_really_current_term\";O:7:\"WP_Term\":10:{s:7:\"term_id\";i:88;s:4:\"name\";s:16:\"Laptop xách tay\";s:4:\"slug\";s:6:\"laptop\";s:10:\"term_group\";i:0;s:16:\"term_taxonomy_id\";i:88;s:8:\"taxonomy\";s:11:\"product_cat\";s:11:\"description\";s:0:\"\";s:6:\"parent\";i:0;s:5:\"count\";i:4;s:6:\"filter\";s:3:\"raw\";}}","no"),
("291256","_transient_timeout_5afb76670eeba7e731adf26386374cce","1698690602","no"),
("291257","_transient_5afb76670eeba7e731adf26386374cce","a:1:{s:24:\"woof_really_current_term\";O:7:\"WP_Term\":10:{s:7:\"term_id\";i:90;s:4:\"name\";s:23:\"Phụ kiện máy tính\";s:4:\"slug\";s:17:\"phu-kien-may-tinh\";s:10:\"term_group\";i:0;s:16:\"term_taxonomy_id\";i:90;s:8:\"taxonomy\";s:11:\"product_cat\";s:11:\"description\";s:0:\"\";s:6:\"parent\";i:0;s:5:\"count\";i:4;s:6:\"filter\";s:3:\"raw\";}}","no"),
("291258","_transient_timeout_c9e7b4cfa5a2f3781965c84874f21d19","1698690609","no"),
("291259","_transient_c9e7b4cfa5a2f3781965c84874f21d19","a:1:{s:24:\"woof_really_current_term\";O:7:\"WP_Term\":10:{s:7:\"term_id\";i:15;s:4:\"name\";s:23:\"Đồ dùng tiện ích\";s:4:\"slug\";s:16:\"do-dung-tien-ich\";s:10:\"term_group\";i:0;s:16:\"term_taxonomy_id\";i:15;s:8:\"taxonomy\";s:11:\"product_cat\";s:11:\"description\";s:0:\"\";s:6:\"parent\";i:0;s:5:\"count\";i:20;s:6:\"filter\";s:3:\"raw\";}}","no"),
("291260","_transient_timeout_f16ca7a160d8fa1fcb375c4b3f603494","1698690613","no"),
("291261","_transient_f16ca7a160d8fa1fcb375c4b3f603494","a:1:{s:24:\"woof_really_current_term\";O:7:\"WP_Term\":10:{s:7:\"term_id\";i:22;s:4:\"name\";s:13:\"Khuyến mãi\";s:4:\"slug\";s:10:\"khuyen-mai\";s:10:\"term_group\";i:0;s:16:\"term_taxonomy_id\";i:22;s:8:\"taxonomy\";s:11:\"product_cat\";s:11:\"description\";s:0:\"\";s:6:\"parent\";i:0;s:5:\"count\";i:0;s:6:\"filter\";s:3:\"raw\";}}","no"),
("291285","_transient_timeout_fc6a9657cfa7678893e4d0c51a6e9fc0","1698697526","no"),
("291286","_transient_fc6a9657cfa7678893e4d0c51a6e9fc0","a:1:{s:24:\"woof_really_current_term\";O:7:\"WP_Term\":10:{s:7:\"term_id\";i:90;s:4:\"name\";s:23:\"Phụ kiện máy tính\";s:4:\"slug\";s:17:\"phu-kien-may-tinh\";s:10:\"term_group\";i:0;s:16:\"term_taxonomy_id\";i:90;s:8:\"taxonomy\";s:11:\"product_cat\";s:11:\"description\";s:0:\"\";s:6:\"parent\";i:0;s:5:\"count\";i:4;s:6:\"filter\";s:3:\"raw\";}}","no"),
("291292","_transient_timeout_wc_related_3363","1698703029","no"),
("291293","_transient_wc_related_3363","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3363\";a:3:{i:0;s:4:\"3346\";i:1;s:4:\"3351\";i:2;s:4:\"3360\";}}","no"),
("291297","_transient_timeout_wc_related_1957","1698700087","no"),
("291298","_transient_wc_related_1957","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1957\";a:19:{i:0;s:4:\"1942\";i:1;s:4:\"1944\";i:2;s:4:\"1946\";i:3;s:4:\"1947\";i:4;s:4:\"1949\";i:5;s:4:\"1951\";i:6;s:4:\"1953\";i:7;s:4:\"1955\";i:8;s:4:\"1959\";i:9;s:4:\"1965\";i:10;s:4:\"1967\";i:11;s:4:\"1970\";i:12;s:4:\"1972\";i:13;s:4:\"1973\";i:14;s:4:\"1975\";i:15;s:4:\"1979\";i:16;s:4:\"2135\";i:17;s:4:\"3296\";i:18;s:4:\"3416\";}}","no"),
("291322","_transient_timeout_wc_related_3248","1698703016","no"),
("291323","_transient_wc_related_3248","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=3248\";a:7:{i:0;s:4:\"3244\";i:1;s:4:\"3257\";i:2;s:4:\"3262\";i:3;s:4:\"3267\";i:4;s:4:\"3271\";i:5;s:4:\"3276\";i:6;s:4:\"3305\";}}","no"),
("291376","_transient_timeout__woocommerce_helper_updates","1698673609","no"),
("291377","_transient__woocommerce_helper_updates","a:4:{s:4:\"hash\";s:32:\"d751713988987e9331980363e24189ce\";s:7:\"updated\";i:1698630409;s:8:\"products\";a:0:{}s:6:\"errors\";a:1:{i:0;s:10:\"http-error\";}}","no"),
("291437","_transient_timeout_wc_related_1979","1698731471","no"),
("291438","_transient_wc_related_1979","a:1:{s:52:\"limit=8&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1979\";a:19:{i:0;s:4:\"1942\";i:1;s:4:\"1944\";i:2;s:4:\"1946\";i:3;s:4:\"1947\";i:4;s:4:\"1949\";i:5;s:4:\"1951\";i:6;s:4:\"1953\";i:7;s:4:\"1955\";i:8;s:4:\"1957\";i:9;s:4:\"1959\";i:10;s:4:\"1965\";i:11;s:4:\"1967\";i:12;s:4:\"1970\";i:13;s:4:\"1972\";i:14;s:4:\"1973\";i:15;s:4:\"1975\";i:16;s:4:\"2135\";i:17;s:4:\"3296\";i:18;s:4:\"3416\";}}","no"),
("291491","_site_transient_timeout_available_translations","1698665897","no"),
("291492","_site_transient_available_translations","a:130:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.6/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-20 14:42:04\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-06-17 14:58:52\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.24/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-29 19:41:58\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.14/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-08-09 10:47:25\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-18 13:58:24\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 05:44:23\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-18 09:29:14\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-06-11 19:56:44\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-12 22:04:28\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.0.6/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-12 22:05:10\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-05-24 08:57:04\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.0.6/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-03-17 12:58:14\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-05-24 09:00:33\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-06-22 15:27:13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-22 00:23:39\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-03-14 08:07:54\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-04-07 21:00:28\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-29 20:39:44\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-16 15:57:15\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-03-30 18:56:30\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 15:36:53\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-05-17 18:49:06\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.14/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-08-01 00:22:12\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.19\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.19/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-07-22 14:08:10\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-05-24 04:14:24\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-15 17:18:32\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-18 14:26:25\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-07-25 12:38:01\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-28 06:50:07\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-03-07 20:30:17\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-03-03 19:05:43\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-12 23:40:28\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2023-07-25 11:17:47\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.24/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.31\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.31/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-02-05 13:50:46\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"5.5.13\";s:7:\"updated\";s:19:\"2023-08-11 04:03:50\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.13/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-18 07:58:01\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-07-18 19:40:10\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-07-24 14:42:20\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 07:28:56\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.24/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-25 17:54:21\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 01:56:21\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.24/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-05-19 07:40:56\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-29 14:49:24\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.24/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.19\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.19/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-30 17:57:15\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-06-08 00:24:23\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-12-07 16:32:30\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.8/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-09-07 19:56:19\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.6/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-23 12:35:40\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-08-07 05:58:01\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.24/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.13\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.13/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.36\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.36/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-12 23:35:25\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-10-18 16:02:27\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-25 08:55:17\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-09-10 16:25:55\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-06-02 21:03:02\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.0.6/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.23/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 13:22:31\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.32\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.32/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-18 18:22:21\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 08:08:26\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-10-01 12:16:29\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-09-28 12:14:53\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.0.6/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-18 09:55:26\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 04:52:26\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.14/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-23 12:36:00\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-10-10 16:01:09\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.6/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-05 12:27:18\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-21 10:38:53\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.8/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-12 20:38:56\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.16\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.16/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.36\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.36/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.8\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.8/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.23\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.23/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-02-28 14:48:14\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.24\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.24/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-09-11 15:51:48\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.14\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.14/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-08-24 07:53:05\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.6/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-13 07:54:31\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.0.6\";s:7:\"updated\";s:19:\"2023-10-12 21:29:42\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.6/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}","no"),
("291493","_site_transient_timeout_kirki_googlefonts_cache","1698741505","no"),
("291494","_site_transient_kirki_googlefonts_cache","a:1064:{s:7:\"ABeeZee\";a:3:{s:5:\"label\";s:7:\"ABeeZee\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Abel\";a:3:{s:5:\"label\";s:4:\"Abel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Abhaya Libre\";a:3:{s:5:\"label\";s:12:\"Abhaya Libre\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Abril Fatface\";a:3:{s:5:\"label\";s:13:\"Abril Fatface\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Aclonica\";a:3:{s:5:\"label\";s:8:\"Aclonica\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Acme\";a:3:{s:5:\"label\";s:4:\"Acme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Actor\";a:3:{s:5:\"label\";s:5:\"Actor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Adamina\";a:3:{s:5:\"label\";s:7:\"Adamina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Advent Pro\";a:3:{s:5:\"label\";s:10:\"Advent Pro\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Aguafina Script\";a:3:{s:5:\"label\";s:15:\"Aguafina Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Akaya Kanadaka\";a:3:{s:5:\"label\";s:14:\"Akaya Kanadaka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Akaya Telivigala\";a:3:{s:5:\"label\";s:16:\"Akaya Telivigala\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Akronim\";a:3:{s:5:\"label\";s:7:\"Akronim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Aladin\";a:3:{s:5:\"label\";s:6:\"Aladin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Alata\";a:3:{s:5:\"label\";s:5:\"Alata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Alatsi\";a:3:{s:5:\"label\";s:6:\"Alatsi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Aldrich\";a:3:{s:5:\"label\";s:7:\"Aldrich\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Alef\";a:3:{s:5:\"label\";s:4:\"Alef\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Alegreya\";a:3:{s:5:\"label\";s:8:\"Alegreya\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Alegreya SC\";a:3:{s:5:\"label\";s:11:\"Alegreya SC\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"800\";i:5;s:9:\"800italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Alegreya Sans\";a:3:{s:5:\"label\";s:13:\"Alegreya Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i: